/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface IZoneCOApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ZoneCODTO</returns>
        ZoneCODTO ApiV1EnvironmentCOZoneCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        ApiResponse<ZoneCODTO> ApiV1EnvironmentCOZoneCOGetWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOZoneCOIdDelete (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOZoneCOIdDeleteWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ZoneCODTO</returns>
        ZoneCODTO ApiV1EnvironmentCOZoneCOIdGet (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        ApiResponse<ZoneCODTO> ApiV1EnvironmentCOZoneCOIdGetWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOZoneCOIdPatch (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOZoneCOIdPatchWithHttpInfo (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ZoneCODTO</returns>
        ZoneCODTO ApiV1EnvironmentCOZoneCOIdPut (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        ApiResponse<ZoneCODTO> ApiV1EnvironmentCOZoneCOIdPutWithHttpInfo (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ZoneCODTO</returns>
        ZoneCODTO ApiV1EnvironmentCOZoneCOPost (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        ApiResponse<ZoneCODTO> ApiV1EnvironmentCOZoneCOPostWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOZoneCOValidatePost (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOZoneCOValidatePostWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        ValidateDTO ApiV1EnvironmentCOZoneCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        ApiResponse<ValidateDTO> ApiV1EnvironmentCOZoneCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ZoneCODTO</returns>
        System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOGetAsync (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOGetAsyncWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOZoneCOIdDeleteAsync (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOZoneCOIdDeleteAsyncWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ZoneCODTO</returns>
        System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOIdGetAsync (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOIdGetAsyncWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOZoneCOIdPatchAsync (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOZoneCOIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ZoneCODTO</returns>
        System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOIdPutAsync (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOIdPutAsyncWithHttpInfo (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ZoneCODTO</returns>
        System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOPostAsync (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOPostAsyncWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOZoneCOValidatePostAsync (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOZoneCOValidatePostAsyncWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCOZoneCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCOZoneCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class ZoneCOApi : IZoneCOApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="ZoneCOApi"/> class.
        /// </summary>
        /// <returns></returns>
        public ZoneCOApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ZoneCOApi"/> class
        /// </summary>
        /// <returns></returns>
        public ZoneCOApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="ZoneCOApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public ZoneCOApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ZoneCODTO</returns>
        public ZoneCODTO ApiV1EnvironmentCOZoneCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = ApiV1EnvironmentCOZoneCOGetWithHttpInfo(op, environment, authorizationScope, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        public ApiResponse< ZoneCODTO > ApiV1EnvironmentCOZoneCOGetWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOGet");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ZoneCODTO</returns>
        public async System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOGetAsync (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = await ApiV1EnvironmentCOZoneCOGetAsyncWithHttpInfo(op, environment, authorizationScope, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOGetAsyncWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOGet");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOZoneCOIdDelete (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiV1EnvironmentCOZoneCOIdDeleteWithHttpInfo(id, environment, tipocfMg08, macroareaMg08, areaMg08, authorizationScope, company, user, acceptLanguage);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOZoneCOIdDeleteWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOZoneCOIdDeleteAsync (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             await ApiV1EnvironmentCOZoneCOIdDeleteAsyncWithHttpInfo(id, environment, tipocfMg08, macroareaMg08, areaMg08, authorizationScope, company, user, acceptLanguage);

        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOZoneCOIdDeleteAsyncWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdDelete");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ZoneCODTO</returns>
        public ZoneCODTO ApiV1EnvironmentCOZoneCOIdGet (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = ApiV1EnvironmentCOZoneCOIdGetWithHttpInfo(id, environment, tipocfMg08, macroareaMg08, areaMg08, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        public ApiResponse< ZoneCODTO > ApiV1EnvironmentCOZoneCOIdGetWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ZoneCODTO</returns>
        public async System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOIdGetAsync (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = await ApiV1EnvironmentCOZoneCOIdGetAsyncWithHttpInfo(id, environment, tipocfMg08, macroareaMg08, areaMg08, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOIdGetAsyncWithHttpInfo (string id, string environment, string tipocfMg08, string macroareaMg08, string areaMg08, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOZoneCOIdPatch (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCOZoneCOIdPatchWithHttpInfo(body, authorizationScope, tipocfMg08, macroareaMg08, areaMg08, id, environment, acceptLanguage, force, op, company, user);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOZoneCOIdPatchWithHttpInfo (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOZoneCOIdPatchAsync (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCOZoneCOIdPatchAsyncWithHttpInfo(body, authorizationScope, tipocfMg08, macroareaMg08, areaMg08, id, environment, acceptLanguage, force, op, company, user);

        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOZoneCOIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPatch");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ZoneCODTO</returns>
        public ZoneCODTO ApiV1EnvironmentCOZoneCOIdPut (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = ApiV1EnvironmentCOZoneCOIdPutWithHttpInfo(body, authorizationScope, tipocfMg08, macroareaMg08, areaMg08, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        public ApiResponse< ZoneCODTO > ApiV1EnvironmentCOZoneCOIdPutWithHttpInfo (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ZoneCODTO</returns>
        public async System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOIdPutAsync (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = await ApiV1EnvironmentCOZoneCOIdPutAsyncWithHttpInfo(body, authorizationScope, tipocfMg08, macroareaMg08, areaMg08, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="tipocfMg08">TipocfMg08 Mandatory to execute current action</param>
        /// <param name="macroareaMg08">MacroareaMg08 Mandatory to execute current action</param>
        /// <param name="areaMg08">AreaMg08 Mandatory to execute current action</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOIdPutAsyncWithHttpInfo (ZoneCODTO body, string authorizationScope, string tipocfMg08, string macroareaMg08, string areaMg08, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'tipocfMg08' is set
            if (tipocfMg08 == null)
                throw new ApiException(400, "Missing required parameter 'tipocfMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'macroareaMg08' is set
            if (macroareaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'macroareaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'areaMg08' is set
            if (areaMg08 == null)
                throw new ApiException(400, "Missing required parameter 'areaMg08' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOIdPut");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (tipocfMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "TipocfMg08", tipocfMg08)); // query parameter
            if (macroareaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "MacroareaMg08", macroareaMg08)); // query parameter
            if (areaMg08 != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "AreaMg08", areaMg08)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ZoneCODTO</returns>
        public ZoneCODTO ApiV1EnvironmentCOZoneCOPost (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = ApiV1EnvironmentCOZoneCOPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ZoneCODTO</returns>
        public ApiResponse< ZoneCODTO > ApiV1EnvironmentCOZoneCOPostWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOPost");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ZoneCODTO</returns>
        public async System.Threading.Tasks.Task<ZoneCODTO> ApiV1EnvironmentCOZoneCOPostAsync (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ZoneCODTO> localVarResponse = await ApiV1EnvironmentCOZoneCOPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ZoneCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ZoneCODTO>> ApiV1EnvironmentCOZoneCOPostAsyncWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOPost");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ZoneCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ZoneCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ZoneCODTO)));
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOZoneCOValidatePost (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCOZoneCOValidatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOZoneCOValidatePostWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOZoneCOValidatePostAsync (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCOZoneCOValidatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);

        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOZoneCOValidatePostAsyncWithHttpInfo (ZoneCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        public ValidateDTO ApiV1EnvironmentCOZoneCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = ApiV1EnvironmentCOZoneCOValidatePropertiesPostWithHttpInfo(authorizationScope, environment, body, acceptLanguage, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        public ApiResponse< ValidateDTO > ApiV1EnvironmentCOZoneCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        public async System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCOZoneCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = await ApiV1EnvironmentCOZoneCOValidatePropertiesPostAsyncWithHttpInfo(authorizationScope, environment, body, acceptLanguage, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCOZoneCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling ZoneCOApi->ApiV1EnvironmentCOZoneCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/ZoneCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOZoneCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

    }
}
