/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG1M_UFFICIOPA - Uffici e riferimenti amministrativi&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;CodDestin&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;CodiceCg16&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;TipocfCg44&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class OfficePACODTO :  IEquatable<OfficePACODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OfficePACODTO" /> class.
        /// </summary>
        /// <param name="cap">CG1M_CAP - Cap.</param>
        /// <param name="codDestin">CG1M_CODDESTIN - Codice destinatario (required).</param>
        /// <param name="codice">CG1M_CODICE - Codice (required).</param>
        /// <param name="codiceCg16">CG1M_CODICE_CG16 - Codice anagrafica generale (required).</param>
        /// <param name="comune">CG1M_COMUNE - Comune.</param>
        /// <param name="flgPreferenziale">CG1M_FLGPREFERENZIALE - Preferenziale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="idprovincia">CG1M_IDPROVINCIA - Cod. Provincia (default to 0).</param>
        /// <param name="idregione">CG1M_IDREGIONE - Cod. Regione (default to 0).</param>
        /// <param name="indIrizzo">CG1M_INDIRIZZO - Indirizzo.</param>
        /// <param name="indTypeb2b">CG1M_INDTYPEB2B - Instradamento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;99&lt;/i&gt; - Non attivo&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - FEPA&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - FEPR&lt;/li&gt;&lt;/ul&gt; (default to 99).</param>
        /// <param name="lastupdateB2b">CG1M_LASTUPDATE_B2B - Data ultimo aggiornamento.</param>
        /// <param name="nome">CG1M_NOME - Denominazione (required).</param>
        /// <param name="tipocfCg44">CG1M_TIPOCF_CG44 - Tipo Cliente / Fornitore&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public OfficePACODTO(string cap = default(string), string codDestin = default(string), string codice = default(string), int? codiceCg16 = default(int?), string comune = default(string), int? flgPreferenziale = 0, int? idprovincia = 0, int? idregione = 0, string indIrizzo = default(string), int? indTypeb2b = 99, DateTime? lastupdateB2b = default(DateTime?), string nome = default(string), double? tipocfCg44 = 0, List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codDestin" is required (not null)
            if (codDestin == null)
            {
                throw new InvalidDataException("codDestin is a required property for OfficePACODTO and cannot be null");
            }
            else
            {
                this.CodDestin = codDestin;
            }
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for OfficePACODTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            // to ensure "codiceCg16" is required (not null)
            if (codiceCg16 == null)
            {
                throw new InvalidDataException("codiceCg16 is a required property for OfficePACODTO and cannot be null");
            }
            else
            {
                this.CodiceCg16 = codiceCg16;
            }
            // to ensure "nome" is required (not null)
            if (nome == null)
            {
                throw new InvalidDataException("nome is a required property for OfficePACODTO and cannot be null");
            }
            else
            {
                this.Nome = nome;
            }
            this.Cap = cap;
            this.Comune = comune;
            // use default value if no "flgPreferenziale" provided
            if (flgPreferenziale == null)
            {
                this.FlgPreferenziale = 0;
            }
            else
            {
                this.FlgPreferenziale = flgPreferenziale;
            }
            // use default value if no "idprovincia" provided
            if (idprovincia == null)
            {
                this.Idprovincia = 0;
            }
            else
            {
                this.Idprovincia = idprovincia;
            }
            // use default value if no "idregione" provided
            if (idregione == null)
            {
                this.Idregione = 0;
            }
            else
            {
                this.Idregione = idregione;
            }
            this.IndIrizzo = indIrizzo;
            // use default value if no "indTypeb2b" provided
            if (indTypeb2b == null)
            {
                this.IndTypeb2b = 99;
            }
            else
            {
                this.IndTypeb2b = indTypeb2b;
            }
            this.LastupdateB2b = lastupdateB2b;
            // use default value if no "tipocfCg44" provided
            if (tipocfCg44 == null)
            {
                this.TipocfCg44 = 0;
            }
            else
            {
                this.TipocfCg44 = tipocfCg44;
            }
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG1M_CAP - Cap
        /// </summary>
        /// <value>CG1M_CAP - Cap</value>
        [DataMember(Name="cap", EmitDefaultValue=false)]
        public string Cap { get; set; }

        /// <summary>
        /// CG1M_CODDESTIN - Codice destinatario
        /// </summary>
        /// <value>CG1M_CODDESTIN - Codice destinatario</value>
        [DataMember(Name="codDestin", EmitDefaultValue=false)]
        public string CodDestin { get; set; }

        /// <summary>
        /// CG1M_CODICE - Codice
        /// </summary>
        /// <value>CG1M_CODICE - Codice</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// CG1M_CODICE_CG16 - Codice anagrafica generale
        /// </summary>
        /// <value>CG1M_CODICE_CG16 - Codice anagrafica generale</value>
        [DataMember(Name="codiceCg16", EmitDefaultValue=false)]
        public int? CodiceCg16 { get; set; }

        /// <summary>
        /// CG1M_COMUNE - Comune
        /// </summary>
        /// <value>CG1M_COMUNE - Comune</value>
        [DataMember(Name="comune", EmitDefaultValue=false)]
        public string Comune { get; set; }

        /// <summary>
        /// CG1M_FLGPREFERENZIALE - Preferenziale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG1M_FLGPREFERENZIALE - Preferenziale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgPreferenziale", EmitDefaultValue=false)]
        public int? FlgPreferenziale { get; set; }

        /// <summary>
        /// CG1M_IDPROVINCIA - Cod. Provincia
        /// </summary>
        /// <value>CG1M_IDPROVINCIA - Cod. Provincia</value>
        [DataMember(Name="idprovincia", EmitDefaultValue=false)]
        public int? Idprovincia { get; set; }

        /// <summary>
        /// CG1M_IDREGIONE - Cod. Regione
        /// </summary>
        /// <value>CG1M_IDREGIONE - Cod. Regione</value>
        [DataMember(Name="idregione", EmitDefaultValue=false)]
        public int? Idregione { get; set; }

        /// <summary>
        /// CG1M_INDIRIZZO - Indirizzo
        /// </summary>
        /// <value>CG1M_INDIRIZZO - Indirizzo</value>
        [DataMember(Name="indIrizzo", EmitDefaultValue=false)]
        public string IndIrizzo { get; set; }

        /// <summary>
        /// CG1M_INDTYPEB2B - Instradamento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;99&lt;/i&gt; - Non attivo&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - FEPA&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - FEPR&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG1M_INDTYPEB2B - Instradamento&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;99&lt;/i&gt; - Non attivo&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - FEPA&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - FEPR&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTypeb2b", EmitDefaultValue=false)]
        public int? IndTypeb2b { get; set; }

        /// <summary>
        /// CG1M_LASTUPDATE_B2B - Data ultimo aggiornamento
        /// </summary>
        /// <value>CG1M_LASTUPDATE_B2B - Data ultimo aggiornamento</value>
        [DataMember(Name="lastupdateB2b", EmitDefaultValue=false)]
        public DateTime? LastupdateB2b { get; set; }

        /// <summary>
        /// CG1M_NOME - Denominazione
        /// </summary>
        /// <value>CG1M_NOME - Denominazione</value>
        [DataMember(Name="nome", EmitDefaultValue=false)]
        public string Nome { get; set; }

        /// <summary>
        /// CG1M_TIPOCF_CG44 - Tipo Cliente / Fornitore&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG1M_TIPOCF_CG44 - Tipo Cliente / Fornitore&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Cliente&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Fornitore&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipocfCg44", EmitDefaultValue=false)]
        public double? TipocfCg44 { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class OfficePACODTO {\n");
            sb.Append("  Cap: ").Append(Cap).Append("\n");
            sb.Append("  CodDestin: ").Append(CodDestin).Append("\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  CodiceCg16: ").Append(CodiceCg16).Append("\n");
            sb.Append("  Comune: ").Append(Comune).Append("\n");
            sb.Append("  FlgPreferenziale: ").Append(FlgPreferenziale).Append("\n");
            sb.Append("  Idprovincia: ").Append(Idprovincia).Append("\n");
            sb.Append("  Idregione: ").Append(Idregione).Append("\n");
            sb.Append("  IndIrizzo: ").Append(IndIrizzo).Append("\n");
            sb.Append("  IndTypeb2b: ").Append(IndTypeb2b).Append("\n");
            sb.Append("  LastupdateB2b: ").Append(LastupdateB2b).Append("\n");
            sb.Append("  Nome: ").Append(Nome).Append("\n");
            sb.Append("  TipocfCg44: ").Append(TipocfCg44).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as OfficePACODTO);
        }

        /// <summary>
        /// Returns true if OfficePACODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of OfficePACODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(OfficePACODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Cap == input.Cap ||
                    (this.Cap != null &&
                    this.Cap.Equals(input.Cap))
                ) && 
                (
                    this.CodDestin == input.CodDestin ||
                    (this.CodDestin != null &&
                    this.CodDestin.Equals(input.CodDestin))
                ) && 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.CodiceCg16 == input.CodiceCg16 ||
                    (this.CodiceCg16 != null &&
                    this.CodiceCg16.Equals(input.CodiceCg16))
                ) && 
                (
                    this.Comune == input.Comune ||
                    (this.Comune != null &&
                    this.Comune.Equals(input.Comune))
                ) && 
                (
                    this.FlgPreferenziale == input.FlgPreferenziale ||
                    (this.FlgPreferenziale != null &&
                    this.FlgPreferenziale.Equals(input.FlgPreferenziale))
                ) && 
                (
                    this.Idprovincia == input.Idprovincia ||
                    (this.Idprovincia != null &&
                    this.Idprovincia.Equals(input.Idprovincia))
                ) && 
                (
                    this.Idregione == input.Idregione ||
                    (this.Idregione != null &&
                    this.Idregione.Equals(input.Idregione))
                ) && 
                (
                    this.IndIrizzo == input.IndIrizzo ||
                    (this.IndIrizzo != null &&
                    this.IndIrizzo.Equals(input.IndIrizzo))
                ) && 
                (
                    this.IndTypeb2b == input.IndTypeb2b ||
                    (this.IndTypeb2b != null &&
                    this.IndTypeb2b.Equals(input.IndTypeb2b))
                ) && 
                (
                    this.LastupdateB2b == input.LastupdateB2b ||
                    (this.LastupdateB2b != null &&
                    this.LastupdateB2b.Equals(input.LastupdateB2b))
                ) && 
                (
                    this.Nome == input.Nome ||
                    (this.Nome != null &&
                    this.Nome.Equals(input.Nome))
                ) && 
                (
                    this.TipocfCg44 == input.TipocfCg44 ||
                    (this.TipocfCg44 != null &&
                    this.TipocfCg44.Equals(input.TipocfCg44))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Cap != null)
                    hashCode = hashCode * 59 + this.Cap.GetHashCode();
                if (this.CodDestin != null)
                    hashCode = hashCode * 59 + this.CodDestin.GetHashCode();
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.CodiceCg16 != null)
                    hashCode = hashCode * 59 + this.CodiceCg16.GetHashCode();
                if (this.Comune != null)
                    hashCode = hashCode * 59 + this.Comune.GetHashCode();
                if (this.FlgPreferenziale != null)
                    hashCode = hashCode * 59 + this.FlgPreferenziale.GetHashCode();
                if (this.Idprovincia != null)
                    hashCode = hashCode * 59 + this.Idprovincia.GetHashCode();
                if (this.Idregione != null)
                    hashCode = hashCode * 59 + this.Idregione.GetHashCode();
                if (this.IndIrizzo != null)
                    hashCode = hashCode * 59 + this.IndIrizzo.GetHashCode();
                if (this.IndTypeb2b != null)
                    hashCode = hashCode * 59 + this.IndTypeb2b.GetHashCode();
                if (this.LastupdateB2b != null)
                    hashCode = hashCode * 59 + this.LastupdateB2b.GetHashCode();
                if (this.Nome != null)
                    hashCode = hashCode * 59 + this.Nome.GetHashCode();
                if (this.TipocfCg44 != null)
                    hashCode = hashCode * 59 + this.TipocfCg44.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
