/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// Parameter to set the new document status.
    /// </summary>
    [DataContract]
        public partial class SetStateParameterDTO :  IEquatable<SetStateParameterDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SetStateParameterDTO" /> class.
        /// </summary>
        /// <param name="guidObject">Guid of the object you want to change the state..</param>
        /// <param name="newState">New state to set if there is a current state.</param>
        /// <param name="entityCodeForDefault">Entity code to find any default. Managed values: 1&#x3D;Customers 2&#x3D;Suppliers 6&#x3D;Items 7&#x3D;Document header 8&#x3D;Document row.</param>
        public SetStateParameterDTO(Guid? guidObject = default(Guid?), int? newState = default(int?), int? entityCodeForDefault = default(int?))
        {
            this.GuidObject = guidObject;
            this.NewState = newState;
            this.EntityCodeForDefault = entityCodeForDefault;
        }
        
        /// <summary>
        /// Guid of the object you want to change the state.
        /// </summary>
        /// <value>Guid of the object you want to change the state.</value>
        [DataMember(Name="guidObject", EmitDefaultValue=false)]
        public Guid? GuidObject { get; set; }

        /// <summary>
        /// New state to set if there is a current state
        /// </summary>
        /// <value>New state to set if there is a current state</value>
        [DataMember(Name="newState", EmitDefaultValue=false)]
        public int? NewState { get; set; }

        /// <summary>
        /// Entity code to find any default. Managed values: 1&#x3D;Customers 2&#x3D;Suppliers 6&#x3D;Items 7&#x3D;Document header 8&#x3D;Document row
        /// </summary>
        /// <value>Entity code to find any default. Managed values: 1&#x3D;Customers 2&#x3D;Suppliers 6&#x3D;Items 7&#x3D;Document header 8&#x3D;Document row</value>
        [DataMember(Name="entityCodeForDefault", EmitDefaultValue=false)]
        public int? EntityCodeForDefault { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class SetStateParameterDTO {\n");
            sb.Append("  GuidObject: ").Append(GuidObject).Append("\n");
            sb.Append("  NewState: ").Append(NewState).Append("\n");
            sb.Append("  EntityCodeForDefault: ").Append(EntityCodeForDefault).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as SetStateParameterDTO);
        }

        /// <summary>
        /// Returns true if SetStateParameterDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of SetStateParameterDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(SetStateParameterDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.GuidObject == input.GuidObject ||
                    (this.GuidObject != null &&
                    this.GuidObject.Equals(input.GuidObject))
                ) && 
                (
                    this.NewState == input.NewState ||
                    (this.NewState != null &&
                    this.NewState.Equals(input.NewState))
                ) && 
                (
                    this.EntityCodeForDefault == input.EntityCodeForDefault ||
                    (this.EntityCodeForDefault != null &&
                    this.EntityCodeForDefault.Equals(input.EntityCodeForDefault))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.GuidObject != null)
                    hashCode = hashCode * 59 + this.GuidObject.GetHashCode();
                if (this.NewState != null)
                    hashCode = hashCode * 59 + this.NewState.GetHashCode();
                if (this.EntityCodeForDefault != null)
                    hashCode = hashCode * 59 + this.EntityCodeForDefault.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
