/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG15_TABCAUPREST - Causale prestazione per soggetti con ritenuta d&#x27;acconto&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class WTCodeCODTO :  IEquatable<WTCodeCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WTCodeCODTO" /> class.
        /// </summary>
        /// <param name="causdd1">CG15_CAUSDD1 - Causale.</param>
        /// <param name="codFiscPrev">CG15_CODFISCPREV - Codice fiscale ente previdenziale.</param>
        /// <param name="codice">CG15_CODICE - Codice (required).</param>
        /// <param name="codNonsog">CG15_CODNONSOG - Codice reddito non soggetto CU.</param>
        /// <param name="codPrev">CG15_CODPREV - Cod. ente previdenziale CU.</param>
        /// <param name="codTribrp">CG15_CODTRIBRP - Trib.RP.</param>
        /// <param name="codTributo">CG15_CODTRIBUTO - Trib.RA.</param>
        /// <param name="descr">CG15_DESCR - Descrizione.</param>
        /// <param name="flgGlad">CG15_FLGGLAD - GLA/D&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgMinimi">CG15_FLGMINIMI - FlgMinimi&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgPignTerzi">CG15_FLGPIGNTERZI - Pignoramento presso terzi.</param>
        /// <param name="flgProteo360">CG15_FLGPROTEO360 - FlgProteo360&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgRegagevo">CG15_FLGREGAGEVO - R.Ag.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgRitImposta">CG15_FLGRITIMPOSTA - Ritenuta a titolo d&#x27;imposta.</param>
        /// <param name="flgSosprit">CG15_FLGSOSPRIT - FlgSosprit&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="gcprev">CG15_GCPREV - g/c contributi previdenziali&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Data documento&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Data pagamento&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="idmediaCg99">CG15_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="idprov">CG15_IDPROV - IdProv (Required only in PUT/PATCH).</param>
        /// <param name="indCodattglad">CG15_INDCODATTGLAD - Attività modello GLA/D&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Amministratore, revisore, liquidatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Amministratore di condominio&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Archiviazione, traduzioni, servizi amm. e contabili&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Assistenza tecnica macchinari, impianti&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Collaborazione giornali, riviste, enciclopedie&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Consulenze aziendali, fiscali, amministr.&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Estetica, igiene in genere&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Formazione, istruzione, addestramento&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Intermediazioni, recup. crediti, notifica atti&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Moda, arte, sport, spettacolo&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - Partecipanti a collegi e commissioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Salute, assistenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Sondaggi di opinione, marketing, pubblicita&#x27;&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Trasporti e spedizioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - Turismo, animazione, intrattenimento&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - Vendite a domicilio&lt;/li&gt;&lt;li&gt;&lt;i&gt;17&lt;/i&gt; - Altre&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indTipocassa">CG15_INDTIPOCASSA - Tipo cassa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Cassa nazionale previdenza e assistenza avvocati e procuratori legali&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Cassa previdenza dottori commercialisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Cassa previdenza e assistenza geometri&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Cassa nazionale previdenza e assistenza ingegneri e architetti liberi professionisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cassa nazionale del notariato&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cassa nazionale previdenza e assistenza ragionieri e periti commerciali&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Ente nazionale assistenza agenti e rappresentanti di commercio (ENASARCO)&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Ente nazionale previdenza e assistenza consulenti del lavoro (ENPACL)&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Ente nazionale previdenza e assistenza medici (ENPAM)&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Ente nazionale previdenza e assistenza farmacisti (ENPAF)&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - Ente nazionale previdenza e assistenza veterinari (ENPAV)&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Ente nazionale previdenza e assistenza impiegati dell&#x27;agricoltura (ENPAIA)&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Fondo previdenza impiegati imprese di spedizione e agenzie marittime&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Istituto nazionale previdenza giornalisti italiani (INPGI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - Opera nazionale assistenza orfani sanitari italiani (ONAOSI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - Cassa autonoma assistenza integrativa giornalisti italiani (CASAGIT)&lt;/li&gt;&lt;li&gt;&lt;i&gt;17&lt;/i&gt; - Ente previdenza periti industriali e periti industriali laureati (EPPI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;18&lt;/i&gt; - Ente previdenza e assistenza pluricategoriale (EPAP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;19&lt;/i&gt; - Ente nazionale previdenza e assistenza biologi (ENPAB)&lt;/li&gt;&lt;li&gt;&lt;i&gt;20&lt;/i&gt; - Ente nazionale previdenza e assistenza professione infermieristica (ENPAPI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;21&lt;/i&gt; - Ente nazionale previdenza e assistenza psicologi (ENPAP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;22&lt;/i&gt; - INPS&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="inpsivs">CG15_INPSIVS - % R.P..</param>
        /// <param name="percbaseimp">CG15_PERCBASEIMP - % B.imp..</param>
        /// <param name="percci">CG15_PERCCI - % C.I..</param>
        /// <param name="percra">CG15_PERCRA - % R.A..</param>
        /// <param name="percripaz">CG15_PERCRIPAZ - % Az..</param>
        /// <param name="percRipPerc">% Perc..</param>
        /// <param name="rowversion">CG15_ROWVERSION - Rowversion.</param>
        /// <param name="tiporapporto">CG15_TIPORAPPPREV - Tipo rapporto.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public WTCodeCODTO(string causdd1 = default(string), string codFiscPrev = default(string), string codice = default(string), double? codNonsog = default(double?), string codPrev = default(string), string codTribrp = default(string), string codTributo = default(string), string descr = default(string), double? flgGlad = 0, int? flgMinimi = 0, double? flgPignTerzi = default(double?), double? flgProteo360 = 0, double? flgRegagevo = 0, double? flgRitImposta = default(double?), int? flgSosprit = 0, int? gcprev = 0, double? idmediaCg99 = default(double?), double? idprov = default(double?), double? indCodattglad = 0, int? indTipocassa = 0, double? inpsivs = default(double?), double? percbaseimp = default(double?), double? percci = default(double?), double? percra = default(double?), double? percripaz = default(double?), double? percRipPerc = default(double?), byte[] rowversion = default(byte[]), string tiporapporto = default(string), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for WTCodeCODTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            this.Causdd1 = causdd1;
            this.CodFiscPrev = codFiscPrev;
            this.CodNonsog = codNonsog;
            this.CodPrev = codPrev;
            this.CodTribrp = codTribrp;
            this.CodTributo = codTributo;
            this.Descr = descr;
            // use default value if no "flgGlad" provided
            if (flgGlad == null)
            {
                this.FlgGlad = 0;
            }
            else
            {
                this.FlgGlad = flgGlad;
            }
            // use default value if no "flgMinimi" provided
            if (flgMinimi == null)
            {
                this.FlgMinimi = 0;
            }
            else
            {
                this.FlgMinimi = flgMinimi;
            }
            this.FlgPignTerzi = flgPignTerzi;
            // use default value if no "flgProteo360" provided
            if (flgProteo360 == null)
            {
                this.FlgProteo360 = 0;
            }
            else
            {
                this.FlgProteo360 = flgProteo360;
            }
            // use default value if no "flgRegagevo" provided
            if (flgRegagevo == null)
            {
                this.FlgRegagevo = 0;
            }
            else
            {
                this.FlgRegagevo = flgRegagevo;
            }
            this.FlgRitImposta = flgRitImposta;
            // use default value if no "flgSosprit" provided
            if (flgSosprit == null)
            {
                this.FlgSosprit = 0;
            }
            else
            {
                this.FlgSosprit = flgSosprit;
            }
            // use default value if no "gcprev" provided
            if (gcprev == null)
            {
                this.Gcprev = 0;
            }
            else
            {
                this.Gcprev = gcprev;
            }
            this.IdmediaCg99 = idmediaCg99;
            this.Idprov = idprov;
            // use default value if no "indCodattglad" provided
            if (indCodattglad == null)
            {
                this.IndCodattglad = 0;
            }
            else
            {
                this.IndCodattglad = indCodattglad;
            }
            // use default value if no "indTipocassa" provided
            if (indTipocassa == null)
            {
                this.IndTipocassa = 0;
            }
            else
            {
                this.IndTipocassa = indTipocassa;
            }
            this.Inpsivs = inpsivs;
            this.Percbaseimp = percbaseimp;
            this.Percci = percci;
            this.Percra = percra;
            this.Percripaz = percripaz;
            this.PercRipPerc = percRipPerc;
            this.Rowversion = rowversion;
            this.Tiporapporto = tiporapporto;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG15_CAUSDD1 - Causale
        /// </summary>
        /// <value>CG15_CAUSDD1 - Causale</value>
        [DataMember(Name="causdd1", EmitDefaultValue=false)]
        public string Causdd1 { get; set; }

        /// <summary>
        /// CG15_CODFISCPREV - Codice fiscale ente previdenziale
        /// </summary>
        /// <value>CG15_CODFISCPREV - Codice fiscale ente previdenziale</value>
        [DataMember(Name="codFiscPrev", EmitDefaultValue=false)]
        public string CodFiscPrev { get; set; }

        /// <summary>
        /// CG15_CODICE - Codice
        /// </summary>
        /// <value>CG15_CODICE - Codice</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public string Codice { get; set; }

        /// <summary>
        /// CG15_CODNONSOG - Codice reddito non soggetto CU
        /// </summary>
        /// <value>CG15_CODNONSOG - Codice reddito non soggetto CU</value>
        [DataMember(Name="codNonsog", EmitDefaultValue=false)]
        public double? CodNonsog { get; set; }

        /// <summary>
        /// CG15_CODPREV - Cod. ente previdenziale CU
        /// </summary>
        /// <value>CG15_CODPREV - Cod. ente previdenziale CU</value>
        [DataMember(Name="codPrev", EmitDefaultValue=false)]
        public string CodPrev { get; set; }

        /// <summary>
        /// CG15_CODTRIBRP - Trib.RP
        /// </summary>
        /// <value>CG15_CODTRIBRP - Trib.RP</value>
        [DataMember(Name="codTribrp", EmitDefaultValue=false)]
        public string CodTribrp { get; set; }

        /// <summary>
        /// CG15_CODTRIBUTO - Trib.RA
        /// </summary>
        /// <value>CG15_CODTRIBUTO - Trib.RA</value>
        [DataMember(Name="codTributo", EmitDefaultValue=false)]
        public string CodTributo { get; set; }

        /// <summary>
        /// CG15_DESCR - Descrizione
        /// </summary>
        /// <value>CG15_DESCR - Descrizione</value>
        [DataMember(Name="descr", EmitDefaultValue=false)]
        public string Descr { get; set; }

        /// <summary>
        /// CG15_FLGGLAD - GLA/D&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_FLGGLAD - GLA/D&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgGlad", EmitDefaultValue=false)]
        public double? FlgGlad { get; set; }

        /// <summary>
        /// CG15_FLGMINIMI - FlgMinimi&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_FLGMINIMI - FlgMinimi&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgMinimi", EmitDefaultValue=false)]
        public int? FlgMinimi { get; set; }

        /// <summary>
        /// CG15_FLGPIGNTERZI - Pignoramento presso terzi
        /// </summary>
        /// <value>CG15_FLGPIGNTERZI - Pignoramento presso terzi</value>
        [DataMember(Name="flgPignTerzi", EmitDefaultValue=false)]
        public double? FlgPignTerzi { get; set; }

        /// <summary>
        /// CG15_FLGPROTEO360 - FlgProteo360&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_FLGPROTEO360 - FlgProteo360&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgProteo360", EmitDefaultValue=false)]
        public double? FlgProteo360 { get; set; }

        /// <summary>
        /// CG15_FLGREGAGEVO - R.Ag.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_FLGREGAGEVO - R.Ag.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgRegagevo", EmitDefaultValue=false)]
        public double? FlgRegagevo { get; set; }

        /// <summary>
        /// CG15_FLGRITIMPOSTA - Ritenuta a titolo d&#x27;imposta
        /// </summary>
        /// <value>CG15_FLGRITIMPOSTA - Ritenuta a titolo d&#x27;imposta</value>
        [DataMember(Name="flgRitImposta", EmitDefaultValue=false)]
        public double? FlgRitImposta { get; set; }

        /// <summary>
        /// CG15_FLGSOSPRIT - FlgSosprit&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_FLGSOSPRIT - FlgSosprit&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSosprit", EmitDefaultValue=false)]
        public int? FlgSosprit { get; set; }

        /// <summary>
        /// CG15_GCPREV - g/c contributi previdenziali&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Data documento&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Data pagamento&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_GCPREV - g/c contributi previdenziali&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Data documento&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Data pagamento&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="gcprev", EmitDefaultValue=false)]
        public int? Gcprev { get; set; }

        /// <summary>
        /// CG15_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>CG15_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// CG15_IDPROV - IdProv (Required only in PUT/PATCH)
        /// </summary>
        /// <value>CG15_IDPROV - IdProv (Required only in PUT/PATCH)</value>
        [DataMember(Name="idprov", EmitDefaultValue=false)]
        public double? Idprov { get; set; }

        /// <summary>
        /// CG15_INDCODATTGLAD - Attività modello GLA/D&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Amministratore, revisore, liquidatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Amministratore di condominio&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Archiviazione, traduzioni, servizi amm. e contabili&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Assistenza tecnica macchinari, impianti&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Collaborazione giornali, riviste, enciclopedie&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Consulenze aziendali, fiscali, amministr.&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Estetica, igiene in genere&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Formazione, istruzione, addestramento&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Intermediazioni, recup. crediti, notifica atti&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Moda, arte, sport, spettacolo&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - Partecipanti a collegi e commissioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Salute, assistenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Sondaggi di opinione, marketing, pubblicita&#x27;&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Trasporti e spedizioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - Turismo, animazione, intrattenimento&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - Vendite a domicilio&lt;/li&gt;&lt;li&gt;&lt;i&gt;17&lt;/i&gt; - Altre&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_INDCODATTGLAD - Attività modello GLA/D&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Amministratore, revisore, liquidatore&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Amministratore di condominio&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Archiviazione, traduzioni, servizi amm. e contabili&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Assistenza tecnica macchinari, impianti&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Collaborazione giornali, riviste, enciclopedie&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Consulenze aziendali, fiscali, amministr.&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Estetica, igiene in genere&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Formazione, istruzione, addestramento&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Intermediazioni, recup. crediti, notifica atti&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Moda, arte, sport, spettacolo&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - Partecipanti a collegi e commissioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Salute, assistenza&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Sondaggi di opinione, marketing, pubblicita&#x27;&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Trasporti e spedizioni&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - Turismo, animazione, intrattenimento&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - Vendite a domicilio&lt;/li&gt;&lt;li&gt;&lt;i&gt;17&lt;/i&gt; - Altre&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indCodattglad", EmitDefaultValue=false)]
        public double? IndCodattglad { get; set; }

        /// <summary>
        /// CG15_INDTIPOCASSA - Tipo cassa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Cassa nazionale previdenza e assistenza avvocati e procuratori legali&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Cassa previdenza dottori commercialisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Cassa previdenza e assistenza geometri&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Cassa nazionale previdenza e assistenza ingegneri e architetti liberi professionisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cassa nazionale del notariato&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cassa nazionale previdenza e assistenza ragionieri e periti commerciali&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Ente nazionale assistenza agenti e rappresentanti di commercio (ENASARCO)&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Ente nazionale previdenza e assistenza consulenti del lavoro (ENPACL)&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Ente nazionale previdenza e assistenza medici (ENPAM)&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Ente nazionale previdenza e assistenza farmacisti (ENPAF)&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - Ente nazionale previdenza e assistenza veterinari (ENPAV)&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Ente nazionale previdenza e assistenza impiegati dell&#x27;agricoltura (ENPAIA)&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Fondo previdenza impiegati imprese di spedizione e agenzie marittime&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Istituto nazionale previdenza giornalisti italiani (INPGI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - Opera nazionale assistenza orfani sanitari italiani (ONAOSI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - Cassa autonoma assistenza integrativa giornalisti italiani (CASAGIT)&lt;/li&gt;&lt;li&gt;&lt;i&gt;17&lt;/i&gt; - Ente previdenza periti industriali e periti industriali laureati (EPPI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;18&lt;/i&gt; - Ente previdenza e assistenza pluricategoriale (EPAP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;19&lt;/i&gt; - Ente nazionale previdenza e assistenza biologi (ENPAB)&lt;/li&gt;&lt;li&gt;&lt;i&gt;20&lt;/i&gt; - Ente nazionale previdenza e assistenza professione infermieristica (ENPAPI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;21&lt;/i&gt; - Ente nazionale previdenza e assistenza psicologi (ENPAP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;22&lt;/i&gt; - INPS&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG15_INDTIPOCASSA - Tipo cassa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  &lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Cassa nazionale previdenza e assistenza avvocati e procuratori legali&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Cassa previdenza dottori commercialisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Cassa previdenza e assistenza geometri&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Cassa nazionale previdenza e assistenza ingegneri e architetti liberi professionisti&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Cassa nazionale del notariato&lt;/li&gt;&lt;li&gt;&lt;i&gt;6&lt;/i&gt; - Cassa nazionale previdenza e assistenza ragionieri e periti commerciali&lt;/li&gt;&lt;li&gt;&lt;i&gt;7&lt;/i&gt; - Ente nazionale assistenza agenti e rappresentanti di commercio (ENASARCO)&lt;/li&gt;&lt;li&gt;&lt;i&gt;8&lt;/i&gt; - Ente nazionale previdenza e assistenza consulenti del lavoro (ENPACL)&lt;/li&gt;&lt;li&gt;&lt;i&gt;9&lt;/i&gt; - Ente nazionale previdenza e assistenza medici (ENPAM)&lt;/li&gt;&lt;li&gt;&lt;i&gt;10&lt;/i&gt; - Ente nazionale previdenza e assistenza farmacisti (ENPAF)&lt;/li&gt;&lt;li&gt;&lt;i&gt;11&lt;/i&gt; - Ente nazionale previdenza e assistenza veterinari (ENPAV)&lt;/li&gt;&lt;li&gt;&lt;i&gt;12&lt;/i&gt; - Ente nazionale previdenza e assistenza impiegati dell&#x27;agricoltura (ENPAIA)&lt;/li&gt;&lt;li&gt;&lt;i&gt;13&lt;/i&gt; - Fondo previdenza impiegati imprese di spedizione e agenzie marittime&lt;/li&gt;&lt;li&gt;&lt;i&gt;14&lt;/i&gt; - Istituto nazionale previdenza giornalisti italiani (INPGI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;15&lt;/i&gt; - Opera nazionale assistenza orfani sanitari italiani (ONAOSI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;16&lt;/i&gt; - Cassa autonoma assistenza integrativa giornalisti italiani (CASAGIT)&lt;/li&gt;&lt;li&gt;&lt;i&gt;17&lt;/i&gt; - Ente previdenza periti industriali e periti industriali laureati (EPPI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;18&lt;/i&gt; - Ente previdenza e assistenza pluricategoriale (EPAP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;19&lt;/i&gt; - Ente nazionale previdenza e assistenza biologi (ENPAB)&lt;/li&gt;&lt;li&gt;&lt;i&gt;20&lt;/i&gt; - Ente nazionale previdenza e assistenza professione infermieristica (ENPAPI)&lt;/li&gt;&lt;li&gt;&lt;i&gt;21&lt;/i&gt; - Ente nazionale previdenza e assistenza psicologi (ENPAP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;22&lt;/i&gt; - INPS&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipocassa", EmitDefaultValue=false)]
        public int? IndTipocassa { get; set; }

        /// <summary>
        /// CG15_INPSIVS - % R.P.
        /// </summary>
        /// <value>CG15_INPSIVS - % R.P.</value>
        [DataMember(Name="inpsivs", EmitDefaultValue=false)]
        public double? Inpsivs { get; set; }

        /// <summary>
        /// CG15_PERCBASEIMP - % B.imp.
        /// </summary>
        /// <value>CG15_PERCBASEIMP - % B.imp.</value>
        [DataMember(Name="percbaseimp", EmitDefaultValue=false)]
        public double? Percbaseimp { get; set; }

        /// <summary>
        /// CG15_PERCCI - % C.I.
        /// </summary>
        /// <value>CG15_PERCCI - % C.I.</value>
        [DataMember(Name="percci", EmitDefaultValue=false)]
        public double? Percci { get; set; }

        /// <summary>
        /// CG15_PERCRA - % R.A.
        /// </summary>
        /// <value>CG15_PERCRA - % R.A.</value>
        [DataMember(Name="percra", EmitDefaultValue=false)]
        public double? Percra { get; set; }

        /// <summary>
        /// CG15_PERCRIPAZ - % Az.
        /// </summary>
        /// <value>CG15_PERCRIPAZ - % Az.</value>
        [DataMember(Name="percripaz", EmitDefaultValue=false)]
        public double? Percripaz { get; set; }

        /// <summary>
        /// % Perc.
        /// </summary>
        /// <value>% Perc.</value>
        [DataMember(Name="percRipPerc", EmitDefaultValue=false)]
        public double? PercRipPerc { get; set; }

        /// <summary>
        /// CG15_ROWVERSION - Rowversion
        /// </summary>
        /// <value>CG15_ROWVERSION - Rowversion</value>
        [DataMember(Name="rowversion", EmitDefaultValue=false)]
        public byte[] Rowversion { get; set; }

        /// <summary>
        /// CG15_TIPORAPPPREV - Tipo rapporto
        /// </summary>
        /// <value>CG15_TIPORAPPPREV - Tipo rapporto</value>
        [DataMember(Name="tiporapporto", EmitDefaultValue=false)]
        public string Tiporapporto { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class WTCodeCODTO {\n");
            sb.Append("  Causdd1: ").Append(Causdd1).Append("\n");
            sb.Append("  CodFiscPrev: ").Append(CodFiscPrev).Append("\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  CodNonsog: ").Append(CodNonsog).Append("\n");
            sb.Append("  CodPrev: ").Append(CodPrev).Append("\n");
            sb.Append("  CodTribrp: ").Append(CodTribrp).Append("\n");
            sb.Append("  CodTributo: ").Append(CodTributo).Append("\n");
            sb.Append("  Descr: ").Append(Descr).Append("\n");
            sb.Append("  FlgGlad: ").Append(FlgGlad).Append("\n");
            sb.Append("  FlgMinimi: ").Append(FlgMinimi).Append("\n");
            sb.Append("  FlgPignTerzi: ").Append(FlgPignTerzi).Append("\n");
            sb.Append("  FlgProteo360: ").Append(FlgProteo360).Append("\n");
            sb.Append("  FlgRegagevo: ").Append(FlgRegagevo).Append("\n");
            sb.Append("  FlgRitImposta: ").Append(FlgRitImposta).Append("\n");
            sb.Append("  FlgSosprit: ").Append(FlgSosprit).Append("\n");
            sb.Append("  Gcprev: ").Append(Gcprev).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  Idprov: ").Append(Idprov).Append("\n");
            sb.Append("  IndCodattglad: ").Append(IndCodattglad).Append("\n");
            sb.Append("  IndTipocassa: ").Append(IndTipocassa).Append("\n");
            sb.Append("  Inpsivs: ").Append(Inpsivs).Append("\n");
            sb.Append("  Percbaseimp: ").Append(Percbaseimp).Append("\n");
            sb.Append("  Percci: ").Append(Percci).Append("\n");
            sb.Append("  Percra: ").Append(Percra).Append("\n");
            sb.Append("  Percripaz: ").Append(Percripaz).Append("\n");
            sb.Append("  PercRipPerc: ").Append(PercRipPerc).Append("\n");
            sb.Append("  Rowversion: ").Append(Rowversion).Append("\n");
            sb.Append("  Tiporapporto: ").Append(Tiporapporto).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as WTCodeCODTO);
        }

        /// <summary>
        /// Returns true if WTCodeCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of WTCodeCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(WTCodeCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Causdd1 == input.Causdd1 ||
                    (this.Causdd1 != null &&
                    this.Causdd1.Equals(input.Causdd1))
                ) && 
                (
                    this.CodFiscPrev == input.CodFiscPrev ||
                    (this.CodFiscPrev != null &&
                    this.CodFiscPrev.Equals(input.CodFiscPrev))
                ) && 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.CodNonsog == input.CodNonsog ||
                    (this.CodNonsog != null &&
                    this.CodNonsog.Equals(input.CodNonsog))
                ) && 
                (
                    this.CodPrev == input.CodPrev ||
                    (this.CodPrev != null &&
                    this.CodPrev.Equals(input.CodPrev))
                ) && 
                (
                    this.CodTribrp == input.CodTribrp ||
                    (this.CodTribrp != null &&
                    this.CodTribrp.Equals(input.CodTribrp))
                ) && 
                (
                    this.CodTributo == input.CodTributo ||
                    (this.CodTributo != null &&
                    this.CodTributo.Equals(input.CodTributo))
                ) && 
                (
                    this.Descr == input.Descr ||
                    (this.Descr != null &&
                    this.Descr.Equals(input.Descr))
                ) && 
                (
                    this.FlgGlad == input.FlgGlad ||
                    (this.FlgGlad != null &&
                    this.FlgGlad.Equals(input.FlgGlad))
                ) && 
                (
                    this.FlgMinimi == input.FlgMinimi ||
                    (this.FlgMinimi != null &&
                    this.FlgMinimi.Equals(input.FlgMinimi))
                ) && 
                (
                    this.FlgPignTerzi == input.FlgPignTerzi ||
                    (this.FlgPignTerzi != null &&
                    this.FlgPignTerzi.Equals(input.FlgPignTerzi))
                ) && 
                (
                    this.FlgProteo360 == input.FlgProteo360 ||
                    (this.FlgProteo360 != null &&
                    this.FlgProteo360.Equals(input.FlgProteo360))
                ) && 
                (
                    this.FlgRegagevo == input.FlgRegagevo ||
                    (this.FlgRegagevo != null &&
                    this.FlgRegagevo.Equals(input.FlgRegagevo))
                ) && 
                (
                    this.FlgRitImposta == input.FlgRitImposta ||
                    (this.FlgRitImposta != null &&
                    this.FlgRitImposta.Equals(input.FlgRitImposta))
                ) && 
                (
                    this.FlgSosprit == input.FlgSosprit ||
                    (this.FlgSosprit != null &&
                    this.FlgSosprit.Equals(input.FlgSosprit))
                ) && 
                (
                    this.Gcprev == input.Gcprev ||
                    (this.Gcprev != null &&
                    this.Gcprev.Equals(input.Gcprev))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.Idprov == input.Idprov ||
                    (this.Idprov != null &&
                    this.Idprov.Equals(input.Idprov))
                ) && 
                (
                    this.IndCodattglad == input.IndCodattglad ||
                    (this.IndCodattglad != null &&
                    this.IndCodattglad.Equals(input.IndCodattglad))
                ) && 
                (
                    this.IndTipocassa == input.IndTipocassa ||
                    (this.IndTipocassa != null &&
                    this.IndTipocassa.Equals(input.IndTipocassa))
                ) && 
                (
                    this.Inpsivs == input.Inpsivs ||
                    (this.Inpsivs != null &&
                    this.Inpsivs.Equals(input.Inpsivs))
                ) && 
                (
                    this.Percbaseimp == input.Percbaseimp ||
                    (this.Percbaseimp != null &&
                    this.Percbaseimp.Equals(input.Percbaseimp))
                ) && 
                (
                    this.Percci == input.Percci ||
                    (this.Percci != null &&
                    this.Percci.Equals(input.Percci))
                ) && 
                (
                    this.Percra == input.Percra ||
                    (this.Percra != null &&
                    this.Percra.Equals(input.Percra))
                ) && 
                (
                    this.Percripaz == input.Percripaz ||
                    (this.Percripaz != null &&
                    this.Percripaz.Equals(input.Percripaz))
                ) && 
                (
                    this.PercRipPerc == input.PercRipPerc ||
                    (this.PercRipPerc != null &&
                    this.PercRipPerc.Equals(input.PercRipPerc))
                ) && 
                (
                    this.Rowversion == input.Rowversion ||
                    (this.Rowversion != null &&
                    this.Rowversion.Equals(input.Rowversion))
                ) && 
                (
                    this.Tiporapporto == input.Tiporapporto ||
                    (this.Tiporapporto != null &&
                    this.Tiporapporto.Equals(input.Tiporapporto))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Causdd1 != null)
                    hashCode = hashCode * 59 + this.Causdd1.GetHashCode();
                if (this.CodFiscPrev != null)
                    hashCode = hashCode * 59 + this.CodFiscPrev.GetHashCode();
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.CodNonsog != null)
                    hashCode = hashCode * 59 + this.CodNonsog.GetHashCode();
                if (this.CodPrev != null)
                    hashCode = hashCode * 59 + this.CodPrev.GetHashCode();
                if (this.CodTribrp != null)
                    hashCode = hashCode * 59 + this.CodTribrp.GetHashCode();
                if (this.CodTributo != null)
                    hashCode = hashCode * 59 + this.CodTributo.GetHashCode();
                if (this.Descr != null)
                    hashCode = hashCode * 59 + this.Descr.GetHashCode();
                if (this.FlgGlad != null)
                    hashCode = hashCode * 59 + this.FlgGlad.GetHashCode();
                if (this.FlgMinimi != null)
                    hashCode = hashCode * 59 + this.FlgMinimi.GetHashCode();
                if (this.FlgPignTerzi != null)
                    hashCode = hashCode * 59 + this.FlgPignTerzi.GetHashCode();
                if (this.FlgProteo360 != null)
                    hashCode = hashCode * 59 + this.FlgProteo360.GetHashCode();
                if (this.FlgRegagevo != null)
                    hashCode = hashCode * 59 + this.FlgRegagevo.GetHashCode();
                if (this.FlgRitImposta != null)
                    hashCode = hashCode * 59 + this.FlgRitImposta.GetHashCode();
                if (this.FlgSosprit != null)
                    hashCode = hashCode * 59 + this.FlgSosprit.GetHashCode();
                if (this.Gcprev != null)
                    hashCode = hashCode * 59 + this.Gcprev.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.Idprov != null)
                    hashCode = hashCode * 59 + this.Idprov.GetHashCode();
                if (this.IndCodattglad != null)
                    hashCode = hashCode * 59 + this.IndCodattglad.GetHashCode();
                if (this.IndTipocassa != null)
                    hashCode = hashCode * 59 + this.IndTipocassa.GetHashCode();
                if (this.Inpsivs != null)
                    hashCode = hashCode * 59 + this.Inpsivs.GetHashCode();
                if (this.Percbaseimp != null)
                    hashCode = hashCode * 59 + this.Percbaseimp.GetHashCode();
                if (this.Percci != null)
                    hashCode = hashCode * 59 + this.Percci.GetHashCode();
                if (this.Percra != null)
                    hashCode = hashCode * 59 + this.Percra.GetHashCode();
                if (this.Percripaz != null)
                    hashCode = hashCode * 59 + this.Percripaz.GetHashCode();
                if (this.PercRipPerc != null)
                    hashCode = hashCode * 59 + this.PercRipPerc.GetHashCode();
                if (this.Rowversion != null)
                    hashCode = hashCode * 59 + this.Rowversion.GetHashCode();
                if (this.Tiporapporto != null)
                    hashCode = hashCode * 59 + this.Tiporapporto.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
