/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface IBankCOApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>BankCODTO</returns>
        BankCODTO ApiV1EnvironmentCOBankCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        ApiResponse<BankCODTO> ApiV1EnvironmentCOBankCOGetWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOBankCOIdDelete (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOBankCOIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>BankCODTO</returns>
        BankCODTO ApiV1EnvironmentCOBankCOIdGet (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        ApiResponse<BankCODTO> ApiV1EnvironmentCOBankCOIdGetWithHttpInfo (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOBankCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOBankCOIdPatchWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>BankCODTO</returns>
        BankCODTO ApiV1EnvironmentCOBankCOIdPut (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        ApiResponse<BankCODTO> ApiV1EnvironmentCOBankCOIdPutWithHttpInfo (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>BankCODTO</returns>
        BankCODTO ApiV1EnvironmentCOBankCOPost (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        ApiResponse<BankCODTO> ApiV1EnvironmentCOBankCOPostWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentCOBankCOValidatePost (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentCOBankCOValidatePostWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        ValidateDTO ApiV1EnvironmentCOBankCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        ApiResponse<ValidateDTO> ApiV1EnvironmentCOBankCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of BankCODTO</returns>
        System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOGetAsync (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOGetAsyncWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOBankCOIdDeleteAsync (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOBankCOIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of BankCODTO</returns>
        System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOIdGetAsync (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOIdGetAsyncWithHttpInfo (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOBankCOIdPatchAsync (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOBankCOIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of BankCODTO</returns>
        System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOIdPutAsync (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOIdPutAsyncWithHttpInfo (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of BankCODTO</returns>
        System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOPostAsync (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOPostAsyncWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentCOBankCOValidatePostAsync (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOBankCOValidatePostAsyncWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCOBankCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCOBankCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class BankCOApi : IBankCOApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="BankCOApi"/> class.
        /// </summary>
        /// <returns></returns>
        public BankCOApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BankCOApi"/> class
        /// </summary>
        /// <returns></returns>
        public BankCOApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BankCOApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public BankCOApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>BankCODTO</returns>
        public BankCODTO ApiV1EnvironmentCOBankCOGet (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<BankCODTO> localVarResponse = ApiV1EnvironmentCOBankCOGetWithHttpInfo(op, environment, authorizationScope, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        public ApiResponse< BankCODTO > ApiV1EnvironmentCOBankCOGetWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling BankCOApi->ApiV1EnvironmentCOBankCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOGet");

            var localVarPath = "/api/v1/{environment}/CO/BankCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of BankCODTO</returns>
        public async System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOGetAsync (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<BankCODTO> localVarResponse = await ApiV1EnvironmentCOBankCOGetAsyncWithHttpInfo(op, environment, authorizationScope, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOGetAsyncWithHttpInfo (string op, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling BankCOApi->ApiV1EnvironmentCOBankCOGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOGet");

            var localVarPath = "/api/v1/{environment}/CO/BankCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOBankCOIdDelete (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiV1EnvironmentCOBankCOIdDeleteWithHttpInfo(id, environment, authorizationScope, company, user, acceptLanguage);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOBankCOIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdDelete");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOBankCOIdDeleteAsync (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
             await ApiV1EnvironmentCOBankCOIdDeleteAsyncWithHttpInfo(id, environment, authorizationScope, company, user, acceptLanguage);

        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOBankCOIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdDelete");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>BankCODTO</returns>
        public BankCODTO ApiV1EnvironmentCOBankCOIdGet (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<BankCODTO> localVarResponse = ApiV1EnvironmentCOBankCOIdGetWithHttpInfo(id, environment, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        public ApiResponse< BankCODTO > ApiV1EnvironmentCOBankCOIdGetWithHttpInfo (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of BankCODTO</returns>
        public async System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOIdGetAsync (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
             ApiResponse<BankCODTO> localVarResponse = await ApiV1EnvironmentCOBankCOIdGetAsyncWithHttpInfo(id, environment, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOIdGetAsyncWithHttpInfo (string id, string environment, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdGet");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOBankCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCOBankCOIdPatchWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, force, op, company, user);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOBankCOIdPatchWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOBankCOIdPatchAsync (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCOBankCOIdPatchAsyncWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, force, op, company, user);

        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOBankCOIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPatch");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>BankCODTO</returns>
        public BankCODTO ApiV1EnvironmentCOBankCOIdPut (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<BankCODTO> localVarResponse = ApiV1EnvironmentCOBankCOIdPutWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        public ApiResponse< BankCODTO > ApiV1EnvironmentCOBankCOIdPutWithHttpInfo (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of BankCODTO</returns>
        public async System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOIdPutAsync (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<BankCODTO> localVarResponse = await ApiV1EnvironmentCOBankCOIdPutAsyncWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, force, op, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOIdPutAsyncWithHttpInfo (BankCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOIdPut");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>BankCODTO</returns>
        public BankCODTO ApiV1EnvironmentCOBankCOPost (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<BankCODTO> localVarResponse = ApiV1EnvironmentCOBankCOPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of BankCODTO</returns>
        public ApiResponse< BankCODTO > ApiV1EnvironmentCOBankCOPostWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOPost");

            var localVarPath = "/api/v1/{environment}/CO/BankCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of BankCODTO</returns>
        public async System.Threading.Tasks.Task<BankCODTO> ApiV1EnvironmentCOBankCOPostAsync (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<BankCODTO> localVarResponse = await ApiV1EnvironmentCOBankCOPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (BankCODTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<BankCODTO>> ApiV1EnvironmentCOBankCOPostAsyncWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOPost");

            var localVarPath = "/api/v1/{environment}/CO/BankCO";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<BankCODTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (BankCODTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(BankCODTO)));
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentCOBankCOValidatePost (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiV1EnvironmentCOBankCOValidatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentCOBankCOValidatePostWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentCOBankCOValidatePostAsync (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentCOBankCOValidatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, company, user);

        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentCOBankCOValidatePostAsyncWithHttpInfo (BankCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePost");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        public ValidateDTO ApiV1EnvironmentCOBankCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = ApiV1EnvironmentCOBankCOValidatePropertiesPostWithHttpInfo(authorizationScope, environment, body, acceptLanguage, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        public ApiResponse< ValidateDTO > ApiV1EnvironmentCOBankCOValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        public async System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentCOBankCOValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = await ApiV1EnvironmentCOBankCOValidatePropertiesPostAsyncWithHttpInfo(authorizationScope, environment, body, acceptLanguage, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Example for multilanguage (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentCOBankCOValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling BankCOApi->ApiV1EnvironmentCOBankCOValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/CO/BankCO/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("accept-language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentCOBankCOValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

    }
}
