/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG35_CLIFORCC - Banca cliente/fornitore&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Id&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class CSBankCODTO :  IEquatable<CSBankCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CSBankCODTO" /> class.
        /// </summary>
        /// <param name="bban">MG35_BBAN - BBAN.</param>
        /// <param name="bicbancaestera">MG35_BICBANCAESTERA - BIC.</param>
        /// <param name="ccaddetto">MG35_CCADDETTO - Addetto.</param>
        /// <param name="ccdesagenz">MG35_CCDESAGENZ - Descrizione agenzia.</param>
        /// <param name="ccforn">MG35_CCFORN - Conto corrente.</param>
        /// <param name="ccfornfactor">MG35_CCFORNFACTOR - Fornitore per factoring.</param>
        /// <param name="ccfornfactoridCg44">MG35_CCFORNFACTORID_CG44 - CcfornfactoridCg44.</param>
        /// <param name="ccggval">MG35_CCGGVAL - Giorni di valuta (default to 0).</param>
        /// <param name="cliforCg44">MG35_CLIFOR_CG44 - Codice Cliente / Fornitore (required).</param>
        /// <param name="codiceCg07">MG35_CODICE_CG07 - Nazione.</param>
        /// <param name="dittaCg18">MG35_DITTA_CG18 - Ditta (required).</param>
        /// <param name="flgPref">MG35_FLGPREF - Preferenziale pagamenti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="flgPrefIncassi">MG35_FLGPREF_INCASSI - Preferenziale incassi&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="iban">MG35_IBAN - IBAN.</param>
        /// <param name="id">MG35_ID - ID (Required only in PUT/PATCH).</param>
        /// <param name="idbancaestera">MG35_IDBANCAESTERA - ID Banca estera.</param>
        /// <param name="idcontratto">MG35_IDCONTRATTO - ID Contratto/Rapporto.</param>
        /// <param name="idsuccursale">MG35_IDSUCCURSALE - ID Succursale.</param>
        /// <param name="indTipoop">MG35_INDTIPOOP - Tipo operazione (default to 2).</param>
        /// <param name="locbancaestera">MG35_LOCBANCAESTERA - Località Banca estera.</param>
        /// <param name="nomebancaestera">MG35_NOMEBANCAESTERA - Nome banca.</param>
        /// <param name="progR">MG35_PROGR - Progr. (required).</param>
        /// <param name="tipobanca">MG35_TIPOBANCA - Tipo banca&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Internazionale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Domestico&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="tipocfCg44">MG35_TIPOCF_CG44 - Tipo Cliente / Fornitore (required).</param>
        /// <param name="agencyCO">agencyCO.</param>
        /// <param name="customerSupplierCO">customerSupplierCO.</param>
        /// <param name="nationCO">nationCO.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public CSBankCODTO(string bban = default(string), string bicbancaestera = default(string), string ccaddetto = default(string), string ccdesagenz = default(string), string ccforn = default(string), double? ccfornfactor = default(double?), int? ccfornfactoridCg44 = default(int?), double? ccggval = 0, double? cliforCg44 = default(double?), double? codiceCg07 = default(double?), double? dittaCg18 = default(double?), double? flgPref = 0, int? flgPrefIncassi = 0, string iban = default(string), int? id = default(int?), string idbancaestera = default(string), string idcontratto = default(string), double? idsuccursale = default(double?), double? indTipoop = 2, string locbancaestera = default(string), string nomebancaestera = default(string), int? progR = default(int?), double? tipobanca = default(double?), double? tipocfCg44 = default(double?), AgencyCODTO agencyCO = default(AgencyCODTO), CustomerSupplierCODTO customerSupplierCO = default(CustomerSupplierCODTO), NationCODTO nationCO = default(NationCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "cliforCg44" is required (not null)
            if (cliforCg44 == null)
            {
                throw new InvalidDataException("cliforCg44 is a required property for CSBankCODTO and cannot be null");
            }
            else
            {
                this.CliforCg44 = cliforCg44;
            }
            // to ensure "dittaCg18" is required (not null)
            if (dittaCg18 == null)
            {
                throw new InvalidDataException("dittaCg18 is a required property for CSBankCODTO and cannot be null");
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // to ensure "progR" is required (not null)
            if (progR == null)
            {
                throw new InvalidDataException("progR is a required property for CSBankCODTO and cannot be null");
            }
            else
            {
                this.ProgR = progR;
            }
            // to ensure "tipocfCg44" is required (not null)
            if (tipocfCg44 == null)
            {
                throw new InvalidDataException("tipocfCg44 is a required property for CSBankCODTO and cannot be null");
            }
            else
            {
                this.TipocfCg44 = tipocfCg44;
            }
            this.Bban = bban;
            this.Bicbancaestera = bicbancaestera;
            this.Ccaddetto = ccaddetto;
            this.Ccdesagenz = ccdesagenz;
            this.Ccforn = ccforn;
            this.Ccfornfactor = ccfornfactor;
            this.CcfornfactoridCg44 = ccfornfactoridCg44;
            // use default value if no "ccggval" provided
            if (ccggval == null)
            {
                this.Ccggval = 0;
            }
            else
            {
                this.Ccggval = ccggval;
            }
            this.CodiceCg07 = codiceCg07;
            // use default value if no "flgPref" provided
            if (flgPref == null)
            {
                this.FlgPref = 0;
            }
            else
            {
                this.FlgPref = flgPref;
            }
            // use default value if no "flgPrefIncassi" provided
            if (flgPrefIncassi == null)
            {
                this.FlgPrefIncassi = 0;
            }
            else
            {
                this.FlgPrefIncassi = flgPrefIncassi;
            }
            this.Iban = iban;
            this.Id = id;
            this.Idbancaestera = idbancaestera;
            this.Idcontratto = idcontratto;
            this.Idsuccursale = idsuccursale;
            // use default value if no "indTipoop" provided
            if (indTipoop == null)
            {
                this.IndTipoop = 2;
            }
            else
            {
                this.IndTipoop = indTipoop;
            }
            this.Locbancaestera = locbancaestera;
            this.Nomebancaestera = nomebancaestera;
            this.Tipobanca = tipobanca;
            this.AgencyCO = agencyCO;
            this.CustomerSupplierCO = customerSupplierCO;
            this.NationCO = nationCO;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG35_BBAN - BBAN
        /// </summary>
        /// <value>MG35_BBAN - BBAN</value>
        [DataMember(Name="bban", EmitDefaultValue=false)]
        public string Bban { get; set; }

        /// <summary>
        /// MG35_BICBANCAESTERA - BIC
        /// </summary>
        /// <value>MG35_BICBANCAESTERA - BIC</value>
        [DataMember(Name="bicbancaestera", EmitDefaultValue=false)]
        public string Bicbancaestera { get; set; }

        /// <summary>
        /// MG35_CCADDETTO - Addetto
        /// </summary>
        /// <value>MG35_CCADDETTO - Addetto</value>
        [DataMember(Name="ccaddetto", EmitDefaultValue=false)]
        public string Ccaddetto { get; set; }

        /// <summary>
        /// MG35_CCDESAGENZ - Descrizione agenzia
        /// </summary>
        /// <value>MG35_CCDESAGENZ - Descrizione agenzia</value>
        [DataMember(Name="ccdesagenz", EmitDefaultValue=false)]
        public string Ccdesagenz { get; set; }

        /// <summary>
        /// MG35_CCFORN - Conto corrente
        /// </summary>
        /// <value>MG35_CCFORN - Conto corrente</value>
        [DataMember(Name="ccforn", EmitDefaultValue=false)]
        public string Ccforn { get; set; }

        /// <summary>
        /// MG35_CCFORNFACTOR - Fornitore per factoring
        /// </summary>
        /// <value>MG35_CCFORNFACTOR - Fornitore per factoring</value>
        [DataMember(Name="ccfornfactor", EmitDefaultValue=false)]
        public double? Ccfornfactor { get; set; }

        /// <summary>
        /// MG35_CCFORNFACTORID_CG44 - CcfornfactoridCg44
        /// </summary>
        /// <value>MG35_CCFORNFACTORID_CG44 - CcfornfactoridCg44</value>
        [DataMember(Name="ccfornfactoridCg44", EmitDefaultValue=false)]
        public int? CcfornfactoridCg44 { get; set; }

        /// <summary>
        /// MG35_CCGGVAL - Giorni di valuta
        /// </summary>
        /// <value>MG35_CCGGVAL - Giorni di valuta</value>
        [DataMember(Name="ccggval", EmitDefaultValue=false)]
        public double? Ccggval { get; set; }

        /// <summary>
        /// MG35_CLIFOR_CG44 - Codice Cliente / Fornitore
        /// </summary>
        /// <value>MG35_CLIFOR_CG44 - Codice Cliente / Fornitore</value>
        [DataMember(Name="cliforCg44", EmitDefaultValue=false)]
        public double? CliforCg44 { get; set; }

        /// <summary>
        /// MG35_CODICE_CG07 - Nazione
        /// </summary>
        /// <value>MG35_CODICE_CG07 - Nazione</value>
        [DataMember(Name="codiceCg07", EmitDefaultValue=false)]
        public double? CodiceCg07 { get; set; }

        /// <summary>
        /// MG35_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG35_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG35_FLGPREF - Preferenziale pagamenti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG35_FLGPREF - Preferenziale pagamenti&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgPref", EmitDefaultValue=false)]
        public double? FlgPref { get; set; }

        /// <summary>
        /// MG35_FLGPREF_INCASSI - Preferenziale incassi&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG35_FLGPREF_INCASSI - Preferenziale incassi&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgPrefIncassi", EmitDefaultValue=false)]
        public int? FlgPrefIncassi { get; set; }

        /// <summary>
        /// MG35_IBAN - IBAN
        /// </summary>
        /// <value>MG35_IBAN - IBAN</value>
        [DataMember(Name="iban", EmitDefaultValue=false)]
        public string Iban { get; set; }

        /// <summary>
        /// MG35_ID - ID (Required only in PUT/PATCH)
        /// </summary>
        /// <value>MG35_ID - ID (Required only in PUT/PATCH)</value>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public int? Id { get; set; }

        /// <summary>
        /// MG35_IDBANCAESTERA - ID Banca estera
        /// </summary>
        /// <value>MG35_IDBANCAESTERA - ID Banca estera</value>
        [DataMember(Name="idbancaestera", EmitDefaultValue=false)]
        public string Idbancaestera { get; set; }

        /// <summary>
        /// MG35_IDCONTRATTO - ID Contratto/Rapporto
        /// </summary>
        /// <value>MG35_IDCONTRATTO - ID Contratto/Rapporto</value>
        [DataMember(Name="idcontratto", EmitDefaultValue=false)]
        public string Idcontratto { get; set; }

        /// <summary>
        /// MG35_IDSUCCURSALE - ID Succursale
        /// </summary>
        /// <value>MG35_IDSUCCURSALE - ID Succursale</value>
        [DataMember(Name="idsuccursale", EmitDefaultValue=false)]
        public double? Idsuccursale { get; set; }

        /// <summary>
        /// MG35_INDTIPOOP - Tipo operazione
        /// </summary>
        /// <value>MG35_INDTIPOOP - Tipo operazione</value>
        [DataMember(Name="indTipoop", EmitDefaultValue=false)]
        public double? IndTipoop { get; set; }

        /// <summary>
        /// MG35_LOCBANCAESTERA - Località Banca estera
        /// </summary>
        /// <value>MG35_LOCBANCAESTERA - Località Banca estera</value>
        [DataMember(Name="locbancaestera", EmitDefaultValue=false)]
        public string Locbancaestera { get; set; }

        /// <summary>
        /// MG35_NOMEBANCAESTERA - Nome banca
        /// </summary>
        /// <value>MG35_NOMEBANCAESTERA - Nome banca</value>
        [DataMember(Name="nomebancaestera", EmitDefaultValue=false)]
        public string Nomebancaestera { get; set; }

        /// <summary>
        /// MG35_PROGR - Progr.
        /// </summary>
        /// <value>MG35_PROGR - Progr.</value>
        [DataMember(Name="progR", EmitDefaultValue=false)]
        public int? ProgR { get; set; }

        /// <summary>
        /// MG35_TIPOBANCA - Tipo banca&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Internazionale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Domestico&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG35_TIPOBANCA - Tipo banca&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Internazionale&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Domestico&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipobanca", EmitDefaultValue=false)]
        public double? Tipobanca { get; set; }

        /// <summary>
        /// MG35_TIPOCF_CG44 - Tipo Cliente / Fornitore
        /// </summary>
        /// <value>MG35_TIPOCF_CG44 - Tipo Cliente / Fornitore</value>
        [DataMember(Name="tipocfCg44", EmitDefaultValue=false)]
        public double? TipocfCg44 { get; set; }

        /// <summary>
        /// Gets or Sets AgencyCO
        /// </summary>
        [DataMember(Name="agencyCO", EmitDefaultValue=false)]
        public AgencyCODTO AgencyCO { get; set; }

        /// <summary>
        /// Gets or Sets CustomerSupplierCO
        /// </summary>
        [DataMember(Name="customerSupplierCO", EmitDefaultValue=false)]
        public CustomerSupplierCODTO CustomerSupplierCO { get; set; }

        /// <summary>
        /// Gets or Sets NationCO
        /// </summary>
        [DataMember(Name="nationCO", EmitDefaultValue=false)]
        public NationCODTO NationCO { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class CSBankCODTO {\n");
            sb.Append("  Bban: ").Append(Bban).Append("\n");
            sb.Append("  Bicbancaestera: ").Append(Bicbancaestera).Append("\n");
            sb.Append("  Ccaddetto: ").Append(Ccaddetto).Append("\n");
            sb.Append("  Ccdesagenz: ").Append(Ccdesagenz).Append("\n");
            sb.Append("  Ccforn: ").Append(Ccforn).Append("\n");
            sb.Append("  Ccfornfactor: ").Append(Ccfornfactor).Append("\n");
            sb.Append("  CcfornfactoridCg44: ").Append(CcfornfactoridCg44).Append("\n");
            sb.Append("  Ccggval: ").Append(Ccggval).Append("\n");
            sb.Append("  CliforCg44: ").Append(CliforCg44).Append("\n");
            sb.Append("  CodiceCg07: ").Append(CodiceCg07).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgPref: ").Append(FlgPref).Append("\n");
            sb.Append("  FlgPrefIncassi: ").Append(FlgPrefIncassi).Append("\n");
            sb.Append("  Iban: ").Append(Iban).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Idbancaestera: ").Append(Idbancaestera).Append("\n");
            sb.Append("  Idcontratto: ").Append(Idcontratto).Append("\n");
            sb.Append("  Idsuccursale: ").Append(Idsuccursale).Append("\n");
            sb.Append("  IndTipoop: ").Append(IndTipoop).Append("\n");
            sb.Append("  Locbancaestera: ").Append(Locbancaestera).Append("\n");
            sb.Append("  Nomebancaestera: ").Append(Nomebancaestera).Append("\n");
            sb.Append("  ProgR: ").Append(ProgR).Append("\n");
            sb.Append("  Tipobanca: ").Append(Tipobanca).Append("\n");
            sb.Append("  TipocfCg44: ").Append(TipocfCg44).Append("\n");
            sb.Append("  AgencyCO: ").Append(AgencyCO).Append("\n");
            sb.Append("  CustomerSupplierCO: ").Append(CustomerSupplierCO).Append("\n");
            sb.Append("  NationCO: ").Append(NationCO).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CSBankCODTO);
        }

        /// <summary>
        /// Returns true if CSBankCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of CSBankCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CSBankCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Bban == input.Bban ||
                    (this.Bban != null &&
                    this.Bban.Equals(input.Bban))
                ) && 
                (
                    this.Bicbancaestera == input.Bicbancaestera ||
                    (this.Bicbancaestera != null &&
                    this.Bicbancaestera.Equals(input.Bicbancaestera))
                ) && 
                (
                    this.Ccaddetto == input.Ccaddetto ||
                    (this.Ccaddetto != null &&
                    this.Ccaddetto.Equals(input.Ccaddetto))
                ) && 
                (
                    this.Ccdesagenz == input.Ccdesagenz ||
                    (this.Ccdesagenz != null &&
                    this.Ccdesagenz.Equals(input.Ccdesagenz))
                ) && 
                (
                    this.Ccforn == input.Ccforn ||
                    (this.Ccforn != null &&
                    this.Ccforn.Equals(input.Ccforn))
                ) && 
                (
                    this.Ccfornfactor == input.Ccfornfactor ||
                    (this.Ccfornfactor != null &&
                    this.Ccfornfactor.Equals(input.Ccfornfactor))
                ) && 
                (
                    this.CcfornfactoridCg44 == input.CcfornfactoridCg44 ||
                    (this.CcfornfactoridCg44 != null &&
                    this.CcfornfactoridCg44.Equals(input.CcfornfactoridCg44))
                ) && 
                (
                    this.Ccggval == input.Ccggval ||
                    (this.Ccggval != null &&
                    this.Ccggval.Equals(input.Ccggval))
                ) && 
                (
                    this.CliforCg44 == input.CliforCg44 ||
                    (this.CliforCg44 != null &&
                    this.CliforCg44.Equals(input.CliforCg44))
                ) && 
                (
                    this.CodiceCg07 == input.CodiceCg07 ||
                    (this.CodiceCg07 != null &&
                    this.CodiceCg07.Equals(input.CodiceCg07))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgPref == input.FlgPref ||
                    (this.FlgPref != null &&
                    this.FlgPref.Equals(input.FlgPref))
                ) && 
                (
                    this.FlgPrefIncassi == input.FlgPrefIncassi ||
                    (this.FlgPrefIncassi != null &&
                    this.FlgPrefIncassi.Equals(input.FlgPrefIncassi))
                ) && 
                (
                    this.Iban == input.Iban ||
                    (this.Iban != null &&
                    this.Iban.Equals(input.Iban))
                ) && 
                (
                    this.Id == input.Id ||
                    (this.Id != null &&
                    this.Id.Equals(input.Id))
                ) && 
                (
                    this.Idbancaestera == input.Idbancaestera ||
                    (this.Idbancaestera != null &&
                    this.Idbancaestera.Equals(input.Idbancaestera))
                ) && 
                (
                    this.Idcontratto == input.Idcontratto ||
                    (this.Idcontratto != null &&
                    this.Idcontratto.Equals(input.Idcontratto))
                ) && 
                (
                    this.Idsuccursale == input.Idsuccursale ||
                    (this.Idsuccursale != null &&
                    this.Idsuccursale.Equals(input.Idsuccursale))
                ) && 
                (
                    this.IndTipoop == input.IndTipoop ||
                    (this.IndTipoop != null &&
                    this.IndTipoop.Equals(input.IndTipoop))
                ) && 
                (
                    this.Locbancaestera == input.Locbancaestera ||
                    (this.Locbancaestera != null &&
                    this.Locbancaestera.Equals(input.Locbancaestera))
                ) && 
                (
                    this.Nomebancaestera == input.Nomebancaestera ||
                    (this.Nomebancaestera != null &&
                    this.Nomebancaestera.Equals(input.Nomebancaestera))
                ) && 
                (
                    this.ProgR == input.ProgR ||
                    (this.ProgR != null &&
                    this.ProgR.Equals(input.ProgR))
                ) && 
                (
                    this.Tipobanca == input.Tipobanca ||
                    (this.Tipobanca != null &&
                    this.Tipobanca.Equals(input.Tipobanca))
                ) && 
                (
                    this.TipocfCg44 == input.TipocfCg44 ||
                    (this.TipocfCg44 != null &&
                    this.TipocfCg44.Equals(input.TipocfCg44))
                ) && 
                (
                    this.AgencyCO == input.AgencyCO ||
                    (this.AgencyCO != null &&
                    this.AgencyCO.Equals(input.AgencyCO))
                ) && 
                (
                    this.CustomerSupplierCO == input.CustomerSupplierCO ||
                    (this.CustomerSupplierCO != null &&
                    this.CustomerSupplierCO.Equals(input.CustomerSupplierCO))
                ) && 
                (
                    this.NationCO == input.NationCO ||
                    (this.NationCO != null &&
                    this.NationCO.Equals(input.NationCO))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Bban != null)
                    hashCode = hashCode * 59 + this.Bban.GetHashCode();
                if (this.Bicbancaestera != null)
                    hashCode = hashCode * 59 + this.Bicbancaestera.GetHashCode();
                if (this.Ccaddetto != null)
                    hashCode = hashCode * 59 + this.Ccaddetto.GetHashCode();
                if (this.Ccdesagenz != null)
                    hashCode = hashCode * 59 + this.Ccdesagenz.GetHashCode();
                if (this.Ccforn != null)
                    hashCode = hashCode * 59 + this.Ccforn.GetHashCode();
                if (this.Ccfornfactor != null)
                    hashCode = hashCode * 59 + this.Ccfornfactor.GetHashCode();
                if (this.CcfornfactoridCg44 != null)
                    hashCode = hashCode * 59 + this.CcfornfactoridCg44.GetHashCode();
                if (this.Ccggval != null)
                    hashCode = hashCode * 59 + this.Ccggval.GetHashCode();
                if (this.CliforCg44 != null)
                    hashCode = hashCode * 59 + this.CliforCg44.GetHashCode();
                if (this.CodiceCg07 != null)
                    hashCode = hashCode * 59 + this.CodiceCg07.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgPref != null)
                    hashCode = hashCode * 59 + this.FlgPref.GetHashCode();
                if (this.FlgPrefIncassi != null)
                    hashCode = hashCode * 59 + this.FlgPrefIncassi.GetHashCode();
                if (this.Iban != null)
                    hashCode = hashCode * 59 + this.Iban.GetHashCode();
                if (this.Id != null)
                    hashCode = hashCode * 59 + this.Id.GetHashCode();
                if (this.Idbancaestera != null)
                    hashCode = hashCode * 59 + this.Idbancaestera.GetHashCode();
                if (this.Idcontratto != null)
                    hashCode = hashCode * 59 + this.Idcontratto.GetHashCode();
                if (this.Idsuccursale != null)
                    hashCode = hashCode * 59 + this.Idsuccursale.GetHashCode();
                if (this.IndTipoop != null)
                    hashCode = hashCode * 59 + this.IndTipoop.GetHashCode();
                if (this.Locbancaestera != null)
                    hashCode = hashCode * 59 + this.Locbancaestera.GetHashCode();
                if (this.Nomebancaestera != null)
                    hashCode = hashCode * 59 + this.Nomebancaestera.GetHashCode();
                if (this.ProgR != null)
                    hashCode = hashCode * 59 + this.ProgR.GetHashCode();
                if (this.Tipobanca != null)
                    hashCode = hashCode * 59 + this.Tipobanca.GetHashCode();
                if (this.TipocfCg44 != null)
                    hashCode = hashCode * 59 + this.TipocfCg44.GetHashCode();
                if (this.AgencyCO != null)
                    hashCode = hashCode * 59 + this.AgencyCO.GetHashCode();
                if (this.CustomerSupplierCO != null)
                    hashCode = hashCode * 59 + this.CustomerSupplierCO.GetHashCode();
                if (this.NationCO != null)
                    hashCode = hashCode * 59 + this.NationCO.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
