# IO.Swagger.Api.CustomerSupplierCOApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercocreateintegrativedeclaretionpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/createintegrativedeclaretion | Integrate the letter of intent
[**ApiV1EnvironmentCOCustomerSupplierCOGet**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoget) | **GET** /api/v1/{environment}/CO/CustomerSupplierCO | Get new
[**ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercogetcswitheffectivepaymentconditionpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/getcswitheffectivepaymentcondition | Returns the customer/supplier with the actual payment condition
[**ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercogetdefaultrevenueagencypost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/getdefaultrevenueagency | Retrieve the default revenew agency
[**ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercogetfirstavailablenumnsprotletterofintentpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/getfirstavailablenumnsprotletterofintent | Retrieve the first available proptocol number for letter of intent
[**ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGet**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercohellotsidget) | **GET** /api/v1/{environment}/CO/CustomerSupplierCO/hello_tsid | Hello customer
[**ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidchkjointlyheldexistpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/{id}/chkjointlyheldexist | Check if exist a customer jointly held to selected customer
[**ApiV1EnvironmentCOCustomerSupplierCOIdDelete**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoiddelete) | **DELETE** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Delete
[**ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoiddeleteallcsjointlyheldpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/{id}/deleteallcsjointlyheld | Delete all customers jointly held to selected customer
[**ApiV1EnvironmentCOCustomerSupplierCOIdGet**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidget) | **GET** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Get by ID
[**ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidgetnewcodscaglpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/{id}/getnewcodscagl | Retrieve a new code for the payment bracket for the customer
[**ApiV1EnvironmentCOCustomerSupplierCOIdPatch**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidpatch) | **PATCH** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Update partial
[**ApiV1EnvironmentCOCustomerSupplierCOIdPut**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidput) | **PUT** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Update
[**ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoinsertsendingletterpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/insertsendingletter | Insert letters
[**ApiV1EnvironmentCOCustomerSupplierCOPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercopost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO | Create
[**ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoupdatevaluesaftergeneratesendingletterpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/updatevaluesaftergeneratesendingletter | Update the generated letters of intent
[**ApiV1EnvironmentCOCustomerSupplierCOValidatePost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercovalidatepost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/validate | Validate
[**ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPost**](CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/validateProperties | Validation of one on more properties of Type

<a name="apiv1environmentcocustomersuppliercocreateintegrativedeclaretionpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPost**
> IntegrativeDeclarationResultDTO ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPost (IntegrativeDeclarationParametersCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Integrate the letter of intent

Integrate the letter of intent

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new IntegrativeDeclarationParametersCODTO(); // IntegrativeDeclarationParametersCODTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Integrate the letter of intent
                IntegrativeDeclarationResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**IntegrativeDeclarationParametersCODTO**](IntegrativeDeclarationParametersCODTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**IntegrativeDeclarationResultDTO**](IntegrativeDeclarationResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoget"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOGet**
> CustomerSupplierCODTO ApiV1EnvironmentCOCustomerSupplierCOGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get new

Get an empty object of type corresponding

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var op = op_example;  // string | The value must be 'new'
            var param = param_example;  // string | Specify optional parameters that will be used during entity creation
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get new
                CustomerSupplierCODTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOGet(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **op** | **string**| The value must be &#x27;new&#x27; | 
 **param** | **string**| Specify optional parameters that will be used during entity creation | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercogetcswitheffectivepaymentconditionpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPost**
> CustomerSupplierCODTO ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPost (CSWithEffectivePaymentConditionParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Returns the customer/supplier with the actual payment condition

Returns the customer/supplier with the actual payment condition, taking into account the brackets

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new CSWithEffectivePaymentConditionParametersDTO(); // CSWithEffectivePaymentConditionParametersDTO | customer/supplier reading parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Returns the customer/supplier with the actual payment condition
                CustomerSupplierCODTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CSWithEffectivePaymentConditionParametersDTO**](CSWithEffectivePaymentConditionParametersDTO.md)| customer/supplier reading parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercogetdefaultrevenueagencypost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPost**
> SendingLetterResultDTO ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPost (string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Retrieve the default revenew agency

Retrieve the default revenew agency

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Retrieve the default revenew agency
                SendingLetterResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPost(environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**SendingLetterResultDTO**](SendingLetterResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercogetfirstavailablenumnsprotletterofintentpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPost**
> GetFirstAvailableNumNsProtLetterOfIntentResultDTO ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPost (GetFirstAvailableNumNsProtLetterOfIntentParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Retrieve the first available proptocol number for letter of intent

Retrieve the first available proptocol number for letter of intent

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new GetFirstAvailableNumNsProtLetterOfIntentParametersDTO(); // GetFirstAvailableNumNsProtLetterOfIntentParametersDTO | TODO_DOCUMENTATION
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Retrieve the first available proptocol number for letter of intent
                GetFirstAvailableNumNsProtLetterOfIntentResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**GetFirstAvailableNumNsProtLetterOfIntentParametersDTO**](GetFirstAvailableNumNsProtLetterOfIntentParametersDTO.md)| TODO_DOCUMENTATION | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**GetFirstAvailableNumNsProtLetterOfIntentResultDTO**](GetFirstAvailableNumNsProtLetterOfIntentResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercohellotsidget"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGet**
> void ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGet (string environment, string authorizationScope, string customer = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Hello customer

Hello customer

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var customer = customer_example;  // string |  (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Hello customer
                apiInstance.ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGet(environment, authorizationScope, customer, company, user, acceptLanguage, acceptTerritory);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **customer** | **string**|  | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoidchkjointlyheldexistpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPost**
> JointlyHeldCOAlreadyExistsResultDTO ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPost (JointlyHeldCOAlreadyExistsParametersDTO body, string authorizationScope, int? id, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Check if exist a customer jointly held to selected customer

Check if exist a customer jointly held to selected customer

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new JointlyHeldCOAlreadyExistsParametersDTO(); // JointlyHeldCOAlreadyExistsParametersDTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = 56;  // int? | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Check if exist a customer jointly held to selected customer
                JointlyHeldCOAlreadyExistsResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPost(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**JointlyHeldCOAlreadyExistsParametersDTO**](JointlyHeldCOAlreadyExistsParametersDTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **int?**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**JointlyHeldCOAlreadyExistsResultDTO**](JointlyHeldCOAlreadyExistsResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoiddelete"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdDelete**
> void ApiV1EnvironmentCOCustomerSupplierCOIdDelete (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Delete

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Delete
                apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdDelete(id, environment, authorizationScope, force, ignoreCompanyPolicyFilter, company, user, acceptLanguage, acceptTerritory);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoiddeleteallcsjointlyheldpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPost**
> JointlyHeldCOAlreadyExistsResultDTO ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPost (int? id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Delete all customers jointly held to selected customer

Delete all customers jointly hel to selected customer

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var id = 56;  // int? | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Delete all customers jointly held to selected customer
                JointlyHeldCOAlreadyExistsResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPost(id, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int?**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**JointlyHeldCOAlreadyExistsResultDTO**](JointlyHeldCOAlreadyExistsResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoidget"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdGet**
> CustomerSupplierCODTO ApiV1EnvironmentCOCustomerSupplierCOIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get by ID

Get an object of type corresponding the requested id

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var id = id_example;  // string | Id to get the object
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var dlevel = dlevel_example;  // string | Serialization level (optional) 
            var dlevelkey = dlevelkey_example;  // string | Serialization level key (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get by ID
                CustomerSupplierCODTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdGet(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Id to get the object | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **dlevel** | **string**| Serialization level | [optional] 
 **dlevelkey** | **string**| Serialization level key | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoidgetnewcodscaglpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPost**
> GetNewCodScaglCSPaymentRangeResultDTO ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPost (int? id, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Retrieve a new code for the payment bracket for the customer

Retrieve a new code for the payment bracket for the customer

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var id = 56;  // int? | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Retrieve a new code for the payment bracket for the customer
                GetNewCodScaglCSPaymentRangeResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPost(id, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int?**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**GetNewCodScaglCSPaymentRangeResultDTO**](GetNewCodScaglCSPaymentRangeResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoidpatch"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdPatch**
> void ApiV1EnvironmentCOCustomerSupplierCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)

Update partial

Patching an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdPatchExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new Object(); // Object | Object of type to patch
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update partial
                apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdPatch(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, force, op, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdPatch: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**Object**](Object.md)| Object of type to patch | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoidput"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOIdPut**
> CustomerSupplierCODTO ApiV1EnvironmentCOCustomerSupplierCOIdPut (CustomerSupplierCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)

Update

Updating an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOIdPutExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new CustomerSupplierCODTO(); // CustomerSupplierCODTO | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update
                CustomerSupplierCODTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOIdPut(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, force, ignoreCompanyPolicyFilter, op, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOIdPut: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoinsertsendingletterpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPost**
> SendingLetterResultDTO ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPost (SendingLettersToInsertParametersCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Insert letters

Insert letters

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new SendingLettersToInsertParametersCODTO(); // SendingLettersToInsertParametersCODTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Insert letters
                SendingLetterResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SendingLettersToInsertParametersCODTO**](SendingLettersToInsertParametersCODTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**SendingLetterResultDTO**](SendingLetterResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercopost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOPost**
> CustomerSupplierCODTO ApiV1EnvironmentCOCustomerSupplierCOPost (CustomerSupplierCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)

Create

Creating new object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new CustomerSupplierCODTO(); // CustomerSupplierCODTO | Object of type to create
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Create
                CustomerSupplierCODTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, op, force, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)| Object of type to create | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercoupdatevaluesaftergeneratesendingletterpost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPost**
> UpdateParametersResultDTO ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPost (UpdateParametersCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Update the generated letters of intent

Update the generated letters of intent

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new UpdateParametersCODTO(); // UpdateParametersCODTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update the generated letters of intent
                UpdateParametersResultDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**UpdateParametersCODTO**](UpdateParametersCODTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**UpdateParametersResultDTO**](UpdateParametersResultDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercovalidatepost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOValidatePost**
> void ApiV1EnvironmentCOCustomerSupplierCOValidatePost (CustomerSupplierCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var body = new CustomerSupplierCODTO(); // CustomerSupplierCODTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentCOCustomerSupplierCOValidatePost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CustomerSupplierCODTO**](CustomerSupplierCODTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcocustomersuppliercovalidatepropertiespost"></a>
# **ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPost**
> ValidateDTO ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validation of one on more properties of Type

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierCOApi();
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var body = new string(); // string |  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validation of one on more properties of Type
                ValidateDTO result = apiInstance.ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPost(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierCOApi.ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **body** | [**string**](string.md)|  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ValidateDTO**](ValidateDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
