# IO.Swagger.Api.InstalmentCalculationServiceApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPost**](InstalmentCalculationServiceApi.md#apiv1environmentcoinstalmentcalculationserviceinstalmentcalculationpost) | **POST** /api/v1/{environment}/CO/InstalmentCalculationService/InstalmentCalculation | Instalment calculation

<a name="apiv1environmentcoinstalmentcalculationserviceinstalmentcalculationpost"></a>
# **ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPost**
> InstalmentCalculationParametersDTO ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPost (InstalmentCalculationParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Instalment calculation

Calculation of deadlines

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new InstalmentCalculationServiceApi();
            var body = new InstalmentCalculationParametersDTO(); // InstalmentCalculationParametersDTO | Object that contains all the parameters necessary to calculate the deadlines
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Instalment calculation
                InstalmentCalculationParametersDTO result = apiInstance.ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling InstalmentCalculationServiceApi.ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**InstalmentCalculationParametersDTO**](InstalmentCalculationParametersDTO.md)| Object that contains all the parameters necessary to calculate the deadlines | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**InstalmentCalculationParametersDTO**](InstalmentCalculationParametersDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
