# IO.Swagger.Api.NatureEsCOApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCONatureEsCOGet**](NatureEsCOApi.md#apiv1environmentconatureescoget) | **GET** /api/v1/{environment}/CO/NatureEsCO | Get new
[**ApiV1EnvironmentCONatureEsCOIdDelete**](NatureEsCOApi.md#apiv1environmentconatureescoiddelete) | **DELETE** /api/v1/{environment}/CO/NatureEsCO/{id} | Delete
[**ApiV1EnvironmentCONatureEsCOIdGet**](NatureEsCOApi.md#apiv1environmentconatureescoidget) | **GET** /api/v1/{environment}/CO/NatureEsCO/{id} | Get by ID
[**ApiV1EnvironmentCONatureEsCOIdPatch**](NatureEsCOApi.md#apiv1environmentconatureescoidpatch) | **PATCH** /api/v1/{environment}/CO/NatureEsCO/{id} | Update partial
[**ApiV1EnvironmentCONatureEsCOIdPut**](NatureEsCOApi.md#apiv1environmentconatureescoidput) | **PUT** /api/v1/{environment}/CO/NatureEsCO/{id} | Update
[**ApiV1EnvironmentCONatureEsCOPost**](NatureEsCOApi.md#apiv1environmentconatureescopost) | **POST** /api/v1/{environment}/CO/NatureEsCO | Create
[**ApiV1EnvironmentCONatureEsCOValidatePost**](NatureEsCOApi.md#apiv1environmentconatureescovalidatepost) | **POST** /api/v1/{environment}/CO/NatureEsCO/validate | Validate
[**ApiV1EnvironmentCONatureEsCOValidatePropertiesPost**](NatureEsCOApi.md#apiv1environmentconatureescovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/NatureEsCO/validateProperties | Validation of one on more properties of Type

<a name="apiv1environmentconatureescoget"></a>
# **ApiV1EnvironmentCONatureEsCOGet**
> NatureEsCODTO ApiV1EnvironmentCONatureEsCOGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get new

Get an empty object of type corresponding

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var op = op_example;  // string | The value must be 'new'
            var param = param_example;  // string | Specify optional parameters that will be used during entity creation
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get new
                NatureEsCODTO result = apiInstance.ApiV1EnvironmentCONatureEsCOGet(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **op** | **string**| The value must be &#x27;new&#x27; | 
 **param** | **string**| Specify optional parameters that will be used during entity creation | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**NatureEsCODTO**](NatureEsCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescoiddelete"></a>
# **ApiV1EnvironmentCONatureEsCOIdDelete**
> void ApiV1EnvironmentCONatureEsCOIdDelete (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Delete

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Delete
                apiInstance.ApiV1EnvironmentCONatureEsCOIdDelete(id, environment, authorizationScope, force, ignoreCompanyPolicyFilter, company, user, acceptLanguage, acceptTerritory);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescoidget"></a>
# **ApiV1EnvironmentCONatureEsCOIdGet**
> NatureEsCODTO ApiV1EnvironmentCONatureEsCOIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get by ID

Get an object of type corresponding the requested id

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOIdGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var id = id_example;  // string | Id to get the object
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var dlevel = dlevel_example;  // string | Serialization level (optional) 
            var dlevelkey = dlevelkey_example;  // string | Serialization level key (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get by ID
                NatureEsCODTO result = apiInstance.ApiV1EnvironmentCONatureEsCOIdGet(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOIdGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Id to get the object | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **dlevel** | **string**| Serialization level | [optional] 
 **dlevelkey** | **string**| Serialization level key | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**NatureEsCODTO**](NatureEsCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescoidpatch"></a>
# **ApiV1EnvironmentCONatureEsCOIdPatch**
> void ApiV1EnvironmentCONatureEsCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)

Update partial

Patching an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOIdPatchExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var body = new Object(); // Object | Object of type to patch
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update partial
                apiInstance.ApiV1EnvironmentCONatureEsCOIdPatch(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, force, op, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOIdPatch: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**Object**](Object.md)| Object of type to patch | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescoidput"></a>
# **ApiV1EnvironmentCONatureEsCOIdPut**
> NatureEsCODTO ApiV1EnvironmentCONatureEsCOIdPut (NatureEsCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)

Update

Updating an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOIdPutExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var body = new NatureEsCODTO(); // NatureEsCODTO | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update
                NatureEsCODTO result = apiInstance.ApiV1EnvironmentCONatureEsCOIdPut(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, force, ignoreCompanyPolicyFilter, op, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOIdPut: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**NatureEsCODTO**](NatureEsCODTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**NatureEsCODTO**](NatureEsCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescopost"></a>
# **ApiV1EnvironmentCONatureEsCOPost**
> NatureEsCODTO ApiV1EnvironmentCONatureEsCOPost (NatureEsCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)

Create

Creating new object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var body = new NatureEsCODTO(); // NatureEsCODTO | Object of type to create
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Create
                NatureEsCODTO result = apiInstance.ApiV1EnvironmentCONatureEsCOPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, op, force, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**NatureEsCODTO**](NatureEsCODTO.md)| Object of type to create | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**NatureEsCODTO**](NatureEsCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescovalidatepost"></a>
# **ApiV1EnvironmentCONatureEsCOValidatePost**
> void ApiV1EnvironmentCONatureEsCOValidatePost (NatureEsCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var body = new NatureEsCODTO(); // NatureEsCODTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentCONatureEsCOValidatePost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**NatureEsCODTO**](NatureEsCODTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentconatureescovalidatepropertiespost"></a>
# **ApiV1EnvironmentCONatureEsCOValidatePropertiesPost**
> ValidateDTO ApiV1EnvironmentCONatureEsCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validation of one on more properties of Type

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCONatureEsCOValidatePropertiesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new NatureEsCOApi();
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var body = new string(); // string |  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validation of one on more properties of Type
                ValidateDTO result = apiInstance.ApiV1EnvironmentCONatureEsCOValidatePropertiesPost(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling NatureEsCOApi.ApiV1EnvironmentCONatureEsCOValidatePropertiesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **body** | [**string**](string.md)|  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ValidateDTO**](ValidateDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
