# IO.Swagger.Api.PaymentTermCOApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCOPaymentTermCOCalculateSumPost**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcocalculatesumpost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/calculate_sum | Calculate the sum of the percentages
[**ApiV1EnvironmentCOPaymentTermCOGet**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcoget) | **GET** /api/v1/{environment}/CO/PaymentTermCO | Get new
[**ApiV1EnvironmentCOPaymentTermCOGetFromCodePost**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcogetfromcodepost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/get_from_code | Retrieve the payment term from code
[**ApiV1EnvironmentCOPaymentTermCOIdDelete**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcoiddelete) | **DELETE** /api/v1/{environment}/CO/PaymentTermCO/{id} | Delete
[**ApiV1EnvironmentCOPaymentTermCOIdGet**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcoidget) | **GET** /api/v1/{environment}/CO/PaymentTermCO/{id} | Get by ID
[**ApiV1EnvironmentCOPaymentTermCOIdPatch**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcoidpatch) | **PATCH** /api/v1/{environment}/CO/PaymentTermCO/{id} | Update partial
[**ApiV1EnvironmentCOPaymentTermCOIdPut**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcoidput) | **PUT** /api/v1/{environment}/CO/PaymentTermCO/{id} | Update
[**ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPost**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcopaymenttermduplicationpost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/PaymentTermDuplication | Duplication of Payment Term
[**ApiV1EnvironmentCOPaymentTermCOPost**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcopost) | **POST** /api/v1/{environment}/CO/PaymentTermCO | Create
[**ApiV1EnvironmentCOPaymentTermCOValidatePost**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcovalidatepost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/validate | Validate
[**ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPost**](PaymentTermCOApi.md#apiv1environmentcopaymenttermcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/validateProperties | Validation of one on more properties of Type

<a name="apiv1environmentcopaymenttermcocalculatesumpost"></a>
# **ApiV1EnvironmentCOPaymentTermCOCalculateSumPost**
> PaymentTermDetailCalculationResultCODTO ApiV1EnvironmentCOPaymentTermCOCalculateSumPost (PaymentTermDetailCOParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Calculate the sum of the percentages

Calculate the sum of the percentages

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOCalculateSumPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new PaymentTermDetailCOParametersDTO(); // PaymentTermDetailCOParametersDTO | Parameters of the request
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Calculate the sum of the percentages
                PaymentTermDetailCalculationResultCODTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOCalculateSumPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOCalculateSumPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**PaymentTermDetailCOParametersDTO**](PaymentTermDetailCOParametersDTO.md)| Parameters of the request | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**PaymentTermDetailCalculationResultCODTO**](PaymentTermDetailCalculationResultCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcoget"></a>
# **ApiV1EnvironmentCOPaymentTermCOGet**
> PaymentTermCODTO ApiV1EnvironmentCOPaymentTermCOGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get new

Get an empty object of type corresponding

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var op = op_example;  // string | The value must be 'new'
            var param = param_example;  // string | Specify optional parameters that will be used during entity creation
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get new
                PaymentTermCODTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOGet(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **op** | **string**| The value must be &#x27;new&#x27; | 
 **param** | **string**| Specify optional parameters that will be used during entity creation | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**PaymentTermCODTO**](PaymentTermCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcogetfromcodepost"></a>
# **ApiV1EnvironmentCOPaymentTermCOGetFromCodePost**
> PaymentTermCODTO ApiV1EnvironmentCOPaymentTermCOGetFromCodePost (CodePaymentTermCOParametersDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Retrieve the payment term from code

Retrieve the payment term from code

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOGetFromCodePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new CodePaymentTermCOParametersDTO(); // CodePaymentTermCOParametersDTO | Input parameters
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Retrieve the payment term from code
                PaymentTermCODTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOGetFromCodePost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOGetFromCodePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CodePaymentTermCOParametersDTO**](CodePaymentTermCOParametersDTO.md)| Input parameters | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**PaymentTermCODTO**](PaymentTermCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcoiddelete"></a>
# **ApiV1EnvironmentCOPaymentTermCOIdDelete**
> void ApiV1EnvironmentCOPaymentTermCOIdDelete (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Delete

Deleting object of type 

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOIdDeleteExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Delete
                apiInstance.ApiV1EnvironmentCOPaymentTermCOIdDelete(id, environment, authorizationScope, force, ignoreCompanyPolicyFilter, company, user, acceptLanguage, acceptTerritory);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOIdDelete: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcoidget"></a>
# **ApiV1EnvironmentCOPaymentTermCOIdGet**
> PaymentTermCODTO ApiV1EnvironmentCOPaymentTermCOIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)

Get by ID

Get an object of type corresponding the requested id

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOIdGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var id = id_example;  // string | Id to get the object
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var dlevel = dlevel_example;  // string | Serialization level (optional) 
            var dlevelkey = dlevelkey_example;  // string | Serialization level key (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get by ID
                PaymentTermCODTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOIdGet(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOIdGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Id to get the object | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **dlevel** | **string**| Serialization level | [optional] 
 **dlevelkey** | **string**| Serialization level key | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]

### Return type

[**PaymentTermCODTO**](PaymentTermCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcoidpatch"></a>
# **ApiV1EnvironmentCOPaymentTermCOIdPatch**
> void ApiV1EnvironmentCOPaymentTermCOIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)

Update partial

Patching an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOIdPatchExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new Object(); // Object | Object of type to patch
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update partial
                apiInstance.ApiV1EnvironmentCOPaymentTermCOIdPatch(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, force, op, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOIdPatch: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**Object**](Object.md)| Object of type to patch | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcoidput"></a>
# **ApiV1EnvironmentCOPaymentTermCOIdPut**
> PaymentTermCODTO ApiV1EnvironmentCOPaymentTermCOIdPut (PaymentTermCODTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)

Update

Updating an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOIdPutExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new PaymentTermCODTO(); // PaymentTermCODTO | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update
                PaymentTermCODTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOIdPut(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, force, ignoreCompanyPolicyFilter, op, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOIdPut: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**PaymentTermCODTO**](PaymentTermCODTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**PaymentTermCODTO**](PaymentTermCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcopaymenttermduplicationpost"></a>
# **ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPost**
> void ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPost (PaymentTermDuplicationParametersCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Duplication of Payment Term

Duplication of Payment Term

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new PaymentTermDuplicationParametersCODTO(); // PaymentTermDuplicationParametersCODTO | Parameters for duplication
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Duplication of Payment Term
                apiInstance.ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**PaymentTermDuplicationParametersCODTO**](PaymentTermDuplicationParametersCODTO.md)| Parameters for duplication | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcopost"></a>
# **ApiV1EnvironmentCOPaymentTermCOPost**
> PaymentTermCODTO ApiV1EnvironmentCOPaymentTermCOPost (PaymentTermCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)

Create

Creating new object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new PaymentTermCODTO(); // PaymentTermCODTO | Object of type to create
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var ignoreCompanyPolicyFilter = true;  // bool? | Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Create
                PaymentTermCODTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOPost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, op, force, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**PaymentTermCODTO**](PaymentTermCODTO.md)| Object of type to create | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **ignoreCompanyPolicyFilter** | **bool?**| Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**PaymentTermCODTO**](PaymentTermCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcovalidatepost"></a>
# **ApiV1EnvironmentCOPaymentTermCOValidatePost**
> void ApiV1EnvironmentCOPaymentTermCOValidatePost (PaymentTermCODTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var body = new PaymentTermCODTO(); // PaymentTermCODTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentCOPaymentTermCOValidatePost(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**PaymentTermCODTO**](PaymentTermCODTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcopaymenttermcovalidatepropertiespost"></a>
# **ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPost**
> ValidateDTO ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)

Validation of one on more properties of Type

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new PaymentTermCOApi();
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var body = new string(); // string |  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validation of one on more properties of Type
                ValidateDTO result = apiInstance.ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPost(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling PaymentTermCOApi.ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **body** | [**string**](string.md)|  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; | [optional] 
 **acceptLanguage** | **string**| Specifies the UI culture to be used for localization of messages. | [optional] [default to it-IT]
 **acceptTerritory** | **string**| Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**ValidateDTO**](ValidateDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
