/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG0C_UNITAMISURA - Unità di misura aziendali&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Umsigla&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class UnitOfMeasureCODTO :  IEquatable<UnitOfMeasureCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="UnitOfMeasureCODTO" /> class.
        /// </summary>
        /// <param name="descr">CG0C_DESCR - Descrizione.</param>
        /// <param name="dittaCg18">CG0C_DITTA_CG18 - Ditta (required).</param>
        /// <param name="fattconv">CG0C_FATTCONV - Fattore di conversione (default to 1).</param>
        /// <param name="indOperatore">CG0C_INDOPERATORE - Operatore di conversione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Moltiplicazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Divisione&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="umsigla">CG0C_UMSIGLA - Sigla da visualizzare (required).</param>
        /// <param name="sigla">sigla (required).</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public UnitOfMeasureCODTO(string descr = default(string), double? dittaCg18 = default(double?), double? fattconv = 1, double? indOperatore = 0, string umsigla = default(string), UMCodeCODTO sigla = default(UMCodeCODTO), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "dittaCg18" is required (not null)
            if (dittaCg18 == null)
            {
                throw new InvalidDataException("dittaCg18 is a required property for UnitOfMeasureCODTO and cannot be null");
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // to ensure "umsigla" is required (not null)
            if (umsigla == null)
            {
                throw new InvalidDataException("umsigla is a required property for UnitOfMeasureCODTO and cannot be null");
            }
            else
            {
                this.Umsigla = umsigla;
            }
            // to ensure "sigla" is required (not null)
            if (sigla == null)
            {
                throw new InvalidDataException("sigla is a required property for UnitOfMeasureCODTO and cannot be null");
            }
            else
            {
                this.Sigla = sigla;
            }
            this.Descr = descr;
            // use default value if no "fattconv" provided
            if (fattconv == null)
            {
                this.Fattconv = 1;
            }
            else
            {
                this.Fattconv = fattconv;
            }
            // use default value if no "indOperatore" provided
            if (indOperatore == null)
            {
                this.IndOperatore = 0;
            }
            else
            {
                this.IndOperatore = indOperatore;
            }
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG0C_DESCR - Descrizione
        /// </summary>
        /// <value>CG0C_DESCR - Descrizione</value>
        [DataMember(Name="descr", EmitDefaultValue=false)]
        public string Descr { get; set; }

        /// <summary>
        /// CG0C_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>CG0C_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// CG0C_FATTCONV - Fattore di conversione
        /// </summary>
        /// <value>CG0C_FATTCONV - Fattore di conversione</value>
        [DataMember(Name="fattconv", EmitDefaultValue=false)]
        public double? Fattconv { get; set; }

        /// <summary>
        /// CG0C_INDOPERATORE - Operatore di conversione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Moltiplicazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Divisione&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG0C_INDOPERATORE - Operatore di conversione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Moltiplicazione&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Divisione&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indOperatore", EmitDefaultValue=false)]
        public double? IndOperatore { get; set; }

        /// <summary>
        /// CG0C_UMSIGLA - Sigla da visualizzare
        /// </summary>
        /// <value>CG0C_UMSIGLA - Sigla da visualizzare</value>
        [DataMember(Name="umsigla", EmitDefaultValue=false)]
        public string Umsigla { get; set; }

        /// <summary>
        /// Gets or Sets Sigla
        /// </summary>
        [DataMember(Name="sigla", EmitDefaultValue=false)]
        public UMCodeCODTO Sigla { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class UnitOfMeasureCODTO {\n");
            sb.Append("  Descr: ").Append(Descr).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  Fattconv: ").Append(Fattconv).Append("\n");
            sb.Append("  IndOperatore: ").Append(IndOperatore).Append("\n");
            sb.Append("  Umsigla: ").Append(Umsigla).Append("\n");
            sb.Append("  Sigla: ").Append(Sigla).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as UnitOfMeasureCODTO);
        }

        /// <summary>
        /// Returns true if UnitOfMeasureCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of UnitOfMeasureCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(UnitOfMeasureCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Descr == input.Descr ||
                    (this.Descr != null &&
                    this.Descr.Equals(input.Descr))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.Fattconv == input.Fattconv ||
                    (this.Fattconv != null &&
                    this.Fattconv.Equals(input.Fattconv))
                ) && 
                (
                    this.IndOperatore == input.IndOperatore ||
                    (this.IndOperatore != null &&
                    this.IndOperatore.Equals(input.IndOperatore))
                ) && 
                (
                    this.Umsigla == input.Umsigla ||
                    (this.Umsigla != null &&
                    this.Umsigla.Equals(input.Umsigla))
                ) && 
                (
                    this.Sigla == input.Sigla ||
                    (this.Sigla != null &&
                    this.Sigla.Equals(input.Sigla))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Descr != null)
                    hashCode = hashCode * 59 + this.Descr.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.Fattconv != null)
                    hashCode = hashCode * 59 + this.Fattconv.GetHashCode();
                if (this.IndOperatore != null)
                    hashCode = hashCode * 59 + this.IndOperatore.GetHashCode();
                if (this.Umsigla != null)
                    hashCode = hashCode * 59 + this.Umsigla.GetHashCode();
                if (this.Sigla != null)
                    hashCode = hashCode * 59 + this.Sigla.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
