'use strict';


/**
 * Calculation of the amount by exchange
 * Currency exchange calculation
 *
 * body CalculateAmountParametersDTO Object containing the parameters necessary for the calculation. If it is not passed the exchange will be taken by CG09_TABCAMBI
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns CalculateAmountResultDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "amount" : 0.8008281904610115,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "currencyExchange" : 6.027456183070403
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Calculation 'Exchange rate'
 * Currency exchange calculation
 *
 * body CalculateExchangeRateParametersDTO Object that contains all the parameters that are used in the calculation
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns CalculateExchangeRateResultDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOCalculate_exchangeratePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cambio" : 1.4658129805029452,
  "dataCambio" : "2000-01-23T04:56:07.000+00:00",
  "tipoCambioRecuperato" : 0,
  "indicatoreCertoIncerto" : 5,
  "numeroDecimali" : 6,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrencyCODTO
 **/
exports.apiV1EnvironmentCOCurrencyCOGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "sigla" : "sigla",
  "dataattuem" : "2000-01-23T04:56:07.000+00:00",
  "numdec" : 8.28965939814297,
  "exchangeRateCO" : [ {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  }, {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  } ],
  "idmediaCg99" : 3.901545264248647,
  "codice" : "codice",
  "indCertoincerto" : 0,
  "extensionData" : [ null, null ],
  "cambiofisso" : 8.251625748923757,
  "descr" : "descr",
  "flgValuem" : 4.459605034958679,
  "indValuem" : 1.7325933120207193,
  "indSepmigl" : 2.9409642974827896,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCurrencyCOIdDELETE = function(id,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrencyCODTO
 **/
exports.apiV1EnvironmentCOCurrencyCOIdGET = function(id,environment,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "sigla" : "sigla",
  "dataattuem" : "2000-01-23T04:56:07.000+00:00",
  "numdec" : 8.28965939814297,
  "exchangeRateCO" : [ {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  }, {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  } ],
  "idmediaCg99" : 3.901545264248647,
  "codice" : "codice",
  "indCertoincerto" : 0,
  "extensionData" : [ null, null ],
  "cambiofisso" : 8.251625748923757,
  "descr" : "descr",
  "flgValuem" : 4.459605034958679,
  "indValuem" : 1.7325933120207193,
  "indSepmigl" : 2.9409642974827896,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCurrencyCOIdPATCH = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body CurrencyCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrencyCODTO
 **/
exports.apiV1EnvironmentCOCurrencyCOIdPUT = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "sigla" : "sigla",
  "dataattuem" : "2000-01-23T04:56:07.000+00:00",
  "numdec" : 8.28965939814297,
  "exchangeRateCO" : [ {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  }, {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  } ],
  "idmediaCg99" : 3.901545264248647,
  "codice" : "codice",
  "indCertoincerto" : 0,
  "extensionData" : [ null, null ],
  "cambiofisso" : 8.251625748923757,
  "descr" : "descr",
  "flgValuem" : 4.459605034958679,
  "indValuem" : 1.7325933120207193,
  "indSepmigl" : 2.9409642974827896,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Average annual exchange rates import
 * Average annual exchange rates import
 *
 * body ImportAnnualAverageRatesInputDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ImportCurrencyRatesOutputDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOImportannualaverageratesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "errorMessages" : [ "errorMessages", "errorMessages" ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "operationResult" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Currency Exchange Import
 * Currency Exchange Import
 *
 * body ImportCurrencyRatesInputDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ImportCurrencyRatesOutputDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOImportcurrencyratesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "errorMessages" : [ "errorMessages", "errorMessages" ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "operationResult" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Import of average monthly exchange rates
 * Import of average monthly exchange rates
 *
 * body ImportMonthlyAverageRatesInputDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ImportCurrencyRatesOutputDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "errorMessages" : [ "errorMessages", "errorMessages" ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "operationResult" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Import time series exchange rates
 * Time Series exchange rates import
 *
 * body ImportTimeSeriesRatesInputDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ImportCurrencyRatesOutputDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOImporttimeseriesratesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "errorMessages" : [ "errorMessages", "errorMessages" ],
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "operationResult" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body CurrencyCODTO Object of type to create
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns CurrencyCODTO
 **/
exports.apiV1EnvironmentCOCurrencyCOPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "sigla" : "sigla",
  "dataattuem" : "2000-01-23T04:56:07.000+00:00",
  "numdec" : 8.28965939814297,
  "exchangeRateCO" : [ {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  }, {
    "cambio" : 8.863729185622827,
    "anno" : 4.573936264232251,
    "idmediaCg99" : 1.8268702177058116,
    "codiceCg08" : "codiceCg08",
    "indCertoincerto" : 3,
    "codicerifCg08" : "codicerifCg08",
    "extensionData" : [ null, null ],
    "giorno" : 9.254183946267839,
    "mese" : 9.183123594773994,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "adegcambio" : 6.623518433804886,
    "rowversion" : ""
  } ],
  "idmediaCg99" : 3.901545264248647,
  "codice" : "codice",
  "indCertoincerto" : 0,
  "extensionData" : [ null, null ],
  "cambiofisso" : 8.251625748923757,
  "descr" : "descr",
  "flgValuem" : 4.459605034958679,
  "indValuem" : 1.7325933120207193,
  "indSepmigl" : 2.9409642974827896,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CurrencyCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCurrencyCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOCurrencyCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

