'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns NationCODTO
 **/
exports.apiV1EnvironmentCONationCOGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "codSian" : 9.702963800023566,
  "crtpiva" : "crtpiva",
  "leniban" : 6,
  "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
  "desiso3166" : "desiso3166",
  "idmediaCg99" : 5.507386964179881,
  "codice" : 0.8774076871421566,
  "numiso3166" : "numiso3166",
  "codiceCg08" : "codiceCg08",
  "currencyCO" : {
    "sigla" : "sigla",
    "dataattuem" : "2000-01-23T04:56:07.000+00:00",
    "numdec" : 8.28965939814297,
    "exchangeRateCO" : [ {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    }, {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    } ],
    "idmediaCg99" : 3.901545264248647,
    "codice" : "codice",
    "indCertoincerto" : 0,
    "extensionData" : [ null, null ],
    "cambiofisso" : 8.251625748923757,
    "descr" : "descr",
    "flgValuem" : 4.459605034958679,
    "indValuem" : 1.7325933120207193,
    "indSepmigl" : 2.9409642974827896,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "extensionData" : [ null, null ],
  "descr" : "descr",
  "flgIban" : 0,
  "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
  "codIso" : "codIso",
  "a3iso3166" : "a3iso3166",
  "indTipostato" : 4.86315908102884,
  "a2iso3166" : "a2iso3166",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "datacee" : "2000-01-23T04:56:07.000+00:00",
  "flgSepa" : 7
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCONationCOIdDELETE = function(id,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns NationCODTO
 **/
exports.apiV1EnvironmentCONationCOIdGET = function(id,environment,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "codSian" : 9.702963800023566,
  "crtpiva" : "crtpiva",
  "leniban" : 6,
  "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
  "desiso3166" : "desiso3166",
  "idmediaCg99" : 5.507386964179881,
  "codice" : 0.8774076871421566,
  "numiso3166" : "numiso3166",
  "codiceCg08" : "codiceCg08",
  "currencyCO" : {
    "sigla" : "sigla",
    "dataattuem" : "2000-01-23T04:56:07.000+00:00",
    "numdec" : 8.28965939814297,
    "exchangeRateCO" : [ {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    }, {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    } ],
    "idmediaCg99" : 3.901545264248647,
    "codice" : "codice",
    "indCertoincerto" : 0,
    "extensionData" : [ null, null ],
    "cambiofisso" : 8.251625748923757,
    "descr" : "descr",
    "flgValuem" : 4.459605034958679,
    "indValuem" : 1.7325933120207193,
    "indSepmigl" : 2.9409642974827896,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "extensionData" : [ null, null ],
  "descr" : "descr",
  "flgIban" : 0,
  "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
  "codIso" : "codIso",
  "a3iso3166" : "a3iso3166",
  "indTipostato" : 4.86315908102884,
  "a2iso3166" : "a2iso3166",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "datacee" : "2000-01-23T04:56:07.000+00:00",
  "flgSepa" : 7
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCONationCOIdPATCH = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body NationCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns NationCODTO
 **/
exports.apiV1EnvironmentCONationCOIdPUT = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "codSian" : 9.702963800023566,
  "crtpiva" : "crtpiva",
  "leniban" : 6,
  "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
  "desiso3166" : "desiso3166",
  "idmediaCg99" : 5.507386964179881,
  "codice" : 0.8774076871421566,
  "numiso3166" : "numiso3166",
  "codiceCg08" : "codiceCg08",
  "currencyCO" : {
    "sigla" : "sigla",
    "dataattuem" : "2000-01-23T04:56:07.000+00:00",
    "numdec" : 8.28965939814297,
    "exchangeRateCO" : [ {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    }, {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    } ],
    "idmediaCg99" : 3.901545264248647,
    "codice" : "codice",
    "indCertoincerto" : 0,
    "extensionData" : [ null, null ],
    "cambiofisso" : 8.251625748923757,
    "descr" : "descr",
    "flgValuem" : 4.459605034958679,
    "indValuem" : 1.7325933120207193,
    "indSepmigl" : 2.9409642974827896,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "extensionData" : [ null, null ],
  "descr" : "descr",
  "flgIban" : 0,
  "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
  "codIso" : "codIso",
  "a3iso3166" : "a3iso3166",
  "indTipostato" : 4.86315908102884,
  "a2iso3166" : "a2iso3166",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "datacee" : "2000-01-23T04:56:07.000+00:00",
  "flgSepa" : 7
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body NationCODTO Object of type to create
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns NationCODTO
 **/
exports.apiV1EnvironmentCONationCOPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "codSian" : 9.702963800023566,
  "crtpiva" : "crtpiva",
  "leniban" : 6,
  "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
  "desiso3166" : "desiso3166",
  "idmediaCg99" : 5.507386964179881,
  "codice" : 0.8774076871421566,
  "numiso3166" : "numiso3166",
  "codiceCg08" : "codiceCg08",
  "currencyCO" : {
    "sigla" : "sigla",
    "dataattuem" : "2000-01-23T04:56:07.000+00:00",
    "numdec" : 8.28965939814297,
    "exchangeRateCO" : [ {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    }, {
      "cambio" : 8.863729185622827,
      "anno" : 4.573936264232251,
      "idmediaCg99" : 1.8268702177058116,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 3,
      "codicerifCg08" : "codicerifCg08",
      "extensionData" : [ null, null ],
      "giorno" : 9.254183946267839,
      "mese" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 6.623518433804886,
      "rowversion" : ""
    } ],
    "idmediaCg99" : 3.901545264248647,
    "codice" : "codice",
    "indCertoincerto" : 0,
    "extensionData" : [ null, null ],
    "cambiofisso" : 8.251625748923757,
    "descr" : "descr",
    "flgValuem" : 4.459605034958679,
    "indValuem" : 1.7325933120207193,
    "indSepmigl" : 2.9409642974827896,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "extensionData" : [ null, null ],
  "descr" : "descr",
  "flgIban" : 0,
  "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
  "codIso" : "codIso",
  "a3iso3166" : "a3iso3166",
  "indTipostato" : 4.86315908102884,
  "a2iso3166" : "a2iso3166",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "datacee" : "2000-01-23T04:56:07.000+00:00",
  "flgSepa" : 7
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body NationCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCONationCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCONationCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

