'use strict';


/**
 * Calculate the sum of the percentages
 * Calculate the sum of the percentages
 *
 * body PaymentTermDetailCOParametersDTO Parameters of the request
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns PaymentTermDetailCalculationResultCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOCalculate_sumPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "sumImp" : 0.8008281904610115,
  "sumIva" : 6.027456183070403,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 7.203794749804894,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  }, {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 4.332304821875894,
  "flgPrefpass" : 9,
  "idExtendedAttributeSubEntity" : 3,
  "flgPrefatt" : 2,
  "flgStornoiva" : 0.58919091925136,
  "descPag" : "descPag",
  "extensionData" : [ null, null ],
  "scpermer2" : 1.3949519358941398,
  "pluginData" : {
    "key" : ""
  },
  "id" : 2,
  "scpercas" : 6.966044574347761,
  "scpermer1" : 9.806951670467935,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 4.8789878742268815,
  "idExtendedAttributeEntity" : 1,
  "rowversion" : "",
  "scart26" : 6.173804034172511
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Retrieve the payment term from code
 * Retrieve the payment term from code
 *
 * body CodePaymentTermCOParametersDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOGet_from_codePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 7.203794749804894,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  }, {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 4.332304821875894,
  "flgPrefpass" : 9,
  "idExtendedAttributeSubEntity" : 3,
  "flgPrefatt" : 2,
  "flgStornoiva" : 0.58919091925136,
  "descPag" : "descPag",
  "extensionData" : [ null, null ],
  "scpermer2" : 1.3949519358941398,
  "pluginData" : {
    "key" : ""
  },
  "id" : 2,
  "scpercas" : 6.966044574347761,
  "scpermer1" : 9.806951670467935,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 4.8789878742268815,
  "idExtendedAttributeEntity" : 1,
  "rowversion" : "",
  "scart26" : 6.173804034172511
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdDELETE = function(id,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdGET = function(id,environment,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 7.203794749804894,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  }, {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 4.332304821875894,
  "flgPrefpass" : 9,
  "idExtendedAttributeSubEntity" : 3,
  "flgPrefatt" : 2,
  "flgStornoiva" : 0.58919091925136,
  "descPag" : "descPag",
  "extensionData" : [ null, null ],
  "scpermer2" : 1.3949519358941398,
  "pluginData" : {
    "key" : ""
  },
  "id" : 2,
  "scpercas" : 6.966044574347761,
  "scpermer1" : 9.806951670467935,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 4.8789878742268815,
  "idExtendedAttributeEntity" : 1,
  "rowversion" : "",
  "scart26" : 6.173804034172511
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdPATCH = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body PaymentTermCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOIdPUT = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 7.203794749804894,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  }, {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 4.332304821875894,
  "flgPrefpass" : 9,
  "idExtendedAttributeSubEntity" : 3,
  "flgPrefatt" : 2,
  "flgStornoiva" : 0.58919091925136,
  "descPag" : "descPag",
  "extensionData" : [ null, null ],
  "scpermer2" : 1.3949519358941398,
  "pluginData" : {
    "key" : ""
  },
  "id" : 2,
  "scpercas" : 6.966044574347761,
  "scpermer1" : 9.806951670467935,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 4.8789878742268815,
  "idExtendedAttributeEntity" : 1,
  "rowversion" : "",
  "scart26" : 6.173804034172511
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body PaymentTermCODTO Object of type to create
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns PaymentTermCODTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgDesc" : 7.203794749804894,
  "paymentTermDetailCO" : [ {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  }, {
    "indImpfix" : 4.010300976654761,
    "daggfix1" : 4.372688051310086,
    "daggfix2" : 5.7911894223693885,
    "ggmmfix" : 7.92839742024475,
    "ggdecor" : 7.726998920545485,
    "idCg64" : 8,
    "imporfix" : 2.9805393113464476,
    "flgFrperciva" : 7.3718573971919445,
    "idCg62" : 3,
    "pluginData" : {
      "key" : ""
    },
    "id" : 4,
    "additionalData" : {
      "key" : ""
    },
    "el2friva" : 3.2841216543560217,
    "indTipocalend" : 8,
    "indTipodecor" : 6.458262756685686,
    "aggfix2" : 1.5970080735609526,
    "aggfix1" : 5.6644160867523485,
    "perciva" : 8.910869026866926,
    "el2frimp" : 1.0639121808530916,
    "ggscadfix2" : 1.7045651386993,
    "tipoeff" : 6.4280627569296165,
    "flgFrpercimp" : 9.785002165136461,
    "percimp" : 4.141296055235948,
    "prog" : 2.058822123984536,
    "extensionData" : [ null, null ],
    "el1frimp" : 5.974942028545841,
    "codPagCg62" : "codPagCg62",
    "ggscadfix1" : 9.402167524121316,
    "subTypeCO" : {
      "ggoffset" : 0.7012260588964747,
      "codiceCg07" : 0.8411762798681321,
      "tipoeff" : 4.943637496515336,
      "codPaguc" : "codPaguc",
      "extensionData" : [ null, null ],
      "descstipo" : "descstipo",
      "codStipoeff" : 2.9679475177256287,
      "flgAssegno" : 5,
      "indModfatturapa" : 6,
      "foreignPaymentCodeCO" : {
        "flgIbanobbl" : 0,
        "descrpag" : "descrpag",
        "codIso" : "codIso",
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 7,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "el1friva" : 3.8008573585058016,
    "indDatarif" : 9.146339979307802,
    "rowversion" : ""
  } ],
  "codPag" : "codPag",
  "desPagAnal" : "desPagAnal",
  "flgDisgg" : 4.332304821875894,
  "flgPrefpass" : 9,
  "idExtendedAttributeSubEntity" : 3,
  "flgPrefatt" : 2,
  "flgStornoiva" : 0.58919091925136,
  "descPag" : "descPag",
  "extensionData" : [ null, null ],
  "scpermer2" : 1.3949519358941398,
  "pluginData" : {
    "key" : ""
  },
  "id" : 2,
  "scpercas" : 6.966044574347761,
  "scpermer1" : 9.806951670467935,
  "additionalData" : {
    "key" : ""
  },
  "scpercart26" : 4.8789878742268815,
  "idExtendedAttributeEntity" : 1,
  "rowversion" : "",
  "scart26" : 6.173804034172511
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Duplication of Payment Term
 * Duplication of Payment Term
 *
 * body PaymentTermDuplicationParametersCODTO Parameters for duplication
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body PaymentTermCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOPaymentTermCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOPaymentTermCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

