'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns VatCodeCODTO
 **/
exports.apiV1EnvironmentCOVatCodeCOGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgSospimp" : 2.8841621266687802,
  "indNatura" : 6,
  "flgAgri" : 7.457744773683766,
  "tipologia" : 8.969578798196912,
  "percindet" : 6.519180951018382,
  "mossperc" : 0.8851374739011653,
  "natureEsCO" : {
    "descr" : "descr",
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "natureAssCO" : [ null, null ],
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ null, null ],
    "rowversion" : ""
  },
  "nationCO" : {
    "codSian" : 9.702963800023566,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 5.507386964179881,
    "codice" : 0.8774076871421566,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "extensionData" : [ null, null ],
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 0,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 4.86315908102884,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "verslynfa" : "verslynfa",
  "idExtendedAttributeEntity" : 7,
  "annotazioni" : "annotazioni",
  "rowVersion" : "",
  "indNatassoswCg2n" : 5,
  "perciva" : 0.10263654006109402,
  "percforf" : 7.058770351582356,
  "codice" : "codice",
  "impostamonofasersm" : 6.878052220127876,
  "codiceOss" : "codiceOss",
  "extensionData" : [ null, null ],
  "stdcodivarifCg28" : "stdcodivarifCg28",
  "flgMossgest" : 3,
  "flgAutoue" : 5.025004791520295,
  "flgIndet" : 8.762042012749001,
  "codPlafond" : 6.84685269835264,
  "note" : "note",
  "flgAssport398" : 4.965218492984954,
  "flgMossrid" : 6,
  "indStaper" : 3.353193347011243,
  "flgAllclifor" : 1.1730742509559433,
  "codiceagr" : "codiceagr",
  "flgImpostadibollo" : 6,
  "flgCorrVent" : 9.965781217890562,
  "aliqivavent" : 1.4894159098541704,
  "flgNotvar" : 1.284659006116532,
  "percmonofasersm" : 4.652396432933246,
  "idprov" : 6.778324963048013,
  "idExtendedAttributeSubEntity" : 3,
  "natureAssCO" : {
    "descr" : "descr",
    "idCg2m" : 7,
    "idassosw" : 3,
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "rowversion" : ""
  },
  "flgMonofasersm" : 6.438423552598547,
  "mosscodCg07" : 7.143538047012306,
  "descrizione" : "descrizione",
  "flgEscludiblacklist" : 9.369310271410669,
  "flgIvaedit" : 9.018348186070783,
  "indtipopart" : 3.0937452626664474
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOVatCodeCOIdDELETE = function(id,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns VatCodeCODTO
 **/
exports.apiV1EnvironmentCOVatCodeCOIdGET = function(id,environment,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgSospimp" : 2.8841621266687802,
  "indNatura" : 6,
  "flgAgri" : 7.457744773683766,
  "tipologia" : 8.969578798196912,
  "percindet" : 6.519180951018382,
  "mossperc" : 0.8851374739011653,
  "natureEsCO" : {
    "descr" : "descr",
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "natureAssCO" : [ null, null ],
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ null, null ],
    "rowversion" : ""
  },
  "nationCO" : {
    "codSian" : 9.702963800023566,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 5.507386964179881,
    "codice" : 0.8774076871421566,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "extensionData" : [ null, null ],
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 0,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 4.86315908102884,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "verslynfa" : "verslynfa",
  "idExtendedAttributeEntity" : 7,
  "annotazioni" : "annotazioni",
  "rowVersion" : "",
  "indNatassoswCg2n" : 5,
  "perciva" : 0.10263654006109402,
  "percforf" : 7.058770351582356,
  "codice" : "codice",
  "impostamonofasersm" : 6.878052220127876,
  "codiceOss" : "codiceOss",
  "extensionData" : [ null, null ],
  "stdcodivarifCg28" : "stdcodivarifCg28",
  "flgMossgest" : 3,
  "flgAutoue" : 5.025004791520295,
  "flgIndet" : 8.762042012749001,
  "codPlafond" : 6.84685269835264,
  "note" : "note",
  "flgAssport398" : 4.965218492984954,
  "flgMossrid" : 6,
  "indStaper" : 3.353193347011243,
  "flgAllclifor" : 1.1730742509559433,
  "codiceagr" : "codiceagr",
  "flgImpostadibollo" : 6,
  "flgCorrVent" : 9.965781217890562,
  "aliqivavent" : 1.4894159098541704,
  "flgNotvar" : 1.284659006116532,
  "percmonofasersm" : 4.652396432933246,
  "idprov" : 6.778324963048013,
  "idExtendedAttributeSubEntity" : 3,
  "natureAssCO" : {
    "descr" : "descr",
    "idCg2m" : 7,
    "idassosw" : 3,
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "rowversion" : ""
  },
  "flgMonofasersm" : 6.438423552598547,
  "mosscodCg07" : 7.143538047012306,
  "descrizione" : "descrizione",
  "flgEscludiblacklist" : 9.369310271410669,
  "flgIvaedit" : 9.018348186070783,
  "indtipopart" : 3.0937452626664474
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOVatCodeCOIdPATCH = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body VatCodeCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns VatCodeCODTO
 **/
exports.apiV1EnvironmentCOVatCodeCOIdPUT = function(body,force,_op,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgSospimp" : 2.8841621266687802,
  "indNatura" : 6,
  "flgAgri" : 7.457744773683766,
  "tipologia" : 8.969578798196912,
  "percindet" : 6.519180951018382,
  "mossperc" : 0.8851374739011653,
  "natureEsCO" : {
    "descr" : "descr",
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "natureAssCO" : [ null, null ],
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ null, null ],
    "rowversion" : ""
  },
  "nationCO" : {
    "codSian" : 9.702963800023566,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 5.507386964179881,
    "codice" : 0.8774076871421566,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "extensionData" : [ null, null ],
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 0,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 4.86315908102884,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "verslynfa" : "verslynfa",
  "idExtendedAttributeEntity" : 7,
  "annotazioni" : "annotazioni",
  "rowVersion" : "",
  "indNatassoswCg2n" : 5,
  "perciva" : 0.10263654006109402,
  "percforf" : 7.058770351582356,
  "codice" : "codice",
  "impostamonofasersm" : 6.878052220127876,
  "codiceOss" : "codiceOss",
  "extensionData" : [ null, null ],
  "stdcodivarifCg28" : "stdcodivarifCg28",
  "flgMossgest" : 3,
  "flgAutoue" : 5.025004791520295,
  "flgIndet" : 8.762042012749001,
  "codPlafond" : 6.84685269835264,
  "note" : "note",
  "flgAssport398" : 4.965218492984954,
  "flgMossrid" : 6,
  "indStaper" : 3.353193347011243,
  "flgAllclifor" : 1.1730742509559433,
  "codiceagr" : "codiceagr",
  "flgImpostadibollo" : 6,
  "flgCorrVent" : 9.965781217890562,
  "aliqivavent" : 1.4894159098541704,
  "flgNotvar" : 1.284659006116532,
  "percmonofasersm" : 4.652396432933246,
  "idprov" : 6.778324963048013,
  "idExtendedAttributeSubEntity" : 3,
  "natureAssCO" : {
    "descr" : "descr",
    "idCg2m" : 7,
    "idassosw" : 3,
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "rowversion" : ""
  },
  "flgMonofasersm" : 6.438423552598547,
  "mosscodCg07" : 7.143538047012306,
  "descrizione" : "descrizione",
  "flgEscludiblacklist" : 9.369310271410669,
  "flgIvaedit" : 9.018348186070783,
  "indtipopart" : 3.0937452626664474
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Check Progressive Handling
 * Check if the specified VAT code has moved the progressives
 *
 * id String The id of the VAT code for which to check the movement of the progressives
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns VerificaMovimentazioneProgressiviResultDTO
 **/
exports.apiV1EnvironmentCOVatCodeCOIdVerifica_movimentazione_progressiviPOST = function(id,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "result" : true,
  "codice" : "codice",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body VatCodeCODTO Object of type to create
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns VatCodeCODTO
 **/
exports.apiV1EnvironmentCOVatCodeCOPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgSospimp" : 2.8841621266687802,
  "indNatura" : 6,
  "flgAgri" : 7.457744773683766,
  "tipologia" : 8.969578798196912,
  "percindet" : 6.519180951018382,
  "mossperc" : 0.8851374739011653,
  "natureEsCO" : {
    "descr" : "descr",
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "natureAssCO" : [ null, null ],
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ null, null ],
    "rowversion" : ""
  },
  "nationCO" : {
    "codSian" : 9.702963800023566,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 5.507386964179881,
    "codice" : 0.8774076871421566,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "extensionData" : [ null, null ],
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 0,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 4.86315908102884,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "verslynfa" : "verslynfa",
  "idExtendedAttributeEntity" : 7,
  "annotazioni" : "annotazioni",
  "rowVersion" : "",
  "indNatassoswCg2n" : 5,
  "perciva" : 0.10263654006109402,
  "percforf" : 7.058770351582356,
  "codice" : "codice",
  "impostamonofasersm" : 6.878052220127876,
  "codiceOss" : "codiceOss",
  "extensionData" : [ null, null ],
  "stdcodivarifCg28" : "stdcodivarifCg28",
  "flgMossgest" : 3,
  "flgAutoue" : 5.025004791520295,
  "flgIndet" : 8.762042012749001,
  "codPlafond" : 6.84685269835264,
  "note" : "note",
  "flgAssport398" : 4.965218492984954,
  "flgMossrid" : 6,
  "indStaper" : 3.353193347011243,
  "flgAllclifor" : 1.1730742509559433,
  "codiceagr" : "codiceagr",
  "flgImpostadibollo" : 6,
  "flgCorrVent" : 9.965781217890562,
  "aliqivavent" : 1.4894159098541704,
  "flgNotvar" : 1.284659006116532,
  "percmonofasersm" : 4.652396432933246,
  "idprov" : 6.778324963048013,
  "idExtendedAttributeSubEntity" : 3,
  "natureAssCO" : {
    "descr" : "descr",
    "idCg2m" : 7,
    "idassosw" : 3,
    "codice" : "codice",
    "datainival" : "2000-01-23T04:56:07.000+00:00",
    "datafineval" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "rowversion" : ""
  },
  "flgMonofasersm" : 6.438423552598547,
  "mosscodCg07" : 7.143538047012306,
  "descrizione" : "descrizione",
  "flgEscludiblacklist" : 9.369310271410669,
  "flgIvaedit" : 9.018348186070783,
  "indtipopart" : 3.0937452626664474
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body VatCodeCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOVatCodeCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOVatCodeCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Duplication of VatCode
 * Duplication of VatCode
 *
 * body VatCodeDuplicationParametersCODTO Parameters for duplication
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOVatCodeCOVatCodeDuplicationPOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}

