'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns AccountingReasonCodeCODTO
 **/
exports.apiV1EnvironmentCOAccountingReasonCodeCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgComp" : 2.3021358869347655,
  "idmediaCg99" : 1.1730742509559433,
  "flgGestsez" : 2.027123023002322,
  "indTipomov" : 3,
  "indTiporeg" : 1,
  "flgInsoluti" : 4.145608029883936,
  "causalecolltype" : 0.8008281904610115,
  "indTipooper" : 6.965117697638846,
  "flgProtsemp" : 1.0246457001441578,
  "indCaubenius" : 5.025004791520295,
  "caualias" : "caualias",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "flgDatiassegno" : 7.061401241503109,
  "flgPortaf" : 1.2315135367772556,
  "indProteo360" : 9.018348186070783,
  "idCgd1" : 7.457744773683766,
  "causaleiva" : "causaleiva",
  "idprov" : 4.965218492984954,
  "idCg0z" : 6,
  "indMonofasersm" : 8.762042012749001,
  "codice" : "codice",
  "flgAutofatt" : 5.962133916683182,
  "flgCaufissa" : 5.637376656633329,
  "tipoeff" : 2,
  "classification" : {
    "descr" : "descr",
    "idmediaCg99" : 6.878052220127876,
    "pluginData" : {
      "key" : ""
    },
    "id" : 6.778324963048013,
    "additionalData" : {
      "key" : ""
    },
    "tipologia" : "tipologia"
  },
  "flgSubforni" : 1.4894159098541704,
  "descr" : "descr",
  "causalecoll" : "causalecoll",
  "flgAgviag" : 1.4658129805029452,
  "flgEconto" : 9.301444243932576,
  "indGestec" : 9.369310271410669,
  "indDaav" : 9,
  "flgFattdiff" : 3.616076749251911,
  "flgIvaedit" : 7.386281948385884,
  "indGestfattproforma" : 6,
  "indScadfattproforma" : 6,
  "flgAcconto" : 6.027456183070403,
  "rowversion" : ""
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns AccountingReasonCodeCODTO
 **/
exports.apiV1EnvironmentCOAccountingReasonCodeCOIdGET = function(id,environment,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "flgComp" : 2.3021358869347655,
  "idmediaCg99" : 1.1730742509559433,
  "flgGestsez" : 2.027123023002322,
  "indTipomov" : 3,
  "indTiporeg" : 1,
  "flgInsoluti" : 4.145608029883936,
  "causalecolltype" : 0.8008281904610115,
  "indTipooper" : 6.965117697638846,
  "flgProtsemp" : 1.0246457001441578,
  "indCaubenius" : 5.025004791520295,
  "caualias" : "caualias",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "flgDatiassegno" : 7.061401241503109,
  "flgPortaf" : 1.2315135367772556,
  "indProteo360" : 9.018348186070783,
  "idCgd1" : 7.457744773683766,
  "causaleiva" : "causaleiva",
  "idprov" : 4.965218492984954,
  "idCg0z" : 6,
  "indMonofasersm" : 8.762042012749001,
  "codice" : "codice",
  "flgAutofatt" : 5.962133916683182,
  "flgCaufissa" : 5.637376656633329,
  "tipoeff" : 2,
  "classification" : {
    "descr" : "descr",
    "idmediaCg99" : 6.878052220127876,
    "pluginData" : {
      "key" : ""
    },
    "id" : 6.778324963048013,
    "additionalData" : {
      "key" : ""
    },
    "tipologia" : "tipologia"
  },
  "flgSubforni" : 1.4894159098541704,
  "descr" : "descr",
  "causalecoll" : "causalecoll",
  "flgAgviag" : 1.4658129805029452,
  "flgEconto" : 9.301444243932576,
  "indGestec" : 9.369310271410669,
  "indDaav" : 9,
  "flgFattdiff" : 3.616076749251911,
  "flgIvaedit" : 7.386281948385884,
  "indGestfattproforma" : 6,
  "indScadfattproforma" : 6,
  "flgAcconto" : 6.027456183070403,
  "rowversion" : ""
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body AccountingReasonCodeCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOAccountingReasonCodeCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOAccountingReasonCodeCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

