'use strict';


/**
 * Integrate the letter of intent
 * Integrate the letter of intent
 *
 * body IntegrativeDeclarationParametersCODTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns IntegrativeDeclarationResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "opResult" : {
    "note" : "note",
    "anno" : 0.8008281904610115,
    "datarevoca" : "2000-01-23T04:56:07.000+00:00",
    "dataProtocollo" : "2000-01-23T04:56:07.000+00:00",
    "alqIvaCg28" : "alqIvaCg28",
    "flagStDich" : 2.3021358869347655,
    "numProtocollo" : 7.386281948385884,
    "numLetDich" : "numLetDich",
    "progRinvio" : 1.2315135367772556,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "numNsProt" : 4.145608029883936,
    "dataFineVal" : "2000-01-23T04:56:07.000+00:00",
    "dataNsReg" : "2000-01-23T04:56:07.000+00:00",
    "flagDisattiv" : 5.637376656633329,
    "tipoCFCg44" : 1.0246457001441578,
    "finoAEuro" : 5.962133916683182,
    "cliForCg44" : 6.027456183070403,
    "dogana" : "dogana",
    "dataInVal" : "2000-01-23T04:56:07.000+00:00",
    "dataRicez" : "2000-01-23T04:56:07.000+00:00",
    "flgScartata" : 9,
    "flagStReg" : 7.061401241503109,
    "vatCodeCO" : {
      "flgSospimp" : 2.8841621266687802,
      "indNatura" : 6,
      "flgAgri" : 7.457744773683766,
      "tipologia" : 8.969578798196912,
      "percindet" : 6.519180951018382,
      "mossperc" : 0.8851374739011653,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 5,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 7,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 5,
      "perciva" : 0.10263654006109402,
      "percforf" : 7.058770351582356,
      "codice" : "codice",
      "impostamonofasersm" : 6.878052220127876,
      "codiceOss" : "codiceOss",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 3,
      "flgAutoue" : 5.025004791520295,
      "flgIndet" : 8.762042012749001,
      "codPlafond" : 6.84685269835264,
      "note" : "note",
      "flgAssport398" : 4.965218492984954,
      "flgMossrid" : 6,
      "indStaper" : 3.353193347011243,
      "flgAllclifor" : 1.1730742509559433,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 6,
      "flgCorrVent" : 9.965781217890562,
      "aliqivavent" : 1.4894159098541704,
      "flgNotvar" : 1.284659006116532,
      "percmonofasersm" : 4.652396432933246,
      "idprov" : 6.778324963048013,
      "idExtendedAttributeSubEntity" : 3,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 7,
        "idassosw" : 3,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "flgMonofasersm" : 6.438423552598547,
      "mosscodCg07" : 7.143538047012306,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 9.369310271410669,
      "flgIvaedit" : 9.018348186070783,
      "indtipopart" : 3.0937452626664474
    },
    "dittaCg18" : 1.4658129805029452,
    "indTipoDich" : 2.027123023002322,
    "rowversion" : ""
  },
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierCODTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 4,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 4
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "codCabCg13" : 5.637376656633329,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 3,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 6.778324963048013,
    "indsoggrit" : 0.10263654006109402,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 0.4182561061793122,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 8,
      "codIntercompany" : 5
    },
    "statofiscCg07" : 7.740351818741173,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 6,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 3,
    "citta" : "citta",
    "statonascitaCg07" : 3.0205796992916243,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 7.143538047012306,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.519180951018382,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 5.312489704336296,
      "flgRegagevo" : 9.897492629215506,
      "idmediaCg99" : 3.1497903714250555,
      "percRipPerc" : 2.7977867356748476,
      "flgRitImposta" : 5.877124706116695,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 3.7814124730767915,
      "flgProteo360" : 3.111202833403195,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 8.37823741034869,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 0,
      "idprov" : 2.380090174313445,
      "codice" : "codice",
      "percci" : 0.35262192099236644,
      "flgSosprit" : 7,
      "descr" : "descr",
      "flgMinimi" : 7,
      "codTributo" : "codTributo",
      "indCodattglad" : 3.804112695731078,
      "indTipocassa" : 8,
      "percra" : 7.203794749804894,
      "percbaseimp" : 0.4833312865174044,
      "codTribrp" : "codTribrp",
      "inpsivs" : 4.518309517874243,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 5.944895607614016,
    "codiceCgc0" : 6.878052220127876,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 0.8851374739011653,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 3.353193347011243,
    "rapazestCg16" : 4,
    "cellnum" : "cellnum",
    "flgPrsfis" : 7.058770351582356,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 7,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 8.969578798196912,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 1,
    "indweb" : "indweb"
  },
  "flgAttivo" : 9.301444243932576,
  "gmdUpdateAdditionalParams" : {
    "codFiscale" : "codFiscale",
    "tel1Num" : "tel1Num",
    "codice" : 0,
    "indirizzo" : "indirizzo",
    "codiceCg07" : 6.027456183070403,
    "ragSoAnag" : "ragSoAnag",
    "tipologia" : "tipologia",
    "numCiv" : "numCiv",
    "cap" : "cap",
    "nationIso" : "nationIso",
    "descrCg07" : "descrCg07",
    "fax" : "fax",
    "prov" : "prov",
    "partiva" : "partiva",
    "codLegCg01" : "codLegCg01",
    "citta" : "citta"
  },
  "csCompanyBankCO" : [ {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  }, {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  } ],
  "intermedioCg40" : 6.84685269835264,
  "csBankCO" : [ {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  }, {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  } ],
  "customerSupplierCIGCUPCO" : [ {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  }, {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  } ],
  "pluginData" : {
    "key" : ""
  },
  "flgArt62" : 7,
  "additionalData" : {
    "key" : ""
  },
  "idExtendedAttributeEntity" : 4,
  "csPaymentRangeCO" : [ {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  }, {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  } ],
  "flgCointestati" : 3.616076749251911,
  "contorCg24" : "contorCg24",
  "extensionData" : [ null, null ],
  "progREf08" : 7.457744773683766,
  "dittaCg18" : 2.3021358869347655,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "clifor" : 1.4658129805029452,
  "custSupplDataInvoicePACO" : {
    "flgAsw" : 2,
    "indTypeb2b" : 5,
    "tipocfCg44" : 5.412786966532157,
    "codiceCg16" : 9,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "emailcortesia" : "emailcortesia"
  },
  "officePACO" : [ {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  }, {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  } ],
  "idmediaCg99" : 1.0246457001441578,
  "codiceCg28" : "codiceCg28",
  "csSddCO" : [ {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  }, {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  } ],
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 9,
    "idknos" : 6,
    "dittaCg18" : 3.5571952270680973,
    "flgInvalid" : 6,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 8.036294790673514,
    "codice" : 8.546645780823726,
    "indDimcentrocomm" : 8.310924482277276,
    "cap" : "cap",
    "dittaCg18" : 4.784107115651097,
    "progRea" : 6.607129449620165,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "indElenchimov3000" : 1,
  "codAbiCg12" : 5.962133916683182,
  "idclifor" : 1,
  "csAccountingIndexCO" : {
    "descr" : "descr",
    "codCat" : "codCat",
    "dittaCg18" : 0.8008281904610115,
    "tipocfCg44" : 6.027456183070403,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "ggscadfix" : 4.145608029883936,
  "idExtendedAttributeSubEntity" : 5,
  "csPostponementPeriodCO" : [ {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  }, {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  } ],
  "gruppoCg10" : 7.386281948385884,
  "vatCodeCO" : {
    "flgSospimp" : 2.8841621266687802,
    "indNatura" : 6,
    "flgAgri" : 7.457744773683766,
    "tipologia" : 8.969578798196912,
    "percindet" : 6.519180951018382,
    "mossperc" : 0.8851374739011653,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 7,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 5,
    "perciva" : 0.10263654006109402,
    "percforf" : 7.058770351582356,
    "codice" : "codice",
    "impostamonofasersm" : 6.878052220127876,
    "codiceOss" : "codiceOss",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 5.025004791520295,
    "flgIndet" : 8.762042012749001,
    "codPlafond" : 6.84685269835264,
    "note" : "note",
    "flgAssport398" : 4.965218492984954,
    "flgMossrid" : 6,
    "indStaper" : 3.353193347011243,
    "flgAllclifor" : 1.1730742509559433,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 6,
    "flgCorrVent" : 9.965781217890562,
    "aliqivavent" : 1.4894159098541704,
    "flgNotvar" : 1.284659006116532,
    "percmonofasersm" : 4.652396432933246,
    "idprov" : 6.778324963048013,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 7,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 6.438423552598547,
    "mosscodCg07" : 7.143538047012306,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 9.369310271410669,
    "flgIvaedit" : 9.018348186070783,
    "indtipopart" : 3.0937452626664474
  },
  "agentCO" : {
    "flgRegimecl" : 2.3021358869347655,
    "tiporappor" : 9.965781217890562,
    "indBaseimpsc" : 7.386281948385884,
    "idmediaCg99" : 2.027123023002322,
    "perprov" : 1.1730742509559433,
    "datainman" : "2000-01-23T04:56:07.000+00:00",
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 9,
      "idknos" : 6,
      "dittaCg18" : 3.5571952270680973,
      "flgInvalid" : 6,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "indStdistenas" : 1.4894159098541704,
    "tiposoc" : 9.369310271410669,
    "indCalcscmag" : 1.2315135367772556,
    "datafineman" : "2000-01-23T04:56:07.000+00:00",
    "indTipoliq" : 7.457744773683766,
    "anagenCg16" : 0,
    "generalMasterDataCO" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 3,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 6.778324963048013,
      "indsoggrit" : 0.10263654006109402,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 0.4182561061793122,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 8,
        "codIntercompany" : 5
      },
      "statofiscCg07" : 7.740351818741173,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 6,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 3,
      "citta" : "citta",
      "statonascitaCg07" : 3.0205796992916243,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 7.143538047012306,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.519180951018382,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 5.312489704336296,
        "flgRegagevo" : 9.897492629215506,
        "idmediaCg99" : 3.1497903714250555,
        "percRipPerc" : 2.7977867356748476,
        "flgRitImposta" : 5.877124706116695,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 3.7814124730767915,
        "flgProteo360" : 3.111202833403195,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 8.37823741034869,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 0,
        "idprov" : 2.380090174313445,
        "codice" : "codice",
        "percci" : 0.35262192099236644,
        "flgSosprit" : 7,
        "descr" : "descr",
        "flgMinimi" : 7,
        "codTributo" : "codTributo",
        "indCodattglad" : 3.804112695731078,
        "indTipocassa" : 8,
        "percra" : 7.203794749804894,
        "percbaseimp" : 0.4833312865174044,
        "codTribrp" : "codTribrp",
        "inpsivs" : 4.518309517874243,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 5.944895607614016,
      "codiceCgc0" : 6.878052220127876,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 0.8851374739011653,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 3.353193347011243,
      "rapazestCg16" : 4,
      "cellnum" : "cellnum",
      "flgPrsfis" : 7.058770351582356,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 7,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 8.969578798196912,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 1,
      "indweb" : "indweb"
    },
    "flgAdeguamscmag" : 5.962133916683182,
    "tipomand" : 5.025004791520295,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgAdegdelta" : 1.4658129805029452,
    "idcapoareaMg17" : 9,
    "idExtendedAttributeEntity" : 6,
    "agente" : "agente",
    "idcapozonaMg17" : 3,
    "flgRegimeart" : 5.637376656633329,
    "idExtendedAttributeSubEntity" : 8,
    "regimeprov" : 4.965218492984954,
    "datainrapp" : "2000-01-23T04:56:07.000+00:00",
    "extensionData" : [ null, null ],
    "idagente" : 7,
    "indBaseimpmag" : 4.145608029883936,
    "dittaCg18" : 6.027456183070403,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indPrefstdoc" : 1.0246457001441578,
    "indTipoage" : 6.84685269835264
  },
  "flgIntercompany" : 2.027123023002322,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "contoCg24" : "contoCg24",
  "csJointlyHeldCO" : [ {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  }, {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  } ],
  "tipocf" : 1.1730742509559433,
  "csInfoCO" : {
    "macroAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 8.863729185622827,
      "idprov" : 9,
      "tipocf" : 1.8268702177058116,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "cliforCg44" : 8.969578798196912,
    "flgSpbol" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 5.507386964179881,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 6,
      "idmediaCg99" : 4.86315908102884,
      "tipocf" : 8.251625748923757,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "macroarea" : "macroarea",
    "irs1099" : "irs1099",
    "macrocat" : "macrocat",
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 1.7325933120207193,
      "idprov" : 6,
      "idmediaCg99" : 8.28965939814297,
      "tipocf" : 4.573936264232251,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "zona" : "zona",
    "raggcrf3" : "raggcrf3",
    "flgSpeinc" : 4.258773108174356,
    "taxareaNv01" : "taxareaNv01",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "bacsaccountno" : 4,
    "area" : "area",
    "indClibloc" : 7.260521264802104,
    "flgTaxliable" : 1,
    "codLivbloc" : "codLivbloc",
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 0.5199002018724985,
    "codRifalf" : "codRifalf",
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 3.502657762086401,
      "tipocf" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.027456183070403,
      "descrcat" : "descrcat",
      "dittaCg18" : 0.8008281904610115,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indSpesecum" : 9.702963800023566,
    "indGesfido" : 9.132027271330688,
    "codIclfatt" : 7.740351818741173,
    "dittaCg18" : 3.0576100241049344,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "finchargerterms" : "finchargerterms",
    "typeofsupply" : "typeofsupply",
    "codRifnum" : 3.0205796992916243,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.8008281904610115,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 6,
      "tipocfMg07" : 1.4658129805029452,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 7.933506881737151,
    "fidofactoring" : 5.533258397034986,
    "idmediaCg99" : 4.678947989005849,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "regimeiva" : "regimeiva",
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.459605034958679,
      "idprov" : 0,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 3.901545264248647,
      "tipocf" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "linguaMg52" : "linguaMg52",
    "notebloc" : "notebloc",
    "categ" : "categ",
    "codRischioMg2a" : "codRischioMg2a",
    "fidoaziendale" : 7.04836565559697,
    "fidolivello1" : 3.2588565619047607,
    "indrottcig" : 0.8774076871421566,
    "sottocat" : "sottocat",
    "fidolivello2" : 4.078845849666752,
    "zoneCO" : {
      "areaMg08" : "areaMg08",
      "macroareaMg08" : "macroareaMg08",
      "dittaCg18" : 5.962133916683182,
      "idprov" : 5,
      "descrzona" : "descrzona",
      "tipocfMg08" : 2.3021358869347655,
      "pluginData" : {
        "key" : ""
      },
      "codiceZona" : "codiceZona",
      "additionalData" : {
        "key" : ""
      }
    },
    "reminderterms" : "reminderterms",
    "raggrcf2" : "raggrcf2",
    "flgEstrpayline" : 0.2025324113236393,
    "raggrcf1" : "raggrcf1",
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 0.4182561061793122,
      "dittaCg18" : 8.761432466225475,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "areanielsenMg0e" : "areanielsenMg0e"
  },
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Returns the customer/supplier with the actual payment condition
 * Returns the customer/supplier with the actual payment condition, taking into account the brackets
 *
 * body CSWithEffectivePaymentConditionParametersDTO customer/supplier reading parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierCODTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 4,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 4
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "codCabCg13" : 5.637376656633329,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 3,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 6.778324963048013,
    "indsoggrit" : 0.10263654006109402,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 0.4182561061793122,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 8,
      "codIntercompany" : 5
    },
    "statofiscCg07" : 7.740351818741173,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 6,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 3,
    "citta" : "citta",
    "statonascitaCg07" : 3.0205796992916243,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 7.143538047012306,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.519180951018382,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 5.312489704336296,
      "flgRegagevo" : 9.897492629215506,
      "idmediaCg99" : 3.1497903714250555,
      "percRipPerc" : 2.7977867356748476,
      "flgRitImposta" : 5.877124706116695,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 3.7814124730767915,
      "flgProteo360" : 3.111202833403195,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 8.37823741034869,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 0,
      "idprov" : 2.380090174313445,
      "codice" : "codice",
      "percci" : 0.35262192099236644,
      "flgSosprit" : 7,
      "descr" : "descr",
      "flgMinimi" : 7,
      "codTributo" : "codTributo",
      "indCodattglad" : 3.804112695731078,
      "indTipocassa" : 8,
      "percra" : 7.203794749804894,
      "percbaseimp" : 0.4833312865174044,
      "codTribrp" : "codTribrp",
      "inpsivs" : 4.518309517874243,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 5.944895607614016,
    "codiceCgc0" : 6.878052220127876,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 0.8851374739011653,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 3.353193347011243,
    "rapazestCg16" : 4,
    "cellnum" : "cellnum",
    "flgPrsfis" : 7.058770351582356,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 7,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 8.969578798196912,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 1,
    "indweb" : "indweb"
  },
  "flgAttivo" : 9.301444243932576,
  "gmdUpdateAdditionalParams" : {
    "codFiscale" : "codFiscale",
    "tel1Num" : "tel1Num",
    "codice" : 0,
    "indirizzo" : "indirizzo",
    "codiceCg07" : 6.027456183070403,
    "ragSoAnag" : "ragSoAnag",
    "tipologia" : "tipologia",
    "numCiv" : "numCiv",
    "cap" : "cap",
    "nationIso" : "nationIso",
    "descrCg07" : "descrCg07",
    "fax" : "fax",
    "prov" : "prov",
    "partiva" : "partiva",
    "codLegCg01" : "codLegCg01",
    "citta" : "citta"
  },
  "csCompanyBankCO" : [ {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  }, {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  } ],
  "intermedioCg40" : 6.84685269835264,
  "csBankCO" : [ {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  }, {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  } ],
  "customerSupplierCIGCUPCO" : [ {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  }, {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  } ],
  "pluginData" : {
    "key" : ""
  },
  "flgArt62" : 7,
  "additionalData" : {
    "key" : ""
  },
  "idExtendedAttributeEntity" : 4,
  "csPaymentRangeCO" : [ {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  }, {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  } ],
  "flgCointestati" : 3.616076749251911,
  "contorCg24" : "contorCg24",
  "extensionData" : [ null, null ],
  "progREf08" : 7.457744773683766,
  "dittaCg18" : 2.3021358869347655,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "clifor" : 1.4658129805029452,
  "custSupplDataInvoicePACO" : {
    "flgAsw" : 2,
    "indTypeb2b" : 5,
    "tipocfCg44" : 5.412786966532157,
    "codiceCg16" : 9,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "emailcortesia" : "emailcortesia"
  },
  "officePACO" : [ {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  }, {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  } ],
  "idmediaCg99" : 1.0246457001441578,
  "codiceCg28" : "codiceCg28",
  "csSddCO" : [ {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  }, {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  } ],
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 9,
    "idknos" : 6,
    "dittaCg18" : 3.5571952270680973,
    "flgInvalid" : 6,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 8.036294790673514,
    "codice" : 8.546645780823726,
    "indDimcentrocomm" : 8.310924482277276,
    "cap" : "cap",
    "dittaCg18" : 4.784107115651097,
    "progRea" : 6.607129449620165,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "indElenchimov3000" : 1,
  "codAbiCg12" : 5.962133916683182,
  "idclifor" : 1,
  "csAccountingIndexCO" : {
    "descr" : "descr",
    "codCat" : "codCat",
    "dittaCg18" : 0.8008281904610115,
    "tipocfCg44" : 6.027456183070403,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "ggscadfix" : 4.145608029883936,
  "idExtendedAttributeSubEntity" : 5,
  "csPostponementPeriodCO" : [ {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  }, {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  } ],
  "gruppoCg10" : 7.386281948385884,
  "vatCodeCO" : {
    "flgSospimp" : 2.8841621266687802,
    "indNatura" : 6,
    "flgAgri" : 7.457744773683766,
    "tipologia" : 8.969578798196912,
    "percindet" : 6.519180951018382,
    "mossperc" : 0.8851374739011653,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 7,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 5,
    "perciva" : 0.10263654006109402,
    "percforf" : 7.058770351582356,
    "codice" : "codice",
    "impostamonofasersm" : 6.878052220127876,
    "codiceOss" : "codiceOss",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 5.025004791520295,
    "flgIndet" : 8.762042012749001,
    "codPlafond" : 6.84685269835264,
    "note" : "note",
    "flgAssport398" : 4.965218492984954,
    "flgMossrid" : 6,
    "indStaper" : 3.353193347011243,
    "flgAllclifor" : 1.1730742509559433,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 6,
    "flgCorrVent" : 9.965781217890562,
    "aliqivavent" : 1.4894159098541704,
    "flgNotvar" : 1.284659006116532,
    "percmonofasersm" : 4.652396432933246,
    "idprov" : 6.778324963048013,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 7,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 6.438423552598547,
    "mosscodCg07" : 7.143538047012306,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 9.369310271410669,
    "flgIvaedit" : 9.018348186070783,
    "indtipopart" : 3.0937452626664474
  },
  "agentCO" : {
    "flgRegimecl" : 2.3021358869347655,
    "tiporappor" : 9.965781217890562,
    "indBaseimpsc" : 7.386281948385884,
    "idmediaCg99" : 2.027123023002322,
    "perprov" : 1.1730742509559433,
    "datainman" : "2000-01-23T04:56:07.000+00:00",
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 9,
      "idknos" : 6,
      "dittaCg18" : 3.5571952270680973,
      "flgInvalid" : 6,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "indStdistenas" : 1.4894159098541704,
    "tiposoc" : 9.369310271410669,
    "indCalcscmag" : 1.2315135367772556,
    "datafineman" : "2000-01-23T04:56:07.000+00:00",
    "indTipoliq" : 7.457744773683766,
    "anagenCg16" : 0,
    "generalMasterDataCO" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 3,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 6.778324963048013,
      "indsoggrit" : 0.10263654006109402,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 0.4182561061793122,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 8,
        "codIntercompany" : 5
      },
      "statofiscCg07" : 7.740351818741173,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 6,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 3,
      "citta" : "citta",
      "statonascitaCg07" : 3.0205796992916243,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 7.143538047012306,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.519180951018382,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 5.312489704336296,
        "flgRegagevo" : 9.897492629215506,
        "idmediaCg99" : 3.1497903714250555,
        "percRipPerc" : 2.7977867356748476,
        "flgRitImposta" : 5.877124706116695,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 3.7814124730767915,
        "flgProteo360" : 3.111202833403195,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 8.37823741034869,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 0,
        "idprov" : 2.380090174313445,
        "codice" : "codice",
        "percci" : 0.35262192099236644,
        "flgSosprit" : 7,
        "descr" : "descr",
        "flgMinimi" : 7,
        "codTributo" : "codTributo",
        "indCodattglad" : 3.804112695731078,
        "indTipocassa" : 8,
        "percra" : 7.203794749804894,
        "percbaseimp" : 0.4833312865174044,
        "codTribrp" : "codTribrp",
        "inpsivs" : 4.518309517874243,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 5.944895607614016,
      "codiceCgc0" : 6.878052220127876,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 0.8851374739011653,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 3.353193347011243,
      "rapazestCg16" : 4,
      "cellnum" : "cellnum",
      "flgPrsfis" : 7.058770351582356,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 7,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 8.969578798196912,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 1,
      "indweb" : "indweb"
    },
    "flgAdeguamscmag" : 5.962133916683182,
    "tipomand" : 5.025004791520295,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgAdegdelta" : 1.4658129805029452,
    "idcapoareaMg17" : 9,
    "idExtendedAttributeEntity" : 6,
    "agente" : "agente",
    "idcapozonaMg17" : 3,
    "flgRegimeart" : 5.637376656633329,
    "idExtendedAttributeSubEntity" : 8,
    "regimeprov" : 4.965218492984954,
    "datainrapp" : "2000-01-23T04:56:07.000+00:00",
    "extensionData" : [ null, null ],
    "idagente" : 7,
    "indBaseimpmag" : 4.145608029883936,
    "dittaCg18" : 6.027456183070403,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indPrefstdoc" : 1.0246457001441578,
    "indTipoage" : 6.84685269835264
  },
  "flgIntercompany" : 2.027123023002322,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "contoCg24" : "contoCg24",
  "csJointlyHeldCO" : [ {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  }, {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  } ],
  "tipocf" : 1.1730742509559433,
  "csInfoCO" : {
    "macroAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 8.863729185622827,
      "idprov" : 9,
      "tipocf" : 1.8268702177058116,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "cliforCg44" : 8.969578798196912,
    "flgSpbol" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 5.507386964179881,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 6,
      "idmediaCg99" : 4.86315908102884,
      "tipocf" : 8.251625748923757,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "macroarea" : "macroarea",
    "irs1099" : "irs1099",
    "macrocat" : "macrocat",
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 1.7325933120207193,
      "idprov" : 6,
      "idmediaCg99" : 8.28965939814297,
      "tipocf" : 4.573936264232251,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "zona" : "zona",
    "raggcrf3" : "raggcrf3",
    "flgSpeinc" : 4.258773108174356,
    "taxareaNv01" : "taxareaNv01",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "bacsaccountno" : 4,
    "area" : "area",
    "indClibloc" : 7.260521264802104,
    "flgTaxliable" : 1,
    "codLivbloc" : "codLivbloc",
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 0.5199002018724985,
    "codRifalf" : "codRifalf",
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 3.502657762086401,
      "tipocf" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.027456183070403,
      "descrcat" : "descrcat",
      "dittaCg18" : 0.8008281904610115,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indSpesecum" : 9.702963800023566,
    "indGesfido" : 9.132027271330688,
    "codIclfatt" : 7.740351818741173,
    "dittaCg18" : 3.0576100241049344,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "finchargerterms" : "finchargerterms",
    "typeofsupply" : "typeofsupply",
    "codRifnum" : 3.0205796992916243,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.8008281904610115,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 6,
      "tipocfMg07" : 1.4658129805029452,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 7.933506881737151,
    "fidofactoring" : 5.533258397034986,
    "idmediaCg99" : 4.678947989005849,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "regimeiva" : "regimeiva",
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.459605034958679,
      "idprov" : 0,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 3.901545264248647,
      "tipocf" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "linguaMg52" : "linguaMg52",
    "notebloc" : "notebloc",
    "categ" : "categ",
    "codRischioMg2a" : "codRischioMg2a",
    "fidoaziendale" : 7.04836565559697,
    "fidolivello1" : 3.2588565619047607,
    "indrottcig" : 0.8774076871421566,
    "sottocat" : "sottocat",
    "fidolivello2" : 4.078845849666752,
    "zoneCO" : {
      "areaMg08" : "areaMg08",
      "macroareaMg08" : "macroareaMg08",
      "dittaCg18" : 5.962133916683182,
      "idprov" : 5,
      "descrzona" : "descrzona",
      "tipocfMg08" : 2.3021358869347655,
      "pluginData" : {
        "key" : ""
      },
      "codiceZona" : "codiceZona",
      "additionalData" : {
        "key" : ""
      }
    },
    "reminderterms" : "reminderterms",
    "raggrcf2" : "raggrcf2",
    "flgEstrpayline" : 0.2025324113236393,
    "raggrcf1" : "raggrcf1",
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 0.4182561061793122,
      "dittaCg18" : 8.761432466225475,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "areanielsenMg0e" : "areanielsenMg0e"
  },
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Retrieve the default revenew agency
 * Retrieve the default revenew agency
 *
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SendingLetterResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPOST = function(environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "opResult" : true,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Retrieve the first available proptocol number for letter of intent
 * Retrieve the first available proptocol number for letter of intent
 *
 * body GetFirstAvailableNumNsProtLetterOfIntentParametersDTO TODO_DOCUMENTATION
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GetFirstAvailableNumNsProtLetterOfIntentResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "numNsProt" : 0.8008281904610115
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Hello customer
 * Hello customer
 *
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * customer String  (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOHello_tsidGET = function(environment,authorizationScope,customer,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Check if exist a customer jointly held to selected customer
 * Check if exist a customer jointly held to selected customer
 *
 * body JointlyHeldCOAlreadyExistsParametersDTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id Integer 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns JointlyHeldCOAlreadyExistsResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPOST = function(body,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "alreadyExists" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdDELETE = function(id,environment,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Delete all customers jointly held to selected customer
 * Delete all customers jointly hel to selected customer
 *
 * id Integer 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns JointlyHeldCOAlreadyExistsResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPOST = function(id,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "alreadyExists" : true
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierCODTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdGET = function(id,environment,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 4,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 4
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "codCabCg13" : 5.637376656633329,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 3,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 6.778324963048013,
    "indsoggrit" : 0.10263654006109402,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 0.4182561061793122,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 8,
      "codIntercompany" : 5
    },
    "statofiscCg07" : 7.740351818741173,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 6,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 3,
    "citta" : "citta",
    "statonascitaCg07" : 3.0205796992916243,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 7.143538047012306,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.519180951018382,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 5.312489704336296,
      "flgRegagevo" : 9.897492629215506,
      "idmediaCg99" : 3.1497903714250555,
      "percRipPerc" : 2.7977867356748476,
      "flgRitImposta" : 5.877124706116695,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 3.7814124730767915,
      "flgProteo360" : 3.111202833403195,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 8.37823741034869,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 0,
      "idprov" : 2.380090174313445,
      "codice" : "codice",
      "percci" : 0.35262192099236644,
      "flgSosprit" : 7,
      "descr" : "descr",
      "flgMinimi" : 7,
      "codTributo" : "codTributo",
      "indCodattglad" : 3.804112695731078,
      "indTipocassa" : 8,
      "percra" : 7.203794749804894,
      "percbaseimp" : 0.4833312865174044,
      "codTribrp" : "codTribrp",
      "inpsivs" : 4.518309517874243,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 5.944895607614016,
    "codiceCgc0" : 6.878052220127876,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 0.8851374739011653,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 3.353193347011243,
    "rapazestCg16" : 4,
    "cellnum" : "cellnum",
    "flgPrsfis" : 7.058770351582356,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 7,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 8.969578798196912,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 1,
    "indweb" : "indweb"
  },
  "flgAttivo" : 9.301444243932576,
  "gmdUpdateAdditionalParams" : {
    "codFiscale" : "codFiscale",
    "tel1Num" : "tel1Num",
    "codice" : 0,
    "indirizzo" : "indirizzo",
    "codiceCg07" : 6.027456183070403,
    "ragSoAnag" : "ragSoAnag",
    "tipologia" : "tipologia",
    "numCiv" : "numCiv",
    "cap" : "cap",
    "nationIso" : "nationIso",
    "descrCg07" : "descrCg07",
    "fax" : "fax",
    "prov" : "prov",
    "partiva" : "partiva",
    "codLegCg01" : "codLegCg01",
    "citta" : "citta"
  },
  "csCompanyBankCO" : [ {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  }, {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  } ],
  "intermedioCg40" : 6.84685269835264,
  "csBankCO" : [ {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  }, {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  } ],
  "customerSupplierCIGCUPCO" : [ {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  }, {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  } ],
  "pluginData" : {
    "key" : ""
  },
  "flgArt62" : 7,
  "additionalData" : {
    "key" : ""
  },
  "idExtendedAttributeEntity" : 4,
  "csPaymentRangeCO" : [ {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  }, {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  } ],
  "flgCointestati" : 3.616076749251911,
  "contorCg24" : "contorCg24",
  "extensionData" : [ null, null ],
  "progREf08" : 7.457744773683766,
  "dittaCg18" : 2.3021358869347655,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "clifor" : 1.4658129805029452,
  "custSupplDataInvoicePACO" : {
    "flgAsw" : 2,
    "indTypeb2b" : 5,
    "tipocfCg44" : 5.412786966532157,
    "codiceCg16" : 9,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "emailcortesia" : "emailcortesia"
  },
  "officePACO" : [ {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  }, {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  } ],
  "idmediaCg99" : 1.0246457001441578,
  "codiceCg28" : "codiceCg28",
  "csSddCO" : [ {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  }, {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  } ],
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 9,
    "idknos" : 6,
    "dittaCg18" : 3.5571952270680973,
    "flgInvalid" : 6,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 8.036294790673514,
    "codice" : 8.546645780823726,
    "indDimcentrocomm" : 8.310924482277276,
    "cap" : "cap",
    "dittaCg18" : 4.784107115651097,
    "progRea" : 6.607129449620165,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "indElenchimov3000" : 1,
  "codAbiCg12" : 5.962133916683182,
  "idclifor" : 1,
  "csAccountingIndexCO" : {
    "descr" : "descr",
    "codCat" : "codCat",
    "dittaCg18" : 0.8008281904610115,
    "tipocfCg44" : 6.027456183070403,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "ggscadfix" : 4.145608029883936,
  "idExtendedAttributeSubEntity" : 5,
  "csPostponementPeriodCO" : [ {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  }, {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  } ],
  "gruppoCg10" : 7.386281948385884,
  "vatCodeCO" : {
    "flgSospimp" : 2.8841621266687802,
    "indNatura" : 6,
    "flgAgri" : 7.457744773683766,
    "tipologia" : 8.969578798196912,
    "percindet" : 6.519180951018382,
    "mossperc" : 0.8851374739011653,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 7,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 5,
    "perciva" : 0.10263654006109402,
    "percforf" : 7.058770351582356,
    "codice" : "codice",
    "impostamonofasersm" : 6.878052220127876,
    "codiceOss" : "codiceOss",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 5.025004791520295,
    "flgIndet" : 8.762042012749001,
    "codPlafond" : 6.84685269835264,
    "note" : "note",
    "flgAssport398" : 4.965218492984954,
    "flgMossrid" : 6,
    "indStaper" : 3.353193347011243,
    "flgAllclifor" : 1.1730742509559433,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 6,
    "flgCorrVent" : 9.965781217890562,
    "aliqivavent" : 1.4894159098541704,
    "flgNotvar" : 1.284659006116532,
    "percmonofasersm" : 4.652396432933246,
    "idprov" : 6.778324963048013,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 7,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 6.438423552598547,
    "mosscodCg07" : 7.143538047012306,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 9.369310271410669,
    "flgIvaedit" : 9.018348186070783,
    "indtipopart" : 3.0937452626664474
  },
  "agentCO" : {
    "flgRegimecl" : 2.3021358869347655,
    "tiporappor" : 9.965781217890562,
    "indBaseimpsc" : 7.386281948385884,
    "idmediaCg99" : 2.027123023002322,
    "perprov" : 1.1730742509559433,
    "datainman" : "2000-01-23T04:56:07.000+00:00",
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 9,
      "idknos" : 6,
      "dittaCg18" : 3.5571952270680973,
      "flgInvalid" : 6,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "indStdistenas" : 1.4894159098541704,
    "tiposoc" : 9.369310271410669,
    "indCalcscmag" : 1.2315135367772556,
    "datafineman" : "2000-01-23T04:56:07.000+00:00",
    "indTipoliq" : 7.457744773683766,
    "anagenCg16" : 0,
    "generalMasterDataCO" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 3,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 6.778324963048013,
      "indsoggrit" : 0.10263654006109402,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 0.4182561061793122,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 8,
        "codIntercompany" : 5
      },
      "statofiscCg07" : 7.740351818741173,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 6,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 3,
      "citta" : "citta",
      "statonascitaCg07" : 3.0205796992916243,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 7.143538047012306,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.519180951018382,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 5.312489704336296,
        "flgRegagevo" : 9.897492629215506,
        "idmediaCg99" : 3.1497903714250555,
        "percRipPerc" : 2.7977867356748476,
        "flgRitImposta" : 5.877124706116695,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 3.7814124730767915,
        "flgProteo360" : 3.111202833403195,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 8.37823741034869,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 0,
        "idprov" : 2.380090174313445,
        "codice" : "codice",
        "percci" : 0.35262192099236644,
        "flgSosprit" : 7,
        "descr" : "descr",
        "flgMinimi" : 7,
        "codTributo" : "codTributo",
        "indCodattglad" : 3.804112695731078,
        "indTipocassa" : 8,
        "percra" : 7.203794749804894,
        "percbaseimp" : 0.4833312865174044,
        "codTribrp" : "codTribrp",
        "inpsivs" : 4.518309517874243,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 5.944895607614016,
      "codiceCgc0" : 6.878052220127876,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 0.8851374739011653,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 3.353193347011243,
      "rapazestCg16" : 4,
      "cellnum" : "cellnum",
      "flgPrsfis" : 7.058770351582356,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 7,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 8.969578798196912,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 1,
      "indweb" : "indweb"
    },
    "flgAdeguamscmag" : 5.962133916683182,
    "tipomand" : 5.025004791520295,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgAdegdelta" : 1.4658129805029452,
    "idcapoareaMg17" : 9,
    "idExtendedAttributeEntity" : 6,
    "agente" : "agente",
    "idcapozonaMg17" : 3,
    "flgRegimeart" : 5.637376656633329,
    "idExtendedAttributeSubEntity" : 8,
    "regimeprov" : 4.965218492984954,
    "datainrapp" : "2000-01-23T04:56:07.000+00:00",
    "extensionData" : [ null, null ],
    "idagente" : 7,
    "indBaseimpmag" : 4.145608029883936,
    "dittaCg18" : 6.027456183070403,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indPrefstdoc" : 1.0246457001441578,
    "indTipoage" : 6.84685269835264
  },
  "flgIntercompany" : 2.027123023002322,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "contoCg24" : "contoCg24",
  "csJointlyHeldCO" : [ {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  }, {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  } ],
  "tipocf" : 1.1730742509559433,
  "csInfoCO" : {
    "macroAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 8.863729185622827,
      "idprov" : 9,
      "tipocf" : 1.8268702177058116,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "cliforCg44" : 8.969578798196912,
    "flgSpbol" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 5.507386964179881,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 6,
      "idmediaCg99" : 4.86315908102884,
      "tipocf" : 8.251625748923757,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "macroarea" : "macroarea",
    "irs1099" : "irs1099",
    "macrocat" : "macrocat",
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 1.7325933120207193,
      "idprov" : 6,
      "idmediaCg99" : 8.28965939814297,
      "tipocf" : 4.573936264232251,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "zona" : "zona",
    "raggcrf3" : "raggcrf3",
    "flgSpeinc" : 4.258773108174356,
    "taxareaNv01" : "taxareaNv01",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "bacsaccountno" : 4,
    "area" : "area",
    "indClibloc" : 7.260521264802104,
    "flgTaxliable" : 1,
    "codLivbloc" : "codLivbloc",
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 0.5199002018724985,
    "codRifalf" : "codRifalf",
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 3.502657762086401,
      "tipocf" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.027456183070403,
      "descrcat" : "descrcat",
      "dittaCg18" : 0.8008281904610115,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indSpesecum" : 9.702963800023566,
    "indGesfido" : 9.132027271330688,
    "codIclfatt" : 7.740351818741173,
    "dittaCg18" : 3.0576100241049344,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "finchargerterms" : "finchargerterms",
    "typeofsupply" : "typeofsupply",
    "codRifnum" : 3.0205796992916243,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.8008281904610115,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 6,
      "tipocfMg07" : 1.4658129805029452,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 7.933506881737151,
    "fidofactoring" : 5.533258397034986,
    "idmediaCg99" : 4.678947989005849,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "regimeiva" : "regimeiva",
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.459605034958679,
      "idprov" : 0,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 3.901545264248647,
      "tipocf" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "linguaMg52" : "linguaMg52",
    "notebloc" : "notebloc",
    "categ" : "categ",
    "codRischioMg2a" : "codRischioMg2a",
    "fidoaziendale" : 7.04836565559697,
    "fidolivello1" : 3.2588565619047607,
    "indrottcig" : 0.8774076871421566,
    "sottocat" : "sottocat",
    "fidolivello2" : 4.078845849666752,
    "zoneCO" : {
      "areaMg08" : "areaMg08",
      "macroareaMg08" : "macroareaMg08",
      "dittaCg18" : 5.962133916683182,
      "idprov" : 5,
      "descrzona" : "descrzona",
      "tipocfMg08" : 2.3021358869347655,
      "pluginData" : {
        "key" : ""
      },
      "codiceZona" : "codiceZona",
      "additionalData" : {
        "key" : ""
      }
    },
    "reminderterms" : "reminderterms",
    "raggrcf2" : "raggrcf2",
    "flgEstrpayline" : 0.2025324113236393,
    "raggrcf1" : "raggrcf1",
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 0.4182561061793122,
      "dittaCg18" : 8.761432466225475,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "areanielsenMg0e" : "areanielsenMg0e"
  },
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Retrieve a new code for the payment bracket for the customer
 * Retrieve a new code for the payment bracket for the customer
 *
 * id Integer 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns GetNewCodScaglCSPaymentRangeResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPOST = function(id,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "codScagl" : 0.8008281904610115,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdPATCH = function(body,ignoreCompanyPolicyFilter,force,_op,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body CustomerSupplierCODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierCODTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 4,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 4
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "codCabCg13" : 5.637376656633329,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 3,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 6.778324963048013,
    "indsoggrit" : 0.10263654006109402,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 0.4182561061793122,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 8,
      "codIntercompany" : 5
    },
    "statofiscCg07" : 7.740351818741173,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 6,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 3,
    "citta" : "citta",
    "statonascitaCg07" : 3.0205796992916243,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 7.143538047012306,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.519180951018382,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 5.312489704336296,
      "flgRegagevo" : 9.897492629215506,
      "idmediaCg99" : 3.1497903714250555,
      "percRipPerc" : 2.7977867356748476,
      "flgRitImposta" : 5.877124706116695,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 3.7814124730767915,
      "flgProteo360" : 3.111202833403195,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 8.37823741034869,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 0,
      "idprov" : 2.380090174313445,
      "codice" : "codice",
      "percci" : 0.35262192099236644,
      "flgSosprit" : 7,
      "descr" : "descr",
      "flgMinimi" : 7,
      "codTributo" : "codTributo",
      "indCodattglad" : 3.804112695731078,
      "indTipocassa" : 8,
      "percra" : 7.203794749804894,
      "percbaseimp" : 0.4833312865174044,
      "codTribrp" : "codTribrp",
      "inpsivs" : 4.518309517874243,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 5.944895607614016,
    "codiceCgc0" : 6.878052220127876,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 0.8851374739011653,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 3.353193347011243,
    "rapazestCg16" : 4,
    "cellnum" : "cellnum",
    "flgPrsfis" : 7.058770351582356,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 7,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 8.969578798196912,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 1,
    "indweb" : "indweb"
  },
  "flgAttivo" : 9.301444243932576,
  "gmdUpdateAdditionalParams" : {
    "codFiscale" : "codFiscale",
    "tel1Num" : "tel1Num",
    "codice" : 0,
    "indirizzo" : "indirizzo",
    "codiceCg07" : 6.027456183070403,
    "ragSoAnag" : "ragSoAnag",
    "tipologia" : "tipologia",
    "numCiv" : "numCiv",
    "cap" : "cap",
    "nationIso" : "nationIso",
    "descrCg07" : "descrCg07",
    "fax" : "fax",
    "prov" : "prov",
    "partiva" : "partiva",
    "codLegCg01" : "codLegCg01",
    "citta" : "citta"
  },
  "csCompanyBankCO" : [ {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  }, {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  } ],
  "intermedioCg40" : 6.84685269835264,
  "csBankCO" : [ {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  }, {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  } ],
  "customerSupplierCIGCUPCO" : [ {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  }, {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  } ],
  "pluginData" : {
    "key" : ""
  },
  "flgArt62" : 7,
  "additionalData" : {
    "key" : ""
  },
  "idExtendedAttributeEntity" : 4,
  "csPaymentRangeCO" : [ {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  }, {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  } ],
  "flgCointestati" : 3.616076749251911,
  "contorCg24" : "contorCg24",
  "extensionData" : [ null, null ],
  "progREf08" : 7.457744773683766,
  "dittaCg18" : 2.3021358869347655,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "clifor" : 1.4658129805029452,
  "custSupplDataInvoicePACO" : {
    "flgAsw" : 2,
    "indTypeb2b" : 5,
    "tipocfCg44" : 5.412786966532157,
    "codiceCg16" : 9,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "emailcortesia" : "emailcortesia"
  },
  "officePACO" : [ {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  }, {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  } ],
  "idmediaCg99" : 1.0246457001441578,
  "codiceCg28" : "codiceCg28",
  "csSddCO" : [ {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  }, {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  } ],
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 9,
    "idknos" : 6,
    "dittaCg18" : 3.5571952270680973,
    "flgInvalid" : 6,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 8.036294790673514,
    "codice" : 8.546645780823726,
    "indDimcentrocomm" : 8.310924482277276,
    "cap" : "cap",
    "dittaCg18" : 4.784107115651097,
    "progRea" : 6.607129449620165,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "indElenchimov3000" : 1,
  "codAbiCg12" : 5.962133916683182,
  "idclifor" : 1,
  "csAccountingIndexCO" : {
    "descr" : "descr",
    "codCat" : "codCat",
    "dittaCg18" : 0.8008281904610115,
    "tipocfCg44" : 6.027456183070403,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "ggscadfix" : 4.145608029883936,
  "idExtendedAttributeSubEntity" : 5,
  "csPostponementPeriodCO" : [ {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  }, {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  } ],
  "gruppoCg10" : 7.386281948385884,
  "vatCodeCO" : {
    "flgSospimp" : 2.8841621266687802,
    "indNatura" : 6,
    "flgAgri" : 7.457744773683766,
    "tipologia" : 8.969578798196912,
    "percindet" : 6.519180951018382,
    "mossperc" : 0.8851374739011653,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 7,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 5,
    "perciva" : 0.10263654006109402,
    "percforf" : 7.058770351582356,
    "codice" : "codice",
    "impostamonofasersm" : 6.878052220127876,
    "codiceOss" : "codiceOss",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 5.025004791520295,
    "flgIndet" : 8.762042012749001,
    "codPlafond" : 6.84685269835264,
    "note" : "note",
    "flgAssport398" : 4.965218492984954,
    "flgMossrid" : 6,
    "indStaper" : 3.353193347011243,
    "flgAllclifor" : 1.1730742509559433,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 6,
    "flgCorrVent" : 9.965781217890562,
    "aliqivavent" : 1.4894159098541704,
    "flgNotvar" : 1.284659006116532,
    "percmonofasersm" : 4.652396432933246,
    "idprov" : 6.778324963048013,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 7,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 6.438423552598547,
    "mosscodCg07" : 7.143538047012306,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 9.369310271410669,
    "flgIvaedit" : 9.018348186070783,
    "indtipopart" : 3.0937452626664474
  },
  "agentCO" : {
    "flgRegimecl" : 2.3021358869347655,
    "tiporappor" : 9.965781217890562,
    "indBaseimpsc" : 7.386281948385884,
    "idmediaCg99" : 2.027123023002322,
    "perprov" : 1.1730742509559433,
    "datainman" : "2000-01-23T04:56:07.000+00:00",
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 9,
      "idknos" : 6,
      "dittaCg18" : 3.5571952270680973,
      "flgInvalid" : 6,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "indStdistenas" : 1.4894159098541704,
    "tiposoc" : 9.369310271410669,
    "indCalcscmag" : 1.2315135367772556,
    "datafineman" : "2000-01-23T04:56:07.000+00:00",
    "indTipoliq" : 7.457744773683766,
    "anagenCg16" : 0,
    "generalMasterDataCO" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 3,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 6.778324963048013,
      "indsoggrit" : 0.10263654006109402,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 0.4182561061793122,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 8,
        "codIntercompany" : 5
      },
      "statofiscCg07" : 7.740351818741173,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 6,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 3,
      "citta" : "citta",
      "statonascitaCg07" : 3.0205796992916243,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 7.143538047012306,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.519180951018382,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 5.312489704336296,
        "flgRegagevo" : 9.897492629215506,
        "idmediaCg99" : 3.1497903714250555,
        "percRipPerc" : 2.7977867356748476,
        "flgRitImposta" : 5.877124706116695,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 3.7814124730767915,
        "flgProteo360" : 3.111202833403195,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 8.37823741034869,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 0,
        "idprov" : 2.380090174313445,
        "codice" : "codice",
        "percci" : 0.35262192099236644,
        "flgSosprit" : 7,
        "descr" : "descr",
        "flgMinimi" : 7,
        "codTributo" : "codTributo",
        "indCodattglad" : 3.804112695731078,
        "indTipocassa" : 8,
        "percra" : 7.203794749804894,
        "percbaseimp" : 0.4833312865174044,
        "codTribrp" : "codTribrp",
        "inpsivs" : 4.518309517874243,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 5.944895607614016,
      "codiceCgc0" : 6.878052220127876,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 0.8851374739011653,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 3.353193347011243,
      "rapazestCg16" : 4,
      "cellnum" : "cellnum",
      "flgPrsfis" : 7.058770351582356,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 7,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 8.969578798196912,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 1,
      "indweb" : "indweb"
    },
    "flgAdeguamscmag" : 5.962133916683182,
    "tipomand" : 5.025004791520295,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgAdegdelta" : 1.4658129805029452,
    "idcapoareaMg17" : 9,
    "idExtendedAttributeEntity" : 6,
    "agente" : "agente",
    "idcapozonaMg17" : 3,
    "flgRegimeart" : 5.637376656633329,
    "idExtendedAttributeSubEntity" : 8,
    "regimeprov" : 4.965218492984954,
    "datainrapp" : "2000-01-23T04:56:07.000+00:00",
    "extensionData" : [ null, null ],
    "idagente" : 7,
    "indBaseimpmag" : 4.145608029883936,
    "dittaCg18" : 6.027456183070403,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indPrefstdoc" : 1.0246457001441578,
    "indTipoage" : 6.84685269835264
  },
  "flgIntercompany" : 2.027123023002322,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "contoCg24" : "contoCg24",
  "csJointlyHeldCO" : [ {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  }, {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  } ],
  "tipocf" : 1.1730742509559433,
  "csInfoCO" : {
    "macroAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 8.863729185622827,
      "idprov" : 9,
      "tipocf" : 1.8268702177058116,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "cliforCg44" : 8.969578798196912,
    "flgSpbol" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 5.507386964179881,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 6,
      "idmediaCg99" : 4.86315908102884,
      "tipocf" : 8.251625748923757,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "macroarea" : "macroarea",
    "irs1099" : "irs1099",
    "macrocat" : "macrocat",
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 1.7325933120207193,
      "idprov" : 6,
      "idmediaCg99" : 8.28965939814297,
      "tipocf" : 4.573936264232251,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "zona" : "zona",
    "raggcrf3" : "raggcrf3",
    "flgSpeinc" : 4.258773108174356,
    "taxareaNv01" : "taxareaNv01",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "bacsaccountno" : 4,
    "area" : "area",
    "indClibloc" : 7.260521264802104,
    "flgTaxliable" : 1,
    "codLivbloc" : "codLivbloc",
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 0.5199002018724985,
    "codRifalf" : "codRifalf",
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 3.502657762086401,
      "tipocf" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.027456183070403,
      "descrcat" : "descrcat",
      "dittaCg18" : 0.8008281904610115,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indSpesecum" : 9.702963800023566,
    "indGesfido" : 9.132027271330688,
    "codIclfatt" : 7.740351818741173,
    "dittaCg18" : 3.0576100241049344,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "finchargerterms" : "finchargerterms",
    "typeofsupply" : "typeofsupply",
    "codRifnum" : 3.0205796992916243,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.8008281904610115,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 6,
      "tipocfMg07" : 1.4658129805029452,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 7.933506881737151,
    "fidofactoring" : 5.533258397034986,
    "idmediaCg99" : 4.678947989005849,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "regimeiva" : "regimeiva",
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.459605034958679,
      "idprov" : 0,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 3.901545264248647,
      "tipocf" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "linguaMg52" : "linguaMg52",
    "notebloc" : "notebloc",
    "categ" : "categ",
    "codRischioMg2a" : "codRischioMg2a",
    "fidoaziendale" : 7.04836565559697,
    "fidolivello1" : 3.2588565619047607,
    "indrottcig" : 0.8774076871421566,
    "sottocat" : "sottocat",
    "fidolivello2" : 4.078845849666752,
    "zoneCO" : {
      "areaMg08" : "areaMg08",
      "macroareaMg08" : "macroareaMg08",
      "dittaCg18" : 5.962133916683182,
      "idprov" : 5,
      "descrzona" : "descrzona",
      "tipocfMg08" : 2.3021358869347655,
      "pluginData" : {
        "key" : ""
      },
      "codiceZona" : "codiceZona",
      "additionalData" : {
        "key" : ""
      }
    },
    "reminderterms" : "reminderterms",
    "raggrcf2" : "raggrcf2",
    "flgEstrpayline" : 0.2025324113236393,
    "raggrcf1" : "raggrcf1",
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 0.4182561061793122,
      "dittaCg18" : 8.761432466225475,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "areanielsenMg0e" : "areanielsenMg0e"
  },
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Insert letters
 * Insert letters
 *
 * body SendingLettersToInsertParametersCODTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns SendingLetterResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "opResult" : true,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body CustomerSupplierCODTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierCODTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOPOST = function(body,ignoreCompanyPolicyFilter,_op,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 4,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 4
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "codCabCg13" : 5.637376656633329,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 7,
        "idCG1J" : 4,
        "pluginData" : {
          "key" : ""
        },
        "id" : 1,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 4,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 0.2025324113236393,
      "statoCg07" : 4.258773108174356,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 9.132027271330688,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 5,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.628464275087742,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 3,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 6.778324963048013,
    "indsoggrit" : 0.10263654006109402,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 0.4182561061793122,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 8,
      "codIntercompany" : 5
    },
    "statofiscCg07" : 7.740351818741173,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 6,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 3,
    "citta" : "citta",
    "statonascitaCg07" : 3.0205796992916243,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 7.143538047012306,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.519180951018382,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 5.312489704336296,
      "flgRegagevo" : 9.897492629215506,
      "idmediaCg99" : 3.1497903714250555,
      "percRipPerc" : 2.7977867356748476,
      "flgRitImposta" : 5.877124706116695,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 3.7814124730767915,
      "flgProteo360" : 3.111202833403195,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 8.37823741034869,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 0,
      "idprov" : 2.380090174313445,
      "codice" : "codice",
      "percci" : 0.35262192099236644,
      "flgSosprit" : 7,
      "descr" : "descr",
      "flgMinimi" : 7,
      "codTributo" : "codTributo",
      "indCodattglad" : 3.804112695731078,
      "indTipocassa" : 8,
      "percra" : 7.203794749804894,
      "percbaseimp" : 0.4833312865174044,
      "codTribrp" : "codTribrp",
      "inpsivs" : 4.518309517874243,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 5.944895607614016,
    "codiceCgc0" : 6.878052220127876,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 0.8851374739011653,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 3.353193347011243,
    "rapazestCg16" : 4,
    "cellnum" : "cellnum",
    "flgPrsfis" : 7.058770351582356,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 7,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 8.969578798196912,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 1,
    "indweb" : "indweb"
  },
  "flgAttivo" : 9.301444243932576,
  "gmdUpdateAdditionalParams" : {
    "codFiscale" : "codFiscale",
    "tel1Num" : "tel1Num",
    "codice" : 0,
    "indirizzo" : "indirizzo",
    "codiceCg07" : 6.027456183070403,
    "ragSoAnag" : "ragSoAnag",
    "tipologia" : "tipologia",
    "numCiv" : "numCiv",
    "cap" : "cap",
    "nationIso" : "nationIso",
    "descrCg07" : "descrCg07",
    "fax" : "fax",
    "prov" : "prov",
    "partiva" : "partiva",
    "codLegCg01" : "codLegCg01",
    "citta" : "citta"
  },
  "csCompanyBankCO" : [ {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  }, {
    "progREf08" : 6.519180951018382,
    "cliforCg44" : 3.353193347011243,
    "dittaCg18" : 3.0937452626664474,
    "tipocfCg44" : 0.10263654006109402,
    "progR" : 7,
    "companyBankCO" : {
      "ggvalmavincpos" : 2.8841621266687802,
      "spinccambfil" : 6.073898085781152,
      "spcommordpfil" : 5.507386964179881,
      "codSia" : "codSia",
      "bancaCg12" : 6.027456183070403,
      "spritrid" : 9.897492629215506,
      "codiceCg07" : 9.301444243932576,
      "flgRidsdd" : 9.369310271410669,
      "spincribaalt" : 6.623518433804886,
      "flgCessioni" : 1.2315135367772556,
      "spritmavincas" : 5.299143560275359,
      "spcommbonalt" : 9.702963800023566,
      "flgRibatratac" : 5.025004791520295,
      "bicbanca" : "bicbanca",
      "nationCO" : {
        "codSian" : 9.702963800023566,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 5.507386964179881,
        "codice" : 0.8774076871421566,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 8.28965939814297,
          "exchangeRateCO" : [ {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          }, {
            "cambio" : 8.863729185622827,
            "anno" : 4.573936264232251,
            "idmediaCg99" : 1.8268702177058116,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 3,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 9.254183946267839,
            "mese" : 9.183123594773994,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 6.623518433804886,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 3.901545264248647,
          "codice" : "codice",
          "indCertoincerto" : 0,
          "cambiofisso" : 8.251625748923757,
          "descr" : "descr",
          "flgValuem" : 4.459605034958679,
          "indValuem" : 1.7325933120207193,
          "indSepmigl" : 2.9409642974827896,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 0,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 4.86315908102884,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "ggvalscfattfil" : 7.143538047012306,
      "id" : 6,
      "idbancaestera" : "idbancaestera",
      "cabbonifCg13" : 1.4658129805029452,
      "spincridalt" : 8.863729185622827,
      "spincmavincpos" : 1.7325933120207193,
      "cabridCg13" : 7.061401241503109,
      "dittaCg18" : 2.027123023002322,
      "idsuccursale" : 4.652396432933246,
      "spinctrafil" : 3.502657762086401,
      "scfindbasecalc" : 7.260521264802104,
      "indPresriba" : 3.2588565619047607,
      "codAzienda" : "codAzienda",
      "bbaneffpresef" : "bbaneffpresef",
      "flgRibatratte" : 9.965781217890562,
      "indPresrid" : 4.078845849666752,
      "spincridfil" : 9.254183946267839,
      "scfperctasso" : 0.8774076871421566,
      "ibaneffpresef" : "ibaneffpresef",
      "ggvalridfil" : 3.353193347011243,
      "ggvalcambfil" : 3.5571952270680973,
      "flgRibacamb" : 7.457744773683766,
      "ggvalribaalt" : 6.878052220127876,
      "idcontratto" : "idcontratto",
      "ggvalmavincfil" : 1.284659006116532,
      "bbananticipi" : "bbananticipi",
      "indTipolib" : 0.2025324113236393,
      "spcommordpalt" : 7.933506881737151,
      "scfvsdocrif" : "scfvsdocrif",
      "spritmavsbf" : 8.37823741034869,
      "progR" : 4.678947989005849,
      "sprittratte" : 7.835035282970782,
      "flgCambiali" : 7.386281948385884,
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "flgRiba" : 6.84685269835264,
      "spincesitopag" : 3.901545264248647,
      "cabmavCg13" : 5.637376656633329,
      "flgMav" : 1.0246457001441578,
      "sppresdistinta" : 9.183123594773994,
      "cceffpresef" : "cceffpresef",
      "scfnsdocrif" : "scfnsdocrif",
      "spincmavincfil" : 2.9409642974827896,
      "ggvaltratfil" : 7.058770351582356,
      "bbanordpbonif" : "bbanordpbonif",
      "ccconto" : "ccconto",
      "ibanordpbonif" : "ibanordpbonif",
      "daprogressmav" : 3.616076749251911,
      "flgRibacess" : 1.1730742509559433,
      "ibananticipi" : "ibananticipi",
      "impfido" : 7.740351818741173,
      "flgTratte" : 9.018348186070783,
      "spritcamb" : 8.761432466225475,
      "spritmavsbfcl" : 7.606863723092579,
      "spritridcl" : 5.877124706116695,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "ccordpbonif" : "ccordpbonif",
      "spinccorfil" : 4.459605034958679,
      "ccanticipi" : "ccanticipi",
      "flgScfatt" : 8.762042012749001,
      "locbancaestera" : "locbancaestera",
      "ultprogressmav" : 2.380090174313445,
      "spincribafil" : 4.573936264232251,
      "creditidentifier" : "creditidentifier",
      "descr" : "descr",
      "spcommbonfil" : 0.5199002018724985,
      "indTipopres" : 6.628464275087742,
      "indCheckpivacf" : 3,
      "ggvalribafil" : 5.944895607614016,
      "ggvalmavincalt" : 6.965117697638846,
      "spritribacl" : 3.111202833403195,
      "spincmavsbf" : 8.28965939814297,
      "rowversion" : "",
      "flgAutattribnrmav" : 4,
      "flgRibaricba" : 4.965218492984954,
      "spritcambcl" : 0.4182561061793122,
      "spritmavincascl" : 5.312489704336296,
      "idmediaCg99" : 0.10263654006109402,
      "ggvalmavsbf" : 6.778324963048013,
      "indCompind" : 3,
      "bbanconto" : "bbanconto",
      "sprittrattecl" : 0.4768402382624515,
      "prefissoattribmav" : 1.041444916118296,
      "aprogressmav" : 0.8008281904610115,
      "codRappopor" : "codRappopor",
      "spincmavincalt" : 0.43431398824148815,
      "spinctraalt" : 1.8268702177058116,
      "ggvaltratalt" : 0.8851374739011653,
      "impcastel" : 8.969578798196912,
      "spritriba" : 3.7814124730767915,
      "scfpercpres" : 9.132027271330688,
      "spinccambalt" : 4.86315908102884,
      "codicecuc" : "codicecuc",
      "ibanconto" : "ibanconto",
      "indContpmtinf" : 7,
      "tipobanca" : 3.1497903714250555,
      "indPresmav" : 5.533258397034986,
      "ggvalridalt" : 6.704019297950036,
      "cabcontoCg13" : 5.962133916683182,
      "ggvalcambalt" : 6.438423552598547,
      "maxgginsoluti" : 4.258773108174356,
      "flgRidsddraggr" : 6,
      "ggvalscfattalt" : 3.0937452626664474,
      "flgPref" : 1.4894159098541704,
      "cabribaCg13" : 2.3021358869347655,
      "spinccoralt" : 8.251625748923757
    },
    "pluginData" : {
      "key" : ""
    },
    "id" : 0,
    "additionalData" : {
      "key" : ""
    },
    "flgPref" : 7,
    "rowversion" : ""
  } ],
  "intermedioCg40" : 6.84685269835264,
  "csBankCO" : [ {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  }, {
    "cliforCg44" : 8.762042012749001,
    "indTipoop" : 6.778324963048013,
    "bban" : "bban",
    "tipocfCg44" : 6.704019297950036,
    "codiceCg07" : 9.018348186070783,
    "nomebancaestera" : "nomebancaestera",
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "idcontratto" : "idcontratto",
    "pluginData" : {
      "key" : ""
    },
    "id" : 1,
    "additionalData" : {
      "key" : ""
    },
    "flgPrefIncassi" : 6,
    "idbancaestera" : "idbancaestera",
    "progR" : 6,
    "bicbancaestera" : "bicbancaestera",
    "locbancaestera" : "locbancaestera",
    "tipobanca" : 5.944895607614016,
    "ccfornfactor" : 9.965781217890562,
    "ccfornfactoridCg44" : 9,
    "ccdesagenz" : "ccdesagenz",
    "ccggval" : 6.683562403749608,
    "dittaCg18" : 6.438423552598547,
    "ccaddetto" : "ccaddetto",
    "idsuccursale" : 2.8841621266687802,
    "ccforn" : "ccforn",
    "iban" : "iban",
    "agencyCO" : {
      "localita" : "localita",
      "descrizione" : "descrizione",
      "codice" : 6.027456183070403,
      "codBanca" : 0.8008281904610115,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "bankCO" : {
        "descrizione" : "descrizione",
        "codBicswift" : "codBicswift",
        "codiceBanca" : 1.4658129805029452,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      }
    },
    "flgPref" : 3.5571952270680973
  } ],
  "customerSupplierCIGCUPCO" : [ {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  }, {
    "cliforCg44" : 2.831445253698411,
    "progRMg35" : 0,
    "idcigcupCo1h" : 8,
    "tipocfCg44" : 1.2786903972794905,
    "progREf08" : 5.829097284708605,
    "dittaCg18" : 6.345503614942988,
    "pluginData" : {
      "key" : ""
    },
    "id" : 5,
    "additionalData" : {
      "key" : ""
    },
    "cigcuPcode" : {
      "cig" : "cig",
      "docrifData" : "2000-01-23T04:56:07.000+00:00",
      "indTipodocrif" : 5,
      "indTipocontr" : 8,
      "descrizione" : "descrizione",
      "docrifId" : "docrifId",
      "flgAttivo" : 8.071139232091417,
      "pluginData" : {
        "key" : ""
      },
      "id" : 2,
      "additionalData" : {
        "key" : ""
      },
      "cup" : "cup",
      "rowversion" : ""
    },
    "rowversion" : ""
  } ],
  "pluginData" : {
    "key" : ""
  },
  "flgArt62" : 7,
  "additionalData" : {
    "key" : ""
  },
  "idExtendedAttributeEntity" : 4,
  "csPaymentRangeCO" : [ {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  }, {
    "cliforCg44" : 5.877124706116695,
    "valutaCg08" : "valutaCg08",
    "tipocfCg44" : 4.518309517874243,
    "idmediaCg99" : 3.804112695731078,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "aimpdoc" : 9.897492629215506,
    "paymentTermCO" : {
      "flgDesc" : 0.4833312865174044,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      }, {
        "indImpfix" : 2.9805393113464476,
        "daggfix1" : 5.6644160867523485,
        "daggfix2" : 1.5970080735609526,
        "ggmmfix" : 7.3718573971919445,
        "ggdecor" : 9.785002165136461,
        "idCg64" : 4,
        "imporfix" : 3.209082285545927,
        "flgFrperciva" : 3.2841216543560217,
        "idCg62" : 1,
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 3.8008573585058016,
        "indTipocalend" : 9,
        "indTipodecor" : 4.010300976654761,
        "aggfix2" : 3.812761638325517,
        "aggfix1" : 1.2555055362323109,
        "perciva" : 6.458262756685686,
        "el2frimp" : 5.974942028545841,
        "ggscadfix2" : 7.92839742024475,
        "tipoeff" : 8.910869026866926,
        "flgFrpercimp" : 1.0639121808530916,
        "percimp" : 8.276461147928103,
        "prog" : 4.141296055235948,
        "el1frimp" : 4.372688051310086,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 7.726998920545485,
        "subTypeCO" : {
          "ggoffset" : 2.9679475177256287,
          "codiceCg07" : 2.058822123984536,
          "tipoeff" : 7.3842318535314,
          "codPaguc" : "codPaguc",
          "descstipo" : "descstipo",
          "codStipoeff" : 6.4280627569296165,
          "flgAssegno" : 0,
          "indModfatturapa" : 0,
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 6,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 5,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 5.7911894223693885,
        "indDatarif" : 8.262795412896967,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 0.35262192099236644,
      "flgPrefpass" : 4,
      "idExtendedAttributeSubEntity" : 1,
      "flgPrefatt" : 7,
      "flgStornoiva" : 2.7977867356748476,
      "descPag" : "descPag",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "scpermer2" : 6.966044574347761,
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "scpercas" : 6.173804034172511,
      "scpermer1" : 4.8789878742268815,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 2.535258963197524,
      "idExtendedAttributeEntity" : 9,
      "rowversion" : "",
      "scart26" : 0.58919091925136
    },
    "codPagCg62" : "codPagCg62",
    "codScagl" : 7.835035282970782,
    "dittaCg18" : 0.4768402382624515,
    "idCg62" : 2,
    "pluginData" : {
      "key" : ""
    },
    "id" : 3,
    "additionalData" : {
      "key" : ""
    },
    "indPagpart" : 8.675064425986758
  } ],
  "flgCointestati" : 3.616076749251911,
  "contorCg24" : "contorCg24",
  "extensionData" : [ null, null ],
  "progREf08" : 7.457744773683766,
  "dittaCg18" : 2.3021358869347655,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "clifor" : 1.4658129805029452,
  "custSupplDataInvoicePACO" : {
    "flgAsw" : 2,
    "indTypeb2b" : 5,
    "tipocfCg44" : 5.412786966532157,
    "codiceCg16" : 9,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "emailcortesia" : "emailcortesia"
  },
  "officePACO" : [ {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  }, {
    "indIrizzo" : "indIrizzo",
    "indTypeb2b" : 7,
    "tipocfCg44" : 7.135782839148426,
    "codDestin" : "codDestin",
    "codice" : "codice",
    "codiceCg16" : 7,
    "nome" : "nome",
    "idprovincia" : 2,
    "cap" : "cap",
    "comune" : "comune",
    "idregione" : 1,
    "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgPreferenziale" : 1
  } ],
  "idmediaCg99" : 1.0246457001441578,
  "codiceCg28" : "codiceCg28",
  "csSddCO" : [ {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  }, {
    "cliforCg44" : 2.026856458177285,
    "flgVariato" : 8.250639315618633,
    "tipologia" : 6.712603870693706,
    "nrrate" : 5.726375546151009,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "additionalData" : {
      "key" : ""
    },
    "dataultimascad" : "2000-01-23T04:56:07.000+00:00",
    "contocorrprec" : "contocorrprec",
    "dataprimascad" : "2000-01-23T04:56:07.000+00:00",
    "locsottoscr" : "locsottoscr",
    "tipoinclocked" : 2.684056218962324,
    "indTiposdd" : 3.5117904067536143,
    "dittaCg18" : 1.9626702727164813,
    "tipologiaprec" : 1.0046985756074744,
    "datarich" : "2000-01-23T04:56:07.000+00:00",
    "flgAllineam" : 5.573385265048522,
    "indIrsottoscr" : "indIrsottoscr",
    "codClidebprec" : "codClidebprec",
    "ridabi" : 7.464202015255506,
    "tipocfCg44" : 8.768153453040833,
    "codAutoriz" : "codAutoriz",
    "idmediaCg99" : 2.4669941706755685,
    "ridibanprec" : "ridibanprec",
    "codRif" : "codRif",
    "indStornoprec" : 2.5524281586707875,
    "datarisp" : "2000-01-23T04:56:07.000+00:00",
    "causrisp" : 4.1661834558007,
    "codBicswift" : "codBicswift",
    "ridcabprec" : 6.642953999458534,
    "diniego" : 3,
    "impmaxrata" : 8.782449469456207,
    "indTipoinc" : 4,
    "causrich" : 2.0981949483881577,
    "cfiscsottoscr" : "cfiscsottoscr",
    "datamandato" : "2000-01-23T04:56:07.000+00:00",
    "progR" : 2,
    "ridcab" : 6.370609851066415,
    "contocorr" : "contocorr",
    "flgDisattivato" : 3,
    "codIndiv" : 3.196820582978078,
    "descrizione" : "descrizione",
    "bancaallineam" : 6.176386745020588,
    "soggtitibanCg16" : 9,
    "csHistorySddCO" : [ {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    }, {
      "tipologia" : 8.238101405568635,
      "codIndiv" : 3.7846852362095262,
      "codBicswift" : "codBicswift",
      "indTiposdd" : 2.008994665592807,
      "soggtitibanCg16" : 2,
      "ridiban" : "ridiban",
      "datavar" : "2000-01-23T04:56:07.000+00:00",
      "indTipoinc" : 4,
      "codClideb" : "codClideb",
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "indStorno" : 1.5743672347582194
    } ],
    "ridabiprec" : 7.129168897240568,
    "codIndivprec" : 5.296102445648278,
    "nuovabanca" : 9.721046668148785,
    "ridiban" : "ridiban",
    "codClideb" : "codClideb",
    "ragsosottoscr" : "ragsosottoscr",
    "indStorno" : 0.4008378390304357
  } ],
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 9,
    "idknos" : 6,
    "dittaCg18" : 3.5571952270680973,
    "flgInvalid" : 6,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 8.036294790673514,
    "codice" : 8.546645780823726,
    "indDimcentrocomm" : 8.310924482277276,
    "cap" : "cap",
    "dittaCg18" : 4.784107115651097,
    "progRea" : 6.607129449620165,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "indElenchimov3000" : 1,
  "codAbiCg12" : 5.962133916683182,
  "idclifor" : 1,
  "csAccountingIndexCO" : {
    "descr" : "descr",
    "codCat" : "codCat",
    "dittaCg18" : 0.8008281904610115,
    "tipocfCg44" : 6.027456183070403,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "ggscadfix" : 4.145608029883936,
  "idExtendedAttributeSubEntity" : 5,
  "csPostponementPeriodCO" : [ {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  }, {
    "cliforCg44" : 0.30134145536422907,
    "tipocfCg44" : 7.390706075830692,
    "idmediaCg99" : 0.11859130807119977,
    "ammgg" : 4.943637496515336,
    "indAppggfix" : 4,
    "tipoeff" : 1.0502890910539986,
    "indTiposlit" : 0.36062689002149373,
    "dammgg" : 0.4867146239815201,
    "ggmmfixslit" : 9.721723570087065,
    "dittaCg18" : 9.456612101333725,
    "pluginData" : {
      "key" : ""
    },
    "ggslsucc" : 7.88722683998926,
    "id" : 6,
    "additionalData" : {
      "key" : ""
    }
  } ],
  "gruppoCg10" : 7.386281948385884,
  "vatCodeCO" : {
    "flgSospimp" : 2.8841621266687802,
    "indNatura" : 6,
    "flgAgri" : 7.457744773683766,
    "tipologia" : 8.969578798196912,
    "percindet" : 6.519180951018382,
    "mossperc" : 0.8851374739011653,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "nationCO" : {
      "codSian" : 9.702963800023566,
      "crtpiva" : "crtpiva",
      "leniban" : 6,
      "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
      "desiso3166" : "desiso3166",
      "idmediaCg99" : 5.507386964179881,
      "codice" : 0.8774076871421566,
      "numiso3166" : "numiso3166",
      "codiceCg08" : "codiceCg08",
      "currencyCO" : {
        "sigla" : "sigla",
        "dataattuem" : "2000-01-23T04:56:07.000+00:00",
        "numdec" : 8.28965939814297,
        "exchangeRateCO" : [ {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        }, {
          "cambio" : 8.863729185622827,
          "anno" : 4.573936264232251,
          "idmediaCg99" : 1.8268702177058116,
          "codiceCg08" : "codiceCg08",
          "indCertoincerto" : 3,
          "codicerifCg08" : "codicerifCg08",
          "giorno" : 9.254183946267839,
          "mese" : 9.183123594773994,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "adegcambio" : 6.623518433804886,
          "rowversion" : ""
        } ],
        "idmediaCg99" : 3.901545264248647,
        "codice" : "codice",
        "indCertoincerto" : 0,
        "cambiofisso" : 8.251625748923757,
        "descr" : "descr",
        "flgValuem" : 4.459605034958679,
        "indValuem" : 1.7325933120207193,
        "indSepmigl" : 2.9409642974827896,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        }
      },
      "descr" : "descr",
      "flgIban" : 0,
      "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
      "codIso" : "codIso",
      "a3iso3166" : "a3iso3166",
      "indTipostato" : 4.86315908102884,
      "a2iso3166" : "a2iso3166",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "datacee" : "2000-01-23T04:56:07.000+00:00",
      "flgSepa" : 7
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 7,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 5,
    "perciva" : 0.10263654006109402,
    "percforf" : 7.058770351582356,
    "codice" : "codice",
    "impostamonofasersm" : 6.878052220127876,
    "codiceOss" : "codiceOss",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 3,
    "flgAutoue" : 5.025004791520295,
    "flgIndet" : 8.762042012749001,
    "codPlafond" : 6.84685269835264,
    "note" : "note",
    "flgAssport398" : 4.965218492984954,
    "flgMossrid" : 6,
    "indStaper" : 3.353193347011243,
    "flgAllclifor" : 1.1730742509559433,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 6,
    "flgCorrVent" : 9.965781217890562,
    "aliqivavent" : 1.4894159098541704,
    "flgNotvar" : 1.284659006116532,
    "percmonofasersm" : 4.652396432933246,
    "idprov" : 6.778324963048013,
    "idExtendedAttributeSubEntity" : 3,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 7,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 6.438423552598547,
    "mosscodCg07" : 7.143538047012306,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 9.369310271410669,
    "flgIvaedit" : 9.018348186070783,
    "indtipopart" : 3.0937452626664474
  },
  "agentCO" : {
    "flgRegimecl" : 2.3021358869347655,
    "tiporappor" : 9.965781217890562,
    "indBaseimpsc" : 7.386281948385884,
    "idmediaCg99" : 2.027123023002322,
    "perprov" : 1.1730742509559433,
    "datainman" : "2000-01-23T04:56:07.000+00:00",
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 9,
      "idknos" : 6,
      "dittaCg18" : 3.5571952270680973,
      "flgInvalid" : 6,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "publicationid" : "publicationid",
      "percorso" : "percorso"
    },
    "indStdistenas" : 1.4894159098541704,
    "tiposoc" : 9.369310271410669,
    "indCalcscmag" : 1.2315135367772556,
    "datafineman" : "2000-01-23T04:56:07.000+00:00",
    "indTipoliq" : 7.457744773683766,
    "anagenCg16" : 0,
    "generalMasterDataCO" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        }, {
          "tipo" : 7,
          "idCG1J" : 4,
          "pluginData" : {
            "key" : ""
          },
          "id" : 1,
          "additionalData" : {
            "key" : ""
          }
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 4,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 0.2025324113236393,
        "statoCg07" : 4.258773108174356,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 9.132027271330688,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed"
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 3,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 5,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 9.702963800023566,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 5.507386964179881,
          "codice" : 0.8774076871421566,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 8.28965939814297,
            "exchangeRateCO" : [ {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            }, {
              "cambio" : 8.863729185622827,
              "anno" : 4.573936264232251,
              "idmediaCg99" : 1.8268702177058116,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 3,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 9.254183946267839,
              "mese" : 9.183123594773994,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 6.623518433804886,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 3.901545264248647,
            "codice" : "codice",
            "indCertoincerto" : 0,
            "cambiofisso" : 8.251625748923757,
            "descr" : "descr",
            "flgValuem" : 4.459605034958679,
            "indValuem" : 1.7325933120207193,
            "indSepmigl" : 2.9409642974827896,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 0,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 4.86315908102884,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.628464275087742,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 3,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 6.778324963048013,
      "indsoggrit" : 0.10263654006109402,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 0.4182561061793122,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 8,
        "codIntercompany" : 5
      },
      "statofiscCg07" : 7.740351818741173,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 6,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 3,
      "citta" : "citta",
      "statonascitaCg07" : 3.0205796992916243,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ {
        "value" : "",
        "key" : "key"
      }, {
        "value" : "",
        "key" : "key"
      } ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 7.143538047012306,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.519180951018382,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 5.312489704336296,
        "flgRegagevo" : 9.897492629215506,
        "idmediaCg99" : 3.1497903714250555,
        "percRipPerc" : 2.7977867356748476,
        "flgRitImposta" : 5.877124706116695,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 3.7814124730767915,
        "flgProteo360" : 3.111202833403195,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 8.37823741034869,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 0,
        "idprov" : 2.380090174313445,
        "codice" : "codice",
        "percci" : 0.35262192099236644,
        "flgSosprit" : 7,
        "descr" : "descr",
        "flgMinimi" : 7,
        "codTributo" : "codTributo",
        "indCodattglad" : 3.804112695731078,
        "indTipocassa" : 8,
        "percra" : 7.203794749804894,
        "percbaseimp" : 0.4833312865174044,
        "codTribrp" : "codTribrp",
        "inpsivs" : 4.518309517874243,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 5.944895607614016,
      "codiceCgc0" : 6.878052220127876,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 0.8851374739011653,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 3.353193347011243,
      "rapazestCg16" : 4,
      "cellnum" : "cellnum",
      "flgPrsfis" : 7.058770351582356,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 7,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 8.969578798196912,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 1,
      "indweb" : "indweb"
    },
    "flgAdeguamscmag" : 5.962133916683182,
    "tipomand" : 5.025004791520295,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "flgAdegdelta" : 1.4658129805029452,
    "idcapoareaMg17" : 9,
    "idExtendedAttributeEntity" : 6,
    "agente" : "agente",
    "idcapozonaMg17" : 3,
    "flgRegimeart" : 5.637376656633329,
    "idExtendedAttributeSubEntity" : 8,
    "regimeprov" : 4.965218492984954,
    "datainrapp" : "2000-01-23T04:56:07.000+00:00",
    "extensionData" : [ null, null ],
    "idagente" : 7,
    "indBaseimpmag" : 4.145608029883936,
    "dittaCg18" : 6.027456183070403,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indPrefstdoc" : 1.0246457001441578,
    "indTipoage" : 6.84685269835264
  },
  "flgIntercompany" : 2.027123023002322,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "contoCg24" : "contoCg24",
  "csJointlyHeldCO" : [ {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  }, {
    "cliforCg44" : 5.299143560275359,
    "percentuale" : 3.7814124730767915,
    "dittaCg18" : 8.37823741034869,
    "tipocfCg44" : 3.111202833403195,
    "idcliforcoCg44" : 7,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "cliforcoCg44" : 5.312489704336296
  } ],
  "tipocf" : 1.1730742509559433,
  "csInfoCO" : {
    "macroAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 8.863729185622827,
      "idprov" : 9,
      "tipocf" : 1.8268702177058116,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "cliforCg44" : 8.969578798196912,
    "flgSpbol" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 5.507386964179881,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 6,
      "idmediaCg99" : 4.86315908102884,
      "tipocf" : 8.251625748923757,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "macroarea" : "macroarea",
    "irs1099" : "irs1099",
    "macrocat" : "macrocat",
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 1.7325933120207193,
      "idprov" : 6,
      "idmediaCg99" : 8.28965939814297,
      "tipocf" : 4.573936264232251,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "zona" : "zona",
    "raggcrf3" : "raggcrf3",
    "flgSpeinc" : 4.258773108174356,
    "taxareaNv01" : "taxareaNv01",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "bacsaccountno" : 4,
    "area" : "area",
    "indClibloc" : 7.260521264802104,
    "flgTaxliable" : 1,
    "codLivbloc" : "codLivbloc",
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 0.5199002018724985,
    "codRifalf" : "codRifalf",
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 3.502657762086401,
      "tipocf" : 9.183123594773994,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.027456183070403,
      "descrcat" : "descrcat",
      "dittaCg18" : 0.8008281904610115,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indSpesecum" : 9.702963800023566,
    "indGesfido" : 9.132027271330688,
    "codIclfatt" : 7.740351818741173,
    "dittaCg18" : 3.0576100241049344,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "finchargerterms" : "finchargerterms",
    "typeofsupply" : "typeofsupply",
    "codRifnum" : 3.0205796992916243,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.8008281904610115,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 5.962133916683182,
        "idprov" : 5,
        "descrzona" : "descrzona",
        "tipocfMg08" : 2.3021358869347655,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 6,
      "tipocfMg07" : 1.4658129805029452,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 7.933506881737151,
    "fidofactoring" : 5.533258397034986,
    "idmediaCg99" : 4.678947989005849,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "regimeiva" : "regimeiva",
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.459605034958679,
      "idprov" : 0,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 3.901545264248647,
      "tipocf" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "linguaMg52" : "linguaMg52",
    "notebloc" : "notebloc",
    "categ" : "categ",
    "codRischioMg2a" : "codRischioMg2a",
    "fidoaziendale" : 7.04836565559697,
    "fidolivello1" : 3.2588565619047607,
    "indrottcig" : 0.8774076871421566,
    "sottocat" : "sottocat",
    "fidolivello2" : 4.078845849666752,
    "zoneCO" : {
      "areaMg08" : "areaMg08",
      "macroareaMg08" : "macroareaMg08",
      "dittaCg18" : 5.962133916683182,
      "idprov" : 5,
      "descrzona" : "descrzona",
      "tipocfMg08" : 2.3021358869347655,
      "pluginData" : {
        "key" : ""
      },
      "codiceZona" : "codiceZona",
      "additionalData" : {
        "key" : ""
      }
    },
    "reminderterms" : "reminderterms",
    "raggrcf2" : "raggrcf2",
    "flgEstrpayline" : 0.2025324113236393,
    "raggrcf1" : "raggrcf1",
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 0.4182561061793122,
      "dittaCg18" : 8.761432466225475,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "areanielsenMg0e" : "areanielsenMg0e"
  },
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update the generated letters of intent
 * Update the generated letters of intent
 *
 * body UpdateParametersCODTO Input parameters
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns UpdateParametersResultDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "opResult" : true,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  }
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CustomerSupplierCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

