'use strict';


/**
 * Instalment calculation
 * Calculation of deadlines
 *
 * body InstalmentCalculationParametersDTO Object that contains all the parameters necessary to calculate the deadlines
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns InstalmentCalculationParametersDTO
 **/
exports.apiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "isIvaSplitPayment" : true,
  "codPag" : "codPag",
  "valuta" : "valuta",
  "idCliFor" : 6,
  "importoFissoEuro" : 2.3021358869347655,
  "dataOrdine" : "2000-01-23T04:56:07.000+00:00",
  "importoFissoValuta" : 7.061401241503109,
  "art62" : true,
  "idCodPag" : 5,
  "dataBolla" : "2000-01-23T04:56:07.000+00:00",
  "idBancaAziendale" : 1,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "escludiScaglioniPagamento" : true,
  "sottotipoSpesa" : 3,
  "cambio" : 0.8008281904610115,
  "totImponibileValuta" : 7.386281948385884,
  "totNonSoggValuta" : 6.84685269835264,
  "idBancaCliFor" : 5,
  "dataDoc" : "2000-01-23T04:56:07.000+00:00",
  "totRitenuteEuro" : 7.457744773683766,
  "dataRichiesta" : "2000-01-23T04:56:07.000+00:00",
  "dataConsegna" : "2000-01-23T04:56:07.000+00:00",
  "totImponibileEuro" : 4.145608029883936,
  "modalitaImportoFisso" : 9,
  "tipoCF" : 2,
  "totIvaValuta" : 1.0246457001441578,
  "totRitenuteValuta" : 1.1730742509559433,
  "totNonSoggEuro" : 1.4894159098541704,
  "totIvaEuro" : 1.2315135367772556
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

