/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace IO.Swagger.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public interface ICarrierMGApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>CarrierMGDTO</returns>
        CarrierMGDTO ApiV1EnvironmentMGCarrierMGGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        ApiResponse<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGGetWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGCarrierMGIdDelete (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGCarrierMGIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>CarrierMGDTO</returns>
        CarrierMGDTO ApiV1EnvironmentMGCarrierMGIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        ApiResponse<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGIdGetWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGCarrierMGIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGCarrierMGIdPatchWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>CarrierMGDTO</returns>
        CarrierMGDTO ApiV1EnvironmentMGCarrierMGIdPut (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        ApiResponse<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGIdPutWithHttpInfo (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>CarrierMGDTO</returns>
        CarrierMGDTO ApiV1EnvironmentMGCarrierMGPost (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        ApiResponse<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGPostWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        void ApiV1EnvironmentMGCarrierMGValidatePost (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> ApiV1EnvironmentMGCarrierMGValidatePostWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        ValidateDTO ApiV1EnvironmentMGCarrierMGValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        ApiResponse<ValidateDTO> ApiV1EnvironmentMGCarrierMGValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGGetAsync (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get new
        /// </summary>
        /// <remarks>
        /// Get an empty object of type corresponding
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGGetAsyncWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGCarrierMGIdDeleteAsync (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Delete
        /// </summary>
        /// <remarks>
        /// Deleting object of type 
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCarrierMGIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGIdGetAsync (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);

        /// <summary>
        /// Get by ID
        /// </summary>
        /// <remarks>
        /// Get an object of type corresponding the requested id
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGIdGetAsyncWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null);
        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGCarrierMGIdPatchAsync (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update partial
        /// </summary>
        /// <remarks>
        /// Patching an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCarrierMGIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGIdPutAsync (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null);

        /// <summary>
        /// Update
        /// </summary>
        /// <remarks>
        /// Updating an object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGIdPutAsyncWithHttpInfo (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null);
        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGPostAsync (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null);

        /// <summary>
        /// Create
        /// </summary>
        /// <remarks>
        /// Creating new object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGPostAsyncWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null);
        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task ApiV1EnvironmentMGCarrierMGValidatePostAsync (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validate
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCarrierMGValidatePostAsyncWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentMGCarrierMGValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);

        /// <summary>
        /// Validation of one on more properties of Type
        /// </summary>
        /// <remarks>
        /// Validation of object of type
        /// </remarks>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentMGCarrierMGValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
        public partial class CarrierMGApi : ICarrierMGApi
    {
        private IO.Swagger.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="CarrierMGApi"/> class.
        /// </summary>
        /// <returns></returns>
        public CarrierMGApi(String basePath)
        {
            this.Configuration = new IO.Swagger.Client.Configuration { BasePath = basePath };

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CarrierMGApi"/> class
        /// </summary>
        /// <returns></returns>
        public CarrierMGApi()
        {
            this.Configuration = IO.Swagger.Client.Configuration.Default;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CarrierMGApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public CarrierMGApi(IO.Swagger.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = IO.Swagger.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = IO.Swagger.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.Options.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public IO.Swagger.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public IO.Swagger.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>CarrierMGDTO</returns>
        public CarrierMGDTO ApiV1EnvironmentMGCarrierMGGet (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = ApiV1EnvironmentMGCarrierMGGetWithHttpInfo(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        public ApiResponse< CarrierMGDTO > ApiV1EnvironmentMGCarrierMGGetWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");
            // verify the required parameter 'param' is set
            if (param == null)
                throw new ApiException(400, "Missing required parameter 'param' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (param != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "param", param)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        public async System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGGetAsync (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = await ApiV1EnvironmentMGCarrierMGGetAsyncWithHttpInfo(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get new Get an empty object of type corresponding
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="op">The value must be &#x27;new&#x27;</param>
        /// <param name="param">Specify optional parameters that will be used during entity creation</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGGetAsyncWithHttpInfo (string op, string param, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'op' is set
            if (op == null)
                throw new ApiException(400, "Missing required parameter 'op' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");
            // verify the required parameter 'param' is set
            if (param == null)
                throw new ApiException(400, "Missing required parameter 'param' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGGet");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (param != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "param", param)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGCarrierMGIdDelete (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiV1EnvironmentMGCarrierMGIdDeleteWithHttpInfo(id, environment, authorizationScope, force, ignoreCompanyPolicyFilter, company, user, acceptLanguage, acceptTerritory);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGCarrierMGIdDeleteWithHttpInfo (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdDelete");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGCarrierMGIdDeleteAsync (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             await ApiV1EnvironmentMGCarrierMGIdDeleteAsyncWithHttpInfo(id, environment, authorizationScope, force, ignoreCompanyPolicyFilter, company, user, acceptLanguage, acceptTerritory);

        }

        /// <summary>
        /// Delete Deleting object of type 
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCarrierMGIdDeleteAsyncWithHttpInfo (string id, string environment, string authorizationScope, string force = null, bool? ignoreCompanyPolicyFilter = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdDelete");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdDelete");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdDelete");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Delete, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdDelete", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>CarrierMGDTO</returns>
        public CarrierMGDTO ApiV1EnvironmentMGCarrierMGIdGet (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = ApiV1EnvironmentMGCarrierMGIdGetWithHttpInfo(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        public ApiResponse< CarrierMGDTO > ApiV1EnvironmentMGCarrierMGIdGetWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdGet");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        public async System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGIdGetAsync (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = await ApiV1EnvironmentMGCarrierMGIdGetAsyncWithHttpInfo(id, environment, authorizationScope, ignoreCompanyPolicyFilter, dlevel, dlevelkey, company, user, acceptLanguage, acceptTerritory);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Get by ID Get an object of type corresponding the requested id
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="id">Id to get the object</param>
        /// <param name="environment"></param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="dlevel">Serialization level (optional)</param>
        /// <param name="dlevelkey">Serialization level key (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGIdGetAsyncWithHttpInfo (string id, string environment, string authorizationScope, bool? ignoreCompanyPolicyFilter = null, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null, string acceptTerritory = null)
        {
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdGet");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdGet");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdGet");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (dlevel != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevel", dlevel)); // query parameter
            if (dlevelkey != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "dlevelkey", dlevelkey)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Get, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGCarrierMGIdPatch (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)
        {
             ApiV1EnvironmentMGCarrierMGIdPatchWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, force, op, company, user);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGCarrierMGIdPatchWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGCarrierMGIdPatchAsync (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentMGCarrierMGIdPatchAsyncWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, force, op, company, user);

        }

        /// <summary>
        /// Update partial Patching an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to patch</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCarrierMGIdPatchAsyncWithHttpInfo (Object body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string force = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPatch");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Patch, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdPatch", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>CarrierMGDTO</returns>
        public CarrierMGDTO ApiV1EnvironmentMGCarrierMGIdPut (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = ApiV1EnvironmentMGCarrierMGIdPutWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, force, ignoreCompanyPolicyFilter, op, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        public ApiResponse< CarrierMGDTO > ApiV1EnvironmentMGCarrierMGIdPutWithHttpInfo (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        public async System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGIdPutAsync (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = await ApiV1EnvironmentMGCarrierMGIdPutAsyncWithHttpInfo(body, authorizationScope, id, environment, acceptLanguage, acceptTerritory, force, ignoreCompanyPolicyFilter, op, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Update Updating an object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to update</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="id"></param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGIdPutAsyncWithHttpInfo (CarrierMGDTO body, string authorizationScope, string id, string environment, string acceptLanguage = null, string acceptTerritory = null, string force = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");
            // verify the required parameter 'id' is set
            if (id == null)
                throw new ApiException(400, "Missing required parameter 'id' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGIdPut");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/{id}";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (id != null) localVarPathParams.Add("id", this.Configuration.ApiClient.ParameterToString(id)); // path parameter
            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Put, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGIdPut", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>CarrierMGDTO</returns>
        public CarrierMGDTO ApiV1EnvironmentMGCarrierMGPost (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = ApiV1EnvironmentMGCarrierMGPostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, op, force, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of CarrierMGDTO</returns>
        public ApiResponse< CarrierMGDTO > ApiV1EnvironmentMGCarrierMGPostWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGPost");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of CarrierMGDTO</returns>
        public async System.Threading.Tasks.Task<CarrierMGDTO> ApiV1EnvironmentMGCarrierMGPostAsync (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)
        {
             ApiResponse<CarrierMGDTO> localVarResponse = await ApiV1EnvironmentMGCarrierMGPostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, ignoreCompanyPolicyFilter, op, force, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Create Creating new object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to create</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="ignoreCompanyPolicyFilter">Specify &#x27;ignoreCompanyPolicyFilter&#x3D;true&#x27; if you want ignore the company filter (optional)</param>
        /// <param name="op">Set &#x27;reload&#x27;, if you want the DTO updated in the response request (optional)</param>
        /// <param name="force">The warning/s code to bypass (separated by ‘,’) during the execution (optional)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (CarrierMGDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<CarrierMGDTO>> ApiV1EnvironmentMGCarrierMGPostAsyncWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, bool? ignoreCompanyPolicyFilter = null, string op = null, string force = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGPost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGPost");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (ignoreCompanyPolicyFilter != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "ignoreCompanyPolicyFilter", ignoreCompanyPolicyFilter)); // query parameter
            if (op != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "_op", op)); // query parameter
            if (force != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "force", force)); // query parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<CarrierMGDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (CarrierMGDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(CarrierMGDTO)));
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns></returns>
        public void ApiV1EnvironmentMGCarrierMGValidatePost (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             ApiV1EnvironmentMGCarrierMGValidatePostWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public ApiResponse<Object> ApiV1EnvironmentMGCarrierMGValidatePostWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePost");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task ApiV1EnvironmentMGCarrierMGValidatePostAsync (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             await ApiV1EnvironmentMGCarrierMGValidatePostAsyncWithHttpInfo(body, authorizationScope, environment, acceptLanguage, acceptTerritory, company, user);

        }

        /// <summary>
        /// Validate Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="body">Object of type to validate</param>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<ApiResponse<Object>> ApiV1EnvironmentMGCarrierMGValidatePostAsyncWithHttpInfo (CarrierMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'body' is set
            if (body == null)
                throw new ApiException(400, "Missing required parameter 'body' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePost");
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePost");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/validate";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json", 
                "application/xml"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGValidatePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<Object>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                null);
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ValidateDTO</returns>
        public ValidateDTO ApiV1EnvironmentMGCarrierMGValidatePropertiesPost (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = ApiV1EnvironmentMGCarrierMGValidatePropertiesPostWithHttpInfo(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
             return localVarResponse.Data;
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>ApiResponse of ValidateDTO</returns>
        public ApiResponse< ValidateDTO > ApiV1EnvironmentMGCarrierMGValidatePropertiesPostWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ValidateDTO</returns>
        public async System.Threading.Tasks.Task<ValidateDTO> ApiV1EnvironmentMGCarrierMGValidatePropertiesPostAsync (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
             ApiResponse<ValidateDTO> localVarResponse = await ApiV1EnvironmentMGCarrierMGValidatePropertiesPostAsyncWithHttpInfo(authorizationScope, environment, body, acceptLanguage, acceptTerritory, company, user);
             return localVarResponse.Data;

        }

        /// <summary>
        /// Validation of one on more properties of Type Validation of object of type
        /// </summary>
        /// <exception cref="IO.Swagger.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="authorizationScope">The environment where this operation will be executed. This must match with the environment in the url.</param>
        /// <param name="environment"></param>
        /// <param name="body"> - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED&lt;br&gt; - The id of an existing object to validate properties, or &#x27;&#x27; if the object does not exist yet &lt;br&gt; (optional)</param>
        /// <param name="acceptLanguage">Specifies the UI culture to be used for localization of messages. (optional, default to it-IT)</param>
        /// <param name="acceptTerritory">Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or &#x27;IT&#x27; (optional, default to it-IT)</param>
        /// <param name="company">Company code (optional)</param>
        /// <param name="user">Application user (mandatory if the WebApi user does not have any mapped application user) (optional)</param>
        /// <returns>Task of ApiResponse (ValidateDTO)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<ValidateDTO>> ApiV1EnvironmentMGCarrierMGValidatePropertiesPostAsyncWithHttpInfo (string authorizationScope, string environment, string body = null, string acceptLanguage = null, string acceptTerritory = null, string company = null, string user = null)
        {
            // verify the required parameter 'authorizationScope' is set
            if (authorizationScope == null)
                throw new ApiException(400, "Missing required parameter 'authorizationScope' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePropertiesPost");
            // verify the required parameter 'environment' is set
            if (environment == null)
                throw new ApiException(400, "Missing required parameter 'environment' when calling CarrierMGApi->ApiV1EnvironmentMGCarrierMGValidatePropertiesPost");

            var localVarPath = "/api/v1/{environment}/MG/CarrierMG/validateProperties";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json",
                "application/xml"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (environment != null) localVarPathParams.Add("environment", this.Configuration.ApiClient.ParameterToString(environment)); // path parameter
            if (company != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "company", company)); // query parameter
            if (user != null) localVarQueryParams.AddRange(this.Configuration.ApiClient.ParameterToKeyValuePairs("", "user", user)); // query parameter
            if (authorizationScope != null) localVarHeaderParams.Add("authorization-scope", this.Configuration.ApiClient.ParameterToString(authorizationScope)); // header parameter
            if (acceptLanguage != null) localVarHeaderParams.Add("Accept-Language", this.Configuration.ApiClient.ParameterToString(acceptLanguage)); // header parameter
            if (acceptTerritory != null) localVarHeaderParams.Add("Accept-Territory", this.Configuration.ApiClient.ParameterToString(acceptTerritory)); // header parameter
            if (body != null && body.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(body); // http body (model) parameter
            }
            else
            {
                localVarPostBody = body; // byte array
            }
            // authentication (Basic) required
            // http basic authentication required
            if (!String.IsNullOrEmpty(this.Configuration.Username) || !String.IsNullOrEmpty(this.Configuration.Password))
            {
                localVarHeaderParams["Authorization"] = "Basic " + ApiClient.Base64Encode(this.Configuration.Username + ":" + this.Configuration.Password);
            }
            // authentication (Bearer) required
            // bearer required
            if (!String.IsNullOrEmpty(this.Configuration.AccessToken))
            {
                localVarHeaderParams["Authorization"] = "Bearer " + this.Configuration.AccessToken;
            }

            // make the HTTP request
            RestResponse localVarResponse = (RestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.Post, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("ApiV1EnvironmentMGCarrierMGValidatePropertiesPost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<ValidateDTO>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => string.Join(",", x.Value)),
                (ValidateDTO) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(ValidateDTO)));
        }

    }
}
