/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// DO11_DOCTESTATA - Documento&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Ditta&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;NumReg&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class DocumentoTestataMGDTO :  IEquatable<DocumentoTestataMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DocumentoTestataMGDTO" /> class.
        /// </summary>
        /// <param name="guid">DO11_GUID - GUID for current states and extended attributes.</param>
        /// <param name="esclusioneAgentiMultipli">Deprecated: use callOptions.EsclusioneAgentiMultipli.</param>
        /// <param name="esclusioneIvaTestata">Deprecated: use callOptions.EsclusioneIvaTestata.</param>
        /// <param name="flgLockOnDocExist">Deprecated: use callOptions.FlgLockOnDocExist.</param>
        /// <param name="acconto">DO13_ACCONTO - Acconto.</param>
        /// <param name="abbuono">DO13_ABBUONO - Abbuono.</param>
        /// <param name="callOptions">callOptions.</param>
        /// <param name="bancaCg12">DO11_BANCA_CG12 - Codice banca di appoggio.</param>
        /// <param name="cambio">DO11_CAMBIO - Cambio valuta.</param>
        /// <param name="cauprestCg15">DO11_CAUPREST_CG15 - Codice causale prestazione.</param>
        /// <param name="causmagMg51">DO11_CAUSMAG_MG51 - Codice causale magazzino.</param>
        /// <param name="cig">DO11_CIG - CIG.</param>
        /// <param name="cliForDest">DO11_CLIFORDEST - Codice destinatario.</param>
        /// <param name="cliforfatt">DO11_CLIFORFATT - Codice cliente/fornitore per fatturazione.</param>
        /// <param name="codbloccoMg25">DO11_CODBLOCCO_MG25 - Codice di blocco documento.</param>
        /// <param name="codcabCg13">DO11_CODCAB_CG13 - Codice agenzia di appoggio.</param>
        /// <param name="codpagCg62">DO11_CODPAG_CG62 - Codice Pagamento.</param>
        /// <param name="cup">DO11_CUP - CUP.</param>
        /// <param name="datacambio">DO11_DATACAMBIO - Data cambio.</param>
        /// <param name="datadoc">DO11_DATADOC - Data docum. (required).</param>
        /// <param name="datainiziopag">DO11_DATAINIZIOPAG - Data decorrenza pagamento manuale.</param>
        /// <param name="dataplafond">DO11_DATAPLAFOND - Data Plafond.</param>
        /// <param name="datareg">DO11_DATAREG - Data registrazione documento (required).</param>
        /// <param name="descraggcont">DO11_DESCRAGGCONT - Descrizione aggiuntiva della registrazione in contabilità.</param>
        /// <param name="ditta">DO11_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="flgClifat">DO11_FLGCLIFAT - Flag cliente/fornitore per fatturazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgDocstamp">DO11_FLGDOCSTAMP - Flag documento stampato&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSpbolli">DO11_FLGSPBOLLI - Flag spese bolli&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSpincas">DO11_FLGSPINCAS - Flag spese di incasso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="idcontCo02">DO11_IDCONT_CO02 - Codice Contatto/Rif. Azienda.</param>
        /// <param name="idmediaCg99">DO11_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indconvclifat">DO11_INDCONVCLIFAT - Conversione cliente per fatturazione.</param>
        /// <param name="indfattpa">DO11_INDFATTPA - Tipo fatt. PA (default to 0).</param>
        /// <param name="lastchange">DO11_LASTCHANGE - Data ultima modifica.</param>
        /// <param name="lineaFa05">DO11_LINEA_FA05 - Linea fashion.</param>
        /// <param name="listmag">DO11_LISTMAG - Listmag.</param>
        /// <param name="notedocum">DO11_NOTEDOCUM - Note documento.</param>
        /// <param name="numautof">DO11_NUMAUTOF - Numero autofattura.</param>
        /// <param name="numdoc">DO11_NUMDOC - Numero documento (required).</param>
        /// <param name="numdocorig">DO11_NUMDOCORIG - Numero documento originale.</param>
        /// <param name="numReg">DO11_NUMREG_CO99 - Numero registrazione (default to &quot;000000000000&quot;).</param>
        /// <param name="progrEf08">DO11_PROGR_EF08 - Codice banca aziendale.</param>
        /// <param name="sezautof">DO11_SEZAUTOF - Sezionale autofattura.</param>
        /// <param name="sezdoc">DO11_SEZDOC - Sezionale documento (required).</param>
        /// <param name="stagioneMg5t">DO11_STAGIONE_MG5T - Codice stagione.</param>
        /// <param name="stipodoc">DO11_STIPODOC - Sottotipo documento.</param>
        /// <param name="testoletint">DO11_TESTOLETINT - Descrizione lettera di intento.</param>
        /// <param name="tipodoc">DO11_TIPODOC - Tipo documento.</param>
        /// <param name="tipodocnumeraz">DO11_TIPODOCNUMERAZ - Indicatore tipo documento di riferimento numerazione.</param>
        /// <param name="tiponumautof">DO11_TIPONUMAUTOF - Tipo registro autofatture.</param>
        /// <param name="valutaCg08">DO11_VALUTA_CG08 - Codice valuta.</param>
        /// <param name="idExtendedAttributeEntity">idExtendedAttributeEntity.</param>
        /// <param name="idExtendedAttributeSubEntity">idExtendedAttributeSubEntity.</param>
        /// <param name="anagraficaDocumentoDitta">anagraficaDocumentoDitta (required).</param>
        /// <param name="codIva">codIva.</param>
        /// <param name="customerSupplierMG">customerSupplierMG.</param>
        /// <param name="documentMaster">documentMaster.</param>
        /// <param name="documentoDatiAccompagnamentoMG">documentoDatiAccompagnamentoMG.</param>
        /// <param name="documentoTestataAgentiMG">documentoTestataAgentiMG.</param>
        /// <param name="documentoTestataProgettiMG">documentoTestataProgettiMG.</param>
        /// <param name="documentoTestataProvvigioniMG">documentoTestataProvvigioniMG.</param>
        /// <param name="documentoTestataRateiMG">documentoTestataRateiMG.</param>
        /// <param name="headingReferenceDocumentMG">headingReferenceDocumentMG.</param>
        /// <param name="officeCO">officeCO.</param>
        /// <param name="righe">righe.</param>
        /// <param name="statoAttuale">statoAttuale.</param>
        /// <param name="storageWH">storageWH (required).</param>
        /// <param name="storageWHCollegato">storageWHCollegato.</param>
        /// <param name="testataEstesa">testataEstesa.</param>
        /// <param name="testataOrdine">testataOrdine.</param>
        /// <param name="testataPersonalizzata">testataPersonalizzata.</param>
        /// <param name="totaliDocumento">totaliDocumento.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public DocumentoTestataMGDTO(Guid? guid = default(Guid?), int? esclusioneAgentiMultipli = default(int?), int? esclusioneIvaTestata = default(int?), bool? flgLockOnDocExist = default(bool?), double? acconto = default(double?), double? abbuono = default(double?), DocumentHeaderCallOptionsDTO callOptions = default(DocumentHeaderCallOptionsDTO), double? bancaCg12 = default(double?), double? cambio = default(double?), string cauprestCg15 = default(string), double? causmagMg51 = default(double?), string cig = default(string), string cliForDest = default(string), double? cliforfatt = default(double?), string codbloccoMg25 = default(string), double? codcabCg13 = default(double?), string codpagCg62 = default(string), string cup = default(string), DateTime? datacambio = default(DateTime?), DateTime? datadoc = default(DateTime?), DateTime? datainiziopag = default(DateTime?), DateTime? dataplafond = default(DateTime?), DateTime? datareg = default(DateTime?), string descraggcont = default(string), double? ditta = 0, int? flgClifat = default(int?), int? flgDocstamp = default(int?), int? flgSpbolli = default(int?), int? flgSpincas = default(int?), double? idcontCo02 = default(double?), double? idmediaCg99 = default(double?), int? indconvclifat = default(int?), int? indfattpa = 0, DateTime? lastchange = default(DateTime?), string lineaFa05 = default(string), double? listmag = default(double?), string notedocum = default(string), double? numautof = default(double?), double? numdoc = default(double?), string numdocorig = default(string), string numReg = "000000000000", double? progrEf08 = default(double?), string sezautof = default(string), string sezdoc = default(string), int? stagioneMg5t = default(int?), double? stipodoc = default(double?), string testoletint = default(string), double? tipodoc = default(double?), double? tipodocnumeraz = default(double?), double? tiponumautof = default(double?), string valutaCg08 = default(string), int? idExtendedAttributeEntity = default(int?), int? idExtendedAttributeSubEntity = default(int?), CompanyDocumentMasterDataMGDTO anagraficaDocumentoDitta = default(CompanyDocumentMasterDataMGDTO), VatCodeCODTO codIva = default(VatCodeCODTO), CustomerSupplierMGDTO customerSupplierMG = default(CustomerSupplierMGDTO), DocumentMasterCODTO documentMaster = default(DocumentMasterCODTO), DocumentoDatiAccompagnamentoMGDTO documentoDatiAccompagnamentoMG = default(DocumentoDatiAccompagnamentoMGDTO), List<DocumentoTestataAgentiMGDTO> documentoTestataAgentiMG = default(List<DocumentoTestataAgentiMGDTO>), DocumentoTestataProgettiMGDTO documentoTestataProgettiMG = default(DocumentoTestataProgettiMGDTO), List<DocumentoTestataProvvigioniMGDTO> documentoTestataProvvigioniMG = default(List<DocumentoTestataProvvigioniMGDTO>), DocumentoTestataRateiMGDTO documentoTestataRateiMG = default(DocumentoTestataRateiMGDTO), List<HeadingReferenceDocumentMGDTO> headingReferenceDocumentMG = default(List<HeadingReferenceDocumentMGDTO>), OfficeCODTO officeCO = default(OfficeCODTO), List<DocumentoRigaMGDTO> righe = default(List<DocumentoRigaMGDTO>), StatoAttualeDTO statoAttuale = default(StatoAttualeDTO), StorageWHDTO storageWH = default(StorageWHDTO), StorageWHDTO storageWHCollegato = default(StorageWHDTO), List<DocumentoTestataEstesaMGDTO> testataEstesa = default(List<DocumentoTestataEstesaMGDTO>), DocumentoTestataOrdiniMGDTO testataOrdine = default(DocumentoTestataOrdiniMGDTO), List<DocumentoTestataPersonalizzataMGDTO> testataPersonalizzata = default(List<DocumentoTestataPersonalizzataMGDTO>), TotaleDocumentoMGDTO totaliDocumento = default(TotaleDocumentoMGDTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "datadoc" is required (not null)
            if (datadoc == null)
            {
                throw new InvalidDataException("datadoc is a required property for DocumentoTestataMGDTO and cannot be null");
            }
            else
            {
                this.Datadoc = datadoc;
            }
            // to ensure "datareg" is required (not null)
            if (datareg == null)
            {
                throw new InvalidDataException("datareg is a required property for DocumentoTestataMGDTO and cannot be null");
            }
            else
            {
                this.Datareg = datareg;
            }
            // to ensure "numdoc" is required (not null)
            if (numdoc == null)
            {
                throw new InvalidDataException("numdoc is a required property for DocumentoTestataMGDTO and cannot be null");
            }
            else
            {
                this.Numdoc = numdoc;
            }
            // to ensure "sezdoc" is required (not null)
            if (sezdoc == null)
            {
                throw new InvalidDataException("sezdoc is a required property for DocumentoTestataMGDTO and cannot be null");
            }
            else
            {
                this.Sezdoc = sezdoc;
            }
            // to ensure "anagraficaDocumentoDitta" is required (not null)
            if (anagraficaDocumentoDitta == null)
            {
                throw new InvalidDataException("anagraficaDocumentoDitta is a required property for DocumentoTestataMGDTO and cannot be null");
            }
            else
            {
                this.AnagraficaDocumentoDitta = anagraficaDocumentoDitta;
            }
            // to ensure "storageWH" is required (not null)
            if (storageWH == null)
            {
                throw new InvalidDataException("storageWH is a required property for DocumentoTestataMGDTO and cannot be null");
            }
            else
            {
                this.StorageWH = storageWH;
            }
            this.Guid = guid;
            this.EsclusioneAgentiMultipli = esclusioneAgentiMultipli;
            this.EsclusioneIvaTestata = esclusioneIvaTestata;
            this.FlgLockOnDocExist = flgLockOnDocExist;
            this.Acconto = acconto;
            this.Abbuono = abbuono;
            this.CallOptions = callOptions;
            this.BancaCg12 = bancaCg12;
            this.Cambio = cambio;
            this.CauprestCg15 = cauprestCg15;
            this.CausmagMg51 = causmagMg51;
            this.Cig = cig;
            this.CliForDest = cliForDest;
            this.Cliforfatt = cliforfatt;
            this.CodbloccoMg25 = codbloccoMg25;
            this.CodcabCg13 = codcabCg13;
            this.CodpagCg62 = codpagCg62;
            this.Cup = cup;
            this.Datacambio = datacambio;
            this.Datainiziopag = datainiziopag;
            this.Dataplafond = dataplafond;
            this.Descraggcont = descraggcont;
            // use default value if no "ditta" provided
            if (ditta == null)
            {
                this.Ditta = 0;
            }
            else
            {
                this.Ditta = ditta;
            }
            this.FlgClifat = flgClifat;
            this.FlgDocstamp = flgDocstamp;
            this.FlgSpbolli = flgSpbolli;
            this.FlgSpincas = flgSpincas;
            this.IdcontCo02 = idcontCo02;
            this.IdmediaCg99 = idmediaCg99;
            this.Indconvclifat = indconvclifat;
            // use default value if no "indfattpa" provided
            if (indfattpa == null)
            {
                this.Indfattpa = 0;
            }
            else
            {
                this.Indfattpa = indfattpa;
            }
            this.Lastchange = lastchange;
            this.LineaFa05 = lineaFa05;
            this.Listmag = listmag;
            this.Notedocum = notedocum;
            this.Numautof = numautof;
            this.Numdocorig = numdocorig;
            // use default value if no "numReg" provided
            if (numReg == null)
            {
                this.NumReg = "000000000000";
            }
            else
            {
                this.NumReg = numReg;
            }
            this.ProgrEf08 = progrEf08;
            this.Sezautof = sezautof;
            this.StagioneMg5t = stagioneMg5t;
            this.Stipodoc = stipodoc;
            this.Testoletint = testoletint;
            this.Tipodoc = tipodoc;
            this.Tipodocnumeraz = tipodocnumeraz;
            this.Tiponumautof = tiponumautof;
            this.ValutaCg08 = valutaCg08;
            this.IdExtendedAttributeEntity = idExtendedAttributeEntity;
            this.IdExtendedAttributeSubEntity = idExtendedAttributeSubEntity;
            this.CodIva = codIva;
            this.CustomerSupplierMG = customerSupplierMG;
            this.DocumentMaster = documentMaster;
            this.DocumentoDatiAccompagnamentoMG = documentoDatiAccompagnamentoMG;
            this.DocumentoTestataAgentiMG = documentoTestataAgentiMG;
            this.DocumentoTestataProgettiMG = documentoTestataProgettiMG;
            this.DocumentoTestataProvvigioniMG = documentoTestataProvvigioniMG;
            this.DocumentoTestataRateiMG = documentoTestataRateiMG;
            this.HeadingReferenceDocumentMG = headingReferenceDocumentMG;
            this.OfficeCO = officeCO;
            this.Righe = righe;
            this.StatoAttuale = statoAttuale;
            this.StorageWHCollegato = storageWHCollegato;
            this.TestataEstesa = testataEstesa;
            this.TestataOrdine = testataOrdine;
            this.TestataPersonalizzata = testataPersonalizzata;
            this.TotaliDocumento = totaliDocumento;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// DO11_GUID - GUID for current states and extended attributes
        /// </summary>
        /// <value>DO11_GUID - GUID for current states and extended attributes</value>
        [DataMember(Name="guid", EmitDefaultValue=false)]
        public Guid? Guid { get; set; }

        /// <summary>
        /// Deprecated: use callOptions.EsclusioneAgentiMultipli
        /// </summary>
        /// <value>Deprecated: use callOptions.EsclusioneAgentiMultipli</value>
        [DataMember(Name="esclusioneAgentiMultipli", EmitDefaultValue=false)]
        public int? EsclusioneAgentiMultipli { get; set; }

        /// <summary>
        /// Deprecated: use callOptions.EsclusioneIvaTestata
        /// </summary>
        /// <value>Deprecated: use callOptions.EsclusioneIvaTestata</value>
        [DataMember(Name="esclusioneIvaTestata", EmitDefaultValue=false)]
        public int? EsclusioneIvaTestata { get; set; }

        /// <summary>
        /// Deprecated: use callOptions.FlgLockOnDocExist
        /// </summary>
        /// <value>Deprecated: use callOptions.FlgLockOnDocExist</value>
        [DataMember(Name="flgLockOnDocExist", EmitDefaultValue=false)]
        public bool? FlgLockOnDocExist { get; set; }

        /// <summary>
        /// DO13_ACCONTO - Acconto
        /// </summary>
        /// <value>DO13_ACCONTO - Acconto</value>
        [DataMember(Name="acconto", EmitDefaultValue=false)]
        public double? Acconto { get; set; }

        /// <summary>
        /// DO13_ABBUONO - Abbuono
        /// </summary>
        /// <value>DO13_ABBUONO - Abbuono</value>
        [DataMember(Name="abbuono", EmitDefaultValue=false)]
        public double? Abbuono { get; set; }

        /// <summary>
        /// Gets or Sets CallOptions
        /// </summary>
        [DataMember(Name="callOptions", EmitDefaultValue=false)]
        public DocumentHeaderCallOptionsDTO CallOptions { get; set; }

        /// <summary>
        /// DO11_BANCA_CG12 - Codice banca di appoggio
        /// </summary>
        /// <value>DO11_BANCA_CG12 - Codice banca di appoggio</value>
        [DataMember(Name="bancaCg12", EmitDefaultValue=false)]
        public double? BancaCg12 { get; set; }

        /// <summary>
        /// DO11_CAMBIO - Cambio valuta
        /// </summary>
        /// <value>DO11_CAMBIO - Cambio valuta</value>
        [DataMember(Name="cambio", EmitDefaultValue=false)]
        public double? Cambio { get; set; }

        /// <summary>
        /// DO11_CAUPREST_CG15 - Codice causale prestazione
        /// </summary>
        /// <value>DO11_CAUPREST_CG15 - Codice causale prestazione</value>
        [DataMember(Name="cauprestCg15", EmitDefaultValue=false)]
        public string CauprestCg15 { get; set; }

        /// <summary>
        /// DO11_CAUSMAG_MG51 - Codice causale magazzino
        /// </summary>
        /// <value>DO11_CAUSMAG_MG51 - Codice causale magazzino</value>
        [DataMember(Name="causmagMg51", EmitDefaultValue=false)]
        public double? CausmagMg51 { get; set; }

        /// <summary>
        /// DO11_CIG - CIG
        /// </summary>
        /// <value>DO11_CIG - CIG</value>
        [DataMember(Name="cig", EmitDefaultValue=false)]
        public string Cig { get; set; }

        /// <summary>
        /// DO11_CLIFORDEST - Codice destinatario
        /// </summary>
        /// <value>DO11_CLIFORDEST - Codice destinatario</value>
        [DataMember(Name="cliForDest", EmitDefaultValue=false)]
        public string CliForDest { get; set; }

        /// <summary>
        /// DO11_CLIFORFATT - Codice cliente/fornitore per fatturazione
        /// </summary>
        /// <value>DO11_CLIFORFATT - Codice cliente/fornitore per fatturazione</value>
        [DataMember(Name="cliforfatt", EmitDefaultValue=false)]
        public double? Cliforfatt { get; set; }

        /// <summary>
        /// DO11_CODBLOCCO_MG25 - Codice di blocco documento
        /// </summary>
        /// <value>DO11_CODBLOCCO_MG25 - Codice di blocco documento</value>
        [DataMember(Name="codbloccoMg25", EmitDefaultValue=false)]
        public string CodbloccoMg25 { get; set; }

        /// <summary>
        /// DO11_CODCAB_CG13 - Codice agenzia di appoggio
        /// </summary>
        /// <value>DO11_CODCAB_CG13 - Codice agenzia di appoggio</value>
        [DataMember(Name="codcabCg13", EmitDefaultValue=false)]
        public double? CodcabCg13 { get; set; }

        /// <summary>
        /// DO11_CODPAG_CG62 - Codice Pagamento
        /// </summary>
        /// <value>DO11_CODPAG_CG62 - Codice Pagamento</value>
        [DataMember(Name="codpagCg62", EmitDefaultValue=false)]
        public string CodpagCg62 { get; set; }

        /// <summary>
        /// DO11_CUP - CUP
        /// </summary>
        /// <value>DO11_CUP - CUP</value>
        [DataMember(Name="cup", EmitDefaultValue=false)]
        public string Cup { get; set; }

        /// <summary>
        /// DO11_DATACAMBIO - Data cambio
        /// </summary>
        /// <value>DO11_DATACAMBIO - Data cambio</value>
        [DataMember(Name="datacambio", EmitDefaultValue=false)]
        public DateTime? Datacambio { get; set; }

        /// <summary>
        /// DO11_DATADOC - Data docum.
        /// </summary>
        /// <value>DO11_DATADOC - Data docum.</value>
        [DataMember(Name="datadoc", EmitDefaultValue=false)]
        public DateTime? Datadoc { get; set; }

        /// <summary>
        /// DO11_DATAINIZIOPAG - Data decorrenza pagamento manuale
        /// </summary>
        /// <value>DO11_DATAINIZIOPAG - Data decorrenza pagamento manuale</value>
        [DataMember(Name="datainiziopag", EmitDefaultValue=false)]
        public DateTime? Datainiziopag { get; set; }

        /// <summary>
        /// DO11_DATAPLAFOND - Data Plafond
        /// </summary>
        /// <value>DO11_DATAPLAFOND - Data Plafond</value>
        [DataMember(Name="dataplafond", EmitDefaultValue=false)]
        public DateTime? Dataplafond { get; set; }

        /// <summary>
        /// DO11_DATAREG - Data registrazione documento
        /// </summary>
        /// <value>DO11_DATAREG - Data registrazione documento</value>
        [DataMember(Name="datareg", EmitDefaultValue=false)]
        public DateTime? Datareg { get; set; }

        /// <summary>
        /// DO11_DESCRAGGCONT - Descrizione aggiuntiva della registrazione in contabilità
        /// </summary>
        /// <value>DO11_DESCRAGGCONT - Descrizione aggiuntiva della registrazione in contabilità</value>
        [DataMember(Name="descraggcont", EmitDefaultValue=false)]
        public string Descraggcont { get; set; }

        /// <summary>
        /// DO11_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>DO11_DITTA_CG18 - Ditta</value>
        [DataMember(Name="ditta", EmitDefaultValue=false)]
        public double? Ditta { get; set; }

        /// <summary>
        /// DO11_FLGCLIFAT - Flag cliente/fornitore per fatturazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO11_FLGCLIFAT - Flag cliente/fornitore per fatturazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgClifat", EmitDefaultValue=false)]
        public int? FlgClifat { get; set; }

        /// <summary>
        /// DO11_FLGDOCSTAMP - Flag documento stampato&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO11_FLGDOCSTAMP - Flag documento stampato&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgDocstamp", EmitDefaultValue=false)]
        public int? FlgDocstamp { get; set; }

        /// <summary>
        /// DO11_FLGSPBOLLI - Flag spese bolli&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO11_FLGSPBOLLI - Flag spese bolli&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSpbolli", EmitDefaultValue=false)]
        public int? FlgSpbolli { get; set; }

        /// <summary>
        /// DO11_FLGSPINCAS - Flag spese di incasso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO11_FLGSPINCAS - Flag spese di incasso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSpincas", EmitDefaultValue=false)]
        public int? FlgSpincas { get; set; }

        /// <summary>
        /// DO11_IDCONT_CO02 - Codice Contatto/Rif. Azienda
        /// </summary>
        /// <value>DO11_IDCONT_CO02 - Codice Contatto/Rif. Azienda</value>
        [DataMember(Name="idcontCo02", EmitDefaultValue=false)]
        public double? IdcontCo02 { get; set; }

        /// <summary>
        /// DO11_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>DO11_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// DO11_INDCONVCLIFAT - Conversione cliente per fatturazione
        /// </summary>
        /// <value>DO11_INDCONVCLIFAT - Conversione cliente per fatturazione</value>
        [DataMember(Name="indconvclifat", EmitDefaultValue=false)]
        public int? Indconvclifat { get; set; }

        /// <summary>
        /// DO11_INDFATTPA - Tipo fatt. PA
        /// </summary>
        /// <value>DO11_INDFATTPA - Tipo fatt. PA</value>
        [DataMember(Name="indfattpa", EmitDefaultValue=false)]
        public int? Indfattpa { get; set; }

        /// <summary>
        /// DO11_LASTCHANGE - Data ultima modifica
        /// </summary>
        /// <value>DO11_LASTCHANGE - Data ultima modifica</value>
        [DataMember(Name="lastchange", EmitDefaultValue=false)]
        public DateTime? Lastchange { get; set; }

        /// <summary>
        /// DO11_LINEA_FA05 - Linea fashion
        /// </summary>
        /// <value>DO11_LINEA_FA05 - Linea fashion</value>
        [DataMember(Name="lineaFa05", EmitDefaultValue=false)]
        public string LineaFa05 { get; set; }

        /// <summary>
        /// DO11_LISTMAG - Listmag
        /// </summary>
        /// <value>DO11_LISTMAG - Listmag</value>
        [DataMember(Name="listmag", EmitDefaultValue=false)]
        public double? Listmag { get; set; }

        /// <summary>
        /// DO11_NOTEDOCUM - Note documento
        /// </summary>
        /// <value>DO11_NOTEDOCUM - Note documento</value>
        [DataMember(Name="notedocum", EmitDefaultValue=false)]
        public string Notedocum { get; set; }

        /// <summary>
        /// DO11_NUMAUTOF - Numero autofattura
        /// </summary>
        /// <value>DO11_NUMAUTOF - Numero autofattura</value>
        [DataMember(Name="numautof", EmitDefaultValue=false)]
        public double? Numautof { get; set; }

        /// <summary>
        /// DO11_NUMDOC - Numero documento
        /// </summary>
        /// <value>DO11_NUMDOC - Numero documento</value>
        [DataMember(Name="numdoc", EmitDefaultValue=false)]
        public double? Numdoc { get; set; }

        /// <summary>
        /// DO11_NUMDOCORIG - Numero documento originale
        /// </summary>
        /// <value>DO11_NUMDOCORIG - Numero documento originale</value>
        [DataMember(Name="numdocorig", EmitDefaultValue=false)]
        public string Numdocorig { get; set; }

        /// <summary>
        /// DO11_NUMREG_CO99 - Numero registrazione
        /// </summary>
        /// <value>DO11_NUMREG_CO99 - Numero registrazione</value>
        [DataMember(Name="numReg", EmitDefaultValue=false)]
        public string NumReg { get; set; }

        /// <summary>
        /// DO11_PROGR_EF08 - Codice banca aziendale
        /// </summary>
        /// <value>DO11_PROGR_EF08 - Codice banca aziendale</value>
        [DataMember(Name="progrEf08", EmitDefaultValue=false)]
        public double? ProgrEf08 { get; set; }

        /// <summary>
        /// DO11_SEZAUTOF - Sezionale autofattura
        /// </summary>
        /// <value>DO11_SEZAUTOF - Sezionale autofattura</value>
        [DataMember(Name="sezautof", EmitDefaultValue=false)]
        public string Sezautof { get; set; }

        /// <summary>
        /// DO11_SEZDOC - Sezionale documento
        /// </summary>
        /// <value>DO11_SEZDOC - Sezionale documento</value>
        [DataMember(Name="sezdoc", EmitDefaultValue=false)]
        public string Sezdoc { get; set; }

        /// <summary>
        /// DO11_STAGIONE_MG5T - Codice stagione
        /// </summary>
        /// <value>DO11_STAGIONE_MG5T - Codice stagione</value>
        [DataMember(Name="stagioneMg5t", EmitDefaultValue=false)]
        public int? StagioneMg5t { get; set; }

        /// <summary>
        /// DO11_STIPODOC - Sottotipo documento
        /// </summary>
        /// <value>DO11_STIPODOC - Sottotipo documento</value>
        [DataMember(Name="stipodoc", EmitDefaultValue=false)]
        public double? Stipodoc { get; set; }

        /// <summary>
        /// DO11_TESTOLETINT - Descrizione lettera di intento
        /// </summary>
        /// <value>DO11_TESTOLETINT - Descrizione lettera di intento</value>
        [DataMember(Name="testoletint", EmitDefaultValue=false)]
        public string Testoletint { get; set; }

        /// <summary>
        /// DO11_TIPODOC - Tipo documento
        /// </summary>
        /// <value>DO11_TIPODOC - Tipo documento</value>
        [DataMember(Name="tipodoc", EmitDefaultValue=false)]
        public double? Tipodoc { get; set; }

        /// <summary>
        /// DO11_TIPODOCNUMERAZ - Indicatore tipo documento di riferimento numerazione
        /// </summary>
        /// <value>DO11_TIPODOCNUMERAZ - Indicatore tipo documento di riferimento numerazione</value>
        [DataMember(Name="tipodocnumeraz", EmitDefaultValue=false)]
        public double? Tipodocnumeraz { get; set; }

        /// <summary>
        /// DO11_TIPONUMAUTOF - Tipo registro autofatture
        /// </summary>
        /// <value>DO11_TIPONUMAUTOF - Tipo registro autofatture</value>
        [DataMember(Name="tiponumautof", EmitDefaultValue=false)]
        public double? Tiponumautof { get; set; }

        /// <summary>
        /// DO11_VALUTA_CG08 - Codice valuta
        /// </summary>
        /// <value>DO11_VALUTA_CG08 - Codice valuta</value>
        [DataMember(Name="valutaCg08", EmitDefaultValue=false)]
        public string ValutaCg08 { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeEntity { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeSubEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeSubEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeSubEntity { get; set; }

        /// <summary>
        /// Gets or Sets AnagraficaDocumentoDitta
        /// </summary>
        [DataMember(Name="anagraficaDocumentoDitta", EmitDefaultValue=false)]
        public CompanyDocumentMasterDataMGDTO AnagraficaDocumentoDitta { get; set; }

        /// <summary>
        /// Gets or Sets CodIva
        /// </summary>
        [DataMember(Name="codIva", EmitDefaultValue=false)]
        public VatCodeCODTO CodIva { get; set; }

        /// <summary>
        /// Gets or Sets CustomerSupplierMG
        /// </summary>
        [DataMember(Name="customerSupplierMG", EmitDefaultValue=false)]
        public CustomerSupplierMGDTO CustomerSupplierMG { get; set; }

        /// <summary>
        /// Gets or Sets DocumentMaster
        /// </summary>
        [DataMember(Name="documentMaster", EmitDefaultValue=false)]
        public DocumentMasterCODTO DocumentMaster { get; set; }

        /// <summary>
        /// Gets or Sets DocumentoDatiAccompagnamentoMG
        /// </summary>
        [DataMember(Name="documentoDatiAccompagnamentoMG", EmitDefaultValue=false)]
        public DocumentoDatiAccompagnamentoMGDTO DocumentoDatiAccompagnamentoMG { get; set; }

        /// <summary>
        /// Gets or Sets DocumentoTestataAgentiMG
        /// </summary>
        [DataMember(Name="documentoTestataAgentiMG", EmitDefaultValue=false)]
        public List<DocumentoTestataAgentiMGDTO> DocumentoTestataAgentiMG { get; set; }

        /// <summary>
        /// Gets or Sets DocumentoTestataProgettiMG
        /// </summary>
        [DataMember(Name="documentoTestataProgettiMG", EmitDefaultValue=false)]
        public DocumentoTestataProgettiMGDTO DocumentoTestataProgettiMG { get; set; }

        /// <summary>
        /// Gets or Sets DocumentoTestataProvvigioniMG
        /// </summary>
        [DataMember(Name="documentoTestataProvvigioniMG", EmitDefaultValue=false)]
        public List<DocumentoTestataProvvigioniMGDTO> DocumentoTestataProvvigioniMG { get; set; }

        /// <summary>
        /// Gets or Sets DocumentoTestataRateiMG
        /// </summary>
        [DataMember(Name="documentoTestataRateiMG", EmitDefaultValue=false)]
        public DocumentoTestataRateiMGDTO DocumentoTestataRateiMG { get; set; }

        /// <summary>
        /// Gets or Sets HeadingReferenceDocumentMG
        /// </summary>
        [DataMember(Name="headingReferenceDocumentMG", EmitDefaultValue=false)]
        public List<HeadingReferenceDocumentMGDTO> HeadingReferenceDocumentMG { get; set; }

        /// <summary>
        /// Gets or Sets OfficeCO
        /// </summary>
        [DataMember(Name="officeCO", EmitDefaultValue=false)]
        public OfficeCODTO OfficeCO { get; set; }

        /// <summary>
        /// Gets or Sets Righe
        /// </summary>
        [DataMember(Name="righe", EmitDefaultValue=false)]
        public List<DocumentoRigaMGDTO> Righe { get; set; }

        /// <summary>
        /// Gets or Sets StatoAttuale
        /// </summary>
        [DataMember(Name="statoAttuale", EmitDefaultValue=false)]
        public StatoAttualeDTO StatoAttuale { get; set; }

        /// <summary>
        /// Gets or Sets StorageWH
        /// </summary>
        [DataMember(Name="storageWH", EmitDefaultValue=false)]
        public StorageWHDTO StorageWH { get; set; }

        /// <summary>
        /// Gets or Sets StorageWHCollegato
        /// </summary>
        [DataMember(Name="storageWHCollegato", EmitDefaultValue=false)]
        public StorageWHDTO StorageWHCollegato { get; set; }

        /// <summary>
        /// Gets or Sets TestataEstesa
        /// </summary>
        [DataMember(Name="testataEstesa", EmitDefaultValue=false)]
        public List<DocumentoTestataEstesaMGDTO> TestataEstesa { get; set; }

        /// <summary>
        /// Gets or Sets TestataOrdine
        /// </summary>
        [DataMember(Name="testataOrdine", EmitDefaultValue=false)]
        public DocumentoTestataOrdiniMGDTO TestataOrdine { get; set; }

        /// <summary>
        /// Gets or Sets TestataPersonalizzata
        /// </summary>
        [DataMember(Name="testataPersonalizzata", EmitDefaultValue=false)]
        public List<DocumentoTestataPersonalizzataMGDTO> TestataPersonalizzata { get; set; }

        /// <summary>
        /// Gets or Sets TotaliDocumento
        /// </summary>
        [DataMember(Name="totaliDocumento", EmitDefaultValue=false)]
        public TotaleDocumentoMGDTO TotaliDocumento { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class DocumentoTestataMGDTO {\n");
            sb.Append("  Guid: ").Append(Guid).Append("\n");
            sb.Append("  EsclusioneAgentiMultipli: ").Append(EsclusioneAgentiMultipli).Append("\n");
            sb.Append("  EsclusioneIvaTestata: ").Append(EsclusioneIvaTestata).Append("\n");
            sb.Append("  FlgLockOnDocExist: ").Append(FlgLockOnDocExist).Append("\n");
            sb.Append("  Acconto: ").Append(Acconto).Append("\n");
            sb.Append("  Abbuono: ").Append(Abbuono).Append("\n");
            sb.Append("  CallOptions: ").Append(CallOptions).Append("\n");
            sb.Append("  BancaCg12: ").Append(BancaCg12).Append("\n");
            sb.Append("  Cambio: ").Append(Cambio).Append("\n");
            sb.Append("  CauprestCg15: ").Append(CauprestCg15).Append("\n");
            sb.Append("  CausmagMg51: ").Append(CausmagMg51).Append("\n");
            sb.Append("  Cig: ").Append(Cig).Append("\n");
            sb.Append("  CliForDest: ").Append(CliForDest).Append("\n");
            sb.Append("  Cliforfatt: ").Append(Cliforfatt).Append("\n");
            sb.Append("  CodbloccoMg25: ").Append(CodbloccoMg25).Append("\n");
            sb.Append("  CodcabCg13: ").Append(CodcabCg13).Append("\n");
            sb.Append("  CodpagCg62: ").Append(CodpagCg62).Append("\n");
            sb.Append("  Cup: ").Append(Cup).Append("\n");
            sb.Append("  Datacambio: ").Append(Datacambio).Append("\n");
            sb.Append("  Datadoc: ").Append(Datadoc).Append("\n");
            sb.Append("  Datainiziopag: ").Append(Datainiziopag).Append("\n");
            sb.Append("  Dataplafond: ").Append(Dataplafond).Append("\n");
            sb.Append("  Datareg: ").Append(Datareg).Append("\n");
            sb.Append("  Descraggcont: ").Append(Descraggcont).Append("\n");
            sb.Append("  Ditta: ").Append(Ditta).Append("\n");
            sb.Append("  FlgClifat: ").Append(FlgClifat).Append("\n");
            sb.Append("  FlgDocstamp: ").Append(FlgDocstamp).Append("\n");
            sb.Append("  FlgSpbolli: ").Append(FlgSpbolli).Append("\n");
            sb.Append("  FlgSpincas: ").Append(FlgSpincas).Append("\n");
            sb.Append("  IdcontCo02: ").Append(IdcontCo02).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  Indconvclifat: ").Append(Indconvclifat).Append("\n");
            sb.Append("  Indfattpa: ").Append(Indfattpa).Append("\n");
            sb.Append("  Lastchange: ").Append(Lastchange).Append("\n");
            sb.Append("  LineaFa05: ").Append(LineaFa05).Append("\n");
            sb.Append("  Listmag: ").Append(Listmag).Append("\n");
            sb.Append("  Notedocum: ").Append(Notedocum).Append("\n");
            sb.Append("  Numautof: ").Append(Numautof).Append("\n");
            sb.Append("  Numdoc: ").Append(Numdoc).Append("\n");
            sb.Append("  Numdocorig: ").Append(Numdocorig).Append("\n");
            sb.Append("  NumReg: ").Append(NumReg).Append("\n");
            sb.Append("  ProgrEf08: ").Append(ProgrEf08).Append("\n");
            sb.Append("  Sezautof: ").Append(Sezautof).Append("\n");
            sb.Append("  Sezdoc: ").Append(Sezdoc).Append("\n");
            sb.Append("  StagioneMg5t: ").Append(StagioneMg5t).Append("\n");
            sb.Append("  Stipodoc: ").Append(Stipodoc).Append("\n");
            sb.Append("  Testoletint: ").Append(Testoletint).Append("\n");
            sb.Append("  Tipodoc: ").Append(Tipodoc).Append("\n");
            sb.Append("  Tipodocnumeraz: ").Append(Tipodocnumeraz).Append("\n");
            sb.Append("  Tiponumautof: ").Append(Tiponumautof).Append("\n");
            sb.Append("  ValutaCg08: ").Append(ValutaCg08).Append("\n");
            sb.Append("  IdExtendedAttributeEntity: ").Append(IdExtendedAttributeEntity).Append("\n");
            sb.Append("  IdExtendedAttributeSubEntity: ").Append(IdExtendedAttributeSubEntity).Append("\n");
            sb.Append("  AnagraficaDocumentoDitta: ").Append(AnagraficaDocumentoDitta).Append("\n");
            sb.Append("  CodIva: ").Append(CodIva).Append("\n");
            sb.Append("  CustomerSupplierMG: ").Append(CustomerSupplierMG).Append("\n");
            sb.Append("  DocumentMaster: ").Append(DocumentMaster).Append("\n");
            sb.Append("  DocumentoDatiAccompagnamentoMG: ").Append(DocumentoDatiAccompagnamentoMG).Append("\n");
            sb.Append("  DocumentoTestataAgentiMG: ").Append(DocumentoTestataAgentiMG).Append("\n");
            sb.Append("  DocumentoTestataProgettiMG: ").Append(DocumentoTestataProgettiMG).Append("\n");
            sb.Append("  DocumentoTestataProvvigioniMG: ").Append(DocumentoTestataProvvigioniMG).Append("\n");
            sb.Append("  DocumentoTestataRateiMG: ").Append(DocumentoTestataRateiMG).Append("\n");
            sb.Append("  HeadingReferenceDocumentMG: ").Append(HeadingReferenceDocumentMG).Append("\n");
            sb.Append("  OfficeCO: ").Append(OfficeCO).Append("\n");
            sb.Append("  Righe: ").Append(Righe).Append("\n");
            sb.Append("  StatoAttuale: ").Append(StatoAttuale).Append("\n");
            sb.Append("  StorageWH: ").Append(StorageWH).Append("\n");
            sb.Append("  StorageWHCollegato: ").Append(StorageWHCollegato).Append("\n");
            sb.Append("  TestataEstesa: ").Append(TestataEstesa).Append("\n");
            sb.Append("  TestataOrdine: ").Append(TestataOrdine).Append("\n");
            sb.Append("  TestataPersonalizzata: ").Append(TestataPersonalizzata).Append("\n");
            sb.Append("  TotaliDocumento: ").Append(TotaliDocumento).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as DocumentoTestataMGDTO);
        }

        /// <summary>
        /// Returns true if DocumentoTestataMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of DocumentoTestataMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(DocumentoTestataMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Guid == input.Guid ||
                    (this.Guid != null &&
                    this.Guid.Equals(input.Guid))
                ) && 
                (
                    this.EsclusioneAgentiMultipli == input.EsclusioneAgentiMultipli ||
                    (this.EsclusioneAgentiMultipli != null &&
                    this.EsclusioneAgentiMultipli.Equals(input.EsclusioneAgentiMultipli))
                ) && 
                (
                    this.EsclusioneIvaTestata == input.EsclusioneIvaTestata ||
                    (this.EsclusioneIvaTestata != null &&
                    this.EsclusioneIvaTestata.Equals(input.EsclusioneIvaTestata))
                ) && 
                (
                    this.FlgLockOnDocExist == input.FlgLockOnDocExist ||
                    (this.FlgLockOnDocExist != null &&
                    this.FlgLockOnDocExist.Equals(input.FlgLockOnDocExist))
                ) && 
                (
                    this.Acconto == input.Acconto ||
                    (this.Acconto != null &&
                    this.Acconto.Equals(input.Acconto))
                ) && 
                (
                    this.Abbuono == input.Abbuono ||
                    (this.Abbuono != null &&
                    this.Abbuono.Equals(input.Abbuono))
                ) && 
                (
                    this.CallOptions == input.CallOptions ||
                    (this.CallOptions != null &&
                    this.CallOptions.Equals(input.CallOptions))
                ) && 
                (
                    this.BancaCg12 == input.BancaCg12 ||
                    (this.BancaCg12 != null &&
                    this.BancaCg12.Equals(input.BancaCg12))
                ) && 
                (
                    this.Cambio == input.Cambio ||
                    (this.Cambio != null &&
                    this.Cambio.Equals(input.Cambio))
                ) && 
                (
                    this.CauprestCg15 == input.CauprestCg15 ||
                    (this.CauprestCg15 != null &&
                    this.CauprestCg15.Equals(input.CauprestCg15))
                ) && 
                (
                    this.CausmagMg51 == input.CausmagMg51 ||
                    (this.CausmagMg51 != null &&
                    this.CausmagMg51.Equals(input.CausmagMg51))
                ) && 
                (
                    this.Cig == input.Cig ||
                    (this.Cig != null &&
                    this.Cig.Equals(input.Cig))
                ) && 
                (
                    this.CliForDest == input.CliForDest ||
                    (this.CliForDest != null &&
                    this.CliForDest.Equals(input.CliForDest))
                ) && 
                (
                    this.Cliforfatt == input.Cliforfatt ||
                    (this.Cliforfatt != null &&
                    this.Cliforfatt.Equals(input.Cliforfatt))
                ) && 
                (
                    this.CodbloccoMg25 == input.CodbloccoMg25 ||
                    (this.CodbloccoMg25 != null &&
                    this.CodbloccoMg25.Equals(input.CodbloccoMg25))
                ) && 
                (
                    this.CodcabCg13 == input.CodcabCg13 ||
                    (this.CodcabCg13 != null &&
                    this.CodcabCg13.Equals(input.CodcabCg13))
                ) && 
                (
                    this.CodpagCg62 == input.CodpagCg62 ||
                    (this.CodpagCg62 != null &&
                    this.CodpagCg62.Equals(input.CodpagCg62))
                ) && 
                (
                    this.Cup == input.Cup ||
                    (this.Cup != null &&
                    this.Cup.Equals(input.Cup))
                ) && 
                (
                    this.Datacambio == input.Datacambio ||
                    (this.Datacambio != null &&
                    this.Datacambio.Equals(input.Datacambio))
                ) && 
                (
                    this.Datadoc == input.Datadoc ||
                    (this.Datadoc != null &&
                    this.Datadoc.Equals(input.Datadoc))
                ) && 
                (
                    this.Datainiziopag == input.Datainiziopag ||
                    (this.Datainiziopag != null &&
                    this.Datainiziopag.Equals(input.Datainiziopag))
                ) && 
                (
                    this.Dataplafond == input.Dataplafond ||
                    (this.Dataplafond != null &&
                    this.Dataplafond.Equals(input.Dataplafond))
                ) && 
                (
                    this.Datareg == input.Datareg ||
                    (this.Datareg != null &&
                    this.Datareg.Equals(input.Datareg))
                ) && 
                (
                    this.Descraggcont == input.Descraggcont ||
                    (this.Descraggcont != null &&
                    this.Descraggcont.Equals(input.Descraggcont))
                ) && 
                (
                    this.Ditta == input.Ditta ||
                    (this.Ditta != null &&
                    this.Ditta.Equals(input.Ditta))
                ) && 
                (
                    this.FlgClifat == input.FlgClifat ||
                    (this.FlgClifat != null &&
                    this.FlgClifat.Equals(input.FlgClifat))
                ) && 
                (
                    this.FlgDocstamp == input.FlgDocstamp ||
                    (this.FlgDocstamp != null &&
                    this.FlgDocstamp.Equals(input.FlgDocstamp))
                ) && 
                (
                    this.FlgSpbolli == input.FlgSpbolli ||
                    (this.FlgSpbolli != null &&
                    this.FlgSpbolli.Equals(input.FlgSpbolli))
                ) && 
                (
                    this.FlgSpincas == input.FlgSpincas ||
                    (this.FlgSpincas != null &&
                    this.FlgSpincas.Equals(input.FlgSpincas))
                ) && 
                (
                    this.IdcontCo02 == input.IdcontCo02 ||
                    (this.IdcontCo02 != null &&
                    this.IdcontCo02.Equals(input.IdcontCo02))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.Indconvclifat == input.Indconvclifat ||
                    (this.Indconvclifat != null &&
                    this.Indconvclifat.Equals(input.Indconvclifat))
                ) && 
                (
                    this.Indfattpa == input.Indfattpa ||
                    (this.Indfattpa != null &&
                    this.Indfattpa.Equals(input.Indfattpa))
                ) && 
                (
                    this.Lastchange == input.Lastchange ||
                    (this.Lastchange != null &&
                    this.Lastchange.Equals(input.Lastchange))
                ) && 
                (
                    this.LineaFa05 == input.LineaFa05 ||
                    (this.LineaFa05 != null &&
                    this.LineaFa05.Equals(input.LineaFa05))
                ) && 
                (
                    this.Listmag == input.Listmag ||
                    (this.Listmag != null &&
                    this.Listmag.Equals(input.Listmag))
                ) && 
                (
                    this.Notedocum == input.Notedocum ||
                    (this.Notedocum != null &&
                    this.Notedocum.Equals(input.Notedocum))
                ) && 
                (
                    this.Numautof == input.Numautof ||
                    (this.Numautof != null &&
                    this.Numautof.Equals(input.Numautof))
                ) && 
                (
                    this.Numdoc == input.Numdoc ||
                    (this.Numdoc != null &&
                    this.Numdoc.Equals(input.Numdoc))
                ) && 
                (
                    this.Numdocorig == input.Numdocorig ||
                    (this.Numdocorig != null &&
                    this.Numdocorig.Equals(input.Numdocorig))
                ) && 
                (
                    this.NumReg == input.NumReg ||
                    (this.NumReg != null &&
                    this.NumReg.Equals(input.NumReg))
                ) && 
                (
                    this.ProgrEf08 == input.ProgrEf08 ||
                    (this.ProgrEf08 != null &&
                    this.ProgrEf08.Equals(input.ProgrEf08))
                ) && 
                (
                    this.Sezautof == input.Sezautof ||
                    (this.Sezautof != null &&
                    this.Sezautof.Equals(input.Sezautof))
                ) && 
                (
                    this.Sezdoc == input.Sezdoc ||
                    (this.Sezdoc != null &&
                    this.Sezdoc.Equals(input.Sezdoc))
                ) && 
                (
                    this.StagioneMg5t == input.StagioneMg5t ||
                    (this.StagioneMg5t != null &&
                    this.StagioneMg5t.Equals(input.StagioneMg5t))
                ) && 
                (
                    this.Stipodoc == input.Stipodoc ||
                    (this.Stipodoc != null &&
                    this.Stipodoc.Equals(input.Stipodoc))
                ) && 
                (
                    this.Testoletint == input.Testoletint ||
                    (this.Testoletint != null &&
                    this.Testoletint.Equals(input.Testoletint))
                ) && 
                (
                    this.Tipodoc == input.Tipodoc ||
                    (this.Tipodoc != null &&
                    this.Tipodoc.Equals(input.Tipodoc))
                ) && 
                (
                    this.Tipodocnumeraz == input.Tipodocnumeraz ||
                    (this.Tipodocnumeraz != null &&
                    this.Tipodocnumeraz.Equals(input.Tipodocnumeraz))
                ) && 
                (
                    this.Tiponumautof == input.Tiponumautof ||
                    (this.Tiponumautof != null &&
                    this.Tiponumautof.Equals(input.Tiponumautof))
                ) && 
                (
                    this.ValutaCg08 == input.ValutaCg08 ||
                    (this.ValutaCg08 != null &&
                    this.ValutaCg08.Equals(input.ValutaCg08))
                ) && 
                (
                    this.IdExtendedAttributeEntity == input.IdExtendedAttributeEntity ||
                    (this.IdExtendedAttributeEntity != null &&
                    this.IdExtendedAttributeEntity.Equals(input.IdExtendedAttributeEntity))
                ) && 
                (
                    this.IdExtendedAttributeSubEntity == input.IdExtendedAttributeSubEntity ||
                    (this.IdExtendedAttributeSubEntity != null &&
                    this.IdExtendedAttributeSubEntity.Equals(input.IdExtendedAttributeSubEntity))
                ) && 
                (
                    this.AnagraficaDocumentoDitta == input.AnagraficaDocumentoDitta ||
                    (this.AnagraficaDocumentoDitta != null &&
                    this.AnagraficaDocumentoDitta.Equals(input.AnagraficaDocumentoDitta))
                ) && 
                (
                    this.CodIva == input.CodIva ||
                    (this.CodIva != null &&
                    this.CodIva.Equals(input.CodIva))
                ) && 
                (
                    this.CustomerSupplierMG == input.CustomerSupplierMG ||
                    (this.CustomerSupplierMG != null &&
                    this.CustomerSupplierMG.Equals(input.CustomerSupplierMG))
                ) && 
                (
                    this.DocumentMaster == input.DocumentMaster ||
                    (this.DocumentMaster != null &&
                    this.DocumentMaster.Equals(input.DocumentMaster))
                ) && 
                (
                    this.DocumentoDatiAccompagnamentoMG == input.DocumentoDatiAccompagnamentoMG ||
                    (this.DocumentoDatiAccompagnamentoMG != null &&
                    this.DocumentoDatiAccompagnamentoMG.Equals(input.DocumentoDatiAccompagnamentoMG))
                ) && 
                (
                    this.DocumentoTestataAgentiMG == input.DocumentoTestataAgentiMG ||
                    this.DocumentoTestataAgentiMG != null &&
                    input.DocumentoTestataAgentiMG != null &&
                    this.DocumentoTestataAgentiMG.SequenceEqual(input.DocumentoTestataAgentiMG)
                ) && 
                (
                    this.DocumentoTestataProgettiMG == input.DocumentoTestataProgettiMG ||
                    (this.DocumentoTestataProgettiMG != null &&
                    this.DocumentoTestataProgettiMG.Equals(input.DocumentoTestataProgettiMG))
                ) && 
                (
                    this.DocumentoTestataProvvigioniMG == input.DocumentoTestataProvvigioniMG ||
                    this.DocumentoTestataProvvigioniMG != null &&
                    input.DocumentoTestataProvvigioniMG != null &&
                    this.DocumentoTestataProvvigioniMG.SequenceEqual(input.DocumentoTestataProvvigioniMG)
                ) && 
                (
                    this.DocumentoTestataRateiMG == input.DocumentoTestataRateiMG ||
                    (this.DocumentoTestataRateiMG != null &&
                    this.DocumentoTestataRateiMG.Equals(input.DocumentoTestataRateiMG))
                ) && 
                (
                    this.HeadingReferenceDocumentMG == input.HeadingReferenceDocumentMG ||
                    this.HeadingReferenceDocumentMG != null &&
                    input.HeadingReferenceDocumentMG != null &&
                    this.HeadingReferenceDocumentMG.SequenceEqual(input.HeadingReferenceDocumentMG)
                ) && 
                (
                    this.OfficeCO == input.OfficeCO ||
                    (this.OfficeCO != null &&
                    this.OfficeCO.Equals(input.OfficeCO))
                ) && 
                (
                    this.Righe == input.Righe ||
                    this.Righe != null &&
                    input.Righe != null &&
                    this.Righe.SequenceEqual(input.Righe)
                ) && 
                (
                    this.StatoAttuale == input.StatoAttuale ||
                    (this.StatoAttuale != null &&
                    this.StatoAttuale.Equals(input.StatoAttuale))
                ) && 
                (
                    this.StorageWH == input.StorageWH ||
                    (this.StorageWH != null &&
                    this.StorageWH.Equals(input.StorageWH))
                ) && 
                (
                    this.StorageWHCollegato == input.StorageWHCollegato ||
                    (this.StorageWHCollegato != null &&
                    this.StorageWHCollegato.Equals(input.StorageWHCollegato))
                ) && 
                (
                    this.TestataEstesa == input.TestataEstesa ||
                    this.TestataEstesa != null &&
                    input.TestataEstesa != null &&
                    this.TestataEstesa.SequenceEqual(input.TestataEstesa)
                ) && 
                (
                    this.TestataOrdine == input.TestataOrdine ||
                    (this.TestataOrdine != null &&
                    this.TestataOrdine.Equals(input.TestataOrdine))
                ) && 
                (
                    this.TestataPersonalizzata == input.TestataPersonalizzata ||
                    this.TestataPersonalizzata != null &&
                    input.TestataPersonalizzata != null &&
                    this.TestataPersonalizzata.SequenceEqual(input.TestataPersonalizzata)
                ) && 
                (
                    this.TotaliDocumento == input.TotaliDocumento ||
                    (this.TotaliDocumento != null &&
                    this.TotaliDocumento.Equals(input.TotaliDocumento))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Guid != null)
                    hashCode = hashCode * 59 + this.Guid.GetHashCode();
                if (this.EsclusioneAgentiMultipli != null)
                    hashCode = hashCode * 59 + this.EsclusioneAgentiMultipli.GetHashCode();
                if (this.EsclusioneIvaTestata != null)
                    hashCode = hashCode * 59 + this.EsclusioneIvaTestata.GetHashCode();
                if (this.FlgLockOnDocExist != null)
                    hashCode = hashCode * 59 + this.FlgLockOnDocExist.GetHashCode();
                if (this.Acconto != null)
                    hashCode = hashCode * 59 + this.Acconto.GetHashCode();
                if (this.Abbuono != null)
                    hashCode = hashCode * 59 + this.Abbuono.GetHashCode();
                if (this.CallOptions != null)
                    hashCode = hashCode * 59 + this.CallOptions.GetHashCode();
                if (this.BancaCg12 != null)
                    hashCode = hashCode * 59 + this.BancaCg12.GetHashCode();
                if (this.Cambio != null)
                    hashCode = hashCode * 59 + this.Cambio.GetHashCode();
                if (this.CauprestCg15 != null)
                    hashCode = hashCode * 59 + this.CauprestCg15.GetHashCode();
                if (this.CausmagMg51 != null)
                    hashCode = hashCode * 59 + this.CausmagMg51.GetHashCode();
                if (this.Cig != null)
                    hashCode = hashCode * 59 + this.Cig.GetHashCode();
                if (this.CliForDest != null)
                    hashCode = hashCode * 59 + this.CliForDest.GetHashCode();
                if (this.Cliforfatt != null)
                    hashCode = hashCode * 59 + this.Cliforfatt.GetHashCode();
                if (this.CodbloccoMg25 != null)
                    hashCode = hashCode * 59 + this.CodbloccoMg25.GetHashCode();
                if (this.CodcabCg13 != null)
                    hashCode = hashCode * 59 + this.CodcabCg13.GetHashCode();
                if (this.CodpagCg62 != null)
                    hashCode = hashCode * 59 + this.CodpagCg62.GetHashCode();
                if (this.Cup != null)
                    hashCode = hashCode * 59 + this.Cup.GetHashCode();
                if (this.Datacambio != null)
                    hashCode = hashCode * 59 + this.Datacambio.GetHashCode();
                if (this.Datadoc != null)
                    hashCode = hashCode * 59 + this.Datadoc.GetHashCode();
                if (this.Datainiziopag != null)
                    hashCode = hashCode * 59 + this.Datainiziopag.GetHashCode();
                if (this.Dataplafond != null)
                    hashCode = hashCode * 59 + this.Dataplafond.GetHashCode();
                if (this.Datareg != null)
                    hashCode = hashCode * 59 + this.Datareg.GetHashCode();
                if (this.Descraggcont != null)
                    hashCode = hashCode * 59 + this.Descraggcont.GetHashCode();
                if (this.Ditta != null)
                    hashCode = hashCode * 59 + this.Ditta.GetHashCode();
                if (this.FlgClifat != null)
                    hashCode = hashCode * 59 + this.FlgClifat.GetHashCode();
                if (this.FlgDocstamp != null)
                    hashCode = hashCode * 59 + this.FlgDocstamp.GetHashCode();
                if (this.FlgSpbolli != null)
                    hashCode = hashCode * 59 + this.FlgSpbolli.GetHashCode();
                if (this.FlgSpincas != null)
                    hashCode = hashCode * 59 + this.FlgSpincas.GetHashCode();
                if (this.IdcontCo02 != null)
                    hashCode = hashCode * 59 + this.IdcontCo02.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.Indconvclifat != null)
                    hashCode = hashCode * 59 + this.Indconvclifat.GetHashCode();
                if (this.Indfattpa != null)
                    hashCode = hashCode * 59 + this.Indfattpa.GetHashCode();
                if (this.Lastchange != null)
                    hashCode = hashCode * 59 + this.Lastchange.GetHashCode();
                if (this.LineaFa05 != null)
                    hashCode = hashCode * 59 + this.LineaFa05.GetHashCode();
                if (this.Listmag != null)
                    hashCode = hashCode * 59 + this.Listmag.GetHashCode();
                if (this.Notedocum != null)
                    hashCode = hashCode * 59 + this.Notedocum.GetHashCode();
                if (this.Numautof != null)
                    hashCode = hashCode * 59 + this.Numautof.GetHashCode();
                if (this.Numdoc != null)
                    hashCode = hashCode * 59 + this.Numdoc.GetHashCode();
                if (this.Numdocorig != null)
                    hashCode = hashCode * 59 + this.Numdocorig.GetHashCode();
                if (this.NumReg != null)
                    hashCode = hashCode * 59 + this.NumReg.GetHashCode();
                if (this.ProgrEf08 != null)
                    hashCode = hashCode * 59 + this.ProgrEf08.GetHashCode();
                if (this.Sezautof != null)
                    hashCode = hashCode * 59 + this.Sezautof.GetHashCode();
                if (this.Sezdoc != null)
                    hashCode = hashCode * 59 + this.Sezdoc.GetHashCode();
                if (this.StagioneMg5t != null)
                    hashCode = hashCode * 59 + this.StagioneMg5t.GetHashCode();
                if (this.Stipodoc != null)
                    hashCode = hashCode * 59 + this.Stipodoc.GetHashCode();
                if (this.Testoletint != null)
                    hashCode = hashCode * 59 + this.Testoletint.GetHashCode();
                if (this.Tipodoc != null)
                    hashCode = hashCode * 59 + this.Tipodoc.GetHashCode();
                if (this.Tipodocnumeraz != null)
                    hashCode = hashCode * 59 + this.Tipodocnumeraz.GetHashCode();
                if (this.Tiponumautof != null)
                    hashCode = hashCode * 59 + this.Tiponumautof.GetHashCode();
                if (this.ValutaCg08 != null)
                    hashCode = hashCode * 59 + this.ValutaCg08.GetHashCode();
                if (this.IdExtendedAttributeEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeEntity.GetHashCode();
                if (this.IdExtendedAttributeSubEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeSubEntity.GetHashCode();
                if (this.AnagraficaDocumentoDitta != null)
                    hashCode = hashCode * 59 + this.AnagraficaDocumentoDitta.GetHashCode();
                if (this.CodIva != null)
                    hashCode = hashCode * 59 + this.CodIva.GetHashCode();
                if (this.CustomerSupplierMG != null)
                    hashCode = hashCode * 59 + this.CustomerSupplierMG.GetHashCode();
                if (this.DocumentMaster != null)
                    hashCode = hashCode * 59 + this.DocumentMaster.GetHashCode();
                if (this.DocumentoDatiAccompagnamentoMG != null)
                    hashCode = hashCode * 59 + this.DocumentoDatiAccompagnamentoMG.GetHashCode();
                if (this.DocumentoTestataAgentiMG != null)
                    hashCode = hashCode * 59 + this.DocumentoTestataAgentiMG.GetHashCode();
                if (this.DocumentoTestataProgettiMG != null)
                    hashCode = hashCode * 59 + this.DocumentoTestataProgettiMG.GetHashCode();
                if (this.DocumentoTestataProvvigioniMG != null)
                    hashCode = hashCode * 59 + this.DocumentoTestataProvvigioniMG.GetHashCode();
                if (this.DocumentoTestataRateiMG != null)
                    hashCode = hashCode * 59 + this.DocumentoTestataRateiMG.GetHashCode();
                if (this.HeadingReferenceDocumentMG != null)
                    hashCode = hashCode * 59 + this.HeadingReferenceDocumentMG.GetHashCode();
                if (this.OfficeCO != null)
                    hashCode = hashCode * 59 + this.OfficeCO.GetHashCode();
                if (this.Righe != null)
                    hashCode = hashCode * 59 + this.Righe.GetHashCode();
                if (this.StatoAttuale != null)
                    hashCode = hashCode * 59 + this.StatoAttuale.GetHashCode();
                if (this.StorageWH != null)
                    hashCode = hashCode * 59 + this.StorageWH.GetHashCode();
                if (this.StorageWHCollegato != null)
                    hashCode = hashCode * 59 + this.StorageWHCollegato.GetHashCode();
                if (this.TestataEstesa != null)
                    hashCode = hashCode * 59 + this.TestataEstesa.GetHashCode();
                if (this.TestataOrdine != null)
                    hashCode = hashCode * 59 + this.TestataOrdine.GetHashCode();
                if (this.TestataPersonalizzata != null)
                    hashCode = hashCode * 59 + this.TestataPersonalizzata.GetHashCode();
                if (this.TotaliDocumento != null)
                    hashCode = hashCode * 59 + this.TotaliDocumento.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
