/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG97_UBICAZ - Ubicazione&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;CodDepMg58&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Ubicaz&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class LocationWHDTO :  IEquatable<LocationWHDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LocationWHDTO" /> class.
        /// </summary>
        /// <param name="altezza">MG97_ALTEZZA - Altezza.</param>
        /// <param name="codClassestoc">MG97_CODCLASSESTOC - Classe stoccaggio.</param>
        /// <param name="codDepMg58">MG97_CODDEP_MG58 - Codice deposito (required).</param>
        /// <param name="codPriorriemp">MG97_CODPRIORRIEMP - Priorità di riempimento.</param>
        /// <param name="coordin1">MG97_COORDIN1 - Coordinata 1.</param>
        /// <param name="coordin2">MG97_COORDIN2 - Coordinata 2.</param>
        /// <param name="coordin3">MG97_COORDIN3 - Coordinata 3.</param>
        /// <param name="descubicaz">MG97_DESCUBICAZ - Descrizione ubicazione (required).</param>
        /// <param name="dittaCg18">MG97_DITTA_CG18 - Codice ditta (default to 0).</param>
        /// <param name="indTipoubicaz">MG97_INDTIPOUBICAZ - Tipo ubicazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Di prelevamento&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Di scorta&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="larghezza">MG97_LARGHEZZA - Larghezza.</param>
        /// <param name="maxpeso">MG97_MAXPESO - Massimo peso.</param>
        /// <param name="profondita">MG97_PROFONDITA - Profondità.</param>
        /// <param name="ubicaz">MG97_UBICAZ - Codice ubicazione (required).</param>
        /// <param name="umdimens">MG97_UMDIMENS - UM dimensione.</param>
        /// <param name="umpeso">MG97_UMPESO - UM Peso.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public LocationWHDTO(double? altezza = default(double?), double? codClassestoc = default(double?), string codDepMg58 = default(string), double? codPriorriemp = default(double?), string coordin1 = default(string), string coordin2 = default(string), string coordin3 = default(string), string descubicaz = default(string), double? dittaCg18 = 0, double? indTipoubicaz = 0, double? larghezza = default(double?), double? maxpeso = default(double?), double? profondita = default(double?), string ubicaz = default(string), string umdimens = default(string), string umpeso = default(string), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codDepMg58" is required (not null)
            if (codDepMg58 == null)
            {
                throw new InvalidDataException("codDepMg58 is a required property for LocationWHDTO and cannot be null");
            }
            else
            {
                this.CodDepMg58 = codDepMg58;
            }
            // to ensure "descubicaz" is required (not null)
            if (descubicaz == null)
            {
                throw new InvalidDataException("descubicaz is a required property for LocationWHDTO and cannot be null");
            }
            else
            {
                this.Descubicaz = descubicaz;
            }
            // to ensure "ubicaz" is required (not null)
            if (ubicaz == null)
            {
                throw new InvalidDataException("ubicaz is a required property for LocationWHDTO and cannot be null");
            }
            else
            {
                this.Ubicaz = ubicaz;
            }
            this.Altezza = altezza;
            this.CodClassestoc = codClassestoc;
            this.CodPriorriemp = codPriorriemp;
            this.Coordin1 = coordin1;
            this.Coordin2 = coordin2;
            this.Coordin3 = coordin3;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // use default value if no "indTipoubicaz" provided
            if (indTipoubicaz == null)
            {
                this.IndTipoubicaz = 0;
            }
            else
            {
                this.IndTipoubicaz = indTipoubicaz;
            }
            this.Larghezza = larghezza;
            this.Maxpeso = maxpeso;
            this.Profondita = profondita;
            this.Umdimens = umdimens;
            this.Umpeso = umpeso;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG97_ALTEZZA - Altezza
        /// </summary>
        /// <value>MG97_ALTEZZA - Altezza</value>
        [DataMember(Name="altezza", EmitDefaultValue=false)]
        public double? Altezza { get; set; }

        /// <summary>
        /// MG97_CODCLASSESTOC - Classe stoccaggio
        /// </summary>
        /// <value>MG97_CODCLASSESTOC - Classe stoccaggio</value>
        [DataMember(Name="codClassestoc", EmitDefaultValue=false)]
        public double? CodClassestoc { get; set; }

        /// <summary>
        /// MG97_CODDEP_MG58 - Codice deposito
        /// </summary>
        /// <value>MG97_CODDEP_MG58 - Codice deposito</value>
        [DataMember(Name="codDepMg58", EmitDefaultValue=false)]
        public string CodDepMg58 { get; set; }

        /// <summary>
        /// MG97_CODPRIORRIEMP - Priorità di riempimento
        /// </summary>
        /// <value>MG97_CODPRIORRIEMP - Priorità di riempimento</value>
        [DataMember(Name="codPriorriemp", EmitDefaultValue=false)]
        public double? CodPriorriemp { get; set; }

        /// <summary>
        /// MG97_COORDIN1 - Coordinata 1
        /// </summary>
        /// <value>MG97_COORDIN1 - Coordinata 1</value>
        [DataMember(Name="coordin1", EmitDefaultValue=false)]
        public string Coordin1 { get; set; }

        /// <summary>
        /// MG97_COORDIN2 - Coordinata 2
        /// </summary>
        /// <value>MG97_COORDIN2 - Coordinata 2</value>
        [DataMember(Name="coordin2", EmitDefaultValue=false)]
        public string Coordin2 { get; set; }

        /// <summary>
        /// MG97_COORDIN3 - Coordinata 3
        /// </summary>
        /// <value>MG97_COORDIN3 - Coordinata 3</value>
        [DataMember(Name="coordin3", EmitDefaultValue=false)]
        public string Coordin3 { get; set; }

        /// <summary>
        /// MG97_DESCUBICAZ - Descrizione ubicazione
        /// </summary>
        /// <value>MG97_DESCUBICAZ - Descrizione ubicazione</value>
        [DataMember(Name="descubicaz", EmitDefaultValue=false)]
        public string Descubicaz { get; set; }

        /// <summary>
        /// MG97_DITTA_CG18 - Codice ditta
        /// </summary>
        /// <value>MG97_DITTA_CG18 - Codice ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG97_INDTIPOUBICAZ - Tipo ubicazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Di prelevamento&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Di scorta&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG97_INDTIPOUBICAZ - Tipo ubicazione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Di prelevamento&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Di scorta&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indTipoubicaz", EmitDefaultValue=false)]
        public double? IndTipoubicaz { get; set; }

        /// <summary>
        /// MG97_LARGHEZZA - Larghezza
        /// </summary>
        /// <value>MG97_LARGHEZZA - Larghezza</value>
        [DataMember(Name="larghezza", EmitDefaultValue=false)]
        public double? Larghezza { get; set; }

        /// <summary>
        /// MG97_MAXPESO - Massimo peso
        /// </summary>
        /// <value>MG97_MAXPESO - Massimo peso</value>
        [DataMember(Name="maxpeso", EmitDefaultValue=false)]
        public double? Maxpeso { get; set; }

        /// <summary>
        /// MG97_PROFONDITA - Profondità
        /// </summary>
        /// <value>MG97_PROFONDITA - Profondità</value>
        [DataMember(Name="profondita", EmitDefaultValue=false)]
        public double? Profondita { get; set; }

        /// <summary>
        /// MG97_UBICAZ - Codice ubicazione
        /// </summary>
        /// <value>MG97_UBICAZ - Codice ubicazione</value>
        [DataMember(Name="ubicaz", EmitDefaultValue=false)]
        public string Ubicaz { get; set; }

        /// <summary>
        /// MG97_UMDIMENS - UM dimensione
        /// </summary>
        /// <value>MG97_UMDIMENS - UM dimensione</value>
        [DataMember(Name="umdimens", EmitDefaultValue=false)]
        public string Umdimens { get; set; }

        /// <summary>
        /// MG97_UMPESO - UM Peso
        /// </summary>
        /// <value>MG97_UMPESO - UM Peso</value>
        [DataMember(Name="umpeso", EmitDefaultValue=false)]
        public string Umpeso { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class LocationWHDTO {\n");
            sb.Append("  Altezza: ").Append(Altezza).Append("\n");
            sb.Append("  CodClassestoc: ").Append(CodClassestoc).Append("\n");
            sb.Append("  CodDepMg58: ").Append(CodDepMg58).Append("\n");
            sb.Append("  CodPriorriemp: ").Append(CodPriorriemp).Append("\n");
            sb.Append("  Coordin1: ").Append(Coordin1).Append("\n");
            sb.Append("  Coordin2: ").Append(Coordin2).Append("\n");
            sb.Append("  Coordin3: ").Append(Coordin3).Append("\n");
            sb.Append("  Descubicaz: ").Append(Descubicaz).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  IndTipoubicaz: ").Append(IndTipoubicaz).Append("\n");
            sb.Append("  Larghezza: ").Append(Larghezza).Append("\n");
            sb.Append("  Maxpeso: ").Append(Maxpeso).Append("\n");
            sb.Append("  Profondita: ").Append(Profondita).Append("\n");
            sb.Append("  Ubicaz: ").Append(Ubicaz).Append("\n");
            sb.Append("  Umdimens: ").Append(Umdimens).Append("\n");
            sb.Append("  Umpeso: ").Append(Umpeso).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as LocationWHDTO);
        }

        /// <summary>
        /// Returns true if LocationWHDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of LocationWHDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(LocationWHDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Altezza == input.Altezza ||
                    (this.Altezza != null &&
                    this.Altezza.Equals(input.Altezza))
                ) && 
                (
                    this.CodClassestoc == input.CodClassestoc ||
                    (this.CodClassestoc != null &&
                    this.CodClassestoc.Equals(input.CodClassestoc))
                ) && 
                (
                    this.CodDepMg58 == input.CodDepMg58 ||
                    (this.CodDepMg58 != null &&
                    this.CodDepMg58.Equals(input.CodDepMg58))
                ) && 
                (
                    this.CodPriorriemp == input.CodPriorriemp ||
                    (this.CodPriorriemp != null &&
                    this.CodPriorriemp.Equals(input.CodPriorriemp))
                ) && 
                (
                    this.Coordin1 == input.Coordin1 ||
                    (this.Coordin1 != null &&
                    this.Coordin1.Equals(input.Coordin1))
                ) && 
                (
                    this.Coordin2 == input.Coordin2 ||
                    (this.Coordin2 != null &&
                    this.Coordin2.Equals(input.Coordin2))
                ) && 
                (
                    this.Coordin3 == input.Coordin3 ||
                    (this.Coordin3 != null &&
                    this.Coordin3.Equals(input.Coordin3))
                ) && 
                (
                    this.Descubicaz == input.Descubicaz ||
                    (this.Descubicaz != null &&
                    this.Descubicaz.Equals(input.Descubicaz))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.IndTipoubicaz == input.IndTipoubicaz ||
                    (this.IndTipoubicaz != null &&
                    this.IndTipoubicaz.Equals(input.IndTipoubicaz))
                ) && 
                (
                    this.Larghezza == input.Larghezza ||
                    (this.Larghezza != null &&
                    this.Larghezza.Equals(input.Larghezza))
                ) && 
                (
                    this.Maxpeso == input.Maxpeso ||
                    (this.Maxpeso != null &&
                    this.Maxpeso.Equals(input.Maxpeso))
                ) && 
                (
                    this.Profondita == input.Profondita ||
                    (this.Profondita != null &&
                    this.Profondita.Equals(input.Profondita))
                ) && 
                (
                    this.Ubicaz == input.Ubicaz ||
                    (this.Ubicaz != null &&
                    this.Ubicaz.Equals(input.Ubicaz))
                ) && 
                (
                    this.Umdimens == input.Umdimens ||
                    (this.Umdimens != null &&
                    this.Umdimens.Equals(input.Umdimens))
                ) && 
                (
                    this.Umpeso == input.Umpeso ||
                    (this.Umpeso != null &&
                    this.Umpeso.Equals(input.Umpeso))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Altezza != null)
                    hashCode = hashCode * 59 + this.Altezza.GetHashCode();
                if (this.CodClassestoc != null)
                    hashCode = hashCode * 59 + this.CodClassestoc.GetHashCode();
                if (this.CodDepMg58 != null)
                    hashCode = hashCode * 59 + this.CodDepMg58.GetHashCode();
                if (this.CodPriorriemp != null)
                    hashCode = hashCode * 59 + this.CodPriorriemp.GetHashCode();
                if (this.Coordin1 != null)
                    hashCode = hashCode * 59 + this.Coordin1.GetHashCode();
                if (this.Coordin2 != null)
                    hashCode = hashCode * 59 + this.Coordin2.GetHashCode();
                if (this.Coordin3 != null)
                    hashCode = hashCode * 59 + this.Coordin3.GetHashCode();
                if (this.Descubicaz != null)
                    hashCode = hashCode * 59 + this.Descubicaz.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.IndTipoubicaz != null)
                    hashCode = hashCode * 59 + this.IndTipoubicaz.GetHashCode();
                if (this.Larghezza != null)
                    hashCode = hashCode * 59 + this.Larghezza.GetHashCode();
                if (this.Maxpeso != null)
                    hashCode = hashCode * 59 + this.Maxpeso.GetHashCode();
                if (this.Profondita != null)
                    hashCode = hashCode * 59 + this.Profondita.GetHashCode();
                if (this.Ubicaz != null)
                    hashCode = hashCode * 59 + this.Ubicaz.GetHashCode();
                if (this.Umdimens != null)
                    hashCode = hashCode * 59 + this.Umdimens.GetHashCode();
                if (this.Umpeso != null)
                    hashCode = hashCode * 59 + this.Umpeso.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
