/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG4F_PARAMMOVLOTTI - Parametri Lotti&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Prog&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class LotMovParameterWHDTO :  IEquatable<LotMovParameterWHDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LotMovParameterWHDTO" /> class.
        /// </summary>
        /// <param name="dittaCg18">MG4F_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="flgAggprogval">MG4F_FLGAGGPROGVAL - Gestione progressivi di magazzino a valore (default to 0).</param>
        /// <param name="flgNote">MG4F_FLGNOTE - Gestione note (default to 0).</param>
        /// <param name="indGiacsca">MG4F_INDGIACSCA - Indicatore scarichi con giacenza negativa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Non gestito&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Segnala se in scarico la giacenza è negativa (senza blocco)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Blocco se in scarico la giacenza è negativa&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="prog">MG4F_PROG - Progressivo (required).</param>
        /// <param name="tipomov">MG4F_TIPOMOV - Tipo movimento.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public LotMovParameterWHDTO(double? dittaCg18 = 0, double? flgAggprogval = 0, double? flgNote = 0, double? indGiacsca = default(double?), double? prog = default(double?), string tipomov = default(string), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "prog" is required (not null)
            if (prog == null)
            {
                throw new InvalidDataException("prog is a required property for LotMovParameterWHDTO and cannot be null");
            }
            else
            {
                this.Prog = prog;
            }
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            // use default value if no "flgAggprogval" provided
            if (flgAggprogval == null)
            {
                this.FlgAggprogval = 0;
            }
            else
            {
                this.FlgAggprogval = flgAggprogval;
            }
            // use default value if no "flgNote" provided
            if (flgNote == null)
            {
                this.FlgNote = 0;
            }
            else
            {
                this.FlgNote = flgNote;
            }
            this.IndGiacsca = indGiacsca;
            this.Tipomov = tipomov;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG4F_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG4F_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG4F_FLGAGGPROGVAL - Gestione progressivi di magazzino a valore
        /// </summary>
        /// <value>MG4F_FLGAGGPROGVAL - Gestione progressivi di magazzino a valore</value>
        [DataMember(Name="flgAggprogval", EmitDefaultValue=false)]
        public double? FlgAggprogval { get; set; }

        /// <summary>
        /// MG4F_FLGNOTE - Gestione note
        /// </summary>
        /// <value>MG4F_FLGNOTE - Gestione note</value>
        [DataMember(Name="flgNote", EmitDefaultValue=false)]
        public double? FlgNote { get; set; }

        /// <summary>
        /// MG4F_INDGIACSCA - Indicatore scarichi con giacenza negativa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Non gestito&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Segnala se in scarico la giacenza è negativa (senza blocco)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Blocco se in scarico la giacenza è negativa&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG4F_INDGIACSCA - Indicatore scarichi con giacenza negativa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Non gestito&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Segnala se in scarico la giacenza è negativa (senza blocco)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Blocco se in scarico la giacenza è negativa&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indGiacsca", EmitDefaultValue=false)]
        public double? IndGiacsca { get; set; }

        /// <summary>
        /// MG4F_PROG - Progressivo
        /// </summary>
        /// <value>MG4F_PROG - Progressivo</value>
        [DataMember(Name="prog", EmitDefaultValue=false)]
        public double? Prog { get; set; }

        /// <summary>
        /// MG4F_TIPOMOV - Tipo movimento
        /// </summary>
        /// <value>MG4F_TIPOMOV - Tipo movimento</value>
        [DataMember(Name="tipomov", EmitDefaultValue=false)]
        public string Tipomov { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class LotMovParameterWHDTO {\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgAggprogval: ").Append(FlgAggprogval).Append("\n");
            sb.Append("  FlgNote: ").Append(FlgNote).Append("\n");
            sb.Append("  IndGiacsca: ").Append(IndGiacsca).Append("\n");
            sb.Append("  Prog: ").Append(Prog).Append("\n");
            sb.Append("  Tipomov: ").Append(Tipomov).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as LotMovParameterWHDTO);
        }

        /// <summary>
        /// Returns true if LotMovParameterWHDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of LotMovParameterWHDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(LotMovParameterWHDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgAggprogval == input.FlgAggprogval ||
                    (this.FlgAggprogval != null &&
                    this.FlgAggprogval.Equals(input.FlgAggprogval))
                ) && 
                (
                    this.FlgNote == input.FlgNote ||
                    (this.FlgNote != null &&
                    this.FlgNote.Equals(input.FlgNote))
                ) && 
                (
                    this.IndGiacsca == input.IndGiacsca ||
                    (this.IndGiacsca != null &&
                    this.IndGiacsca.Equals(input.IndGiacsca))
                ) && 
                (
                    this.Prog == input.Prog ||
                    (this.Prog != null &&
                    this.Prog.Equals(input.Prog))
                ) && 
                (
                    this.Tipomov == input.Tipomov ||
                    (this.Tipomov != null &&
                    this.Tipomov.Equals(input.Tipomov))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgAggprogval != null)
                    hashCode = hashCode * 59 + this.FlgAggprogval.GetHashCode();
                if (this.FlgNote != null)
                    hashCode = hashCode * 59 + this.FlgNote.GetHashCode();
                if (this.IndGiacsca != null)
                    hashCode = hashCode * 59 + this.IndGiacsca.GetHashCode();
                if (this.Prog != null)
                    hashCode = hashCode * 59 + this.Prog.GetHashCode();
                if (this.Tipomov != null)
                    hashCode = hashCode * 59 + this.Tipomov.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
