/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG24_CLIFORRAG - Raggr. prevalente&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;CliforCg44&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;CodRag&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class RaggruppamentoCliForMGDTO :  IEquatable<RaggruppamentoCliForMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="RaggruppamentoCliForMGDTO" /> class.
        /// </summary>
        /// <param name="cliforCg44">MG24_CLIFOR_CG44 - Codice Cliente / Fornitore (required).</param>
        /// <param name="codRag">MG24_CODRAG - Codice raggruppamento (required).</param>
        /// <param name="descragg">MG24_DESCRAGG - Descrizione raggruppamento (required).</param>
        /// <param name="dittaCg18">MG24_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="idmediaCg99">MG24_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public RaggruppamentoCliForMGDTO(double? cliforCg44 = default(double?), string codRag = default(string), string descragg = default(string), double? dittaCg18 = 0, double? idmediaCg99 = default(double?), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "cliforCg44" is required (not null)
            if (cliforCg44 == null)
            {
                throw new InvalidDataException("cliforCg44 is a required property for RaggruppamentoCliForMGDTO and cannot be null");
            }
            else
            {
                this.CliforCg44 = cliforCg44;
            }
            // to ensure "codRag" is required (not null)
            if (codRag == null)
            {
                throw new InvalidDataException("codRag is a required property for RaggruppamentoCliForMGDTO and cannot be null");
            }
            else
            {
                this.CodRag = codRag;
            }
            // to ensure "descragg" is required (not null)
            if (descragg == null)
            {
                throw new InvalidDataException("descragg is a required property for RaggruppamentoCliForMGDTO and cannot be null");
            }
            else
            {
                this.Descragg = descragg;
            }
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.IdmediaCg99 = idmediaCg99;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG24_CLIFOR_CG44 - Codice Cliente / Fornitore
        /// </summary>
        /// <value>MG24_CLIFOR_CG44 - Codice Cliente / Fornitore</value>
        [DataMember(Name="cliforCg44", EmitDefaultValue=false)]
        public double? CliforCg44 { get; set; }

        /// <summary>
        /// MG24_CODRAG - Codice raggruppamento
        /// </summary>
        /// <value>MG24_CODRAG - Codice raggruppamento</value>
        [DataMember(Name="codRag", EmitDefaultValue=false)]
        public string CodRag { get; set; }

        /// <summary>
        /// MG24_DESCRAGG - Descrizione raggruppamento
        /// </summary>
        /// <value>MG24_DESCRAGG - Descrizione raggruppamento</value>
        [DataMember(Name="descragg", EmitDefaultValue=false)]
        public string Descragg { get; set; }

        /// <summary>
        /// MG24_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG24_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG24_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG24_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class RaggruppamentoCliForMGDTO {\n");
            sb.Append("  CliforCg44: ").Append(CliforCg44).Append("\n");
            sb.Append("  CodRag: ").Append(CodRag).Append("\n");
            sb.Append("  Descragg: ").Append(Descragg).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as RaggruppamentoCliForMGDTO);
        }

        /// <summary>
        /// Returns true if RaggruppamentoCliForMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of RaggruppamentoCliForMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(RaggruppamentoCliForMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.CliforCg44 == input.CliforCg44 ||
                    (this.CliforCg44 != null &&
                    this.CliforCg44.Equals(input.CliforCg44))
                ) && 
                (
                    this.CodRag == input.CodRag ||
                    (this.CodRag != null &&
                    this.CodRag.Equals(input.CodRag))
                ) && 
                (
                    this.Descragg == input.Descragg ||
                    (this.Descragg != null &&
                    this.Descragg.Equals(input.Descragg))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.CliforCg44 != null)
                    hashCode = hashCode * 59 + this.CliforCg44.GetHashCode();
                if (this.CodRag != null)
                    hashCode = hashCode * 59 + this.CodRag.GetHashCode();
                if (this.Descragg != null)
                    hashCode = hashCode * 59 + this.Descragg.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
