'use strict';


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns CustomerSupplierExtensionMGDTO
 **/
exports.apiV1EnvironmentMGCustomerSupplierExtensionMGIdGET = function(id,environment,tipocfCg44,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cliforCg44" : 0.8008281904610115,
  "indarrinfat" : 1.2315135367772556,
  "indprefstdoc" : 4.965218492984954,
  "sc2percor" : 6.438423552598547,
  "ggcons" : 2.027123023002322,
  "flgesclspepor" : 5.637376656633329,
  "tipoclxdoc" : 6.778324963048013,
  "coddocumMg3g" : "coddocumMg3g",
  "indtestof2" : "0",
  "impdaarrot" : 7.386281948385884,
  "indtestof1" : 9.965781217890562,
  "pluginData" : {
    "key" : ""
  },
  "flgrottsingdoc" : 3.616076749251911,
  "scimpcor" : 6.965117697638846,
  "additionalData" : {
    "key" : ""
  },
  "dataultord" : "2000-01-23T04:56:07.000+00:00",
  "magpercor" : 6.683562403749608,
  "sc1percor" : 9.018348186070783,
  "extensionData" : [ null, null ],
  "dittaCg18" : 6.027456183070403,
  "magimpcor" : 9.369310271410669,
  "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
  "flgart62ctr" : 1,
  "imparrotprec" : 4.145608029883936,
  "tipocfCg44" : 2.8841621266687802,
  "indstscadest" : 5.025004791520295,
  "indclifat" : 1.4894159098541704,
  "scperpiede" : 1.284659006116532,
  "dataultfat" : "2000-01-23T04:56:07.000+00:00",
  "punlis99pre" : 8.762042012749001,
  "cliForFatturazione" : {
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 4,
        "idStato" : 5,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 9,
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "extensionData" : [ null, null ]
    },
    "contratto" : "contratto",
    "idCliFor" : 8,
    "idmediaCg99" : 7.740351818741173,
    "blackListGeneralMasterData" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed",
          "extensionData" : [ null, null ]
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "extensionData" : [ null, null ],
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "extensionData" : [ null, null ],
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "extensionData" : [ null, null ],
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed",
          "extensionData" : [ null, null ]
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "extensionData" : [ null, null ],
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "extensionData" : [ null, null ],
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "extensionData" : [ null, null ],
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 7,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 7.061401241503109,
      "indsoggrit" : 7.457744773683766,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9,
        "extensionData" : [ null, null ]
      },
      "statofiscCg07" : 5.025004791520295,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 2,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 9,
      "citta" : "citta",
      "statonascitaCg07" : 9.965781217890562,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ null, null ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 1.2315135367772556,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.84685269835264,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 0.8774076871421566,
        "flgRegagevo" : 4.86315908102884,
        "idmediaCg99" : 3.901545264248647,
        "percRipPerc" : 1.8268702177058116,
        "flgRitImposta" : 6.073898085781152,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 9.254183946267839,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 7.933506881737151,
        "flgProteo360" : 5.507386964179881,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 9.702963800023566,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 4,
        "idprov" : 0.43431398824148815,
        "codice" : "codice",
        "extensionData" : [ null, null ],
        "percci" : 4.573936264232251,
        "flgSosprit" : 8,
        "descr" : "descr",
        "flgMinimi" : 0,
        "codTributo" : "codTributo",
        "indCodattglad" : 2.9409642974827896,
        "indTipocassa" : 1,
        "percra" : 8.863729185622827,
        "percbaseimp" : 6.623518433804886,
        "codTribrp" : "codTribrp",
        "inpsivs" : 8.28965939814297,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 3.616076749251911,
      "codiceCgc0" : 9.301444243932576,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 1.0246457001441578,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 4.145608029883936,
      "rapazestCg16" : 1,
      "cellnum" : "cellnum",
      "flgPrsfis" : 1.4894159098541704,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 6,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 4.965218492984954,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 5,
      "indweb" : "indweb"
    },
    "goods" : {
      "reverseTypeFI" : {
        "reverseTypeCode" : 3,
        "reverseTypeDescription" : "reverseTypeDescription",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "flgBilconsattpassdist" : 8,
      "contochiu" : "contochiu",
      "flgAnalit" : 2,
      "codeformatted" : "codeformatted",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9,
        "extensionData" : [ null, null ]
      },
      "flgAggfatt" : 2,
      "indLivchius" : 7,
      "idcontoratattCg24" : 5,
      "idcontoapeCg24" : 9,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contocrsosp" : "contocrsosp",
      "flgContoimm" : 2,
      "flgOpnonfin" : 5.829097284708605,
      "indDaavec" : 7,
      "cogeprogeMateriali" : 9,
      "coaAccountCustomizationFI" : [ {
        "descr" : "descr",
        "iddespcon" : 8,
        "dittaCg18" : 3.8581948879558317,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 0.9178980228274691,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 1.9732909296667345,
        "extensionData" : [ null, null ],
        "idCg24" : 4,
        "rowversion" : ""
      }, {
        "descr" : "descr",
        "iddespcon" : 8,
        "dittaCg18" : 3.8581948879558317,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 0.9178980228274691,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 1.9732909296667345,
        "extensionData" : [ null, null ],
        "idCg24" : 4,
        "rowversion" : ""
      } ],
      "accountType" : 8,
      "contoratpass" : "contoratpass",
      "extensionData" : [ null, null ],
      "descr" : "descr",
      "idcontorisattCg24" : 8,
      "indDaav" : 1,
      "suddconti" : 3.8601930294054942,
      "contoratatt" : "contoratatt",
      "indMastroCliFor" : 1.0348002257634148,
      "idcontochiuCg24" : 2,
      "percindetra" : 1.1864130338603074,
      "codiceCg22" : 2.684056218962324,
      "indAttpasspor" : 7,
      "indTipoconto" : 4,
      "contoape" : "contoape",
      "flgGespor" : 5,
      "cogeprogeAbil" : 1,
      "flgSaldog" : 8,
      "percindeduc" : 4.754071900895484,
      "contorisatt" : "contorisatt",
      "codiceCgc0" : 6.712603870693706,
      "flgValutaest" : 2,
      "flgRaganal" : 0,
      "alias" : "alias",
      "conto" : "conto",
      "cogeprogeNodo" : 1,
      "contorispass" : "contorispass",
      "indContoricav" : 1,
      "vatTypeFI" : {
        "descr" : "descr",
        "indAutofattura" : 9,
        "agviaggio" : 5,
        "codice" : 8.331741856019029,
        "pluginData" : {
          "key" : ""
        },
        "localizzazione" : 0,
        "additionalData" : {
          "key" : ""
        },
        "codiceCg0d" : 7.6528347060559,
        "extensionData" : [ null, null ],
        "indTipo" : 8.223593720381889
      },
      "idcontorispassCg24" : 4,
      "cogeprogeAttivita" : 3,
      "flgGesec" : 6,
      "coaInternationalCustomizationFI" : [ {
        "categoria" : 6,
        "iso3166A2" : "iso3166A2",
        "gruppoCg10" : 7.375698277301938,
        "extensionData" : [ null, null ],
        "idCg24" : 0,
        "contoCg24" : "contoCg24",
        "subcategoria" : 9,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      }, {
        "categoria" : 6,
        "iso3166A2" : "iso3166A2",
        "gruppoCg10" : 7.375698277301938,
        "extensionData" : [ null, null ],
        "idCg24" : 0,
        "contoCg24" : "contoCg24",
        "subcategoria" : 9,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      } ],
      "gruppoCg10" : 8.257837395465918,
      "coaAccountStateFI" : [ {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 8.780989965779524,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 9.966789814889403,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 6,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "extensionData" : [ null, null ],
        "flgDisatt" : 5.616380282218067,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 8.780989965779524,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 9.966789814889403,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 6,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "extensionData" : [ null, null ],
        "flgDisatt" : 5.616380282218067,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "coaGroupCodeFI" : {
        "descr" : "descr",
        "numlivcons" : 9.684087197655908,
        "gruppo" : 0.8972273556195443,
        "numlivelli" : 1.7692392591014339,
        "accountProposals" : [ {
          "contoCg24" : "contoCg24",
          "codice" : 6.79368409560902,
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 9.0012452339701,
          "extensionData" : [ null, null ],
          "idCg24" : 8,
          "rowversion" : ""
        }, {
          "contoCg24" : "contoCg24",
          "codice" : 6.79368409560902,
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 9.0012452339701,
          "extensionData" : [ null, null ],
          "idCg24" : 8,
          "rowversion" : ""
        } ],
        "pluginData" : {
          "key" : ""
        },
        "maskedit" : "maskedit",
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "flgPdclib" : 7,
        "rowversion" : ""
      },
      "idparent" : 8,
      "idreverse" : 8,
      "flgIntercompany" : 8,
      "idcontoratpassCg24" : 5,
      "flgRarp" : 1,
      "idconto" : 5,
      "cogeprogeSpese" : 4,
      "idRifPdC80" : 6,
      "indCosvend" : 2
    },
    "flgAttivo" : 0.8851374739011653,
    "tipocfCg40" : 5.533258397034986,
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 7,
      "idknos" : 6,
      "dittaCg18" : 6.642953999458534,
      "flgInvalid" : 9,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "percorso" : "percorso",
      "extensionData" : [ null, null ]
    },
    "officeCO" : {
      "indIrizzo" : "indIrizzo",
      "idmediaCg99" : 9.908114046741538,
      "codice" : 0.7370530802760489,
      "indDimcentrocomm" : 7.541803065493349,
      "extensionData" : [ null, null ],
      "cap" : "cap",
      "dittaCg18" : 4.318826475758856,
      "progRea" : 7.437703257022269,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "numerorea" : "numerorea",
      "citta" : "citta",
      "rowversion" : ""
    },
    "flgInterCompany" : 6.519180951018382,
    "paymentTermCO" : {
      "flgDesc" : 8.875589915795528,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 5.103912736584151,
        "daggfix1" : 4.035133329541982,
        "daggfix2" : 2.1518888575299036,
        "ggmmfix" : 7.964879197514727,
        "ggdecor" : 4.39343993729625,
        "idCg64" : 6,
        "imporfix" : 3.8463127686084055,
        "flgFrperciva" : 8.81377937009168,
        "idCg62" : 2,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 9.610516429629122,
        "indTipocalend" : 4,
        "indTipodecor" : 4.075306827525243,
        "aggfix2" : 6.936499209818381,
        "aggfix1" : 4.403697036782718,
        "perciva" : 2.3317418552851765,
        "el2frimp" : 5.948961008630453,
        "ggscadfix2" : 7.321091499885957,
        "tipoeff" : 1.4985931822280574,
        "flgFrpercimp" : 9.140242185517025,
        "percimp" : 2.674423984487264,
        "prog" : 6.568304668801491,
        "extensionData" : [ null, null ],
        "el1frimp" : 3.0659734456354117,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 4.180725413706508,
        "subTypeCO" : {
          "ggoffset" : 5.099298781640682,
          "codiceCg07" : 7.338782761819433,
          "tipoeff" : 8.50835276411088,
          "codPaguc" : "codPaguc",
          "extensionData" : [ null, null ],
          "descstipo" : "descstipo",
          "codStipoeff" : 9.739448828157911,
          "flgAssegno" : 0,
          "indModfatturapa" : 3,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "extensionData" : [ null, null ],
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "extensionData" : [ null, null ],
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 9,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "extensionData" : [ null, null ]
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 8.638367073739522,
        "indDatarif" : 0.6052866655822231,
        "rowversion" : ""
      }, {
        "indImpfix" : 5.103912736584151,
        "daggfix1" : 4.035133329541982,
        "daggfix2" : 2.1518888575299036,
        "ggmmfix" : 7.964879197514727,
        "ggdecor" : 4.39343993729625,
        "idCg64" : 6,
        "imporfix" : 3.8463127686084055,
        "flgFrperciva" : 8.81377937009168,
        "idCg62" : 2,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 9.610516429629122,
        "indTipocalend" : 4,
        "indTipodecor" : 4.075306827525243,
        "aggfix2" : 6.936499209818381,
        "aggfix1" : 4.403697036782718,
        "perciva" : 2.3317418552851765,
        "el2frimp" : 5.948961008630453,
        "ggscadfix2" : 7.321091499885957,
        "tipoeff" : 1.4985931822280574,
        "flgFrpercimp" : 9.140242185517025,
        "percimp" : 2.674423984487264,
        "prog" : 6.568304668801491,
        "extensionData" : [ null, null ],
        "el1frimp" : 3.0659734456354117,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 4.180725413706508,
        "subTypeCO" : {
          "ggoffset" : 5.099298781640682,
          "codiceCg07" : 7.338782761819433,
          "tipoeff" : 8.50835276411088,
          "codPaguc" : "codPaguc",
          "extensionData" : [ null, null ],
          "descstipo" : "descstipo",
          "codStipoeff" : 9.739448828157911,
          "flgAssegno" : 0,
          "indModfatturapa" : 3,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "extensionData" : [ null, null ],
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "extensionData" : [ null, null ],
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 9,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "extensionData" : [ null, null ]
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 8.638367073739522,
        "indDatarif" : 0.6052866655822231,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 7.766860781935265,
      "flgPrefpass" : 6,
      "idExtendedAttributeSubEntity" : 0,
      "flgPrefatt" : 1,
      "flgStornoiva" : 5.304373278797373,
      "descPag" : "descPag",
      "extensionData" : [ null, null ],
      "scpermer2" : 7.701777079007398,
      "pluginData" : {
        "key" : ""
      },
      "id" : 8,
      "scpercas" : 4.4580628783592156,
      "scpermer1" : 0.313237310471568,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 4.13177941962639,
      "idExtendedAttributeEntity" : 2,
      "rowversion" : "",
      "scart26" : 0.8164256701298711
    },
    "progrEf08" : 3.0576100241049344,
    "tipoCf" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "cliFor" : 3.353193347011243,
    "additionalData" : {
      "key" : ""
    },
    "ggScadFix" : 0.10263654006109402,
    "idExtendedAttributeEntity" : 3,
    "idExtendedAttributeSubEntity" : 4,
    "flgCointestati" : 7.058770351582356,
    "gruppoCg10" : 4.652396432933246,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "extensionData" : [ null, null ],
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "vatCodeCO" : {
      "flgSospimp" : 2.9790233918904585,
      "indNatura" : 0,
      "flgAgri" : 1.2794383049745206,
      "tipologia" : 6.711221582652969,
      "percindet" : 8.474710856151638,
      "mossperc" : 4.851239691941878,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "rowversion" : ""
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 5,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 3,
      "perciva" : 3.474156394106027,
      "percforf" : 7.062107048540267,
      "codice" : "codice",
      "impostamonofasersm" : 2.6249013358703053,
      "codiceOss" : "codiceOss",
      "extensionData" : [ null, null ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 1,
      "flgAutoue" : 8.018039914932286,
      "flgIndet" : 9.852147203726787,
      "codPlafond" : 0.391063602337155,
      "note" : "note",
      "flgAssport398" : 2.9691650858515217,
      "flgMossrid" : 5,
      "indStaper" : 7.224413148959403,
      "flgAllclifor" : 2.0561655911354517,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 6,
      "flgCorrVent" : 2.6736395633233356,
      "aliqivavent" : 2.4977456046390434,
      "flgNotvar" : 4.966567419166605,
      "percmonofasersm" : 6.008900790410507,
      "idprov" : 9.693372334146686,
      "idExtendedAttributeSubEntity" : 6,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 5,
        "idassosw" : 6,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "rowversion" : ""
      },
      "flgMonofasersm" : 1.2880645475702646,
      "mosscodCg07" : 0.42286244411048224,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 7.239590766928185,
      "flgIvaedit" : 6.677419970877656,
      "indtipopart" : 1.633699845078339
    },
    "extensionData" : [ null, null ],
    "classificationData" : {
      "cliforCg44" : 0.2025324113236393,
      "indarrinfat" : 4.573936264232251,
      "indprefstdoc" : 5.299143560275359,
      "sc2percor" : 0.4768402382624515,
      "codrifnum" : 6.628464275087742,
      "grouping1CO" : {
        "dittaCg18" : 3.209082285545927,
        "codRaggrcf1" : "codRaggrcf1",
        "descraggrcf1" : "descraggrcf1",
        "idprov" : 2,
        "idmediaCg99" : 8.262795412896967,
        "tipocf" : 9.146339979307802,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "language" : {
        "iso639" : "iso639",
        "idmediaCg99" : 2.9679475177256287,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrlingua" : "descrlingua",
        "codLingua" : "codLingua",
        "siglalingua" : "siglalingua",
        "extensionData" : [ null, null ]
      },
      "irs1099" : "irs1099",
      "ggcons" : 2.9409642974827896,
      "flgesclspepor" : 0.5199002018724985,
      "grouping3CO" : {
        "codRaggrcf3" : "codRaggrcf3",
        "descraggrcf3" : "descraggrcf3",
        "dittaCg18" : 8.910869026866926,
        "idprov" : 6,
        "idmediaCg99" : 2.058822123984536,
        "tipocf" : 0.8411762798681321,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "datiAccompagnamento" : {
        "cliforCg44" : 4.8789878742268815,
        "vett1Mg14" : "vett1Mg14",
        "imballoMg95" : "imballoMg95",
        "tipocfCg44" : 1.3949519358941398,
        "idmediaCg99" : 9.806951670467935,
        "portoMg91" : "portoMg91",
        "vett2Mg14" : "vett2Mg14",
        "extensionData" : [ null, null ],
        "aspettoMg99" : "aspettoMg99",
        "dittaCg18" : 6.966044574347761,
        "spedizMg15" : "spedizMg15",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "tipospedMg93" : "tipospedMg93"
      },
      "tipoclxdoc" : 0.4833312865174044,
      "priceListSalePurchase" : {
        "desclist" : "desclist",
        "numlist" : 9.456612101333725,
        "valutaCg08" : "valutaCg08",
        "dittaCg18" : 0.30134145536422907,
        "flgVenacq" : 0.4867146239815201,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "coddocumMg3g" : "coddocumMg3g",
      "indtestof2" : "0",
      "impdaarrot" : 6.623518433804886,
      "indtestof1" : 3.7814124730767915,
      "pluginData" : {
        "key" : ""
      },
      "flgrottsingdoc" : 8.251625748923757,
      "scimpcor" : 3.804112695731078,
      "additionalData" : {
        "key" : ""
      },
      "dataultord" : "2000-01-23T04:56:07.000+00:00",
      "flgTaxliable" : 0,
      "flgspbol" : 4.459605034958679,
      "magpercor" : 5.877124706116695,
      "taxexemptionno" : "taxexemptionno",
      "scaglspbanc" : 2.380090174313445,
      "macroCategoryCO" : {
        "descrmacrocat" : "descrmacrocat",
        "categorie" : [ null, null ],
        "dittaCg18" : 6.749525837406151,
        "tipocf" : 4.943637496515336,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "macrocat" : "macrocat",
        "extensionData" : [ null, null ]
      },
      "datacreaz" : "2000-01-23T04:56:07.000+00:00",
      "flgspeinc" : 3.901545264248647,
      "codrifalf" : "codrifalf",
      "sc1percor" : 7.835035282970782,
      "listmag" : 3.111202833403195,
      "categoryCO" : {
        "macrocatMg10" : "macrocatMg10",
        "tipocfMg10" : 6.173804034172511,
        "descrcat" : "descrcat",
        "dittaCg18" : 2.535258963197524,
        "categ" : "categ",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "extensionData" : [ null, null ],
      "dittaCg18" : 4.258773108174356,
      "indspesecum" : 8.37823741034869,
      "magimpcor" : 9.897492629215506,
      "datadismis" : "2000-01-23T04:56:07.000+00:00",
      "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
      "macAreaCO" : {
        "descrmacroar" : "descrmacroar",
        "dittaCg18" : 5.747795090145878,
        "idprov" : 0,
        "tipocf" : 7.3842318535314,
        "areas" : [ null, null ],
        "pluginData" : {
          "key" : ""
        },
        "codiceMacroarea" : "codiceMacroarea",
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "indclibloc" : 9.254183946267839,
      "fixedText1" : {
        "descr" : "descr",
        "datainizioval" : "2000-01-23T04:56:07.000+00:00",
        "indTipoevas" : 4.4935252719377825,
        "idprov" : 1,
        "idmediaCg99" : 9.402167524121316,
        "codice" : "codice",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "testo" : "testo"
      },
      "flgart62ctr" : 0,
      "imparrotprec" : 8.28965939814297,
      "areaCO" : {
        "codiceAreaMG" : "codiceAreaMG",
        "macroareaMg07" : "macroareaMg07",
        "dittaCg18" : 0.35262192099236644,
        "zone" : [ {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ null, null ]
        }, {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ null, null ]
        } ],
        "idprov" : 7,
        "tipocfMg07" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrarea" : "descrarea",
        "extensionData" : [ null, null ]
      },
      "dataultvar" : "2000-01-23T04:56:07.000+00:00",
      "tipocfCg44" : 4.518309517874243,
      "fidofactoring" : 4.678947989005849,
      "idmediaCg99" : 1.7325933120207193,
      "datarischio" : "2000-01-23T04:56:07.000+00:00",
      "indstscadest" : 7.606863723092579,
      "grouping2CO" : {
        "codRaggrcf2" : "codRaggrcf2",
        "dittaCg18" : 4.010300976654761,
        "idprov" : 6,
        "descraggrcf2" : "descraggrcf2",
        "idmediaCg99" : 8.276461147928103,
        "tipocf" : 4.141296055235948,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "indclifat" : 1.8268702177058116,
      "fixedExp1" : {
        "flgRicfatriep" : 5.6644160867523485,
        "flgVentstat" : 4.372688051310086,
        "flgIvaincl" : 1,
        "indTipoevas" : 9.785002165136461,
        "idmediaCg99" : 5.7911894223693885,
        "codice" : "codice",
        "indTotspese" : 7.92839742024475,
        "indRotturacorpo" : 1.0639121808530916,
        "indTipospesa" : 7.3718573971919445,
        "extensionData" : [ null, null ],
        "indGesintra" : 3.8008573585058016,
        "descr" : "descr",
        "indFatriep" : 5.974942028545841,
        "indTipotot" : 7.726998920545485,
        "indTipoaliq" : 3.2841216543560217,
        "pluginData" : {
          "key" : ""
        },
        "flgVentamm" : 1.5970080735609526,
        "additionalData" : {
          "key" : ""
        },
        "flgOramin" : 3.812761638325517
      },
      "scperpiede" : 8.675064425986758,
      "rischio" : {
        "indSegnalazionecorpo" : 4.432841187680573,
        "flgAttivo" : 0.36062689002149373,
        "flgScadereins" : 1.9626702727164813,
        "flgOrdini" : 5.296102445648278,
        "flgCalcmovprev" : 2.026856458177285,
        "flgSaldocon" : 3.8156682252305574,
        "pluginData" : {
          "key" : ""
        },
        "flgCalcmovdacons" : 4.1661834558007,
        "additionalData" : {
          "key" : ""
        },
        "flgScadutoins" : 3.0269458094096646,
        "mesiricscadenze" : 9.721046668148785,
        "flgSelclifortrasf" : 7.273019311111276,
        "indElabscadinsol" : 0.4008378390304357,
        "flgScadutonoins" : 8.250639315618633,
        "codice" : "codice",
        "flgEffettiscaduti" : 3.196820582978078,
        "extensionData" : [ null, null ],
        "flgScaderenoins" : 5.573385265048522,
        "flgCalceffcons" : 7.390706075830692,
        "flgCalcmovcons" : 2.0981949483881577,
        "descrizione" : "descrizione",
        "flgCalceffprev" : 6.176386745020588,
        "dittaCg18" : 4.637509675190766,
        "flgCalceffdacons" : 1.0502890910539986,
        "indAttivatrasf" : 8.782449469456207,
        "mesiricordini" : 5.726375546151009,
        "flgSolobusinesriskattivo" : 2.4669941706755685,
        "indProvenienzafido" : 2.5524281586707875,
        "mesiricdocdafatt" : 3.5117904067536143
      },
      "dataultfat" : "2000-01-23T04:56:07.000+00:00",
      "notebloc" : "notebloc",
      "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
      "indgesfido" : 8.761432466225475,
      "flgprzcamp" : 5.507386964179881,
      "inddesdocest" : 3.502657762086401,
      "flgdaticlfat" : 9.702963800023566,
      "indgiorni" : 0.4182561061793122,
      "fidoaziendale" : 1.041444916118296,
      "fidolivello1" : 7.260521264802104,
      "indrottcig" : 5.312489704336296,
      "fidolivello2" : 9.132027271330688,
      "raggruppamentoPrevalente" : {
        "descragg" : "descragg",
        "cliforCg44" : 7.88722683998926,
        "dittaCg18" : 6.918231485891953,
        "idmediaCg99" : 0.11859130807119977,
        "codRag" : "codRag",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "indarrl96" : 8.863729185622827,
      "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
      "flgrottcig" : 6.073898085781152,
      "coddestprev" : "coddestprev",
      "codprevragb" : "codprevragb",
      "art62txt" : "art62txt",
      "flgEstrpayline" : 7.933506881737151,
      "indFattper" : 9.183123594773994,
      "flgqualita" : 4.86315908102884,
      "datablocco" : "2000-01-23T04:56:07.000+00:00",
      "priceListWithMultipleItems" : {
        "descr" : "descr",
        "dittaCg18" : 9.721723570087065,
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "subCategoryCO" : {
        "descrsottocat" : "descrsottocat",
        "tipocfMg11" : 7.464202015255506,
        "dittaCg18" : 2.922265432447957,
        "sottcat" : "sottcat",
        "categMg11" : "categMg11",
        "macrocatMg11" : "macrocatMg11",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "sc3percor" : 3.1497903714250555
    },
    "datavaliva" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.0937452626664474,
    "flgart62" : 7,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indElenchiMov3000" : 3,
    "lastchange" : "2000-01-23T04:56:07.000+00:00"
  },
  "flgprzcamp" : 2.3021358869347655,
  "inddesdocest" : 6.84685269835264,
  "flgdaticlfat" : 5.962133916683182,
  "indgiorni" : 1.1730742509559433,
  "indarrl96" : 1.0246457001441578,
  "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
  "flgrottcig" : 9.301444243932576,
  "coddestprev" : "coddestprev",
  "blockLevelCO" : {
    "descrblocco" : "descrblocco",
    "dittaCg18" : 6.878052220127876,
    "idmediaCg99" : 5.944895607614016,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codBlocco" : "codBlocco",
    "indPayline" : 6.704019297950036,
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ]
  },
  "art62txt" : "art62txt",
  "indFattper" : 7.457744773683766,
  "flgqualita" : 7.061401241503109,
  "sc3percor" : 3.5571952270680973
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGCustomerSupplierExtensionMGIdPATCH = function(body,force,_op,tipocfCg44,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body CustomerSupplierExtensionMGDTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns CustomerSupplierExtensionMGDTO
 **/
exports.apiV1EnvironmentMGCustomerSupplierExtensionMGIdPUT = function(body,force,_op,tipocfCg44,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cliforCg44" : 0.8008281904610115,
  "indarrinfat" : 1.2315135367772556,
  "indprefstdoc" : 4.965218492984954,
  "sc2percor" : 6.438423552598547,
  "ggcons" : 2.027123023002322,
  "flgesclspepor" : 5.637376656633329,
  "tipoclxdoc" : 6.778324963048013,
  "coddocumMg3g" : "coddocumMg3g",
  "indtestof2" : "0",
  "impdaarrot" : 7.386281948385884,
  "indtestof1" : 9.965781217890562,
  "pluginData" : {
    "key" : ""
  },
  "flgrottsingdoc" : 3.616076749251911,
  "scimpcor" : 6.965117697638846,
  "additionalData" : {
    "key" : ""
  },
  "dataultord" : "2000-01-23T04:56:07.000+00:00",
  "magpercor" : 6.683562403749608,
  "sc1percor" : 9.018348186070783,
  "extensionData" : [ null, null ],
  "dittaCg18" : 6.027456183070403,
  "magimpcor" : 9.369310271410669,
  "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
  "flgart62ctr" : 1,
  "imparrotprec" : 4.145608029883936,
  "tipocfCg44" : 2.8841621266687802,
  "indstscadest" : 5.025004791520295,
  "indclifat" : 1.4894159098541704,
  "scperpiede" : 1.284659006116532,
  "dataultfat" : "2000-01-23T04:56:07.000+00:00",
  "punlis99pre" : 8.762042012749001,
  "cliForFatturazione" : {
    "statoAttualeCO" : {
      "statiDisponibili" : [ null, null ],
      "statoCorrente" : {
        "indTipoStato" : 4,
        "idStato" : 5,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "seq" : 9,
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "extensionData" : [ null, null ]
    },
    "contratto" : "contratto",
    "idCliFor" : 8,
    "idmediaCg99" : 7.740351818741173,
    "blackListGeneralMasterData" : {
      "datavalid" : "2000-01-23T04:56:07.000+00:00",
      "ragsofiscex" : "ragsofiscex",
      "addresses" : [ {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed",
          "extensionData" : [ null, null ]
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "extensionData" : [ null, null ],
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "extensionData" : [ null, null ],
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "extensionData" : [ null, null ],
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      }, {
        "indirizzocomp2" : "indirizzocomp2",
        "addressesType" : [ {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        }, {
          "tipo" : 6,
          "idCG1J" : 6,
          "pluginData" : {
            "key" : ""
          },
          "id" : 2,
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ {
            "value" : "",
            "key" : "key"
          }, {
            "value" : "",
            "key" : "key"
          } ]
        } ],
        "risstato" : "risstato",
        "riszip" : "riszip",
        "pv" : "pv",
        "precisione" : "precisione",
        "codlinguaMg52" : "codlinguaMg52",
        "frazione" : "frazione",
        "emailPec" : "emailPec",
        "tipologia" : "tipologia",
        "via" : "via",
        "idTeamportal" : 6,
        "numciv" : "numciv",
        "cap" : "cap",
        "latitudine" : 3.5571952270680973,
        "statoCg07" : 1.284659006116532,
        "presso" : "presso",
        "federalStateViewCO" : {
          "descr" : "descr",
          "iso3166statofed" : "iso3166statofed",
          "a2iso3166Cg07" : "a2iso3166Cg07",
          "pluginData" : {
            "key" : ""
          },
          "codiceCg07" : 5.944895607614016,
          "additionalData" : {
            "key" : ""
          },
          "statofed" : "statofed",
          "extensionData" : [ null, null ]
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "fax" : "fax",
        "statofed" : "statofed",
        "telefono" : "telefono",
        "datamod" : "2000-01-23T04:56:07.000+00:00",
        "email" : "email",
        "citta" : "citta",
        "ragsoc" : "ragsoc",
        "cellnum" : "cellnum",
        "comanaCg01" : "comanaCg01",
        "codiceCg16" : 8,
        "datacre" : "2000-01-23T04:56:07.000+00:00",
        "ragsocex" : "ragsocex",
        "rifindirizzo" : "rifindirizzo",
        "codicesfed" : "codicesfed",
        "extensionData" : [ null, null ],
        "contea" : "contea",
        "indirizzocomp" : "indirizzocomp",
        "riswarning" : "riswarning",
        "indirizzoex" : "indirizzoex",
        "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
        "risregione" : "risregione",
        "edificio" : "edificio",
        "statoEst" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "extensionData" : [ null, null ],
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "extensionData" : [ null, null ],
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "extensionData" : [ null, null ],
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "longitudine" : 6.965117697638846,
        "indweb" : "indweb"
      } ],
      "codiceident" : "codiceident",
      "indirCorEX" : "indirCorEX",
      "flgFattpa" : 7,
      "indirizzo" : "indirizzo",
      "ragsoanagex" : "ragsoanagex",
      "codiceCg07" : 7.061401241503109,
      "indsoggrit" : 7.457744773683766,
      "ragSoAnag" : "ragSoAnag",
      "capcor" : "capcor",
      "cittafisc" : "cittafisc",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9,
        "extensionData" : [ null, null ]
      },
      "statofiscCg07" : 5.025004791520295,
      "tel2num" : "tel2num",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codfiscale" : "codfiscale",
      "statofed" : "statofed",
      "codrichiamo" : 2,
      "provfisc" : "provfisc",
      "idExtendedAttributeEntity" : 9,
      "citta" : "citta",
      "statonascitaCg07" : 9.965781217890562,
      "codice" : 2,
      "indFiscale" : "indFiscale",
      "nome" : "nome",
      "comnascitaCg01" : "comnascitaCg01",
      "codiceCg15" : "codiceCg15",
      "extensionData" : [ null, null ],
      "ragsofisc" : "ragsofisc",
      "indemail" : "indemail",
      "indirizzoEX" : "indirizzoEX",
      "comfisCg01" : "comfisCg01",
      "comnascita" : "comnascita",
      "partiva" : "partiva",
      "flgNoblacklist" : 1.2315135367772556,
      "partivaEst" : "partivaEst",
      "cognome" : "cognome",
      "idmediaCg99" : 6.84685269835264,
      "wtCodeCO" : {
        "causdd1" : "causdd1",
        "codNonsog" : 0.8774076871421566,
        "flgRegagevo" : 4.86315908102884,
        "idmediaCg99" : 3.901545264248647,
        "percRipPerc" : 1.8268702177058116,
        "flgRitImposta" : 6.073898085781152,
        "codPrev" : "codPrev",
        "tiporapporto" : "tiporapporto",
        "percripaz" : 9.254183946267839,
        "pluginData" : {
          "key" : ""
        },
        "flgPignTerzi" : 7.933506881737151,
        "flgProteo360" : 5.507386964179881,
        "additionalData" : {
          "key" : ""
        },
        "flgGlad" : 9.702963800023566,
        "codFiscPrev" : "codFiscPrev",
        "gcprev" : 4,
        "idprov" : 0.43431398824148815,
        "codice" : "codice",
        "extensionData" : [ null, null ],
        "percci" : 4.573936264232251,
        "flgSosprit" : 8,
        "descr" : "descr",
        "flgMinimi" : 0,
        "codTributo" : "codTributo",
        "indCodattglad" : 2.9409642974827896,
        "indTipocassa" : 1,
        "percra" : 8.863729185622827,
        "percbaseimp" : 6.623518433804886,
        "codTribrp" : "codTribrp",
        "inpsivs" : 8.28965939814297,
        "rowversion" : ""
      },
      "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
      "capfisc" : "capfisc",
      "codicecorCg07" : 3.616076749251911,
      "codiceCgc0" : 9.301444243932576,
      "cap" : "cap",
      "faxnum" : "faxnum",
      "alias" : "alias",
      "flgOmonimo" : 1.0246457001441578,
      "provnascita" : "provnascita",
      "ragsocor" : "ragsocor",
      "prov" : "prov",
      "flgAnagval" : 4.145608029883936,
      "rapazestCg16" : 1,
      "cellnum" : "cellnum",
      "flgPrsfis" : 1.4894159098541704,
      "tel1num" : "tel1num",
      "idExtendedAttributeSubEntity" : 6,
      "provcor" : "provcor",
      "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
      "cittacor" : "cittacor",
      "codicesfed" : "codicesfed",
      "statofedfisc" : "statofedfisc",
      "indFiscaleEX" : "indFiscaleEX",
      "partitaIVA" : "partitaIVA",
      "indirCor" : "indirCor",
      "sesso" : 4.965218492984954,
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "ragsocorex" : "ragsocorex",
      "datanascita" : "2000-01-23T04:56:07.000+00:00",
      "auidAu04" : 5,
      "indweb" : "indweb"
    },
    "goods" : {
      "reverseTypeFI" : {
        "reverseTypeCode" : 3,
        "reverseTypeDescription" : "reverseTypeDescription",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "flgBilconsattpassdist" : 8,
      "contochiu" : "contochiu",
      "flgAnalit" : 2,
      "codeformatted" : "codeformatted",
      "intragroupStructureCO" : {
        "descr" : "descr",
        "codice" : 7.260521264802104,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "codAnagGen" : 4,
        "codIntercompany" : 9,
        "extensionData" : [ null, null ]
      },
      "flgAggfatt" : 2,
      "indLivchius" : 7,
      "idcontoratattCg24" : 5,
      "idcontoapeCg24" : 9,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "contocrsosp" : "contocrsosp",
      "flgContoimm" : 2,
      "flgOpnonfin" : 5.829097284708605,
      "indDaavec" : 7,
      "cogeprogeMateriali" : 9,
      "coaAccountCustomizationFI" : [ {
        "descr" : "descr",
        "iddespcon" : 8,
        "dittaCg18" : 3.8581948879558317,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 0.9178980228274691,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 1.9732909296667345,
        "extensionData" : [ null, null ],
        "idCg24" : 4,
        "rowversion" : ""
      }, {
        "descr" : "descr",
        "iddespcon" : 8,
        "dittaCg18" : 3.8581948879558317,
        "contoCg24" : "contoCg24",
        "idmediaCg99" : 0.9178980228274691,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 1.9732909296667345,
        "extensionData" : [ null, null ],
        "idCg24" : 4,
        "rowversion" : ""
      } ],
      "accountType" : 8,
      "contoratpass" : "contoratpass",
      "extensionData" : [ null, null ],
      "descr" : "descr",
      "idcontorisattCg24" : 8,
      "indDaav" : 1,
      "suddconti" : 3.8601930294054942,
      "contoratatt" : "contoratatt",
      "indMastroCliFor" : 1.0348002257634148,
      "idcontochiuCg24" : 2,
      "percindetra" : 1.1864130338603074,
      "codiceCg22" : 2.684056218962324,
      "indAttpasspor" : 7,
      "indTipoconto" : 4,
      "contoape" : "contoape",
      "flgGespor" : 5,
      "cogeprogeAbil" : 1,
      "flgSaldog" : 8,
      "percindeduc" : 4.754071900895484,
      "contorisatt" : "contorisatt",
      "codiceCgc0" : 6.712603870693706,
      "flgValutaest" : 2,
      "flgRaganal" : 0,
      "alias" : "alias",
      "conto" : "conto",
      "cogeprogeNodo" : 1,
      "contorispass" : "contorispass",
      "indContoricav" : 1,
      "vatTypeFI" : {
        "descr" : "descr",
        "indAutofattura" : 9,
        "agviaggio" : 5,
        "codice" : 8.331741856019029,
        "pluginData" : {
          "key" : ""
        },
        "localizzazione" : 0,
        "additionalData" : {
          "key" : ""
        },
        "codiceCg0d" : 7.6528347060559,
        "extensionData" : [ null, null ],
        "indTipo" : 8.223593720381889
      },
      "idcontorispassCg24" : 4,
      "cogeprogeAttivita" : 3,
      "flgGesec" : 6,
      "coaInternationalCustomizationFI" : [ {
        "categoria" : 6,
        "iso3166A2" : "iso3166A2",
        "gruppoCg10" : 7.375698277301938,
        "extensionData" : [ null, null ],
        "idCg24" : 0,
        "contoCg24" : "contoCg24",
        "subcategoria" : 9,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      }, {
        "categoria" : 6,
        "iso3166A2" : "iso3166A2",
        "gruppoCg10" : 7.375698277301938,
        "extensionData" : [ null, null ],
        "idCg24" : 0,
        "contoCg24" : "contoCg24",
        "subcategoria" : 9,
        "gbDeferralcode" : "gbDeferralcode",
        "esModulo347" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      } ],
      "gruppoCg10" : 8.257837395465918,
      "coaAccountStateFI" : [ {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 8.780989965779524,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 9.966789814889403,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 6,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "extensionData" : [ null, null ],
        "flgDisatt" : 5.616380282218067,
        "idCg24" : 9,
        "rowversion" : ""
      }, {
        "consosCg24" : "consosCg24",
        "dittaCg18" : 8.780989965779524,
        "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
        "grusosCg10" : 9.966789814889403,
        "pluginData" : {
          "key" : ""
        },
        "idstatipdc" : 6,
        "additionalData" : {
          "key" : ""
        },
        "dtconsos" : "2000-01-23T04:56:07.000+00:00",
        "extensionData" : [ null, null ],
        "flgDisatt" : 5.616380282218067,
        "idCg24" : 9,
        "rowversion" : ""
      } ],
      "coaGroupCodeFI" : {
        "descr" : "descr",
        "numlivcons" : 9.684087197655908,
        "gruppo" : 0.8972273556195443,
        "numlivelli" : 1.7692392591014339,
        "accountProposals" : [ {
          "contoCg24" : "contoCg24",
          "codice" : 6.79368409560902,
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 9.0012452339701,
          "extensionData" : [ null, null ],
          "idCg24" : 8,
          "rowversion" : ""
        }, {
          "contoCg24" : "contoCg24",
          "codice" : 6.79368409560902,
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "gruppoCg10" : 9.0012452339701,
          "extensionData" : [ null, null ],
          "idCg24" : 8,
          "rowversion" : ""
        } ],
        "pluginData" : {
          "key" : ""
        },
        "maskedit" : "maskedit",
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "flgPdclib" : 7,
        "rowversion" : ""
      },
      "idparent" : 8,
      "idreverse" : 8,
      "flgIntercompany" : 8,
      "idcontoratpassCg24" : 5,
      "flgRarp" : 1,
      "idconto" : 5,
      "cogeprogeSpese" : 4,
      "idRifPdC80" : 6,
      "indCosvend" : 2
    },
    "flgAttivo" : 0.8851374739011653,
    "tipocfCg40" : 5.533258397034986,
    "dmsPublishedEntityFW" : {
      "tipoarchHm30" : 7,
      "idknos" : 6,
      "dittaCg18" : 6.642953999458534,
      "flgInvalid" : 9,
      "datapub" : "2000-01-23T04:56:07.000+00:00",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "protocollo" : "protocollo",
      "nome" : "nome",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "percorso" : "percorso",
      "extensionData" : [ null, null ]
    },
    "officeCO" : {
      "indIrizzo" : "indIrizzo",
      "idmediaCg99" : 9.908114046741538,
      "codice" : 0.7370530802760489,
      "indDimcentrocomm" : 7.541803065493349,
      "extensionData" : [ null, null ],
      "cap" : "cap",
      "dittaCg18" : 4.318826475758856,
      "progRea" : 7.437703257022269,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prov" : "prov",
      "numerorea" : "numerorea",
      "citta" : "citta",
      "rowversion" : ""
    },
    "flgInterCompany" : 6.519180951018382,
    "paymentTermCO" : {
      "flgDesc" : 8.875589915795528,
      "paymentTermDetailCO" : [ {
        "indImpfix" : 5.103912736584151,
        "daggfix1" : 4.035133329541982,
        "daggfix2" : 2.1518888575299036,
        "ggmmfix" : 7.964879197514727,
        "ggdecor" : 4.39343993729625,
        "idCg64" : 6,
        "imporfix" : 3.8463127686084055,
        "flgFrperciva" : 8.81377937009168,
        "idCg62" : 2,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 9.610516429629122,
        "indTipocalend" : 4,
        "indTipodecor" : 4.075306827525243,
        "aggfix2" : 6.936499209818381,
        "aggfix1" : 4.403697036782718,
        "perciva" : 2.3317418552851765,
        "el2frimp" : 5.948961008630453,
        "ggscadfix2" : 7.321091499885957,
        "tipoeff" : 1.4985931822280574,
        "flgFrpercimp" : 9.140242185517025,
        "percimp" : 2.674423984487264,
        "prog" : 6.568304668801491,
        "extensionData" : [ null, null ],
        "el1frimp" : 3.0659734456354117,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 4.180725413706508,
        "subTypeCO" : {
          "ggoffset" : 5.099298781640682,
          "codiceCg07" : 7.338782761819433,
          "tipoeff" : 8.50835276411088,
          "codPaguc" : "codPaguc",
          "extensionData" : [ null, null ],
          "descstipo" : "descstipo",
          "codStipoeff" : 9.739448828157911,
          "flgAssegno" : 0,
          "indModfatturapa" : 3,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "extensionData" : [ null, null ],
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "extensionData" : [ null, null ],
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 9,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "extensionData" : [ null, null ]
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 8.638367073739522,
        "indDatarif" : 0.6052866655822231,
        "rowversion" : ""
      }, {
        "indImpfix" : 5.103912736584151,
        "daggfix1" : 4.035133329541982,
        "daggfix2" : 2.1518888575299036,
        "ggmmfix" : 7.964879197514727,
        "ggdecor" : 4.39343993729625,
        "idCg64" : 6,
        "imporfix" : 3.8463127686084055,
        "flgFrperciva" : 8.81377937009168,
        "idCg62" : 2,
        "pluginData" : {
          "key" : ""
        },
        "id" : 7,
        "additionalData" : {
          "key" : ""
        },
        "el2friva" : 9.610516429629122,
        "indTipocalend" : 4,
        "indTipodecor" : 4.075306827525243,
        "aggfix2" : 6.936499209818381,
        "aggfix1" : 4.403697036782718,
        "perciva" : 2.3317418552851765,
        "el2frimp" : 5.948961008630453,
        "ggscadfix2" : 7.321091499885957,
        "tipoeff" : 1.4985931822280574,
        "flgFrpercimp" : 9.140242185517025,
        "percimp" : 2.674423984487264,
        "prog" : 6.568304668801491,
        "extensionData" : [ null, null ],
        "el1frimp" : 3.0659734456354117,
        "codPagCg62" : "codPagCg62",
        "ggscadfix1" : 4.180725413706508,
        "subTypeCO" : {
          "ggoffset" : 5.099298781640682,
          "codiceCg07" : 7.338782761819433,
          "tipoeff" : 8.50835276411088,
          "codPaguc" : "codPaguc",
          "extensionData" : [ null, null ],
          "descstipo" : "descstipo",
          "codStipoeff" : 9.739448828157911,
          "flgAssegno" : 0,
          "indModfatturapa" : 3,
          "nationCO" : {
            "codSian" : 3.353193347011243,
            "crtpiva" : "crtpiva",
            "leniban" : 6,
            "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
            "desiso3166" : "desiso3166",
            "idmediaCg99" : 0.8851374739011653,
            "codice" : 6.704019297950036,
            "numiso3166" : "numiso3166",
            "codiceCg08" : "codiceCg08",
            "currencyCO" : {
              "sigla" : "sigla",
              "dataattuem" : "2000-01-23T04:56:07.000+00:00",
              "numdec" : 7.04836565559697,
              "exchangeRateCO" : [ {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              }, {
                "cambio" : 4.078845849666752,
                "anno" : 3.2588565619047607,
                "idmediaCg99" : 6.628464275087742,
                "codiceCg08" : "codiceCg08",
                "indCertoincerto" : 4,
                "codicerifCg08" : "codicerifCg08",
                "extensionData" : [ null, null ],
                "giorno" : 0.2025324113236393,
                "mese" : 1.041444916118296,
                "pluginData" : {
                  "key" : ""
                },
                "additionalData" : {
                  "key" : ""
                },
                "adegcambio" : 5.533258397034986,
                "rowversion" : ""
              } ],
              "idmediaCg99" : 8.969578798196912,
              "codice" : "codice",
              "indCertoincerto" : 7,
              "extensionData" : [ null, null ],
              "cambiofisso" : 0.10263654006109402,
              "descr" : "descr",
              "flgValuem" : 4.652396432933246,
              "indValuem" : 3.0576100241049344,
              "indSepmigl" : 3.0205796992916243,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              }
            },
            "extensionData" : [ null, null ],
            "descr" : "descr",
            "flgIban" : 3,
            "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
            "codIso" : "codIso",
            "a3iso3166" : "a3iso3166",
            "indTipostato" : 7.058770351582356,
            "a2iso3166" : "a2iso3166",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "datacee" : "2000-01-23T04:56:07.000+00:00",
            "flgSepa" : 7
          },
          "foreignPaymentCodeCO" : {
            "flgIbanobbl" : 9,
            "descrpag" : "descrpag",
            "codIso" : "codIso",
            "codice" : "codice",
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "extensionData" : [ null, null ]
          },
          "pluginData" : {
            "key" : ""
          },
          "id" : 9,
          "additionalData" : {
            "key" : ""
          },
          "rowversion" : ""
        },
        "el1friva" : 8.638367073739522,
        "indDatarif" : 0.6052866655822231,
        "rowversion" : ""
      } ],
      "codPag" : "codPag",
      "desPagAnal" : "desPagAnal",
      "flgDisgg" : 7.766860781935265,
      "flgPrefpass" : 6,
      "idExtendedAttributeSubEntity" : 0,
      "flgPrefatt" : 1,
      "flgStornoiva" : 5.304373278797373,
      "descPag" : "descPag",
      "extensionData" : [ null, null ],
      "scpermer2" : 7.701777079007398,
      "pluginData" : {
        "key" : ""
      },
      "id" : 8,
      "scpercas" : 4.4580628783592156,
      "scpermer1" : 0.313237310471568,
      "additionalData" : {
        "key" : ""
      },
      "scpercart26" : 4.13177941962639,
      "idExtendedAttributeEntity" : 2,
      "rowversion" : "",
      "scart26" : 0.8164256701298711
    },
    "progrEf08" : 3.0576100241049344,
    "tipoCf" : 7.04836565559697,
    "pluginData" : {
      "key" : ""
    },
    "cliFor" : 3.353193347011243,
    "additionalData" : {
      "key" : ""
    },
    "ggScadFix" : 0.10263654006109402,
    "idExtendedAttributeEntity" : 3,
    "idExtendedAttributeSubEntity" : 4,
    "flgCointestati" : 7.058770351582356,
    "gruppoCg10" : 4.652396432933246,
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "extensionData" : [ null, null ],
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "vatCodeCO" : {
      "flgSospimp" : 2.9790233918904585,
      "indNatura" : 0,
      "flgAgri" : 1.2794383049745206,
      "tipologia" : 6.711221582652969,
      "percindet" : 8.474710856151638,
      "mossperc" : 4.851239691941878,
      "natureEsCO" : {
        "descr" : "descr",
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "natureAssCO" : [ null, null ],
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "rowversion" : ""
      },
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "verslynfa" : "verslynfa",
      "idExtendedAttributeEntity" : 5,
      "annotazioni" : "annotazioni",
      "rowVersion" : "",
      "indNatassoswCg2n" : 3,
      "perciva" : 3.474156394106027,
      "percforf" : 7.062107048540267,
      "codice" : "codice",
      "impostamonofasersm" : 2.6249013358703053,
      "codiceOss" : "codiceOss",
      "extensionData" : [ null, null ],
      "stdcodivarifCg28" : "stdcodivarifCg28",
      "flgMossgest" : 1,
      "flgAutoue" : 8.018039914932286,
      "flgIndet" : 9.852147203726787,
      "codPlafond" : 0.391063602337155,
      "note" : "note",
      "flgAssport398" : 2.9691650858515217,
      "flgMossrid" : 5,
      "indStaper" : 7.224413148959403,
      "flgAllclifor" : 2.0561655911354517,
      "codiceagr" : "codiceagr",
      "flgImpostadibollo" : 6,
      "flgCorrVent" : 2.6736395633233356,
      "aliqivavent" : 2.4977456046390434,
      "flgNotvar" : 4.966567419166605,
      "percmonofasersm" : 6.008900790410507,
      "idprov" : 9.693372334146686,
      "idExtendedAttributeSubEntity" : 6,
      "natureAssCO" : {
        "descr" : "descr",
        "idCg2m" : 5,
        "idassosw" : 6,
        "codice" : "codice",
        "datainival" : "2000-01-23T04:56:07.000+00:00",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "rowversion" : ""
      },
      "flgMonofasersm" : 1.2880645475702646,
      "mosscodCg07" : 0.42286244411048224,
      "descrizione" : "descrizione",
      "flgEscludiblacklist" : 7.239590766928185,
      "flgIvaedit" : 6.677419970877656,
      "indtipopart" : 1.633699845078339
    },
    "extensionData" : [ null, null ],
    "classificationData" : {
      "cliforCg44" : 0.2025324113236393,
      "indarrinfat" : 4.573936264232251,
      "indprefstdoc" : 5.299143560275359,
      "sc2percor" : 0.4768402382624515,
      "codrifnum" : 6.628464275087742,
      "grouping1CO" : {
        "dittaCg18" : 3.209082285545927,
        "codRaggrcf1" : "codRaggrcf1",
        "descraggrcf1" : "descraggrcf1",
        "idprov" : 2,
        "idmediaCg99" : 8.262795412896967,
        "tipocf" : 9.146339979307802,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "language" : {
        "iso639" : "iso639",
        "idmediaCg99" : 2.9679475177256287,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrlingua" : "descrlingua",
        "codLingua" : "codLingua",
        "siglalingua" : "siglalingua",
        "extensionData" : [ null, null ]
      },
      "irs1099" : "irs1099",
      "ggcons" : 2.9409642974827896,
      "flgesclspepor" : 0.5199002018724985,
      "grouping3CO" : {
        "codRaggrcf3" : "codRaggrcf3",
        "descraggrcf3" : "descraggrcf3",
        "dittaCg18" : 8.910869026866926,
        "idprov" : 6,
        "idmediaCg99" : 2.058822123984536,
        "tipocf" : 0.8411762798681321,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "datiAccompagnamento" : {
        "cliforCg44" : 4.8789878742268815,
        "vett1Mg14" : "vett1Mg14",
        "imballoMg95" : "imballoMg95",
        "tipocfCg44" : 1.3949519358941398,
        "idmediaCg99" : 9.806951670467935,
        "portoMg91" : "portoMg91",
        "vett2Mg14" : "vett2Mg14",
        "extensionData" : [ null, null ],
        "aspettoMg99" : "aspettoMg99",
        "dittaCg18" : 6.966044574347761,
        "spedizMg15" : "spedizMg15",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "tipospedMg93" : "tipospedMg93"
      },
      "tipoclxdoc" : 0.4833312865174044,
      "priceListSalePurchase" : {
        "desclist" : "desclist",
        "numlist" : 9.456612101333725,
        "valutaCg08" : "valutaCg08",
        "dittaCg18" : 0.30134145536422907,
        "flgVenacq" : 0.4867146239815201,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "coddocumMg3g" : "coddocumMg3g",
      "indtestof2" : "0",
      "impdaarrot" : 6.623518433804886,
      "indtestof1" : 3.7814124730767915,
      "pluginData" : {
        "key" : ""
      },
      "flgrottsingdoc" : 8.251625748923757,
      "scimpcor" : 3.804112695731078,
      "additionalData" : {
        "key" : ""
      },
      "dataultord" : "2000-01-23T04:56:07.000+00:00",
      "flgTaxliable" : 0,
      "flgspbol" : 4.459605034958679,
      "magpercor" : 5.877124706116695,
      "taxexemptionno" : "taxexemptionno",
      "scaglspbanc" : 2.380090174313445,
      "macroCategoryCO" : {
        "descrmacrocat" : "descrmacrocat",
        "categorie" : [ null, null ],
        "dittaCg18" : 6.749525837406151,
        "tipocf" : 4.943637496515336,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "macrocat" : "macrocat",
        "extensionData" : [ null, null ]
      },
      "datacreaz" : "2000-01-23T04:56:07.000+00:00",
      "flgspeinc" : 3.901545264248647,
      "codrifalf" : "codrifalf",
      "sc1percor" : 7.835035282970782,
      "listmag" : 3.111202833403195,
      "categoryCO" : {
        "macrocatMg10" : "macrocatMg10",
        "tipocfMg10" : 6.173804034172511,
        "descrcat" : "descrcat",
        "dittaCg18" : 2.535258963197524,
        "categ" : "categ",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "extensionData" : [ null, null ],
      "dittaCg18" : 4.258773108174356,
      "indspesecum" : 8.37823741034869,
      "magimpcor" : 9.897492629215506,
      "datadismis" : "2000-01-23T04:56:07.000+00:00",
      "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
      "macAreaCO" : {
        "descrmacroar" : "descrmacroar",
        "dittaCg18" : 5.747795090145878,
        "idprov" : 0,
        "tipocf" : 7.3842318535314,
        "areas" : [ null, null ],
        "pluginData" : {
          "key" : ""
        },
        "codiceMacroarea" : "codiceMacroarea",
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "indclibloc" : 9.254183946267839,
      "fixedText1" : {
        "descr" : "descr",
        "datainizioval" : "2000-01-23T04:56:07.000+00:00",
        "indTipoevas" : 4.4935252719377825,
        "idprov" : 1,
        "idmediaCg99" : 9.402167524121316,
        "codice" : "codice",
        "datafineval" : "2000-01-23T04:56:07.000+00:00",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ],
        "testo" : "testo"
      },
      "flgart62ctr" : 0,
      "imparrotprec" : 8.28965939814297,
      "areaCO" : {
        "codiceAreaMG" : "codiceAreaMG",
        "macroareaMg07" : "macroareaMg07",
        "dittaCg18" : 0.35262192099236644,
        "zone" : [ {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ null, null ]
        }, {
          "areaMg08" : "areaMg08",
          "macroareaMg08" : "macroareaMg08",
          "dittaCg18" : 2.7977867356748476,
          "idprov" : 9,
          "descrzona" : "descrzona",
          "tipocfMg08" : 0.58919091925136,
          "pluginData" : {
            "key" : ""
          },
          "codiceZona" : "codiceZona",
          "additionalData" : {
            "key" : ""
          },
          "extensionData" : [ null, null ]
        } ],
        "idprov" : 7,
        "tipocfMg07" : 4.332304821875894,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "descrarea" : "descrarea",
        "extensionData" : [ null, null ]
      },
      "dataultvar" : "2000-01-23T04:56:07.000+00:00",
      "tipocfCg44" : 4.518309517874243,
      "fidofactoring" : 4.678947989005849,
      "idmediaCg99" : 1.7325933120207193,
      "datarischio" : "2000-01-23T04:56:07.000+00:00",
      "indstscadest" : 7.606863723092579,
      "grouping2CO" : {
        "codRaggrcf2" : "codRaggrcf2",
        "dittaCg18" : 4.010300976654761,
        "idprov" : 6,
        "descraggrcf2" : "descraggrcf2",
        "idmediaCg99" : 8.276461147928103,
        "tipocf" : 4.141296055235948,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "indclifat" : 1.8268702177058116,
      "fixedExp1" : {
        "flgRicfatriep" : 5.6644160867523485,
        "flgVentstat" : 4.372688051310086,
        "flgIvaincl" : 1,
        "indTipoevas" : 9.785002165136461,
        "idmediaCg99" : 5.7911894223693885,
        "codice" : "codice",
        "indTotspese" : 7.92839742024475,
        "indRotturacorpo" : 1.0639121808530916,
        "indTipospesa" : 7.3718573971919445,
        "extensionData" : [ null, null ],
        "indGesintra" : 3.8008573585058016,
        "descr" : "descr",
        "indFatriep" : 5.974942028545841,
        "indTipotot" : 7.726998920545485,
        "indTipoaliq" : 3.2841216543560217,
        "pluginData" : {
          "key" : ""
        },
        "flgVentamm" : 1.5970080735609526,
        "additionalData" : {
          "key" : ""
        },
        "flgOramin" : 3.812761638325517
      },
      "scperpiede" : 8.675064425986758,
      "rischio" : {
        "indSegnalazionecorpo" : 4.432841187680573,
        "flgAttivo" : 0.36062689002149373,
        "flgScadereins" : 1.9626702727164813,
        "flgOrdini" : 5.296102445648278,
        "flgCalcmovprev" : 2.026856458177285,
        "flgSaldocon" : 3.8156682252305574,
        "pluginData" : {
          "key" : ""
        },
        "flgCalcmovdacons" : 4.1661834558007,
        "additionalData" : {
          "key" : ""
        },
        "flgScadutoins" : 3.0269458094096646,
        "mesiricscadenze" : 9.721046668148785,
        "flgSelclifortrasf" : 7.273019311111276,
        "indElabscadinsol" : 0.4008378390304357,
        "flgScadutonoins" : 8.250639315618633,
        "codice" : "codice",
        "flgEffettiscaduti" : 3.196820582978078,
        "extensionData" : [ null, null ],
        "flgScaderenoins" : 5.573385265048522,
        "flgCalceffcons" : 7.390706075830692,
        "flgCalcmovcons" : 2.0981949483881577,
        "descrizione" : "descrizione",
        "flgCalceffprev" : 6.176386745020588,
        "dittaCg18" : 4.637509675190766,
        "flgCalceffdacons" : 1.0502890910539986,
        "indAttivatrasf" : 8.782449469456207,
        "mesiricordini" : 5.726375546151009,
        "flgSolobusinesriskattivo" : 2.4669941706755685,
        "indProvenienzafido" : 2.5524281586707875,
        "mesiricdocdafatt" : 3.5117904067536143
      },
      "dataultfat" : "2000-01-23T04:56:07.000+00:00",
      "notebloc" : "notebloc",
      "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
      "indgesfido" : 8.761432466225475,
      "flgprzcamp" : 5.507386964179881,
      "inddesdocest" : 3.502657762086401,
      "flgdaticlfat" : 9.702963800023566,
      "indgiorni" : 0.4182561061793122,
      "fidoaziendale" : 1.041444916118296,
      "fidolivello1" : 7.260521264802104,
      "indrottcig" : 5.312489704336296,
      "fidolivello2" : 9.132027271330688,
      "raggruppamentoPrevalente" : {
        "descragg" : "descragg",
        "cliforCg44" : 7.88722683998926,
        "dittaCg18" : 6.918231485891953,
        "idmediaCg99" : 0.11859130807119977,
        "codRag" : "codRag",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "indarrl96" : 8.863729185622827,
      "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
      "flgrottcig" : 6.073898085781152,
      "coddestprev" : "coddestprev",
      "codprevragb" : "codprevragb",
      "art62txt" : "art62txt",
      "flgEstrpayline" : 7.933506881737151,
      "indFattper" : 9.183123594773994,
      "flgqualita" : 4.86315908102884,
      "datablocco" : "2000-01-23T04:56:07.000+00:00",
      "priceListWithMultipleItems" : {
        "descr" : "descr",
        "dittaCg18" : 9.721723570087065,
        "codice" : "codice",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "subCategoryCO" : {
        "descrsottocat" : "descrsottocat",
        "tipocfMg11" : 7.464202015255506,
        "dittaCg18" : 2.922265432447957,
        "sottcat" : "sottcat",
        "categMg11" : "categMg11",
        "macrocatMg11" : "macrocatMg11",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ null, null ]
      },
      "lastchange" : "2000-01-23T04:56:07.000+00:00",
      "sc3percor" : 3.1497903714250555
    },
    "datavaliva" : "2000-01-23T04:56:07.000+00:00",
    "dittaCg18" : 3.0937452626664474,
    "flgart62" : 7,
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "indElenchiMov3000" : 3,
    "lastchange" : "2000-01-23T04:56:07.000+00:00"
  },
  "flgprzcamp" : 2.3021358869347655,
  "inddesdocest" : 6.84685269835264,
  "flgdaticlfat" : 5.962133916683182,
  "indgiorni" : 1.1730742509559433,
  "indarrl96" : 1.0246457001441578,
  "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
  "flgrottcig" : 9.301444243932576,
  "coddestprev" : "coddestprev",
  "blockLevelCO" : {
    "descrblocco" : "descrblocco",
    "dittaCg18" : 6.878052220127876,
    "idmediaCg99" : 5.944895607614016,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codBlocco" : "codBlocco",
    "indPayline" : 6.704019297950036,
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ]
  },
  "art62txt" : "art62txt",
  "indFattper" : 7.457744773683766,
  "flgqualita" : 7.061401241503109,
  "sc3percor" : 3.5571952270680973
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CustomerSupplierExtensionMGDTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGCustomerSupplierExtensionMGValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}

