'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns RecipientMGDTO
 **/
exports.apiV1EnvironmentMGRecipientMGGET = function(_op,environment,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cliforCg44" : 0.8008281904610115,
  "macroareaMg07" : "macroareaMg07",
  "tipocfCg44" : 3.616076749251911,
  "codDestin" : "codDestin",
  "destemail" : "destemail",
  "destnote" : "destnote",
  "destcitta" : "destcitta",
  "destprov" : "destprov",
  "generalMasterDataCO" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 7,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 7.061401241503109,
    "indsoggrit" : 7.457744773683766,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9,
      "extensionData" : [ null, null ]
    },
    "statofiscCg07" : 5.025004791520295,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 2,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 9,
    "citta" : "citta",
    "statonascitaCg07" : 9.965781217890562,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ null, null ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 1.2315135367772556,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.84685269835264,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 0.8774076871421566,
      "flgRegagevo" : 4.86315908102884,
      "idmediaCg99" : 3.901545264248647,
      "percRipPerc" : 1.8268702177058116,
      "flgRitImposta" : 6.073898085781152,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 9.254183946267839,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 7.933506881737151,
      "flgProteo360" : 5.507386964179881,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 9.702963800023566,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 4,
      "idprov" : 0.43431398824148815,
      "codice" : "codice",
      "extensionData" : [ null, null ],
      "percci" : 4.573936264232251,
      "flgSosprit" : 8,
      "descr" : "descr",
      "flgMinimi" : 0,
      "codTributo" : "codTributo",
      "indCodattglad" : 2.9409642974827896,
      "indTipocassa" : 1,
      "percra" : 8.863729185622827,
      "percbaseimp" : 6.623518433804886,
      "codTribrp" : "codTribrp",
      "inpsivs" : 8.28965939814297,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 3.616076749251911,
    "codiceCgc0" : 9.301444243932576,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 1.0246457001441578,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 4.145608029883936,
    "rapazestCg16" : 1,
    "cellnum" : "cellnum",
    "flgPrsfis" : 1.4894159098541704,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 6,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 4.965218492984954,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 5,
    "indweb" : "indweb"
  },
  "nationCO" : {
    "codSian" : 3.353193347011243,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 0.8851374739011653,
    "codice" : 6.704019297950036,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "extensionData" : [ null, null ],
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 3,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 7.058770351582356,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "destindex" : "destindex",
  "additionalData" : {
    "key" : ""
  },
  "destcell" : "destcell",
  "destcap" : 6.027456183070403,
  "flgTaxliable" : 7,
  "taxexemptionno" : "taxexemptionno",
  "destfax" : "destfax",
  "destragsoc" : "destragsoc",
  "destragsocex" : "destragsocex",
  "desttel" : "desttel",
  "tipodestxdoc" : 2.027123023002322,
  "destind" : "destind",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "flgApptaxdata" : 5,
  "flgStetic" : 2.3021358869347655,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "dittaCg18" : 1.4658129805029452,
  "zonaMg09" : "zonaMg09",
  "codAlf" : "codAlf",
  "flgAppiva" : 5,
  "areaMGMg08" : "areaMGMg08",
  "destcapchar" : "destcapchar",
  "indPrefstdoc" : 9.301444243932576,
  "destpec" : "destpec"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGRecipientMGIdDELETE = function(id,environment,cliforCg44,tipocfCg44,authorizationScope,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Example for multilanguage (optional)
 * returns RecipientMGDTO
 **/
exports.apiV1EnvironmentMGRecipientMGIdGET = function(id,environment,cliforCg44,tipocfCg44,authorizationScope,dlevel,dlevelkey,company,user,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cliforCg44" : 0.8008281904610115,
  "macroareaMg07" : "macroareaMg07",
  "tipocfCg44" : 3.616076749251911,
  "codDestin" : "codDestin",
  "destemail" : "destemail",
  "destnote" : "destnote",
  "destcitta" : "destcitta",
  "destprov" : "destprov",
  "generalMasterDataCO" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 7,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 7.061401241503109,
    "indsoggrit" : 7.457744773683766,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9,
      "extensionData" : [ null, null ]
    },
    "statofiscCg07" : 5.025004791520295,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 2,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 9,
    "citta" : "citta",
    "statonascitaCg07" : 9.965781217890562,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ null, null ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 1.2315135367772556,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.84685269835264,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 0.8774076871421566,
      "flgRegagevo" : 4.86315908102884,
      "idmediaCg99" : 3.901545264248647,
      "percRipPerc" : 1.8268702177058116,
      "flgRitImposta" : 6.073898085781152,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 9.254183946267839,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 7.933506881737151,
      "flgProteo360" : 5.507386964179881,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 9.702963800023566,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 4,
      "idprov" : 0.43431398824148815,
      "codice" : "codice",
      "extensionData" : [ null, null ],
      "percci" : 4.573936264232251,
      "flgSosprit" : 8,
      "descr" : "descr",
      "flgMinimi" : 0,
      "codTributo" : "codTributo",
      "indCodattglad" : 2.9409642974827896,
      "indTipocassa" : 1,
      "percra" : 8.863729185622827,
      "percbaseimp" : 6.623518433804886,
      "codTribrp" : "codTribrp",
      "inpsivs" : 8.28965939814297,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 3.616076749251911,
    "codiceCgc0" : 9.301444243932576,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 1.0246457001441578,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 4.145608029883936,
    "rapazestCg16" : 1,
    "cellnum" : "cellnum",
    "flgPrsfis" : 1.4894159098541704,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 6,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 4.965218492984954,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 5,
    "indweb" : "indweb"
  },
  "nationCO" : {
    "codSian" : 3.353193347011243,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 0.8851374739011653,
    "codice" : 6.704019297950036,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "extensionData" : [ null, null ],
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 3,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 7.058770351582356,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "destindex" : "destindex",
  "additionalData" : {
    "key" : ""
  },
  "destcell" : "destcell",
  "destcap" : 6.027456183070403,
  "flgTaxliable" : 7,
  "taxexemptionno" : "taxexemptionno",
  "destfax" : "destfax",
  "destragsoc" : "destragsoc",
  "destragsocex" : "destragsocex",
  "desttel" : "desttel",
  "tipodestxdoc" : 2.027123023002322,
  "destind" : "destind",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "flgApptaxdata" : 5,
  "flgStetic" : 2.3021358869347655,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "dittaCg18" : 1.4658129805029452,
  "zonaMg09" : "zonaMg09",
  "codAlf" : "codAlf",
  "flgAppiva" : 5,
  "areaMGMg08" : "areaMGMg08",
  "destcapchar" : "destcapchar",
  "indPrefstdoc" : 9.301444243932576,
  "destpec" : "destpec"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGRecipientMGIdPATCH = function(body,force,_op,cliforCg44,tipocfCg44,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body RecipientMGDTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional)
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns RecipientMGDTO
 **/
exports.apiV1EnvironmentMGRecipientMGIdPUT = function(body,force,_op,cliforCg44,tipocfCg44,company,user,id,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cliforCg44" : 0.8008281904610115,
  "macroareaMg07" : "macroareaMg07",
  "tipocfCg44" : 3.616076749251911,
  "codDestin" : "codDestin",
  "destemail" : "destemail",
  "destnote" : "destnote",
  "destcitta" : "destcitta",
  "destprov" : "destprov",
  "generalMasterDataCO" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 7,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 7.061401241503109,
    "indsoggrit" : 7.457744773683766,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9,
      "extensionData" : [ null, null ]
    },
    "statofiscCg07" : 5.025004791520295,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 2,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 9,
    "citta" : "citta",
    "statonascitaCg07" : 9.965781217890562,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ null, null ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 1.2315135367772556,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.84685269835264,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 0.8774076871421566,
      "flgRegagevo" : 4.86315908102884,
      "idmediaCg99" : 3.901545264248647,
      "percRipPerc" : 1.8268702177058116,
      "flgRitImposta" : 6.073898085781152,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 9.254183946267839,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 7.933506881737151,
      "flgProteo360" : 5.507386964179881,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 9.702963800023566,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 4,
      "idprov" : 0.43431398824148815,
      "codice" : "codice",
      "extensionData" : [ null, null ],
      "percci" : 4.573936264232251,
      "flgSosprit" : 8,
      "descr" : "descr",
      "flgMinimi" : 0,
      "codTributo" : "codTributo",
      "indCodattglad" : 2.9409642974827896,
      "indTipocassa" : 1,
      "percra" : 8.863729185622827,
      "percbaseimp" : 6.623518433804886,
      "codTribrp" : "codTribrp",
      "inpsivs" : 8.28965939814297,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 3.616076749251911,
    "codiceCgc0" : 9.301444243932576,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 1.0246457001441578,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 4.145608029883936,
    "rapazestCg16" : 1,
    "cellnum" : "cellnum",
    "flgPrsfis" : 1.4894159098541704,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 6,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 4.965218492984954,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 5,
    "indweb" : "indweb"
  },
  "nationCO" : {
    "codSian" : 3.353193347011243,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 0.8851374739011653,
    "codice" : 6.704019297950036,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "extensionData" : [ null, null ],
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 3,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 7.058770351582356,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "destindex" : "destindex",
  "additionalData" : {
    "key" : ""
  },
  "destcell" : "destcell",
  "destcap" : 6.027456183070403,
  "flgTaxliable" : 7,
  "taxexemptionno" : "taxexemptionno",
  "destfax" : "destfax",
  "destragsoc" : "destragsoc",
  "destragsocex" : "destragsocex",
  "desttel" : "desttel",
  "tipodestxdoc" : 2.027123023002322,
  "destind" : "destind",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "flgApptaxdata" : 5,
  "flgStetic" : 2.3021358869347655,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "dittaCg18" : 1.4658129805029452,
  "zonaMg09" : "zonaMg09",
  "codAlf" : "codAlf",
  "flgAppiva" : 5,
  "areaMGMg08" : "areaMGMg08",
  "destcapchar" : "destcapchar",
  "indPrefstdoc" : 9.301444243932576,
  "destpec" : "destpec"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body RecipientMGDTO Object of type to create
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns RecipientMGDTO
 **/
exports.apiV1EnvironmentMGRecipientMGPOST = function(body,cliforCg44,tipocfCg44,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "cliforCg44" : 0.8008281904610115,
  "macroareaMg07" : "macroareaMg07",
  "tipocfCg44" : 3.616076749251911,
  "codDestin" : "codDestin",
  "destemail" : "destemail",
  "destnote" : "destnote",
  "destcitta" : "destcitta",
  "destprov" : "destprov",
  "generalMasterDataCO" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        },
        "extensionData" : [ {
          "value" : "",
          "key" : "key"
        }, {
          "value" : "",
          "key" : "key"
        } ]
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed",
        "extensionData" : [ null, null ]
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "extensionData" : [ null, null ],
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "extensionData" : [ null, null ],
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "extensionData" : [ null, null ],
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "extensionData" : [ null, null ],
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 7,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 7.061401241503109,
    "indsoggrit" : 7.457744773683766,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9,
      "extensionData" : [ null, null ]
    },
    "statofiscCg07" : 5.025004791520295,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 2,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 9,
    "citta" : "citta",
    "statonascitaCg07" : 9.965781217890562,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ null, null ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 1.2315135367772556,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.84685269835264,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 0.8774076871421566,
      "flgRegagevo" : 4.86315908102884,
      "idmediaCg99" : 3.901545264248647,
      "percRipPerc" : 1.8268702177058116,
      "flgRitImposta" : 6.073898085781152,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 9.254183946267839,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 7.933506881737151,
      "flgProteo360" : 5.507386964179881,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 9.702963800023566,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 4,
      "idprov" : 0.43431398824148815,
      "codice" : "codice",
      "extensionData" : [ null, null ],
      "percci" : 4.573936264232251,
      "flgSosprit" : 8,
      "descr" : "descr",
      "flgMinimi" : 0,
      "codTributo" : "codTributo",
      "indCodattglad" : 2.9409642974827896,
      "indTipocassa" : 1,
      "percra" : 8.863729185622827,
      "percbaseimp" : 6.623518433804886,
      "codTribrp" : "codTribrp",
      "inpsivs" : 8.28965939814297,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 3.616076749251911,
    "codiceCgc0" : 9.301444243932576,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 1.0246457001441578,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 4.145608029883936,
    "rapazestCg16" : 1,
    "cellnum" : "cellnum",
    "flgPrsfis" : 1.4894159098541704,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 6,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 4.965218492984954,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 5,
    "indweb" : "indweb"
  },
  "nationCO" : {
    "codSian" : 3.353193347011243,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 0.8851374739011653,
    "codice" : 6.704019297950036,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 7.04836565559697,
      "exchangeRateCO" : [ {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      }, {
        "cambio" : 4.078845849666752,
        "anno" : 3.2588565619047607,
        "idmediaCg99" : 6.628464275087742,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 4,
        "codicerifCg08" : "codicerifCg08",
        "extensionData" : [ null, null ],
        "giorno" : 0.2025324113236393,
        "mese" : 1.041444916118296,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 5.533258397034986,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 8.969578798196912,
      "codice" : "codice",
      "indCertoincerto" : 7,
      "extensionData" : [ null, null ],
      "cambiofisso" : 0.10263654006109402,
      "descr" : "descr",
      "flgValuem" : 4.652396432933246,
      "indValuem" : 3.0576100241049344,
      "indSepmigl" : 3.0205796992916243,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "extensionData" : [ null, null ],
    "descr" : "descr",
    "flgIban" : 3,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 7.058770351582356,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "pluginData" : {
    "key" : ""
  },
  "destindex" : "destindex",
  "additionalData" : {
    "key" : ""
  },
  "destcell" : "destcell",
  "destcap" : 6.027456183070403,
  "flgTaxliable" : 7,
  "taxexemptionno" : "taxexemptionno",
  "destfax" : "destfax",
  "destragsoc" : "destragsoc",
  "destragsocex" : "destragsocex",
  "desttel" : "desttel",
  "tipodestxdoc" : 2.027123023002322,
  "destind" : "destind",
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ],
  "flgApptaxdata" : 5,
  "flgStetic" : 2.3021358869347655,
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "dittaCg18" : 1.4658129805029452,
  "zonaMg09" : "zonaMg09",
  "codAlf" : "codAlf",
  "flgAppiva" : 5,
  "areaMGMg08" : "areaMGMg08",
  "destcapchar" : "destcapchar",
  "indPrefstdoc" : 9.301444243932576,
  "destpec" : "destpec"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body RecipientMGDTO Object of type to validate
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGRecipientMGValidatePOST = function(body,cliforCg44,tipocfCg44,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * cliforCg44 String CliforCg44 Mandatory to execute current action
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Example for multilanguage (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentMGRecipientMGValidatePropertiesPOST = function(body,cliforCg44,tipocfCg44,company,user,environment,authorizationScope,acceptLanguage) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ],
  "extensionData" : [ {
    "value" : "",
    "key" : "key"
  }, {
    "value" : "",
    "key" : "key"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

