# IO.Swagger.Api.StateManagementServiceApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentCOStateManagementServiceGuidGet**](StateManagementServiceApi.md#apiv1environmentcostatemanagementserviceguidget) | **GET** /api/v1/{environment}/CO/StateManagementService/{guid} | Get the current state of an object with the list of available states.
[**ApiV1EnvironmentCOStateManagementServiceHistoryGuidGet**](StateManagementServiceApi.md#apiv1environmentcostatemanagementservicehistoryguidget) | **GET** /api/v1/{environment}/CO/StateManagementService/history/{guid} | Get the current state of an object and the list of operations performed on the state.
[**ApiV1EnvironmentCOStateManagementServiceSetstatePost**](StateManagementServiceApi.md#apiv1environmentcostatemanagementservicesetstatepost) | **POST** /api/v1/{environment}/CO/StateManagementService/setstate | Set a new object state or create default state.

<a name="apiv1environmentcostatemanagementserviceguidget"></a>
# **ApiV1EnvironmentCOStateManagementServiceGuidGet**
> CurrentStateCODTO ApiV1EnvironmentCOStateManagementServiceGuidGet (string guid, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)

Get the current state of an object with the list of available states.

Get the current state of an object with the list of available states.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOStateManagementServiceGuidGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new StateManagementServiceApi();
            var guid = guid_example;  // string | Guid to get the current state of an object with the list of available states.
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Get the current state of an object with the list of available states.
                CurrentStateCODTO result = apiInstance.ApiV1EnvironmentCOStateManagementServiceGuidGet(guid, environment, authorizationScope, company, user, acceptLanguage);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling StateManagementServiceApi.ApiV1EnvironmentCOStateManagementServiceGuidGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **guid** | **string**| Guid to get the current state of an object with the list of available states. | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

[**CurrentStateCODTO**](CurrentStateCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcostatemanagementservicehistoryguidget"></a>
# **ApiV1EnvironmentCOStateManagementServiceHistoryGuidGet**
> CurrentStateHistoryCODTO ApiV1EnvironmentCOStateManagementServiceHistoryGuidGet (string guid, string environment, string authorizationScope, string company = null, string user = null, string acceptLanguage = null)

Get the current state of an object and the list of operations performed on the state.

Get the current state of an object and the list of operations performed on the state.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOStateManagementServiceHistoryGuidGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new StateManagementServiceApi();
            var guid = guid_example;  // string | Guid to get the current state of an object and the list of operations performed on the state.
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Get the current state of an object and the list of operations performed on the state.
                CurrentStateHistoryCODTO result = apiInstance.ApiV1EnvironmentCOStateManagementServiceHistoryGuidGet(guid, environment, authorizationScope, company, user, acceptLanguage);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling StateManagementServiceApi.ApiV1EnvironmentCOStateManagementServiceHistoryGuidGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **guid** | **string**| Guid to get the current state of an object and the list of operations performed on the state. | 
 **environment** | **string**|  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

[**CurrentStateHistoryCODTO**](CurrentStateHistoryCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentcostatemanagementservicesetstatepost"></a>
# **ApiV1EnvironmentCOStateManagementServiceSetstatePost**
> CurrentStateCODTO ApiV1EnvironmentCOStateManagementServiceSetstatePost (SetStateParameterDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Set a new object state or create default state.

Set a new object state or create default state.

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentCOStateManagementServiceSetstatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new StateManagementServiceApi();
            var body = new SetStateParameterDTO(); // SetStateParameterDTO | Parameters to set a new object state or create default state. 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Set a new object state or create default state.
                CurrentStateCODTO result = apiInstance.ApiV1EnvironmentCOStateManagementServiceSetstatePost(body, authorizationScope, environment, acceptLanguage, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling StateManagementServiceApi.ApiV1EnvironmentCOStateManagementServiceSetstatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**SetStateParameterDTO**](SetStateParameterDTO.md)| Parameters to set a new object state or create default state.  | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CurrentStateCODTO**](CurrentStateCODTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
