# IO.Swagger - the C# library for the TSE Cloud - CO

This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).

This C# SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v2025.3000
- SDK version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.dotnet.CSharpClientCodegen
    For more information, please visit [https://mysupport.teamsystem.com/](https://mysupport.teamsystem.com/)

<a name="frameworks-supported"></a>
## Frameworks supported
- .NET 4.7.1 or later

<a name="dependencies"></a>
## Dependencies
- [RestSharp](https://www.nuget.org/packages/RestSharp) - 111.4.1 or later
- [Json.NET](https://www.nuget.org/packages/Newtonsoft.Json/) - 7.0.0 or later
- [JsonSubTypes](https://www.nuget.org/packages/JsonSubTypes/) - 1.2.0 or later

The DLLs included in the package may not be the latest version. We recommend using [NuGet](https://docs.nuget.org/consume/installing-nuget) to obtain the latest version of the packages:
```
Install-Package RestSharp
Install-Package Newtonsoft.Json
Install-Package JsonSubTypes
```

NOTE: RestSharp versions greater than 105.1.0 have a bug which causes file uploads to fail. See [RestSharp#742](https://github.com/restsharp/RestSharp/issues/742)

<a name="installation"></a>
## Installation

Run the following commands to generate the DLL
```
cd src/IO.Swagger
dotnet restore
dotnet build
```

Then include the DLL (under the `bin` folder) in the C# project, and use the namespaces:
```csharp
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;
```

<a name="packaging"></a>
## Packaging

A `.nuspec` is included with the project. You can follow the Nuget quickstart to [create](https://docs.microsoft.com/en-us/nuget/quickstart/create-and-publish-a-package#create-the-package) and [publish](https://docs.microsoft.com/en-us/nuget/quickstart/create-and-publish-a-package#publish-the-package) packages.

This `.nuspec` uses placeholders from the `.csproj`, so build the `.csproj` directly:

```
nuget pack -Build -OutputDirectory out IO.Swagger.csproj
```

Then, publish to a [local feed](https://docs.microsoft.com/en-us/nuget/hosting-packages/local-feeds) or [other host](https://docs.microsoft.com/en-us/nuget/hosting-packages/overview) and consume the new package via Nuget as usual.


<a name="getting-started"></a>
## Getting Started

```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class Example
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new AccountingReasonCodeCOApi();
            var op = op_example;  // string | The value must be 'new'
            var param = param_example;  // string | Specify optional parameters that will be used during entity creation
            var environment = environment_example;  // string | 
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Specifies the UI culture to be used for localization of messages. (optional)  (default to it-IT)
            var acceptTerritory = acceptTerritory_example;  // string | Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)  (default to it-IT)

            try
            {
                // Get new
                AccountingReasonCodeCODTO result = apiInstance.ApiV1EnvironmentCOAccountingReasonCodeCOGet(op, param, environment, authorizationScope, company, user, acceptLanguage, acceptTerritory);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling AccountingReasonCodeCOApi.ApiV1EnvironmentCOAccountingReasonCodeCOGet: " + e.Message );
            }
        }
    }
}
```

<a name="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *https://apicsdemo.teamsystem.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountingReasonCodeCOApi* | [**ApiV1EnvironmentCOAccountingReasonCodeCOGet**](docs/AccountingReasonCodeCOApi.md#apiv1environmentcoaccountingreasoncodecoget) | **GET** /api/v1/{environment}/CO/AccountingReasonCodeCO | Get new
*AccountingReasonCodeCOApi* | [**ApiV1EnvironmentCOAccountingReasonCodeCOIdGet**](docs/AccountingReasonCodeCOApi.md#apiv1environmentcoaccountingreasoncodecoidget) | **GET** /api/v1/{environment}/CO/AccountingReasonCodeCO/{id} | Get by ID
*AccountingReasonCodeCOApi* | [**ApiV1EnvironmentCOAccountingReasonCodeCOValidatePost**](docs/AccountingReasonCodeCOApi.md#apiv1environmentcoaccountingreasoncodecovalidatepost) | **POST** /api/v1/{environment}/CO/AccountingReasonCodeCO/validate | Validate
*AccountingReasonCodeCOApi* | [**ApiV1EnvironmentCOAccountingReasonCodeCOValidatePropertiesPost**](docs/AccountingReasonCodeCOApi.md#apiv1environmentcoaccountingreasoncodecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/AccountingReasonCodeCO/validateProperties | Validation of one on more properties of Type
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOGet**](docs/AgencyCOApi.md#apiv1environmentcoagencycoget) | **GET** /api/v1/{environment}/CO/AgencyCO | Get new
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOIdDelete**](docs/AgencyCOApi.md#apiv1environmentcoagencycoiddelete) | **DELETE** /api/v1/{environment}/CO/AgencyCO/{id} | Delete
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOIdGet**](docs/AgencyCOApi.md#apiv1environmentcoagencycoidget) | **GET** /api/v1/{environment}/CO/AgencyCO/{id} | Get by ID
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOIdPatch**](docs/AgencyCOApi.md#apiv1environmentcoagencycoidpatch) | **PATCH** /api/v1/{environment}/CO/AgencyCO/{id} | Update partial
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOIdPut**](docs/AgencyCOApi.md#apiv1environmentcoagencycoidput) | **PUT** /api/v1/{environment}/CO/AgencyCO/{id} | Update
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOPost**](docs/AgencyCOApi.md#apiv1environmentcoagencycopost) | **POST** /api/v1/{environment}/CO/AgencyCO | Create
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOValidatePost**](docs/AgencyCOApi.md#apiv1environmentcoagencycovalidatepost) | **POST** /api/v1/{environment}/CO/AgencyCO/validate | Validate
*AgencyCOApi* | [**ApiV1EnvironmentCOAgencyCOValidatePropertiesPost**](docs/AgencyCOApi.md#apiv1environmentcoagencycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/AgencyCO/validateProperties | Validation of one on more properties of Type
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOGet**](docs/AgentCOApi.md#apiv1environmentcoagentcoget) | **GET** /api/v1/{environment}/CO/AgentCO | Get new
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOIdDelete**](docs/AgentCOApi.md#apiv1environmentcoagentcoiddelete) | **DELETE** /api/v1/{environment}/CO/AgentCO/{id} | Delete
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOIdGet**](docs/AgentCOApi.md#apiv1environmentcoagentcoidget) | **GET** /api/v1/{environment}/CO/AgentCO/{id} | Get by ID
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOIdPatch**](docs/AgentCOApi.md#apiv1environmentcoagentcoidpatch) | **PATCH** /api/v1/{environment}/CO/AgentCO/{id} | Update partial
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOIdPut**](docs/AgentCOApi.md#apiv1environmentcoagentcoidput) | **PUT** /api/v1/{environment}/CO/AgentCO/{id} | Update
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOPost**](docs/AgentCOApi.md#apiv1environmentcoagentcopost) | **POST** /api/v1/{environment}/CO/AgentCO | Create
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOValidatePost**](docs/AgentCOApi.md#apiv1environmentcoagentcovalidatepost) | **POST** /api/v1/{environment}/CO/AgentCO/validate | Validate
*AgentCOApi* | [**ApiV1EnvironmentCOAgentCOValidatePropertiesPost**](docs/AgentCOApi.md#apiv1environmentcoagentcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/AgentCO/validateProperties | Validation of one on more properties of Type
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOGet**](docs/AreaCOApi.md#apiv1environmentcoareacoget) | **GET** /api/v1/{environment}/CO/AreaCO | Get new
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOIdDelete**](docs/AreaCOApi.md#apiv1environmentcoareacoiddelete) | **DELETE** /api/v1/{environment}/CO/AreaCO/{id} | Delete
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOIdGet**](docs/AreaCOApi.md#apiv1environmentcoareacoidget) | **GET** /api/v1/{environment}/CO/AreaCO/{id} | Get by ID
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOIdPatch**](docs/AreaCOApi.md#apiv1environmentcoareacoidpatch) | **PATCH** /api/v1/{environment}/CO/AreaCO/{id} | Update partial
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOIdPut**](docs/AreaCOApi.md#apiv1environmentcoareacoidput) | **PUT** /api/v1/{environment}/CO/AreaCO/{id} | Update
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOPost**](docs/AreaCOApi.md#apiv1environmentcoareacopost) | **POST** /api/v1/{environment}/CO/AreaCO | Create
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOValidatePost**](docs/AreaCOApi.md#apiv1environmentcoareacovalidatepost) | **POST** /api/v1/{environment}/CO/AreaCO/validate | Validate
*AreaCOApi* | [**ApiV1EnvironmentCOAreaCOValidatePropertiesPost**](docs/AreaCOApi.md#apiv1environmentcoareacovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/AreaCO/validateProperties | Validation of one on more properties of Type
*BankCOApi* | [**ApiV1EnvironmentCOBankCOGet**](docs/BankCOApi.md#apiv1environmentcobankcoget) | **GET** /api/v1/{environment}/CO/BankCO | Get new
*BankCOApi* | [**ApiV1EnvironmentCOBankCOIdDelete**](docs/BankCOApi.md#apiv1environmentcobankcoiddelete) | **DELETE** /api/v1/{environment}/CO/BankCO/{id} | Delete
*BankCOApi* | [**ApiV1EnvironmentCOBankCOIdGet**](docs/BankCOApi.md#apiv1environmentcobankcoidget) | **GET** /api/v1/{environment}/CO/BankCO/{id} | Get by ID
*BankCOApi* | [**ApiV1EnvironmentCOBankCOIdPatch**](docs/BankCOApi.md#apiv1environmentcobankcoidpatch) | **PATCH** /api/v1/{environment}/CO/BankCO/{id} | Update partial
*BankCOApi* | [**ApiV1EnvironmentCOBankCOIdPut**](docs/BankCOApi.md#apiv1environmentcobankcoidput) | **PUT** /api/v1/{environment}/CO/BankCO/{id} | Update
*BankCOApi* | [**ApiV1EnvironmentCOBankCOPost**](docs/BankCOApi.md#apiv1environmentcobankcopost) | **POST** /api/v1/{environment}/CO/BankCO | Create
*BankCOApi* | [**ApiV1EnvironmentCOBankCOValidatePost**](docs/BankCOApi.md#apiv1environmentcobankcovalidatepost) | **POST** /api/v1/{environment}/CO/BankCO/validate | Validate
*BankCOApi* | [**ApiV1EnvironmentCOBankCOValidatePropertiesPost**](docs/BankCOApi.md#apiv1environmentcobankcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/BankCO/validateProperties | Validation of one on more properties of Type
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOGet**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcoget) | **GET** /api/v1/{environment}/CO/CSAccountingIndexCO | Get new
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOIdDelete**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcoiddelete) | **DELETE** /api/v1/{environment}/CO/CSAccountingIndexCO/{id} | Delete
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOIdGet**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcoidget) | **GET** /api/v1/{environment}/CO/CSAccountingIndexCO/{id} | Get by ID
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOIdPatch**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcoidpatch) | **PATCH** /api/v1/{environment}/CO/CSAccountingIndexCO/{id} | Update partial
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOIdPut**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcoidput) | **PUT** /api/v1/{environment}/CO/CSAccountingIndexCO/{id} | Update
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOPost**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcopost) | **POST** /api/v1/{environment}/CO/CSAccountingIndexCO | Create
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOValidatePost**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcovalidatepost) | **POST** /api/v1/{environment}/CO/CSAccountingIndexCO/validate | Validate
*CSAccountingIndexCOApi* | [**ApiV1EnvironmentCOCSAccountingIndexCOValidatePropertiesPost**](docs/CSAccountingIndexCOApi.md#apiv1environmentcocsaccountingindexcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CSAccountingIndexCO/validateProperties | Validation of one on more properties of Type
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOGet**](docs/CategoryCOApi.md#apiv1environmentcocategorycoget) | **GET** /api/v1/{environment}/CO/CategoryCO | Get new
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOIdDelete**](docs/CategoryCOApi.md#apiv1environmentcocategorycoiddelete) | **DELETE** /api/v1/{environment}/CO/CategoryCO/{id} | Delete
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOIdGet**](docs/CategoryCOApi.md#apiv1environmentcocategorycoidget) | **GET** /api/v1/{environment}/CO/CategoryCO/{id} | Get by ID
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOIdPatch**](docs/CategoryCOApi.md#apiv1environmentcocategorycoidpatch) | **PATCH** /api/v1/{environment}/CO/CategoryCO/{id} | Update partial
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOIdPut**](docs/CategoryCOApi.md#apiv1environmentcocategorycoidput) | **PUT** /api/v1/{environment}/CO/CategoryCO/{id} | Update
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOPost**](docs/CategoryCOApi.md#apiv1environmentcocategorycopost) | **POST** /api/v1/{environment}/CO/CategoryCO | Create
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOValidatePost**](docs/CategoryCOApi.md#apiv1environmentcocategorycovalidatepost) | **POST** /api/v1/{environment}/CO/CategoryCO/validate | Validate
*CategoryCOApi* | [**ApiV1EnvironmentCOCategoryCOValidatePropertiesPost**](docs/CategoryCOApi.md#apiv1environmentcocategorycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CategoryCO/validateProperties | Validation of one on more properties of Type
*CityCOApi* | [**ApiV1EnvironmentCOCityCOGet**](docs/CityCOApi.md#apiv1environmentcocitycoget) | **GET** /api/v1/{environment}/CO/CityCO | Get new
*CityCOApi* | [**ApiV1EnvironmentCOCityCOIdDelete**](docs/CityCOApi.md#apiv1environmentcocitycoiddelete) | **DELETE** /api/v1/{environment}/CO/CityCO/{id} | Delete
*CityCOApi* | [**ApiV1EnvironmentCOCityCOIdGet**](docs/CityCOApi.md#apiv1environmentcocitycoidget) | **GET** /api/v1/{environment}/CO/CityCO/{id} | Get by ID
*CityCOApi* | [**ApiV1EnvironmentCOCityCOIdPatch**](docs/CityCOApi.md#apiv1environmentcocitycoidpatch) | **PATCH** /api/v1/{environment}/CO/CityCO/{id} | Update partial
*CityCOApi* | [**ApiV1EnvironmentCOCityCOIdPut**](docs/CityCOApi.md#apiv1environmentcocitycoidput) | **PUT** /api/v1/{environment}/CO/CityCO/{id} | Update
*CityCOApi* | [**ApiV1EnvironmentCOCityCOPost**](docs/CityCOApi.md#apiv1environmentcocitycopost) | **POST** /api/v1/{environment}/CO/CityCO | Create
*CityCOApi* | [**ApiV1EnvironmentCOCityCOValidatePost**](docs/CityCOApi.md#apiv1environmentcocitycovalidatepost) | **POST** /api/v1/{environment}/CO/CityCO/validate | Validate
*CityCOApi* | [**ApiV1EnvironmentCOCityCOValidatePropertiesPost**](docs/CityCOApi.md#apiv1environmentcocitycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CityCO/validateProperties | Validation of one on more properties of Type
*CompanyBankCOApi* | [**ApiV1EnvironmentCOCompanyBankCOGet**](docs/CompanyBankCOApi.md#apiv1environmentcocompanybankcoget) | **GET** /api/v1/{environment}/CO/CompanyBankCO | Get new
*CompanyBankCOApi* | [**ApiV1EnvironmentCOCompanyBankCOIdGet**](docs/CompanyBankCOApi.md#apiv1environmentcocompanybankcoidget) | **GET** /api/v1/{environment}/CO/CompanyBankCO/{id} | Get by ID
*CompanyBankCOApi* | [**ApiV1EnvironmentCOCompanyBankCOValidatePost**](docs/CompanyBankCOApi.md#apiv1environmentcocompanybankcovalidatepost) | **POST** /api/v1/{environment}/CO/CompanyBankCO/validate | Validate
*CompanyBankCOApi* | [**ApiV1EnvironmentCOCompanyBankCOValidatePropertiesPost**](docs/CompanyBankCOApi.md#apiv1environmentcocompanybankcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CompanyBankCO/validateProperties | Validation of one on more properties of Type
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOGet**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscoget) | **GET** /api/v1/{environment}/CO/ContactLinksCO | Get new
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOIdDelete**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscoiddelete) | **DELETE** /api/v1/{environment}/CO/ContactLinksCO/{id} | Delete
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOIdGet**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscoidget) | **GET** /api/v1/{environment}/CO/ContactLinksCO/{id} | Get by ID
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOIdPatch**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscoidpatch) | **PATCH** /api/v1/{environment}/CO/ContactLinksCO/{id} | Update partial
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOIdPut**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscoidput) | **PUT** /api/v1/{environment}/CO/ContactLinksCO/{id} | Update
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOPost**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscopost) | **POST** /api/v1/{environment}/CO/ContactLinksCO | Create
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOValidatePost**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscovalidatepost) | **POST** /api/v1/{environment}/CO/ContactLinksCO/validate | Validate
*ContactLinksCOApi* | [**ApiV1EnvironmentCOContactLinksCOValidatePropertiesPost**](docs/ContactLinksCOApi.md#apiv1environmentcocontactlinkscovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/ContactLinksCO/validateProperties | Validation of one on more properties of Type
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOGet**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcoget) | **GET** /api/v1/{environment}/CO/ContactSubjectCO | Get new
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOIdDelete**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcoiddelete) | **DELETE** /api/v1/{environment}/CO/ContactSubjectCO/{id} | Delete
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOIdGet**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcoidget) | **GET** /api/v1/{environment}/CO/ContactSubjectCO/{id} | Get by ID
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOIdPatch**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcoidpatch) | **PATCH** /api/v1/{environment}/CO/ContactSubjectCO/{id} | Update partial
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOIdPut**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcoidput) | **PUT** /api/v1/{environment}/CO/ContactSubjectCO/{id} | Update
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOPost**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcopost) | **POST** /api/v1/{environment}/CO/ContactSubjectCO | Create
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOValidatePost**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcovalidatepost) | **POST** /api/v1/{environment}/CO/ContactSubjectCO/validate | Validate
*ContactSubjectCOApi* | [**ApiV1EnvironmentCOContactSubjectCOValidatePropertiesPost**](docs/ContactSubjectCOApi.md#apiv1environmentcocontactsubjectcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/ContactSubjectCO/validateProperties | Validation of one on more properties of Type
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOGet**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecoget) | **GET** /api/v1/{environment}/CO/ContactTypeCO | Get new
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOIdDelete**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecoiddelete) | **DELETE** /api/v1/{environment}/CO/ContactTypeCO/{id} | Delete
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOIdGet**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecoidget) | **GET** /api/v1/{environment}/CO/ContactTypeCO/{id} | Get by ID
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOIdPatch**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecoidpatch) | **PATCH** /api/v1/{environment}/CO/ContactTypeCO/{id} | Update partial
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOIdPut**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecoidput) | **PUT** /api/v1/{environment}/CO/ContactTypeCO/{id} | Update
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOPost**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecopost) | **POST** /api/v1/{environment}/CO/ContactTypeCO | Create
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOValidatePost**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecovalidatepost) | **POST** /api/v1/{environment}/CO/ContactTypeCO/validate | Validate
*ContactTypeCOApi* | [**ApiV1EnvironmentCOContactTypeCOValidatePropertiesPost**](docs/ContactTypeCOApi.md#apiv1environmentcocontacttypecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/ContactTypeCO/validateProperties | Validation of one on more properties of Type
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOCalculateAmountByCurrencyPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycocalculateamountbycurrencypost) | **POST** /api/v1/{environment}/CO/CurrencyCO/calculateAmountByCurrency | Calculation of the amount by exchange
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOCalculateExchangeratePost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycocalculateexchangeratepost) | **POST** /api/v1/{environment}/CO/CurrencyCO/calculate_exchangerate | Calculation 'Exchange rate'
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOGet**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoget) | **GET** /api/v1/{environment}/CO/CurrencyCO | Get new
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOIdDelete**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoiddelete) | **DELETE** /api/v1/{environment}/CO/CurrencyCO/{id} | Delete
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOIdGet**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoidget) | **GET** /api/v1/{environment}/CO/CurrencyCO/{id} | Get by ID
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOIdPatch**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoidpatch) | **PATCH** /api/v1/{environment}/CO/CurrencyCO/{id} | Update partial
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOIdPut**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoidput) | **PUT** /api/v1/{environment}/CO/CurrencyCO/{id} | Update
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOImportannualaverageratesPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoimportannualaverageratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importannualaveragerates | Average annual exchange rates import
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOImportcurrencyratesPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoimportcurrencyratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importcurrencyrates | Currency Exchange Import
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOImportmonthlyaverageratesPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoimportmonthlyaverageratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importmonthlyaveragerates | Import of average monthly exchange rates
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOImporttimeseriesratesPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycoimporttimeseriesratespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/importtimeseriesrates | Import time series exchange rates
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycopost) | **POST** /api/v1/{environment}/CO/CurrencyCO | Create
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOValidatePost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycovalidatepost) | **POST** /api/v1/{environment}/CO/CurrencyCO/validate | Validate
*CurrencyCOApi* | [**ApiV1EnvironmentCOCurrencyCOValidatePropertiesPost**](docs/CurrencyCOApi.md#apiv1environmentcocurrencycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CurrencyCO/validateProperties | Validation of one on more properties of Type
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOGet**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacoget) | **GET** /api/v1/{environment}/CO/CustSupplDataInvoicePACO | Get new
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOIdDelete**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacoiddelete) | **DELETE** /api/v1/{environment}/CO/CustSupplDataInvoicePACO/{id} | Delete
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOIdGet**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacoidget) | **GET** /api/v1/{environment}/CO/CustSupplDataInvoicePACO/{id} | Get by ID
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOIdPatch**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacoidpatch) | **PATCH** /api/v1/{environment}/CO/CustSupplDataInvoicePACO/{id} | Update partial
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOIdPut**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacoidput) | **PUT** /api/v1/{environment}/CO/CustSupplDataInvoicePACO/{id} | Update
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOPost**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacopost) | **POST** /api/v1/{environment}/CO/CustSupplDataInvoicePACO | Create
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOValidatePost**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacovalidatepost) | **POST** /api/v1/{environment}/CO/CustSupplDataInvoicePACO/validate | Validate
*CustSupplDataInvoicePACOApi* | [**ApiV1EnvironmentCOCustSupplDataInvoicePACOValidatePropertiesPost**](docs/CustSupplDataInvoicePACOApi.md#apiv1environmentcocustsuppldatainvoicepacovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CustSupplDataInvoicePACO/validateProperties | Validation of one on more properties of Type
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOCreateintegrativedeclaretionPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercocreateintegrativedeclaretionpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/createintegrativedeclaretion | Integrate the letter of intent
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOGet**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoget) | **GET** /api/v1/{environment}/CO/CustomerSupplierCO | Get new
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOGetcswitheffectivepaymentconditionPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercogetcswitheffectivepaymentconditionpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/getcswitheffectivepaymentcondition | Returns the customer/supplier with the actual payment condition
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOGetdefaultrevenueagencyPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercogetdefaultrevenueagencypost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/getdefaultrevenueagency | Retrieve the default revenew agency
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOGetfirstavailablenumnsprotletterofintentPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercogetfirstavailablenumnsprotletterofintentpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/getfirstavailablenumnsprotletterofintent | Retrieve the first available proptocol number for letter of intent
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOHelloTsidGet**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercohellotsidget) | **GET** /api/v1/{environment}/CO/CustomerSupplierCO/hello_tsid | Hello customer
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdChkjointlyheldexistPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidchkjointlyheldexistpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/{id}/chkjointlyheldexist | Check if exist a customer jointly held to selected customer
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdDelete**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoiddelete) | **DELETE** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Delete
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdDeleteallcsjointlyheldPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoiddeleteallcsjointlyheldpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/{id}/deleteallcsjointlyheld | Delete all customers jointly held to selected customer
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdGet**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidget) | **GET** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Get by ID
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdGetnewcodscaglPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidgetnewcodscaglpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/{id}/getnewcodscagl | Retrieve a new code for the payment bracket for the customer
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdPatch**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidpatch) | **PATCH** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Update partial
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOIdPut**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoidput) | **PUT** /api/v1/{environment}/CO/CustomerSupplierCO/{id} | Update
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOInsertsendingletterPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoinsertsendingletterpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/insertsendingletter | Insert letters
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercopost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO | Create
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOUpdatevaluesaftergeneratesendingletterPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercoupdatevaluesaftergeneratesendingletterpost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/updatevaluesaftergeneratesendingletter | Update the generated letters of intent
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOValidatePost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercovalidatepost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/validate | Validate
*CustomerSupplierCOApi* | [**ApiV1EnvironmentCOCustomerSupplierCOValidatePropertiesPost**](docs/CustomerSupplierCOApi.md#apiv1environmentcocustomersuppliercovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/CustomerSupplierCO/validateProperties | Validation of one on more properties of Type
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOGet**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacoget) | **GET** /api/v1/{environment}/CO/GeneralMasterDataCO | Get new
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOGetfromcervedPost**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacogetfromcervedpost) | **POST** /api/v1/{environment}/CO/GeneralMasterDataCO/getfromcerved | GetFromCerved
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOIdDelete**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacoiddelete) | **DELETE** /api/v1/{environment}/CO/GeneralMasterDataCO/{id} | Delete
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOIdGet**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacoidget) | **GET** /api/v1/{environment}/CO/GeneralMasterDataCO/{id} | Get by ID
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOIdPatch**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacoidpatch) | **PATCH** /api/v1/{environment}/CO/GeneralMasterDataCO/{id} | Update partial
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOIdPut**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacoidput) | **PUT** /api/v1/{environment}/CO/GeneralMasterDataCO/{id} | Update
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOPost**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacopost) | **POST** /api/v1/{environment}/CO/GeneralMasterDataCO | Create
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOValidatePost**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacovalidatepost) | **POST** /api/v1/{environment}/CO/GeneralMasterDataCO/validate | Validate
*GeneralMasterDataCOApi* | [**ApiV1EnvironmentCOGeneralMasterDataCOValidatePropertiesPost**](docs/GeneralMasterDataCOApi.md#apiv1environmentcogeneralmasterdatacovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/GeneralMasterDataCO/validateProperties | Validation of one on more properties of Type
*IEExportCOApi* | [**ApiV1EnvironmentCOIEExportCOCustomersupplierPost**](docs/IEExportCOApi.md#apiv1environmentcoieexportcocustomersupplierpost) | **POST** /api/v1/{environment}/CO/IEExportCO/customersupplier | Export Customers/Suppliers based on the required parameters
*IEImportCOApi* | [**ApiV1EnvironmentCOIEImportCOCustomersupplierPost**](docs/IEImportCOApi.md#apiv1environmentcoieimportcocustomersupplierpost) | **POST** /api/v1/{environment}/CO/IEImportCO/customersupplier | Import Customers/Suppliers based on the required parameters
*IELayoutCOApi* | [**ApiV1EnvironmentCOIELayoutCOIdGet**](docs/IELayoutCOApi.md#apiv1environmentcoielayoutcoidget) | **GET** /api/v1/{environment}/CO/IELayoutCO/{id} | Get by ID
*IEServiceCOApi* | [**ApiV1EnvironmentCOIEServiceCOGuidProcessGet**](docs/IEServiceCOApi.md#apiv1environmentcoieservicecoguidprocessget) | **GET** /api/v1/{environment}/CO/IEServiceCO/{GuidProcess} | Get by Guid Session result of import/export
*IEStructureSubTypeCOApi* | [**ApiV1EnvironmentCOIEStructureSubTypeCOIdGet**](docs/IEStructureSubTypeCOApi.md#apiv1environmentcoiestructuresubtypecoidget) | **GET** /api/v1/{environment}/CO/IEStructureSubTypeCO/{id} | Get by ID
*IEStructureTypeCOApi* | [**ApiV1EnvironmentCOIEStructureTypeCOIdGet**](docs/IEStructureTypeCOApi.md#apiv1environmentcoiestructuretypecoidget) | **GET** /api/v1/{environment}/CO/IEStructureTypeCO/{id} | Get by ID
*InstalmentCalculationServiceApi* | [**ApiV1EnvironmentCOInstalmentCalculationServiceInstalmentCalculationPost**](docs/InstalmentCalculationServiceApi.md#apiv1environmentcoinstalmentcalculationserviceinstalmentcalculationpost) | **POST** /api/v1/{environment}/CO/InstalmentCalculationService/InstalmentCalculation | Instalment calculation
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOGet**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecoget) | **GET** /api/v1/{environment}/CO/IntragroupStructureCO | Get new
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOIdDelete**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecoiddelete) | **DELETE** /api/v1/{environment}/CO/IntragroupStructureCO/{id} | Delete
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOIdGet**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecoidget) | **GET** /api/v1/{environment}/CO/IntragroupStructureCO/{id} | Get by ID
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOIdPatch**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecoidpatch) | **PATCH** /api/v1/{environment}/CO/IntragroupStructureCO/{id} | Update partial
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOIdPut**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecoidput) | **PUT** /api/v1/{environment}/CO/IntragroupStructureCO/{id} | Update
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOPost**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecopost) | **POST** /api/v1/{environment}/CO/IntragroupStructureCO | Create
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOValidatePost**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecovalidatepost) | **POST** /api/v1/{environment}/CO/IntragroupStructureCO/validate | Validate
*IntragroupStructureCOApi* | [**ApiV1EnvironmentCOIntragroupStructureCOValidatePropertiesPost**](docs/IntragroupStructureCOApi.md#apiv1environmentcointragroupstructurecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/IntragroupStructureCO/validateProperties | Validation of one on more properties of Type
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOGet**](docs/LanguageCOApi.md#apiv1environmentcolanguagecoget) | **GET** /api/v1/{environment}/CO/LanguageCO | Get new
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOIdDelete**](docs/LanguageCOApi.md#apiv1environmentcolanguagecoiddelete) | **DELETE** /api/v1/{environment}/CO/LanguageCO/{id} | Delete
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOIdGet**](docs/LanguageCOApi.md#apiv1environmentcolanguagecoidget) | **GET** /api/v1/{environment}/CO/LanguageCO/{id} | Get by ID
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOIdPatch**](docs/LanguageCOApi.md#apiv1environmentcolanguagecoidpatch) | **PATCH** /api/v1/{environment}/CO/LanguageCO/{id} | Update partial
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOIdPut**](docs/LanguageCOApi.md#apiv1environmentcolanguagecoidput) | **PUT** /api/v1/{environment}/CO/LanguageCO/{id} | Update
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOPost**](docs/LanguageCOApi.md#apiv1environmentcolanguagecopost) | **POST** /api/v1/{environment}/CO/LanguageCO | Create
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOValidatePost**](docs/LanguageCOApi.md#apiv1environmentcolanguagecovalidatepost) | **POST** /api/v1/{environment}/CO/LanguageCO/validate | Validate
*LanguageCOApi* | [**ApiV1EnvironmentCOLanguageCOValidatePropertiesPost**](docs/LanguageCOApi.md#apiv1environmentcolanguagecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/LanguageCO/validateProperties | Validation of one on more properties of Type
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOGet**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacoget) | **GET** /api/v1/{environment}/CO/MacroAreaCO | Get new
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOIdDelete**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacoiddelete) | **DELETE** /api/v1/{environment}/CO/MacroAreaCO/{id} | Delete
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOIdGet**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacoidget) | **GET** /api/v1/{environment}/CO/MacroAreaCO/{id} | Get by ID
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOIdPatch**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacoidpatch) | **PATCH** /api/v1/{environment}/CO/MacroAreaCO/{id} | Update partial
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOIdPut**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacoidput) | **PUT** /api/v1/{environment}/CO/MacroAreaCO/{id} | Update
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOPost**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacopost) | **POST** /api/v1/{environment}/CO/MacroAreaCO | Create
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOValidatePost**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacovalidatepost) | **POST** /api/v1/{environment}/CO/MacroAreaCO/validate | Validate
*MacroAreaCOApi* | [**ApiV1EnvironmentCOMacroAreaCOValidatePropertiesPost**](docs/MacroAreaCOApi.md#apiv1environmentcomacroareacovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/MacroAreaCO/validateProperties | Validation of one on more properties of Type
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOGet**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycoget) | **GET** /api/v1/{environment}/CO/MacroCategoryCO | Get new
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOIdDelete**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycoiddelete) | **DELETE** /api/v1/{environment}/CO/MacroCategoryCO/{id} | Delete
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOIdGet**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycoidget) | **GET** /api/v1/{environment}/CO/MacroCategoryCO/{id} | Get by ID
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOIdPatch**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycoidpatch) | **PATCH** /api/v1/{environment}/CO/MacroCategoryCO/{id} | Update partial
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOIdPut**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycoidput) | **PUT** /api/v1/{environment}/CO/MacroCategoryCO/{id} | Update
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOPost**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycopost) | **POST** /api/v1/{environment}/CO/MacroCategoryCO | Create
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOValidatePost**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycovalidatepost) | **POST** /api/v1/{environment}/CO/MacroCategoryCO/validate | Validate
*MacroCategoryCOApi* | [**ApiV1EnvironmentCOMacroCategoryCOValidatePropertiesPost**](docs/MacroCategoryCOApi.md#apiv1environmentcomacrocategorycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/MacroCategoryCO/validateProperties | Validation of one on more properties of Type
*NationCOApi* | [**ApiV1EnvironmentCONationCOGet**](docs/NationCOApi.md#apiv1environmentconationcoget) | **GET** /api/v1/{environment}/CO/NationCO | Get new
*NationCOApi* | [**ApiV1EnvironmentCONationCOIdDelete**](docs/NationCOApi.md#apiv1environmentconationcoiddelete) | **DELETE** /api/v1/{environment}/CO/NationCO/{id} | Delete
*NationCOApi* | [**ApiV1EnvironmentCONationCOIdGet**](docs/NationCOApi.md#apiv1environmentconationcoidget) | **GET** /api/v1/{environment}/CO/NationCO/{id} | Get by ID
*NationCOApi* | [**ApiV1EnvironmentCONationCOIdPatch**](docs/NationCOApi.md#apiv1environmentconationcoidpatch) | **PATCH** /api/v1/{environment}/CO/NationCO/{id} | Update partial
*NationCOApi* | [**ApiV1EnvironmentCONationCOIdPut**](docs/NationCOApi.md#apiv1environmentconationcoidput) | **PUT** /api/v1/{environment}/CO/NationCO/{id} | Update
*NationCOApi* | [**ApiV1EnvironmentCONationCOPost**](docs/NationCOApi.md#apiv1environmentconationcopost) | **POST** /api/v1/{environment}/CO/NationCO | Create
*NationCOApi* | [**ApiV1EnvironmentCONationCOValidatePost**](docs/NationCOApi.md#apiv1environmentconationcovalidatepost) | **POST** /api/v1/{environment}/CO/NationCO/validate | Validate
*NationCOApi* | [**ApiV1EnvironmentCONationCOValidatePropertiesPost**](docs/NationCOApi.md#apiv1environmentconationcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/NationCO/validateProperties | Validation of one on more properties of Type
*NatureAssCOApi* | [**ApiV1EnvironmentCONatureAssCOGet**](docs/NatureAssCOApi.md#apiv1environmentconatureasscoget) | **GET** /api/v1/{environment}/CO/NatureAssCO | Get new
*NatureAssCOApi* | [**ApiV1EnvironmentCONatureAssCOIdGet**](docs/NatureAssCOApi.md#apiv1environmentconatureasscoidget) | **GET** /api/v1/{environment}/CO/NatureAssCO/{id} | Get by ID
*NatureAssCOApi* | [**ApiV1EnvironmentCONatureAssCOValidatePost**](docs/NatureAssCOApi.md#apiv1environmentconatureasscovalidatepost) | **POST** /api/v1/{environment}/CO/NatureAssCO/validate | Validate
*NatureAssCOApi* | [**ApiV1EnvironmentCONatureAssCOValidatePropertiesPost**](docs/NatureAssCOApi.md#apiv1environmentconatureasscovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/NatureAssCO/validateProperties | Validation of one on more properties of Type
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOGet**](docs/NatureEsCOApi.md#apiv1environmentconatureescoget) | **GET** /api/v1/{environment}/CO/NatureEsCO | Get new
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOIdDelete**](docs/NatureEsCOApi.md#apiv1environmentconatureescoiddelete) | **DELETE** /api/v1/{environment}/CO/NatureEsCO/{id} | Delete
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOIdGet**](docs/NatureEsCOApi.md#apiv1environmentconatureescoidget) | **GET** /api/v1/{environment}/CO/NatureEsCO/{id} | Get by ID
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOIdPatch**](docs/NatureEsCOApi.md#apiv1environmentconatureescoidpatch) | **PATCH** /api/v1/{environment}/CO/NatureEsCO/{id} | Update partial
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOIdPut**](docs/NatureEsCOApi.md#apiv1environmentconatureescoidput) | **PUT** /api/v1/{environment}/CO/NatureEsCO/{id} | Update
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOPost**](docs/NatureEsCOApi.md#apiv1environmentconatureescopost) | **POST** /api/v1/{environment}/CO/NatureEsCO | Create
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOValidatePost**](docs/NatureEsCOApi.md#apiv1environmentconatureescovalidatepost) | **POST** /api/v1/{environment}/CO/NatureEsCO/validate | Validate
*NatureEsCOApi* | [**ApiV1EnvironmentCONatureEsCOValidatePropertiesPost**](docs/NatureEsCOApi.md#apiv1environmentconatureescovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/NatureEsCO/validateProperties | Validation of one on more properties of Type
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOGet**](docs/OfficeCOApi.md#apiv1environmentcoofficecoget) | **GET** /api/v1/{environment}/CO/OfficeCO | Get new
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOIdDelete**](docs/OfficeCOApi.md#apiv1environmentcoofficecoiddelete) | **DELETE** /api/v1/{environment}/CO/OfficeCO/{id} | Delete
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOIdGet**](docs/OfficeCOApi.md#apiv1environmentcoofficecoidget) | **GET** /api/v1/{environment}/CO/OfficeCO/{id} | Get by ID
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOIdPatch**](docs/OfficeCOApi.md#apiv1environmentcoofficecoidpatch) | **PATCH** /api/v1/{environment}/CO/OfficeCO/{id} | Update partial
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOIdPut**](docs/OfficeCOApi.md#apiv1environmentcoofficecoidput) | **PUT** /api/v1/{environment}/CO/OfficeCO/{id} | Update
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOPost**](docs/OfficeCOApi.md#apiv1environmentcoofficecopost) | **POST** /api/v1/{environment}/CO/OfficeCO | Create
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOValidatePost**](docs/OfficeCOApi.md#apiv1environmentcoofficecovalidatepost) | **POST** /api/v1/{environment}/CO/OfficeCO/validate | Validate
*OfficeCOApi* | [**ApiV1EnvironmentCOOfficeCOValidatePropertiesPost**](docs/OfficeCOApi.md#apiv1environmentcoofficecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/OfficeCO/validateProperties | Validation of one on more properties of Type
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOGet**](docs/OfficePACOApi.md#apiv1environmentcoofficepacoget) | **GET** /api/v1/{environment}/CO/OfficePACO | Get new
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOIdDelete**](docs/OfficePACOApi.md#apiv1environmentcoofficepacoiddelete) | **DELETE** /api/v1/{environment}/CO/OfficePACO/{id} | Delete
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOIdGet**](docs/OfficePACOApi.md#apiv1environmentcoofficepacoidget) | **GET** /api/v1/{environment}/CO/OfficePACO/{id} | Get by ID
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOIdPatch**](docs/OfficePACOApi.md#apiv1environmentcoofficepacoidpatch) | **PATCH** /api/v1/{environment}/CO/OfficePACO/{id} | Update partial
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOIdPut**](docs/OfficePACOApi.md#apiv1environmentcoofficepacoidput) | **PUT** /api/v1/{environment}/CO/OfficePACO/{id} | Update
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOPost**](docs/OfficePACOApi.md#apiv1environmentcoofficepacopost) | **POST** /api/v1/{environment}/CO/OfficePACO | Create
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOValidatePost**](docs/OfficePACOApi.md#apiv1environmentcoofficepacovalidatepost) | **POST** /api/v1/{environment}/CO/OfficePACO/validate | Validate
*OfficePACOApi* | [**ApiV1EnvironmentCOOfficePACOValidatePropertiesPost**](docs/OfficePACOApi.md#apiv1environmentcoofficepacovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/OfficePACO/validateProperties | Validation of one on more properties of Type
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOCalculateSumPost**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcocalculatesumpost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/calculate_sum | Calculate the sum of the percentages
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOGet**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcoget) | **GET** /api/v1/{environment}/CO/PaymentTermCO | Get new
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOGetFromCodePost**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcogetfromcodepost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/get_from_code | Retrieve the payment term from code
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOIdDelete**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcoiddelete) | **DELETE** /api/v1/{environment}/CO/PaymentTermCO/{id} | Delete
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOIdGet**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcoidget) | **GET** /api/v1/{environment}/CO/PaymentTermCO/{id} | Get by ID
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOIdPatch**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcoidpatch) | **PATCH** /api/v1/{environment}/CO/PaymentTermCO/{id} | Update partial
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOIdPut**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcoidput) | **PUT** /api/v1/{environment}/CO/PaymentTermCO/{id} | Update
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOPaymentTermDuplicationPost**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcopaymenttermduplicationpost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/PaymentTermDuplication | Duplication of Payment Term
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOPost**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcopost) | **POST** /api/v1/{environment}/CO/PaymentTermCO | Create
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOValidatePost**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcovalidatepost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/validate | Validate
*PaymentTermCOApi* | [**ApiV1EnvironmentCOPaymentTermCOValidatePropertiesPost**](docs/PaymentTermCOApi.md#apiv1environmentcopaymenttermcovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/PaymentTermCO/validateProperties | Validation of one on more properties of Type
*PgmExecApi* | [**ApiV1EnvironmentCOPgmExecPgmexecschedulerasyncPost**](docs/PgmExecApi.md#apiv1environmentcopgmexecpgmexecschedulerasyncpost) | **POST** /api/v1/{environment}/CO/PgmExec/pgmexecschedulerasync | Schedule and Execute program
*ProvinceCOApi* | [**ApiV1EnvironmentCOProvinceCOIdGet**](docs/ProvinceCOApi.md#apiv1environmentcoprovincecoidget) | **GET** /api/v1/{environment}/CO/ProvinceCO/{id} | Get by ID
*RegionCOApi* | [**ApiV1EnvironmentCORegionCOIdGet**](docs/RegionCOApi.md#apiv1environmentcoregioncoidget) | **GET** /api/v1/{environment}/CO/RegionCO/{id} | Get by ID
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOGet**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacoget) | **GET** /api/v1/{environment}/CO/SectionalMasterDataCO | Get new
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOGetSectionalMasterDataProposalPost**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacogetsectionalmasterdataproposalpost) | **POST** /api/v1/{environment}/CO/SectionalMasterDataCO/Get_SectionalMasterDataProposal | Proposes the sectional
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOIdDelete**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacoiddelete) | **DELETE** /api/v1/{environment}/CO/SectionalMasterDataCO/{id} | Delete
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOIdGet**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacoidget) | **GET** /api/v1/{environment}/CO/SectionalMasterDataCO/{id} | Get by ID
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOIdPatch**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacoidpatch) | **PATCH** /api/v1/{environment}/CO/SectionalMasterDataCO/{id} | Update partial
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOIdPut**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacoidput) | **PUT** /api/v1/{environment}/CO/SectionalMasterDataCO/{id} | Update
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOPost**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacopost) | **POST** /api/v1/{environment}/CO/SectionalMasterDataCO | Create
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOValidatePost**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacovalidatepost) | **POST** /api/v1/{environment}/CO/SectionalMasterDataCO/validate | Validate
*SectionalMasterDataCOApi* | [**ApiV1EnvironmentCOSectionalMasterDataCOValidatePropertiesPost**](docs/SectionalMasterDataCOApi.md#apiv1environmentcosectionalmasterdatacovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/SectionalMasterDataCO/validateProperties | Validation of one on more properties of Type
*StateManagementServiceApi* | [**ApiV1EnvironmentCOStateManagementServiceGuidGet**](docs/StateManagementServiceApi.md#apiv1environmentcostatemanagementserviceguidget) | **GET** /api/v1/{environment}/CO/StateManagementService/{guid} | Get the current state of an object with the list of available states.
*StateManagementServiceApi* | [**ApiV1EnvironmentCOStateManagementServiceHistoryGuidGet**](docs/StateManagementServiceApi.md#apiv1environmentcostatemanagementservicehistoryguidget) | **GET** /api/v1/{environment}/CO/StateManagementService/history/{guid} | Get the current state of an object and the list of operations performed on the state.
*StateManagementServiceApi* | [**ApiV1EnvironmentCOStateManagementServiceSetstatePost**](docs/StateManagementServiceApi.md#apiv1environmentcostatemanagementservicesetstatepost) | **POST** /api/v1/{environment}/CO/StateManagementService/setstate | Set a new object state or create default state.
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOGet**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycoget) | **GET** /api/v1/{environment}/CO/SubCategoryCO | Get new
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOIdDelete**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycoiddelete) | **DELETE** /api/v1/{environment}/CO/SubCategoryCO/{id} | Delete
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOIdGet**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycoidget) | **GET** /api/v1/{environment}/CO/SubCategoryCO/{id} | Get by ID
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOIdPatch**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycoidpatch) | **PATCH** /api/v1/{environment}/CO/SubCategoryCO/{id} | Update partial
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOIdPut**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycoidput) | **PUT** /api/v1/{environment}/CO/SubCategoryCO/{id} | Update
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOPost**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycopost) | **POST** /api/v1/{environment}/CO/SubCategoryCO | Create
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOValidatePost**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycovalidatepost) | **POST** /api/v1/{environment}/CO/SubCategoryCO/validate | Validate
*SubCategoryCOApi* | [**ApiV1EnvironmentCOSubCategoryCOValidatePropertiesPost**](docs/SubCategoryCOApi.md#apiv1environmentcosubcategorycovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/SubCategoryCO/validateProperties | Validation of one on more properties of Type
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOGet**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecoget) | **GET** /api/v1/{environment}/CO/UnitOfMeasureCO | Get new
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOIdDelete**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecoiddelete) | **DELETE** /api/v1/{environment}/CO/UnitOfMeasureCO/{id} | Delete
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOIdGet**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecoidget) | **GET** /api/v1/{environment}/CO/UnitOfMeasureCO/{id} | Get by ID
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOIdPatch**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecoidpatch) | **PATCH** /api/v1/{environment}/CO/UnitOfMeasureCO/{id} | Update partial
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOIdPut**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecoidput) | **PUT** /api/v1/{environment}/CO/UnitOfMeasureCO/{id} | Update
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOPost**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecopost) | **POST** /api/v1/{environment}/CO/UnitOfMeasureCO | Create
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOValidatePost**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecovalidatepost) | **POST** /api/v1/{environment}/CO/UnitOfMeasureCO/validate | Validate
*UnitOfMeasureCOApi* | [**ApiV1EnvironmentCOUnitOfMeasureCOValidatePropertiesPost**](docs/UnitOfMeasureCOApi.md#apiv1environmentcounitofmeasurecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/UnitOfMeasureCO/validateProperties | Validation of one on more properties of Type
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOGet**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecoget) | **GET** /api/v1/{environment}/CO/VatCodeCO | Get new
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOIdDelete**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecoiddelete) | **DELETE** /api/v1/{environment}/CO/VatCodeCO/{id} | Delete
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOIdGet**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecoidget) | **GET** /api/v1/{environment}/CO/VatCodeCO/{id} | Get by ID
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOIdPatch**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecoidpatch) | **PATCH** /api/v1/{environment}/CO/VatCodeCO/{id} | Update partial
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOIdPut**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecoidput) | **PUT** /api/v1/{environment}/CO/VatCodeCO/{id} | Update
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOIdVerificaMovimentazioneProgressiviPost**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecoidverificamovimentazioneprogressivipost) | **POST** /api/v1/{environment}/CO/VatCodeCO/{id}/verifica_movimentazione_progressivi | Check Progressive Handling
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOPost**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecopost) | **POST** /api/v1/{environment}/CO/VatCodeCO | Create
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOValidatePost**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecovalidatepost) | **POST** /api/v1/{environment}/CO/VatCodeCO/validate | Validate
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOValidatePropertiesPost**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/VatCodeCO/validateProperties | Validation of one on more properties of Type
*VatCodeCOApi* | [**ApiV1EnvironmentCOVatCodeCOVatCodeDuplicationPost**](docs/VatCodeCOApi.md#apiv1environmentcovatcodecovatcodeduplicationpost) | **POST** /api/v1/{environment}/CO/VatCodeCO/VatCodeDuplication | Duplication of VatCode
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOGet**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecoget) | **GET** /api/v1/{environment}/CO/WTCodeCO | Get new
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOIdDelete**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecoiddelete) | **DELETE** /api/v1/{environment}/CO/WTCodeCO/{id} | Delete
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOIdGet**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecoidget) | **GET** /api/v1/{environment}/CO/WTCodeCO/{id} | Get by ID
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOIdPatch**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecoidpatch) | **PATCH** /api/v1/{environment}/CO/WTCodeCO/{id} | Update partial
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOIdPut**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecoidput) | **PUT** /api/v1/{environment}/CO/WTCodeCO/{id} | Update
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOPost**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecopost) | **POST** /api/v1/{environment}/CO/WTCodeCO | Create
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOValidatePost**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecovalidatepost) | **POST** /api/v1/{environment}/CO/WTCodeCO/validate | Validate
*WTCodeCOApi* | [**ApiV1EnvironmentCOWTCodeCOValidatePropertiesPost**](docs/WTCodeCOApi.md#apiv1environmentcowtcodecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/WTCodeCO/validateProperties | Validation of one on more properties of Type
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOGet**](docs/ZoneCOApi.md#apiv1environmentcozonecoget) | **GET** /api/v1/{environment}/CO/ZoneCO | Get new
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOIdDelete**](docs/ZoneCOApi.md#apiv1environmentcozonecoiddelete) | **DELETE** /api/v1/{environment}/CO/ZoneCO/{id} | Delete
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOIdGet**](docs/ZoneCOApi.md#apiv1environmentcozonecoidget) | **GET** /api/v1/{environment}/CO/ZoneCO/{id} | Get by ID
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOIdPatch**](docs/ZoneCOApi.md#apiv1environmentcozonecoidpatch) | **PATCH** /api/v1/{environment}/CO/ZoneCO/{id} | Update partial
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOIdPut**](docs/ZoneCOApi.md#apiv1environmentcozonecoidput) | **PUT** /api/v1/{environment}/CO/ZoneCO/{id} | Update
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOPost**](docs/ZoneCOApi.md#apiv1environmentcozonecopost) | **POST** /api/v1/{environment}/CO/ZoneCO | Create
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOValidatePost**](docs/ZoneCOApi.md#apiv1environmentcozonecovalidatepost) | **POST** /api/v1/{environment}/CO/ZoneCO/validate | Validate
*ZoneCOApi* | [**ApiV1EnvironmentCOZoneCOValidatePropertiesPost**](docs/ZoneCOApi.md#apiv1environmentcozonecovalidatepropertiespost) | **POST** /api/v1/{environment}/CO/ZoneCO/validateProperties | Validation of one on more properties of Type

<a name="documentation-for-models"></a>
## Documentation for Models

 - [Model.AccountingReasonCodeCODTO](docs/AccountingReasonCodeCODTO.md)
 - [Model.AccountingReasonCodeClassificationCODTO](docs/AccountingReasonCodeClassificationCODTO.md)
 - [Model.ActionResult](docs/ActionResult.md)
 - [Model.AddressCODTO](docs/AddressCODTO.md)
 - [Model.AddressTypeCODTO](docs/AddressTypeCODTO.md)
 - [Model.AgencyCODTO](docs/AgencyCODTO.md)
 - [Model.AgentCODTO](docs/AgentCODTO.md)
 - [Model.AreaCODTO](docs/AreaCODTO.md)
 - [Model.BankCODTO](docs/BankCODTO.md)
 - [Model.CIGCUPMasterDataCODTO](docs/CIGCUPMasterDataCODTO.md)
 - [Model.CSAccountingIndexCODTO](docs/CSAccountingIndexCODTO.md)
 - [Model.CSBankCODTO](docs/CSBankCODTO.md)
 - [Model.CSCompanyBankCODTO](docs/CSCompanyBankCODTO.md)
 - [Model.CSHistorySddCODTO](docs/CSHistorySddCODTO.md)
 - [Model.CSInfoCODTO](docs/CSInfoCODTO.md)
 - [Model.CSJointlyHeldCODTO](docs/CSJointlyHeldCODTO.md)
 - [Model.CSLetterOfIntentCODTO](docs/CSLetterOfIntentCODTO.md)
 - [Model.CSPaymentRangeCODTO](docs/CSPaymentRangeCODTO.md)
 - [Model.CSPostponementPeriodCODTO](docs/CSPostponementPeriodCODTO.md)
 - [Model.CSSddCODTO](docs/CSSddCODTO.md)
 - [Model.CSWithEffectivePaymentConditionParametersDTO](docs/CSWithEffectivePaymentConditionParametersDTO.md)
 - [Model.CalculateAmountParametersDTO](docs/CalculateAmountParametersDTO.md)
 - [Model.CalculateAmountResultDTO](docs/CalculateAmountResultDTO.md)
 - [Model.CalculateExchangeRateParametersDTO](docs/CalculateExchangeRateParametersDTO.md)
 - [Model.CalculateExchangeRateResultDTO](docs/CalculateExchangeRateResultDTO.md)
 - [Model.CategoryCODTO](docs/CategoryCODTO.md)
 - [Model.CityCODTO](docs/CityCODTO.md)
 - [Model.CodePaymentTermCOParametersDTO](docs/CodePaymentTermCOParametersDTO.md)
 - [Model.CompanyBankCODTO](docs/CompanyBankCODTO.md)
 - [Model.ContactLinksCODTO](docs/ContactLinksCODTO.md)
 - [Model.ContactSubjectCODTO](docs/ContactSubjectCODTO.md)
 - [Model.ContactTypeCODTO](docs/ContactTypeCODTO.md)
 - [Model.CurrencyCODTO](docs/CurrencyCODTO.md)
 - [Model.CurrentStateCODTO](docs/CurrentStateCODTO.md)
 - [Model.CurrentStateHistoryCODTO](docs/CurrentStateHistoryCODTO.md)
 - [Model.CustSupplDataInvoicePACODTO](docs/CustSupplDataInvoicePACODTO.md)
 - [Model.CustomerSupplierCIGCUPCODTO](docs/CustomerSupplierCIGCUPCODTO.md)
 - [Model.CustomerSupplierCODTO](docs/CustomerSupplierCODTO.md)
 - [Model.DMSPublishedEntityFWDTO](docs/DMSPublishedEntityFWDTO.md)
 - [Model.ExchangeRateCODTO](docs/ExchangeRateCODTO.md)
 - [Model.ExportCustomerSupplierCOAddParameterDTO](docs/ExportCustomerSupplierCOAddParameterDTO.md)
 - [Model.ExportCustomerSupplierCOParameterDTO](docs/ExportCustomerSupplierCOParameterDTO.md)
 - [Model.FederalStateViewCODTO](docs/FederalStateViewCODTO.md)
 - [Model.ForeignPaymentCodeCODTO](docs/ForeignPaymentCodeCODTO.md)
 - [Model.GMDUpdateAdditionalParametersDTO](docs/GMDUpdateAdditionalParametersDTO.md)
 - [Model.GeneralMasterDataCODTO](docs/GeneralMasterDataCODTO.md)
 - [Model.GetFirstAvailableNumNsProtLetterOfIntentParametersDTO](docs/GetFirstAvailableNumNsProtLetterOfIntentParametersDTO.md)
 - [Model.GetFirstAvailableNumNsProtLetterOfIntentResultDTO](docs/GetFirstAvailableNumNsProtLetterOfIntentResultDTO.md)
 - [Model.GetFromCervedParametersDTO](docs/GetFromCervedParametersDTO.md)
 - [Model.GetNewCodScaglCSPaymentRangeResultDTO](docs/GetNewCodScaglCSPaymentRangeResultDTO.md)
 - [Model.Grouping1CODTO](docs/Grouping1CODTO.md)
 - [Model.Grouping2CODTO](docs/Grouping2CODTO.md)
 - [Model.Grouping3CODTO](docs/Grouping3CODTO.md)
 - [Model.HistoryStateCODTO](docs/HistoryStateCODTO.md)
 - [Model.IELayoutCODTO](docs/IELayoutCODTO.md)
 - [Model.IEStructureSubTypeCODTO](docs/IEStructureSubTypeCODTO.md)
 - [Model.IEStructureTypeCODTO](docs/IEStructureTypeCODTO.md)
 - [Model.ImportAnnualAverageRatesInputDTO](docs/ImportAnnualAverageRatesInputDTO.md)
 - [Model.ImportCurrencyRatesInputDTO](docs/ImportCurrencyRatesInputDTO.md)
 - [Model.ImportCurrencyRatesOutputDTO](docs/ImportCurrencyRatesOutputDTO.md)
 - [Model.ImportCustomerSupplierCOAddParameterDTO](docs/ImportCustomerSupplierCOAddParameterDTO.md)
 - [Model.ImportCustomerSupplierCOParameterDTO](docs/ImportCustomerSupplierCOParameterDTO.md)
 - [Model.ImportExportHeadResultDTO](docs/ImportExportHeadResultDTO.md)
 - [Model.ImportExportResultDTO](docs/ImportExportResultDTO.md)
 - [Model.ImportExportRowResultDTO](docs/ImportExportRowResultDTO.md)
 - [Model.ImportMonthlyAverageRatesInputDTO](docs/ImportMonthlyAverageRatesInputDTO.md)
 - [Model.ImportTimeSeriesRatesInputDTO](docs/ImportTimeSeriesRatesInputDTO.md)
 - [Model.InstalmentCalculationParametersDTO](docs/InstalmentCalculationParametersDTO.md)
 - [Model.IntegrativeDeclarationParametersCODTO](docs/IntegrativeDeclarationParametersCODTO.md)
 - [Model.IntegrativeDeclarationResultDTO](docs/IntegrativeDeclarationResultDTO.md)
 - [Model.IntragroupStructureCODTO](docs/IntragroupStructureCODTO.md)
 - [Model.JointlyHeldCOAlreadyExistsParametersDTO](docs/JointlyHeldCOAlreadyExistsParametersDTO.md)
 - [Model.JointlyHeldCOAlreadyExistsResultDTO](docs/JointlyHeldCOAlreadyExistsResultDTO.md)
 - [Model.LanguageCODTO](docs/LanguageCODTO.md)
 - [Model.MacroAreaCODTO](docs/MacroAreaCODTO.md)
 - [Model.MacroCategoryCODTO](docs/MacroCategoryCODTO.md)
 - [Model.NationCODTO](docs/NationCODTO.md)
 - [Model.NatureAssCODTO](docs/NatureAssCODTO.md)
 - [Model.NatureEsCODTO](docs/NatureEsCODTO.md)
 - [Model.NumDocOrigProposalDTO](docs/NumDocOrigProposalDTO.md)
 - [Model.OfficeCODTO](docs/OfficeCODTO.md)
 - [Model.OfficePACODTO](docs/OfficePACODTO.md)
 - [Model.OneOfSearchGroupDTOItemsItems](docs/OneOfSearchGroupDTOItemsItems.md)
 - [Model.PaymentTermCODTO](docs/PaymentTermCODTO.md)
 - [Model.PaymentTermDetailCODTO](docs/PaymentTermDetailCODTO.md)
 - [Model.PaymentTermDetailCOParametersDTO](docs/PaymentTermDetailCOParametersDTO.md)
 - [Model.PaymentTermDetailCalculationResultCODTO](docs/PaymentTermDetailCalculationResultCODTO.md)
 - [Model.PaymentTermDuplicationParametersCODTO](docs/PaymentTermDuplicationParametersCODTO.md)
 - [Model.PgmExecDTO](docs/PgmExecDTO.md)
 - [Model.ProtocolCalculationResultDTO](docs/ProtocolCalculationResultDTO.md)
 - [Model.ProvinceCODTO](docs/ProvinceCODTO.md)
 - [Model.RegionCODTO](docs/RegionCODTO.md)
 - [Model.SearchDTO](docs/SearchDTO.md)
 - [Model.SearchElementDTO](docs/SearchElementDTO.md)
 - [Model.SearchGroupDTO](docs/SearchGroupDTO.md)
 - [Model.SearchNodeDTO](docs/SearchNodeDTO.md)
 - [Model.SearchNodeValueDTO](docs/SearchNodeValueDTO.md)
 - [Model.SectionalMasterDataCODTO](docs/SectionalMasterDataCODTO.md)
 - [Model.SectionalMasterDataProposalInfoDTO](docs/SectionalMasterDataProposalInfoDTO.md)
 - [Model.SectionalMasterDataProposalParametersDTO](docs/SectionalMasterDataProposalParametersDTO.md)
 - [Model.SectionalMasterDataProposalResultDTO](docs/SectionalMasterDataProposalResultDTO.md)
 - [Model.SendingLetterResultDTO](docs/SendingLetterResultDTO.md)
 - [Model.SendingLettersToInsertParametersCODTO](docs/SendingLettersToInsertParametersCODTO.md)
 - [Model.SendingLettersToInsertRowCODTO](docs/SendingLettersToInsertRowCODTO.md)
 - [Model.SetStateParameterDTO](docs/SetStateParameterDTO.md)
 - [Model.StateCODTO](docs/StateCODTO.md)
 - [Model.StatoAttualeDTO](docs/StatoAttualeDTO.md)
 - [Model.StatoDTO](docs/StatoDTO.md)
 - [Model.StoreCODTO](docs/StoreCODTO.md)
 - [Model.StringObjectKeyValuePair](docs/StringObjectKeyValuePair.md)
 - [Model.SubCategoryCODTO](docs/SubCategoryCODTO.md)
 - [Model.SubTypeCODTO](docs/SubTypeCODTO.md)
 - [Model.UMCodeCODTO](docs/UMCodeCODTO.md)
 - [Model.UnitOfMeasureCODTO](docs/UnitOfMeasureCODTO.md)
 - [Model.UpdateParametersCODTO](docs/UpdateParametersCODTO.md)
 - [Model.UpdateParametersResultDTO](docs/UpdateParametersResultDTO.md)
 - [Model.ValidateDTO](docs/ValidateDTO.md)
 - [Model.ValidationResultDTO](docs/ValidationResultDTO.md)
 - [Model.VatCodeCODTO](docs/VatCodeCODTO.md)
 - [Model.VatCodeDuplicationParametersCODTO](docs/VatCodeDuplicationParametersCODTO.md)
 - [Model.VerificaMovimentazioneProgressiviResultDTO](docs/VerificaMovimentazioneProgressiviResultDTO.md)
 - [Model.WTCodeCODTO](docs/WTCodeCODTO.md)
 - [Model.ZoneCODTO](docs/ZoneCODTO.md)

<a name="documentation-for-authorization"></a>
## Documentation for Authorization

<a name="Basic"></a>
### Basic

- **Type**: HTTP basic authentication

<a name="Bearer"></a>
### Bearer


