/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG19_CLIFORVA - Classificazione Cliente/Fornitore&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;CliforCg44&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;TipocfCg44&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class CSInfoCODTO :  IEquatable<CSInfoCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CSInfoCODTO" /> class.
        /// </summary>
        /// <param name="area">MG19_AREA - Codice Area.</param>
        /// <param name="areanielsenMg0e">MG19_AREANIELSEN_MG0E - Area Nielsen.</param>
        /// <param name="bacsaccountno">MG19_BACSACCOUNTNO - Codice BACS.</param>
        /// <param name="categ">MG19_CATEG - Codice Categoria.</param>
        /// <param name="cliforCg44">MG19_CLIFOR_CG44 - Codice cliente (required).</param>
        /// <param name="codIclfatt">MG19_CODICLFATT - Cliente fatturazione.</param>
        /// <param name="codLivbloc">MG19_CODLIVBLOC - Codice Blocco.</param>
        /// <param name="codRifalf">MG19_CODRIFALF - Codice di riferimento alfanumerico.</param>
        /// <param name="codRifnum">MG19_CODRIFNUM - Codice di riferimento numerico.</param>
        /// <param name="codRischioMg2a">MG19_CODRISCHIO_MG2A - Codice rischio.</param>
        /// <param name="datablocco">MG19_DATABLOCCO - Data blocco.</param>
        /// <param name="datacreaz">MG19_DATACREAZ - Data creazione.</param>
        /// <param name="datadismis">MG19_DATADISMIS - Data dismissione.</param>
        /// <param name="datarischio">MG19_DATARISCHIO - Data dell&#x27;attivazione controllo rischio.</param>
        /// <param name="dataultvar">MG19_DATAULTVAR - Data ultima variazione.</param>
        /// <param name="dittaCg18">MG19_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="fidoaziendale">MG19_FIDOAZIENDALE - Fido aziendale.</param>
        /// <param name="fidofactoring">MG19_FIDOFACTORING - Importo fido assicurazione credito.</param>
        /// <param name="fidolivello1">MG19_FIDOLIVELLO1 - Fido liv. 1.</param>
        /// <param name="fidolivello2">MG19_FIDOLIVELLO2 - Fido liv.2.</param>
        /// <param name="finchargerterms">MG19_FINCHARGERTERMS - Termini di addebito.</param>
        /// <param name="flgEstrpayline">MG19_FLGESTRPAYLINE - Estrazione Payline (default to 0).</param>
        /// <param name="flgSpbol">MG19_FLGSPBOL - Spese bolli (default to 0).</param>
        /// <param name="flgSpeinc">MG19_FLGSPEINC - Spese incasso (default to 0).</param>
        /// <param name="flgTaxliable">MG19_FLGTAXLIABLE - Tax Liable (default to 0).</param>
        /// <param name="idmediaCg99">MG19_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indClibloc">MG19_INDCLIBLOC - Tipo blocco&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - senza possibilità di sblocco&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - con possibilità di sblocco&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="indGesfido">MG19_INDGESFIDO - Indicatore gestione fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Come pers. documenti&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - No controllo fido&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Si controllo fido&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indrottcig">MG19_INDROTTCIG - Tracciabilità flussi fin.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  No gestione CIG (CUP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Genera un documento per ogni CIG (CUP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; -  Genera un documento riepilogativo a fronte di CIG (CUP) diversi&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indSpesecum">MG19_INDSPESECUM - Cumulo sp.bolli/incasso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Sì, mensili&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Sì, per quindicina&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Sì, per decade&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Sì, per settimana&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Sì, per giorno&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="irs1099">MG19_IRS1099 - IRSS1099 Code.</param>
        /// <param name="lastchange">MG19_LASTCHANGE - Data ultima variazione.</param>
        /// <param name="linguaMg52">MG19_LINGUA_MG52 - Codice lingua.</param>
        /// <param name="macroarea">MG19_MACROAREA - Codice Macroarea.</param>
        /// <param name="macrocat">MG19_MACROCAT - Codice Macrocategoria.</param>
        /// <param name="notebloc">MG19_NOTEBLOC - Note blocco.</param>
        /// <param name="raggcrf3">MG19_RAGGCRF3 - Codice raggrupamento Clienti/Fornitori 3.</param>
        /// <param name="raggrcf1">MG19_RAGGRCF1 - Codice raggruppamento Clienti/Fornitori 1.</param>
        /// <param name="raggrcf2">MG19_RAGGRCF2 - Codice raggruppamento Clienti/Fornitori 2.</param>
        /// <param name="regimeiva">MG19_REGIMEIVA - Regime IVA.</param>
        /// <param name="reminderterms">MG19_REMINDERTERMS - Termini di sollecito.</param>
        /// <param name="scaglspbanc">MG19_SCAGLSPBANC - Codice della tabella bolli e spese incasso (default to 0).</param>
        /// <param name="sottocat">MG19_SOTTOCAT - Codice Sottocategoria.</param>
        /// <param name="taxareaNv01">MG19_TAXAREA_NV01 - Tax area.</param>
        /// <param name="taxexemptionno">MG19_TAXEXEMPTIONNO - USA-numero esenzione sales tax.</param>
        /// <param name="tipocfCg44">MG19_TIPOCF_CG44 - Tipo Cliente/ Fornitore (required).</param>
        /// <param name="typeofsupply">MG19_TYPEOFSUPPLY - Tipo di fornitura.</param>
        /// <param name="zona">MG19_ZONA - Codice Zona.</param>
        /// <param name="areaCO">areaCO.</param>
        /// <param name="categoryCO">categoryCO.</param>
        /// <param name="grouping1CO">grouping1CO.</param>
        /// <param name="grouping2CO">grouping2CO.</param>
        /// <param name="grouping3CO">grouping3CO.</param>
        /// <param name="macroAreaCO">macroAreaCO.</param>
        /// <param name="macroCategoryCO">macroCategoryCO.</param>
        /// <param name="subCategoryCO">subCategoryCO.</param>
        /// <param name="zoneCO">zoneCO.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public CSInfoCODTO(string area = default(string), string areanielsenMg0e = default(string), int? bacsaccountno = default(int?), string categ = default(string), double? cliforCg44 = default(double?), double? codIclfatt = default(double?), string codLivbloc = default(string), string codRifalf = default(string), double? codRifnum = default(double?), string codRischioMg2a = default(string), DateTime? datablocco = default(DateTime?), DateTime? datacreaz = default(DateTime?), DateTime? datadismis = default(DateTime?), DateTime? datarischio = default(DateTime?), DateTime? dataultvar = default(DateTime?), double? dittaCg18 = 0, double? fidoaziendale = default(double?), double? fidofactoring = default(double?), double? fidolivello1 = default(double?), double? fidolivello2 = default(double?), string finchargerterms = default(string), double? flgEstrpayline = 0, double? flgSpbol = 0, double? flgSpeinc = 0, int? flgTaxliable = 0, double? idmediaCg99 = default(double?), double? indClibloc = default(double?), double? indGesfido = 0, double? indrottcig = 0, double? indSpesecum = 0, string irs1099 = default(string), DateTime? lastchange = default(DateTime?), string linguaMg52 = default(string), string macroarea = default(string), string macrocat = default(string), string notebloc = default(string), string raggcrf3 = default(string), string raggrcf1 = default(string), string raggrcf2 = default(string), string regimeiva = default(string), string reminderterms = default(string), double? scaglspbanc = 0, string sottocat = default(string), string taxareaNv01 = default(string), string taxexemptionno = default(string), double? tipocfCg44 = default(double?), string typeofsupply = default(string), string zona = default(string), AreaCODTO areaCO = default(AreaCODTO), CategoryCODTO categoryCO = default(CategoryCODTO), Grouping1CODTO grouping1CO = default(Grouping1CODTO), Grouping2CODTO grouping2CO = default(Grouping2CODTO), Grouping3CODTO grouping3CO = default(Grouping3CODTO), MacroAreaCODTO macroAreaCO = default(MacroAreaCODTO), MacroCategoryCODTO macroCategoryCO = default(MacroCategoryCODTO), SubCategoryCODTO subCategoryCO = default(SubCategoryCODTO), ZoneCODTO zoneCO = default(ZoneCODTO), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "cliforCg44" is required (not null)
            if (cliforCg44 == null)
            {
                throw new InvalidDataException("cliforCg44 is a required property for CSInfoCODTO and cannot be null");
            }
            else
            {
                this.CliforCg44 = cliforCg44;
            }
            // to ensure "tipocfCg44" is required (not null)
            if (tipocfCg44 == null)
            {
                throw new InvalidDataException("tipocfCg44 is a required property for CSInfoCODTO and cannot be null");
            }
            else
            {
                this.TipocfCg44 = tipocfCg44;
            }
            this.Area = area;
            this.AreanielsenMg0e = areanielsenMg0e;
            this.Bacsaccountno = bacsaccountno;
            this.Categ = categ;
            this.CodIclfatt = codIclfatt;
            this.CodLivbloc = codLivbloc;
            this.CodRifalf = codRifalf;
            this.CodRifnum = codRifnum;
            this.CodRischioMg2a = codRischioMg2a;
            this.Datablocco = datablocco;
            this.Datacreaz = datacreaz;
            this.Datadismis = datadismis;
            this.Datarischio = datarischio;
            this.Dataultvar = dataultvar;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.Fidoaziendale = fidoaziendale;
            this.Fidofactoring = fidofactoring;
            this.Fidolivello1 = fidolivello1;
            this.Fidolivello2 = fidolivello2;
            this.Finchargerterms = finchargerterms;
            // use default value if no "flgEstrpayline" provided
            if (flgEstrpayline == null)
            {
                this.FlgEstrpayline = 0;
            }
            else
            {
                this.FlgEstrpayline = flgEstrpayline;
            }
            // use default value if no "flgSpbol" provided
            if (flgSpbol == null)
            {
                this.FlgSpbol = 0;
            }
            else
            {
                this.FlgSpbol = flgSpbol;
            }
            // use default value if no "flgSpeinc" provided
            if (flgSpeinc == null)
            {
                this.FlgSpeinc = 0;
            }
            else
            {
                this.FlgSpeinc = flgSpeinc;
            }
            // use default value if no "flgTaxliable" provided
            if (flgTaxliable == null)
            {
                this.FlgTaxliable = 0;
            }
            else
            {
                this.FlgTaxliable = flgTaxliable;
            }
            this.IdmediaCg99 = idmediaCg99;
            this.IndClibloc = indClibloc;
            // use default value if no "indGesfido" provided
            if (indGesfido == null)
            {
                this.IndGesfido = 0;
            }
            else
            {
                this.IndGesfido = indGesfido;
            }
            // use default value if no "indrottcig" provided
            if (indrottcig == null)
            {
                this.Indrottcig = 0;
            }
            else
            {
                this.Indrottcig = indrottcig;
            }
            // use default value if no "indSpesecum" provided
            if (indSpesecum == null)
            {
                this.IndSpesecum = 0;
            }
            else
            {
                this.IndSpesecum = indSpesecum;
            }
            this.Irs1099 = irs1099;
            this.Lastchange = lastchange;
            this.LinguaMg52 = linguaMg52;
            this.Macroarea = macroarea;
            this.Macrocat = macrocat;
            this.Notebloc = notebloc;
            this.Raggcrf3 = raggcrf3;
            this.Raggrcf1 = raggrcf1;
            this.Raggrcf2 = raggrcf2;
            this.Regimeiva = regimeiva;
            this.Reminderterms = reminderterms;
            // use default value if no "scaglspbanc" provided
            if (scaglspbanc == null)
            {
                this.Scaglspbanc = 0;
            }
            else
            {
                this.Scaglspbanc = scaglspbanc;
            }
            this.Sottocat = sottocat;
            this.TaxareaNv01 = taxareaNv01;
            this.Taxexemptionno = taxexemptionno;
            this.Typeofsupply = typeofsupply;
            this.Zona = zona;
            this.AreaCO = areaCO;
            this.CategoryCO = categoryCO;
            this.Grouping1CO = grouping1CO;
            this.Grouping2CO = grouping2CO;
            this.Grouping3CO = grouping3CO;
            this.MacroAreaCO = macroAreaCO;
            this.MacroCategoryCO = macroCategoryCO;
            this.SubCategoryCO = subCategoryCO;
            this.ZoneCO = zoneCO;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG19_AREA - Codice Area
        /// </summary>
        /// <value>MG19_AREA - Codice Area</value>
        [DataMember(Name="area", EmitDefaultValue=false)]
        public string Area { get; set; }

        /// <summary>
        /// MG19_AREANIELSEN_MG0E - Area Nielsen
        /// </summary>
        /// <value>MG19_AREANIELSEN_MG0E - Area Nielsen</value>
        [DataMember(Name="areanielsenMg0e", EmitDefaultValue=false)]
        public string AreanielsenMg0e { get; set; }

        /// <summary>
        /// MG19_BACSACCOUNTNO - Codice BACS
        /// </summary>
        /// <value>MG19_BACSACCOUNTNO - Codice BACS</value>
        [DataMember(Name="bacsaccountno", EmitDefaultValue=false)]
        public int? Bacsaccountno { get; set; }

        /// <summary>
        /// MG19_CATEG - Codice Categoria
        /// </summary>
        /// <value>MG19_CATEG - Codice Categoria</value>
        [DataMember(Name="categ", EmitDefaultValue=false)]
        public string Categ { get; set; }

        /// <summary>
        /// MG19_CLIFOR_CG44 - Codice cliente
        /// </summary>
        /// <value>MG19_CLIFOR_CG44 - Codice cliente</value>
        [DataMember(Name="cliforCg44", EmitDefaultValue=false)]
        public double? CliforCg44 { get; set; }

        /// <summary>
        /// MG19_CODICLFATT - Cliente fatturazione
        /// </summary>
        /// <value>MG19_CODICLFATT - Cliente fatturazione</value>
        [DataMember(Name="codIclfatt", EmitDefaultValue=false)]
        public double? CodIclfatt { get; set; }

        /// <summary>
        /// MG19_CODLIVBLOC - Codice Blocco
        /// </summary>
        /// <value>MG19_CODLIVBLOC - Codice Blocco</value>
        [DataMember(Name="codLivbloc", EmitDefaultValue=false)]
        public string CodLivbloc { get; set; }

        /// <summary>
        /// MG19_CODRIFALF - Codice di riferimento alfanumerico
        /// </summary>
        /// <value>MG19_CODRIFALF - Codice di riferimento alfanumerico</value>
        [DataMember(Name="codRifalf", EmitDefaultValue=false)]
        public string CodRifalf { get; set; }

        /// <summary>
        /// MG19_CODRIFNUM - Codice di riferimento numerico
        /// </summary>
        /// <value>MG19_CODRIFNUM - Codice di riferimento numerico</value>
        [DataMember(Name="codRifnum", EmitDefaultValue=false)]
        public double? CodRifnum { get; set; }

        /// <summary>
        /// MG19_CODRISCHIO_MG2A - Codice rischio
        /// </summary>
        /// <value>MG19_CODRISCHIO_MG2A - Codice rischio</value>
        [DataMember(Name="codRischioMg2a", EmitDefaultValue=false)]
        public string CodRischioMg2a { get; set; }

        /// <summary>
        /// MG19_DATABLOCCO - Data blocco
        /// </summary>
        /// <value>MG19_DATABLOCCO - Data blocco</value>
        [DataMember(Name="datablocco", EmitDefaultValue=false)]
        public DateTime? Datablocco { get; set; }

        /// <summary>
        /// MG19_DATACREAZ - Data creazione
        /// </summary>
        /// <value>MG19_DATACREAZ - Data creazione</value>
        [DataMember(Name="datacreaz", EmitDefaultValue=false)]
        public DateTime? Datacreaz { get; set; }

        /// <summary>
        /// MG19_DATADISMIS - Data dismissione
        /// </summary>
        /// <value>MG19_DATADISMIS - Data dismissione</value>
        [DataMember(Name="datadismis", EmitDefaultValue=false)]
        public DateTime? Datadismis { get; set; }

        /// <summary>
        /// MG19_DATARISCHIO - Data dell&#x27;attivazione controllo rischio
        /// </summary>
        /// <value>MG19_DATARISCHIO - Data dell&#x27;attivazione controllo rischio</value>
        [DataMember(Name="datarischio", EmitDefaultValue=false)]
        public DateTime? Datarischio { get; set; }

        /// <summary>
        /// MG19_DATAULTVAR - Data ultima variazione
        /// </summary>
        /// <value>MG19_DATAULTVAR - Data ultima variazione</value>
        [DataMember(Name="dataultvar", EmitDefaultValue=false)]
        public DateTime? Dataultvar { get; set; }

        /// <summary>
        /// MG19_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG19_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG19_FIDOAZIENDALE - Fido aziendale
        /// </summary>
        /// <value>MG19_FIDOAZIENDALE - Fido aziendale</value>
        [DataMember(Name="fidoaziendale", EmitDefaultValue=false)]
        public double? Fidoaziendale { get; set; }

        /// <summary>
        /// MG19_FIDOFACTORING - Importo fido assicurazione credito
        /// </summary>
        /// <value>MG19_FIDOFACTORING - Importo fido assicurazione credito</value>
        [DataMember(Name="fidofactoring", EmitDefaultValue=false)]
        public double? Fidofactoring { get; set; }

        /// <summary>
        /// MG19_FIDOLIVELLO1 - Fido liv. 1
        /// </summary>
        /// <value>MG19_FIDOLIVELLO1 - Fido liv. 1</value>
        [DataMember(Name="fidolivello1", EmitDefaultValue=false)]
        public double? Fidolivello1 { get; set; }

        /// <summary>
        /// MG19_FIDOLIVELLO2 - Fido liv.2
        /// </summary>
        /// <value>MG19_FIDOLIVELLO2 - Fido liv.2</value>
        [DataMember(Name="fidolivello2", EmitDefaultValue=false)]
        public double? Fidolivello2 { get; set; }

        /// <summary>
        /// MG19_FINCHARGERTERMS - Termini di addebito
        /// </summary>
        /// <value>MG19_FINCHARGERTERMS - Termini di addebito</value>
        [DataMember(Name="finchargerterms", EmitDefaultValue=false)]
        public string Finchargerterms { get; set; }

        /// <summary>
        /// MG19_FLGESTRPAYLINE - Estrazione Payline
        /// </summary>
        /// <value>MG19_FLGESTRPAYLINE - Estrazione Payline</value>
        [DataMember(Name="flgEstrpayline", EmitDefaultValue=false)]
        public double? FlgEstrpayline { get; set; }

        /// <summary>
        /// MG19_FLGSPBOL - Spese bolli
        /// </summary>
        /// <value>MG19_FLGSPBOL - Spese bolli</value>
        [DataMember(Name="flgSpbol", EmitDefaultValue=false)]
        public double? FlgSpbol { get; set; }

        /// <summary>
        /// MG19_FLGSPEINC - Spese incasso
        /// </summary>
        /// <value>MG19_FLGSPEINC - Spese incasso</value>
        [DataMember(Name="flgSpeinc", EmitDefaultValue=false)]
        public double? FlgSpeinc { get; set; }

        /// <summary>
        /// MG19_FLGTAXLIABLE - Tax Liable
        /// </summary>
        /// <value>MG19_FLGTAXLIABLE - Tax Liable</value>
        [DataMember(Name="flgTaxliable", EmitDefaultValue=false)]
        public int? FlgTaxliable { get; set; }

        /// <summary>
        /// MG19_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>MG19_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// MG19_INDCLIBLOC - Tipo blocco&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - senza possibilità di sblocco&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - con possibilità di sblocco&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG19_INDCLIBLOC - Tipo blocco&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Nessuno&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - senza possibilità di sblocco&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - con possibilità di sblocco&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indClibloc", EmitDefaultValue=false)]
        public double? IndClibloc { get; set; }

        /// <summary>
        /// MG19_INDGESFIDO - Indicatore gestione fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Come pers. documenti&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - No controllo fido&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Si controllo fido&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG19_INDGESFIDO - Indicatore gestione fido&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Come pers. documenti&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - No controllo fido&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Si controllo fido&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indGesfido", EmitDefaultValue=false)]
        public double? IndGesfido { get; set; }

        /// <summary>
        /// MG19_INDROTTCIG - Tracciabilità flussi fin.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  No gestione CIG (CUP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Genera un documento per ogni CIG (CUP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; -  Genera un documento riepilogativo a fronte di CIG (CUP) diversi&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG19_INDROTTCIG - Tracciabilità flussi fin.&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  No gestione CIG (CUP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; -  Genera un documento per ogni CIG (CUP)&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; -  Genera un documento riepilogativo a fronte di CIG (CUP) diversi&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indrottcig", EmitDefaultValue=false)]
        public double? Indrottcig { get; set; }

        /// <summary>
        /// MG19_INDSPESECUM - Cumulo sp.bolli/incasso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Sì, mensili&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Sì, per quindicina&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Sì, per decade&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Sì, per settimana&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Sì, per giorno&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG19_INDSPESECUM - Cumulo sp.bolli/incasso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Sì, mensili&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Sì, per quindicina&lt;/li&gt;&lt;li&gt;&lt;i&gt;3&lt;/i&gt; - Sì, per decade&lt;/li&gt;&lt;li&gt;&lt;i&gt;4&lt;/i&gt; - Sì, per settimana&lt;/li&gt;&lt;li&gt;&lt;i&gt;5&lt;/i&gt; - Sì, per giorno&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indSpesecum", EmitDefaultValue=false)]
        public double? IndSpesecum { get; set; }

        /// <summary>
        /// MG19_IRS1099 - IRSS1099 Code
        /// </summary>
        /// <value>MG19_IRS1099 - IRSS1099 Code</value>
        [DataMember(Name="irs1099", EmitDefaultValue=false)]
        public string Irs1099 { get; set; }

        /// <summary>
        /// MG19_LASTCHANGE - Data ultima variazione
        /// </summary>
        /// <value>MG19_LASTCHANGE - Data ultima variazione</value>
        [DataMember(Name="lastchange", EmitDefaultValue=false)]
        public DateTime? Lastchange { get; set; }

        /// <summary>
        /// MG19_LINGUA_MG52 - Codice lingua
        /// </summary>
        /// <value>MG19_LINGUA_MG52 - Codice lingua</value>
        [DataMember(Name="linguaMg52", EmitDefaultValue=false)]
        public string LinguaMg52 { get; set; }

        /// <summary>
        /// MG19_MACROAREA - Codice Macroarea
        /// </summary>
        /// <value>MG19_MACROAREA - Codice Macroarea</value>
        [DataMember(Name="macroarea", EmitDefaultValue=false)]
        public string Macroarea { get; set; }

        /// <summary>
        /// MG19_MACROCAT - Codice Macrocategoria
        /// </summary>
        /// <value>MG19_MACROCAT - Codice Macrocategoria</value>
        [DataMember(Name="macrocat", EmitDefaultValue=false)]
        public string Macrocat { get; set; }

        /// <summary>
        /// MG19_NOTEBLOC - Note blocco
        /// </summary>
        /// <value>MG19_NOTEBLOC - Note blocco</value>
        [DataMember(Name="notebloc", EmitDefaultValue=false)]
        public string Notebloc { get; set; }

        /// <summary>
        /// MG19_RAGGCRF3 - Codice raggrupamento Clienti/Fornitori 3
        /// </summary>
        /// <value>MG19_RAGGCRF3 - Codice raggrupamento Clienti/Fornitori 3</value>
        [DataMember(Name="raggcrf3", EmitDefaultValue=false)]
        public string Raggcrf3 { get; set; }

        /// <summary>
        /// MG19_RAGGRCF1 - Codice raggruppamento Clienti/Fornitori 1
        /// </summary>
        /// <value>MG19_RAGGRCF1 - Codice raggruppamento Clienti/Fornitori 1</value>
        [DataMember(Name="raggrcf1", EmitDefaultValue=false)]
        public string Raggrcf1 { get; set; }

        /// <summary>
        /// MG19_RAGGRCF2 - Codice raggruppamento Clienti/Fornitori 2
        /// </summary>
        /// <value>MG19_RAGGRCF2 - Codice raggruppamento Clienti/Fornitori 2</value>
        [DataMember(Name="raggrcf2", EmitDefaultValue=false)]
        public string Raggrcf2 { get; set; }

        /// <summary>
        /// MG19_REGIMEIVA - Regime IVA
        /// </summary>
        /// <value>MG19_REGIMEIVA - Regime IVA</value>
        [DataMember(Name="regimeiva", EmitDefaultValue=false)]
        public string Regimeiva { get; set; }

        /// <summary>
        /// MG19_REMINDERTERMS - Termini di sollecito
        /// </summary>
        /// <value>MG19_REMINDERTERMS - Termini di sollecito</value>
        [DataMember(Name="reminderterms", EmitDefaultValue=false)]
        public string Reminderterms { get; set; }

        /// <summary>
        /// MG19_SCAGLSPBANC - Codice della tabella bolli e spese incasso
        /// </summary>
        /// <value>MG19_SCAGLSPBANC - Codice della tabella bolli e spese incasso</value>
        [DataMember(Name="scaglspbanc", EmitDefaultValue=false)]
        public double? Scaglspbanc { get; set; }

        /// <summary>
        /// MG19_SOTTOCAT - Codice Sottocategoria
        /// </summary>
        /// <value>MG19_SOTTOCAT - Codice Sottocategoria</value>
        [DataMember(Name="sottocat", EmitDefaultValue=false)]
        public string Sottocat { get; set; }

        /// <summary>
        /// MG19_TAXAREA_NV01 - Tax area
        /// </summary>
        /// <value>MG19_TAXAREA_NV01 - Tax area</value>
        [DataMember(Name="taxareaNv01", EmitDefaultValue=false)]
        public string TaxareaNv01 { get; set; }

        /// <summary>
        /// MG19_TAXEXEMPTIONNO - USA-numero esenzione sales tax
        /// </summary>
        /// <value>MG19_TAXEXEMPTIONNO - USA-numero esenzione sales tax</value>
        [DataMember(Name="taxexemptionno", EmitDefaultValue=false)]
        public string Taxexemptionno { get; set; }

        /// <summary>
        /// MG19_TIPOCF_CG44 - Tipo Cliente/ Fornitore
        /// </summary>
        /// <value>MG19_TIPOCF_CG44 - Tipo Cliente/ Fornitore</value>
        [DataMember(Name="tipocfCg44", EmitDefaultValue=false)]
        public double? TipocfCg44 { get; set; }

        /// <summary>
        /// MG19_TYPEOFSUPPLY - Tipo di fornitura
        /// </summary>
        /// <value>MG19_TYPEOFSUPPLY - Tipo di fornitura</value>
        [DataMember(Name="typeofsupply", EmitDefaultValue=false)]
        public string Typeofsupply { get; set; }

        /// <summary>
        /// MG19_ZONA - Codice Zona
        /// </summary>
        /// <value>MG19_ZONA - Codice Zona</value>
        [DataMember(Name="zona", EmitDefaultValue=false)]
        public string Zona { get; set; }

        /// <summary>
        /// Gets or Sets AreaCO
        /// </summary>
        [DataMember(Name="areaCO", EmitDefaultValue=false)]
        public AreaCODTO AreaCO { get; set; }

        /// <summary>
        /// Gets or Sets CategoryCO
        /// </summary>
        [DataMember(Name="categoryCO", EmitDefaultValue=false)]
        public CategoryCODTO CategoryCO { get; set; }

        /// <summary>
        /// Gets or Sets Grouping1CO
        /// </summary>
        [DataMember(Name="grouping1CO", EmitDefaultValue=false)]
        public Grouping1CODTO Grouping1CO { get; set; }

        /// <summary>
        /// Gets or Sets Grouping2CO
        /// </summary>
        [DataMember(Name="grouping2CO", EmitDefaultValue=false)]
        public Grouping2CODTO Grouping2CO { get; set; }

        /// <summary>
        /// Gets or Sets Grouping3CO
        /// </summary>
        [DataMember(Name="grouping3CO", EmitDefaultValue=false)]
        public Grouping3CODTO Grouping3CO { get; set; }

        /// <summary>
        /// Gets or Sets MacroAreaCO
        /// </summary>
        [DataMember(Name="macroAreaCO", EmitDefaultValue=false)]
        public MacroAreaCODTO MacroAreaCO { get; set; }

        /// <summary>
        /// Gets or Sets MacroCategoryCO
        /// </summary>
        [DataMember(Name="macroCategoryCO", EmitDefaultValue=false)]
        public MacroCategoryCODTO MacroCategoryCO { get; set; }

        /// <summary>
        /// Gets or Sets SubCategoryCO
        /// </summary>
        [DataMember(Name="subCategoryCO", EmitDefaultValue=false)]
        public SubCategoryCODTO SubCategoryCO { get; set; }

        /// <summary>
        /// Gets or Sets ZoneCO
        /// </summary>
        [DataMember(Name="zoneCO", EmitDefaultValue=false)]
        public ZoneCODTO ZoneCO { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class CSInfoCODTO {\n");
            sb.Append("  Area: ").Append(Area).Append("\n");
            sb.Append("  AreanielsenMg0e: ").Append(AreanielsenMg0e).Append("\n");
            sb.Append("  Bacsaccountno: ").Append(Bacsaccountno).Append("\n");
            sb.Append("  Categ: ").Append(Categ).Append("\n");
            sb.Append("  CliforCg44: ").Append(CliforCg44).Append("\n");
            sb.Append("  CodIclfatt: ").Append(CodIclfatt).Append("\n");
            sb.Append("  CodLivbloc: ").Append(CodLivbloc).Append("\n");
            sb.Append("  CodRifalf: ").Append(CodRifalf).Append("\n");
            sb.Append("  CodRifnum: ").Append(CodRifnum).Append("\n");
            sb.Append("  CodRischioMg2a: ").Append(CodRischioMg2a).Append("\n");
            sb.Append("  Datablocco: ").Append(Datablocco).Append("\n");
            sb.Append("  Datacreaz: ").Append(Datacreaz).Append("\n");
            sb.Append("  Datadismis: ").Append(Datadismis).Append("\n");
            sb.Append("  Datarischio: ").Append(Datarischio).Append("\n");
            sb.Append("  Dataultvar: ").Append(Dataultvar).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  Fidoaziendale: ").Append(Fidoaziendale).Append("\n");
            sb.Append("  Fidofactoring: ").Append(Fidofactoring).Append("\n");
            sb.Append("  Fidolivello1: ").Append(Fidolivello1).Append("\n");
            sb.Append("  Fidolivello2: ").Append(Fidolivello2).Append("\n");
            sb.Append("  Finchargerterms: ").Append(Finchargerterms).Append("\n");
            sb.Append("  FlgEstrpayline: ").Append(FlgEstrpayline).Append("\n");
            sb.Append("  FlgSpbol: ").Append(FlgSpbol).Append("\n");
            sb.Append("  FlgSpeinc: ").Append(FlgSpeinc).Append("\n");
            sb.Append("  FlgTaxliable: ").Append(FlgTaxliable).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  IndClibloc: ").Append(IndClibloc).Append("\n");
            sb.Append("  IndGesfido: ").Append(IndGesfido).Append("\n");
            sb.Append("  Indrottcig: ").Append(Indrottcig).Append("\n");
            sb.Append("  IndSpesecum: ").Append(IndSpesecum).Append("\n");
            sb.Append("  Irs1099: ").Append(Irs1099).Append("\n");
            sb.Append("  Lastchange: ").Append(Lastchange).Append("\n");
            sb.Append("  LinguaMg52: ").Append(LinguaMg52).Append("\n");
            sb.Append("  Macroarea: ").Append(Macroarea).Append("\n");
            sb.Append("  Macrocat: ").Append(Macrocat).Append("\n");
            sb.Append("  Notebloc: ").Append(Notebloc).Append("\n");
            sb.Append("  Raggcrf3: ").Append(Raggcrf3).Append("\n");
            sb.Append("  Raggrcf1: ").Append(Raggrcf1).Append("\n");
            sb.Append("  Raggrcf2: ").Append(Raggrcf2).Append("\n");
            sb.Append("  Regimeiva: ").Append(Regimeiva).Append("\n");
            sb.Append("  Reminderterms: ").Append(Reminderterms).Append("\n");
            sb.Append("  Scaglspbanc: ").Append(Scaglspbanc).Append("\n");
            sb.Append("  Sottocat: ").Append(Sottocat).Append("\n");
            sb.Append("  TaxareaNv01: ").Append(TaxareaNv01).Append("\n");
            sb.Append("  Taxexemptionno: ").Append(Taxexemptionno).Append("\n");
            sb.Append("  TipocfCg44: ").Append(TipocfCg44).Append("\n");
            sb.Append("  Typeofsupply: ").Append(Typeofsupply).Append("\n");
            sb.Append("  Zona: ").Append(Zona).Append("\n");
            sb.Append("  AreaCO: ").Append(AreaCO).Append("\n");
            sb.Append("  CategoryCO: ").Append(CategoryCO).Append("\n");
            sb.Append("  Grouping1CO: ").Append(Grouping1CO).Append("\n");
            sb.Append("  Grouping2CO: ").Append(Grouping2CO).Append("\n");
            sb.Append("  Grouping3CO: ").Append(Grouping3CO).Append("\n");
            sb.Append("  MacroAreaCO: ").Append(MacroAreaCO).Append("\n");
            sb.Append("  MacroCategoryCO: ").Append(MacroCategoryCO).Append("\n");
            sb.Append("  SubCategoryCO: ").Append(SubCategoryCO).Append("\n");
            sb.Append("  ZoneCO: ").Append(ZoneCO).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as CSInfoCODTO);
        }

        /// <summary>
        /// Returns true if CSInfoCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of CSInfoCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(CSInfoCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Area == input.Area ||
                    (this.Area != null &&
                    this.Area.Equals(input.Area))
                ) && 
                (
                    this.AreanielsenMg0e == input.AreanielsenMg0e ||
                    (this.AreanielsenMg0e != null &&
                    this.AreanielsenMg0e.Equals(input.AreanielsenMg0e))
                ) && 
                (
                    this.Bacsaccountno == input.Bacsaccountno ||
                    (this.Bacsaccountno != null &&
                    this.Bacsaccountno.Equals(input.Bacsaccountno))
                ) && 
                (
                    this.Categ == input.Categ ||
                    (this.Categ != null &&
                    this.Categ.Equals(input.Categ))
                ) && 
                (
                    this.CliforCg44 == input.CliforCg44 ||
                    (this.CliforCg44 != null &&
                    this.CliforCg44.Equals(input.CliforCg44))
                ) && 
                (
                    this.CodIclfatt == input.CodIclfatt ||
                    (this.CodIclfatt != null &&
                    this.CodIclfatt.Equals(input.CodIclfatt))
                ) && 
                (
                    this.CodLivbloc == input.CodLivbloc ||
                    (this.CodLivbloc != null &&
                    this.CodLivbloc.Equals(input.CodLivbloc))
                ) && 
                (
                    this.CodRifalf == input.CodRifalf ||
                    (this.CodRifalf != null &&
                    this.CodRifalf.Equals(input.CodRifalf))
                ) && 
                (
                    this.CodRifnum == input.CodRifnum ||
                    (this.CodRifnum != null &&
                    this.CodRifnum.Equals(input.CodRifnum))
                ) && 
                (
                    this.CodRischioMg2a == input.CodRischioMg2a ||
                    (this.CodRischioMg2a != null &&
                    this.CodRischioMg2a.Equals(input.CodRischioMg2a))
                ) && 
                (
                    this.Datablocco == input.Datablocco ||
                    (this.Datablocco != null &&
                    this.Datablocco.Equals(input.Datablocco))
                ) && 
                (
                    this.Datacreaz == input.Datacreaz ||
                    (this.Datacreaz != null &&
                    this.Datacreaz.Equals(input.Datacreaz))
                ) && 
                (
                    this.Datadismis == input.Datadismis ||
                    (this.Datadismis != null &&
                    this.Datadismis.Equals(input.Datadismis))
                ) && 
                (
                    this.Datarischio == input.Datarischio ||
                    (this.Datarischio != null &&
                    this.Datarischio.Equals(input.Datarischio))
                ) && 
                (
                    this.Dataultvar == input.Dataultvar ||
                    (this.Dataultvar != null &&
                    this.Dataultvar.Equals(input.Dataultvar))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.Fidoaziendale == input.Fidoaziendale ||
                    (this.Fidoaziendale != null &&
                    this.Fidoaziendale.Equals(input.Fidoaziendale))
                ) && 
                (
                    this.Fidofactoring == input.Fidofactoring ||
                    (this.Fidofactoring != null &&
                    this.Fidofactoring.Equals(input.Fidofactoring))
                ) && 
                (
                    this.Fidolivello1 == input.Fidolivello1 ||
                    (this.Fidolivello1 != null &&
                    this.Fidolivello1.Equals(input.Fidolivello1))
                ) && 
                (
                    this.Fidolivello2 == input.Fidolivello2 ||
                    (this.Fidolivello2 != null &&
                    this.Fidolivello2.Equals(input.Fidolivello2))
                ) && 
                (
                    this.Finchargerterms == input.Finchargerterms ||
                    (this.Finchargerterms != null &&
                    this.Finchargerterms.Equals(input.Finchargerterms))
                ) && 
                (
                    this.FlgEstrpayline == input.FlgEstrpayline ||
                    (this.FlgEstrpayline != null &&
                    this.FlgEstrpayline.Equals(input.FlgEstrpayline))
                ) && 
                (
                    this.FlgSpbol == input.FlgSpbol ||
                    (this.FlgSpbol != null &&
                    this.FlgSpbol.Equals(input.FlgSpbol))
                ) && 
                (
                    this.FlgSpeinc == input.FlgSpeinc ||
                    (this.FlgSpeinc != null &&
                    this.FlgSpeinc.Equals(input.FlgSpeinc))
                ) && 
                (
                    this.FlgTaxliable == input.FlgTaxliable ||
                    (this.FlgTaxliable != null &&
                    this.FlgTaxliable.Equals(input.FlgTaxliable))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.IndClibloc == input.IndClibloc ||
                    (this.IndClibloc != null &&
                    this.IndClibloc.Equals(input.IndClibloc))
                ) && 
                (
                    this.IndGesfido == input.IndGesfido ||
                    (this.IndGesfido != null &&
                    this.IndGesfido.Equals(input.IndGesfido))
                ) && 
                (
                    this.Indrottcig == input.Indrottcig ||
                    (this.Indrottcig != null &&
                    this.Indrottcig.Equals(input.Indrottcig))
                ) && 
                (
                    this.IndSpesecum == input.IndSpesecum ||
                    (this.IndSpesecum != null &&
                    this.IndSpesecum.Equals(input.IndSpesecum))
                ) && 
                (
                    this.Irs1099 == input.Irs1099 ||
                    (this.Irs1099 != null &&
                    this.Irs1099.Equals(input.Irs1099))
                ) && 
                (
                    this.Lastchange == input.Lastchange ||
                    (this.Lastchange != null &&
                    this.Lastchange.Equals(input.Lastchange))
                ) && 
                (
                    this.LinguaMg52 == input.LinguaMg52 ||
                    (this.LinguaMg52 != null &&
                    this.LinguaMg52.Equals(input.LinguaMg52))
                ) && 
                (
                    this.Macroarea == input.Macroarea ||
                    (this.Macroarea != null &&
                    this.Macroarea.Equals(input.Macroarea))
                ) && 
                (
                    this.Macrocat == input.Macrocat ||
                    (this.Macrocat != null &&
                    this.Macrocat.Equals(input.Macrocat))
                ) && 
                (
                    this.Notebloc == input.Notebloc ||
                    (this.Notebloc != null &&
                    this.Notebloc.Equals(input.Notebloc))
                ) && 
                (
                    this.Raggcrf3 == input.Raggcrf3 ||
                    (this.Raggcrf3 != null &&
                    this.Raggcrf3.Equals(input.Raggcrf3))
                ) && 
                (
                    this.Raggrcf1 == input.Raggrcf1 ||
                    (this.Raggrcf1 != null &&
                    this.Raggrcf1.Equals(input.Raggrcf1))
                ) && 
                (
                    this.Raggrcf2 == input.Raggrcf2 ||
                    (this.Raggrcf2 != null &&
                    this.Raggrcf2.Equals(input.Raggrcf2))
                ) && 
                (
                    this.Regimeiva == input.Regimeiva ||
                    (this.Regimeiva != null &&
                    this.Regimeiva.Equals(input.Regimeiva))
                ) && 
                (
                    this.Reminderterms == input.Reminderterms ||
                    (this.Reminderterms != null &&
                    this.Reminderterms.Equals(input.Reminderterms))
                ) && 
                (
                    this.Scaglspbanc == input.Scaglspbanc ||
                    (this.Scaglspbanc != null &&
                    this.Scaglspbanc.Equals(input.Scaglspbanc))
                ) && 
                (
                    this.Sottocat == input.Sottocat ||
                    (this.Sottocat != null &&
                    this.Sottocat.Equals(input.Sottocat))
                ) && 
                (
                    this.TaxareaNv01 == input.TaxareaNv01 ||
                    (this.TaxareaNv01 != null &&
                    this.TaxareaNv01.Equals(input.TaxareaNv01))
                ) && 
                (
                    this.Taxexemptionno == input.Taxexemptionno ||
                    (this.Taxexemptionno != null &&
                    this.Taxexemptionno.Equals(input.Taxexemptionno))
                ) && 
                (
                    this.TipocfCg44 == input.TipocfCg44 ||
                    (this.TipocfCg44 != null &&
                    this.TipocfCg44.Equals(input.TipocfCg44))
                ) && 
                (
                    this.Typeofsupply == input.Typeofsupply ||
                    (this.Typeofsupply != null &&
                    this.Typeofsupply.Equals(input.Typeofsupply))
                ) && 
                (
                    this.Zona == input.Zona ||
                    (this.Zona != null &&
                    this.Zona.Equals(input.Zona))
                ) && 
                (
                    this.AreaCO == input.AreaCO ||
                    (this.AreaCO != null &&
                    this.AreaCO.Equals(input.AreaCO))
                ) && 
                (
                    this.CategoryCO == input.CategoryCO ||
                    (this.CategoryCO != null &&
                    this.CategoryCO.Equals(input.CategoryCO))
                ) && 
                (
                    this.Grouping1CO == input.Grouping1CO ||
                    (this.Grouping1CO != null &&
                    this.Grouping1CO.Equals(input.Grouping1CO))
                ) && 
                (
                    this.Grouping2CO == input.Grouping2CO ||
                    (this.Grouping2CO != null &&
                    this.Grouping2CO.Equals(input.Grouping2CO))
                ) && 
                (
                    this.Grouping3CO == input.Grouping3CO ||
                    (this.Grouping3CO != null &&
                    this.Grouping3CO.Equals(input.Grouping3CO))
                ) && 
                (
                    this.MacroAreaCO == input.MacroAreaCO ||
                    (this.MacroAreaCO != null &&
                    this.MacroAreaCO.Equals(input.MacroAreaCO))
                ) && 
                (
                    this.MacroCategoryCO == input.MacroCategoryCO ||
                    (this.MacroCategoryCO != null &&
                    this.MacroCategoryCO.Equals(input.MacroCategoryCO))
                ) && 
                (
                    this.SubCategoryCO == input.SubCategoryCO ||
                    (this.SubCategoryCO != null &&
                    this.SubCategoryCO.Equals(input.SubCategoryCO))
                ) && 
                (
                    this.ZoneCO == input.ZoneCO ||
                    (this.ZoneCO != null &&
                    this.ZoneCO.Equals(input.ZoneCO))
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Area != null)
                    hashCode = hashCode * 59 + this.Area.GetHashCode();
                if (this.AreanielsenMg0e != null)
                    hashCode = hashCode * 59 + this.AreanielsenMg0e.GetHashCode();
                if (this.Bacsaccountno != null)
                    hashCode = hashCode * 59 + this.Bacsaccountno.GetHashCode();
                if (this.Categ != null)
                    hashCode = hashCode * 59 + this.Categ.GetHashCode();
                if (this.CliforCg44 != null)
                    hashCode = hashCode * 59 + this.CliforCg44.GetHashCode();
                if (this.CodIclfatt != null)
                    hashCode = hashCode * 59 + this.CodIclfatt.GetHashCode();
                if (this.CodLivbloc != null)
                    hashCode = hashCode * 59 + this.CodLivbloc.GetHashCode();
                if (this.CodRifalf != null)
                    hashCode = hashCode * 59 + this.CodRifalf.GetHashCode();
                if (this.CodRifnum != null)
                    hashCode = hashCode * 59 + this.CodRifnum.GetHashCode();
                if (this.CodRischioMg2a != null)
                    hashCode = hashCode * 59 + this.CodRischioMg2a.GetHashCode();
                if (this.Datablocco != null)
                    hashCode = hashCode * 59 + this.Datablocco.GetHashCode();
                if (this.Datacreaz != null)
                    hashCode = hashCode * 59 + this.Datacreaz.GetHashCode();
                if (this.Datadismis != null)
                    hashCode = hashCode * 59 + this.Datadismis.GetHashCode();
                if (this.Datarischio != null)
                    hashCode = hashCode * 59 + this.Datarischio.GetHashCode();
                if (this.Dataultvar != null)
                    hashCode = hashCode * 59 + this.Dataultvar.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.Fidoaziendale != null)
                    hashCode = hashCode * 59 + this.Fidoaziendale.GetHashCode();
                if (this.Fidofactoring != null)
                    hashCode = hashCode * 59 + this.Fidofactoring.GetHashCode();
                if (this.Fidolivello1 != null)
                    hashCode = hashCode * 59 + this.Fidolivello1.GetHashCode();
                if (this.Fidolivello2 != null)
                    hashCode = hashCode * 59 + this.Fidolivello2.GetHashCode();
                if (this.Finchargerterms != null)
                    hashCode = hashCode * 59 + this.Finchargerterms.GetHashCode();
                if (this.FlgEstrpayline != null)
                    hashCode = hashCode * 59 + this.FlgEstrpayline.GetHashCode();
                if (this.FlgSpbol != null)
                    hashCode = hashCode * 59 + this.FlgSpbol.GetHashCode();
                if (this.FlgSpeinc != null)
                    hashCode = hashCode * 59 + this.FlgSpeinc.GetHashCode();
                if (this.FlgTaxliable != null)
                    hashCode = hashCode * 59 + this.FlgTaxliable.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.IndClibloc != null)
                    hashCode = hashCode * 59 + this.IndClibloc.GetHashCode();
                if (this.IndGesfido != null)
                    hashCode = hashCode * 59 + this.IndGesfido.GetHashCode();
                if (this.Indrottcig != null)
                    hashCode = hashCode * 59 + this.Indrottcig.GetHashCode();
                if (this.IndSpesecum != null)
                    hashCode = hashCode * 59 + this.IndSpesecum.GetHashCode();
                if (this.Irs1099 != null)
                    hashCode = hashCode * 59 + this.Irs1099.GetHashCode();
                if (this.Lastchange != null)
                    hashCode = hashCode * 59 + this.Lastchange.GetHashCode();
                if (this.LinguaMg52 != null)
                    hashCode = hashCode * 59 + this.LinguaMg52.GetHashCode();
                if (this.Macroarea != null)
                    hashCode = hashCode * 59 + this.Macroarea.GetHashCode();
                if (this.Macrocat != null)
                    hashCode = hashCode * 59 + this.Macrocat.GetHashCode();
                if (this.Notebloc != null)
                    hashCode = hashCode * 59 + this.Notebloc.GetHashCode();
                if (this.Raggcrf3 != null)
                    hashCode = hashCode * 59 + this.Raggcrf3.GetHashCode();
                if (this.Raggrcf1 != null)
                    hashCode = hashCode * 59 + this.Raggrcf1.GetHashCode();
                if (this.Raggrcf2 != null)
                    hashCode = hashCode * 59 + this.Raggrcf2.GetHashCode();
                if (this.Regimeiva != null)
                    hashCode = hashCode * 59 + this.Regimeiva.GetHashCode();
                if (this.Reminderterms != null)
                    hashCode = hashCode * 59 + this.Reminderterms.GetHashCode();
                if (this.Scaglspbanc != null)
                    hashCode = hashCode * 59 + this.Scaglspbanc.GetHashCode();
                if (this.Sottocat != null)
                    hashCode = hashCode * 59 + this.Sottocat.GetHashCode();
                if (this.TaxareaNv01 != null)
                    hashCode = hashCode * 59 + this.TaxareaNv01.GetHashCode();
                if (this.Taxexemptionno != null)
                    hashCode = hashCode * 59 + this.Taxexemptionno.GetHashCode();
                if (this.TipocfCg44 != null)
                    hashCode = hashCode * 59 + this.TipocfCg44.GetHashCode();
                if (this.Typeofsupply != null)
                    hashCode = hashCode * 59 + this.Typeofsupply.GetHashCode();
                if (this.Zona != null)
                    hashCode = hashCode * 59 + this.Zona.GetHashCode();
                if (this.AreaCO != null)
                    hashCode = hashCode * 59 + this.AreaCO.GetHashCode();
                if (this.CategoryCO != null)
                    hashCode = hashCode * 59 + this.CategoryCO.GetHashCode();
                if (this.Grouping1CO != null)
                    hashCode = hashCode * 59 + this.Grouping1CO.GetHashCode();
                if (this.Grouping2CO != null)
                    hashCode = hashCode * 59 + this.Grouping2CO.GetHashCode();
                if (this.Grouping3CO != null)
                    hashCode = hashCode * 59 + this.Grouping3CO.GetHashCode();
                if (this.MacroAreaCO != null)
                    hashCode = hashCode * 59 + this.MacroAreaCO.GetHashCode();
                if (this.MacroCategoryCO != null)
                    hashCode = hashCode * 59 + this.MacroCategoryCO.GetHashCode();
                if (this.SubCategoryCO != null)
                    hashCode = hashCode * 59 + this.SubCategoryCO.GetHashCode();
                if (this.ZoneCO != null)
                    hashCode = hashCode * 59 + this.ZoneCO.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
