/* 
 * TSE Cloud - CO
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// CG16_ANAGGEN - Anagrafica generale&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;Codice&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class GeneralMasterDataCODTO :  IEquatable<GeneralMasterDataCODTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="GeneralMasterDataCODTO" /> class.
        /// </summary>
        /// <param name="alias">CG16_ALIAS - Alias.</param>
        /// <param name="auidAu04">CG16_AUID_AU04 - Codice AU.</param>
        /// <param name="cap">CG16_CAP - Cap.</param>
        /// <param name="capcor">CG16_CAPCOR - Cap corrispondenza.</param>
        /// <param name="capfisc">CG16_CAPFISC - CAP fiscale.</param>
        /// <param name="cellnum">CG16_CELLNUM - Cell..</param>
        /// <param name="citta">CG16_CITTA - Città.</param>
        /// <param name="cittacor">CG16_CITTACOR - Città corrispondenza.</param>
        /// <param name="cittafisc">CG16_CITTAFISC - Città fiscale.</param>
        /// <param name="codfiscale">CG16_CODFISCALE - Codice fiscale.</param>
        /// <param name="codice">CG16_CODICE - Codice (required).</param>
        /// <param name="codiceCg07">CG16_CODICE_CG07 - Stato estero.</param>
        /// <param name="codiceCg15">CG16_CODICE_CG15 - Causale prestazione.</param>
        /// <param name="codiceCgc0">CG16_CODICE_CGC0 - Azienda intercompany.</param>
        /// <param name="codicecorCg07">CG16_CODICECOR_CG07 - Stato estero corrisp..</param>
        /// <param name="codiceident">CG16_CODICEIDENT - Codice aggiuntivo.</param>
        /// <param name="codicesfed">CG16_CODICESFED - Stato federato.</param>
        /// <param name="codrichiamo">CG16_CODRICHIAMO - Codice anagrafica sostitutiva.</param>
        /// <param name="cognome">CG16_COGNOME - Cognome.</param>
        /// <param name="comfisCg01">CG16_COMFIS_CG01 - Codice comune fiscale.</param>
        /// <param name="comnascita">CG16_COMNASCITA - Comune di nascita.</param>
        /// <param name="comnascitaCg01">CG16_COMNASCITA_CG01 - Codice comune nascita.</param>
        /// <param name="datanascita">CG16_DATANASCITA - Data di nascita.</param>
        /// <param name="datavalid">CG16_DATAVALID - Data validità.</param>
        /// <param name="dtfinepec">CG16_DTFINEPEC - Data fine procedure esecutive o concorsuali.</param>
        /// <param name="dtiniziopec">CG16_DTINIZIOPEC - Data inizio procedure esecutive o concorsuali.</param>
        /// <param name="faxnum">CG16_FAXNUM - Fax.</param>
        /// <param name="flgAnagval">CG16_FLGANAGVAL - Anag. valida&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Anagrafica valida&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Anagrafica non valida&lt;/li&gt;&lt;/ul&gt; (default to 1).</param>
        /// <param name="flgFattpa">CG16_FLGFATTPA - Attivazione modulo fatturazione elettronica verso la Pubblica Amministrazione (default to 0).</param>
        /// <param name="flgNoblacklist">CG16_FLGNOBLACKLIST - Escludi anagrafica da elenco Black List (default to 0).</param>
        /// <param name="flgOmonimo">CG16_FLGOMONIMO - Anagr. principale per fusione omonimi (default to 0).</param>
        /// <param name="flgPrsfis">CG16_FLGPRSFIS - Persona fisica&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="idmediaCg99">CG16_IDMEDIA_CG99 - ID HyperMedia.</param>
        /// <param name="indemail">CG16_INDEMAIL - E-mail.</param>
        /// <param name="indFiscale">CG16_INDFISCALE - Indirizzo fiscale.</param>
        /// <param name="indFiscaleEX">CG16_INDFISCALEEX - Indirizzo fiscale est.</param>
        /// <param name="indirCor">CG16_INDIRCOR - Indirizzo corrispondenza.</param>
        /// <param name="indirCorEX">CG16_INDIRCOREX - Indirizzo corrispondenza esteso.</param>
        /// <param name="indirizzo">CG16_INDIRIZZO - Indirizzo.</param>
        /// <param name="indirizzoEX">CG16_INDIRIZZOEX - Indirizzo esteso.</param>
        /// <param name="indsoggrit">CG16_INDSOGGRIT - Soggetto ritenuta acconto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Non soggetto&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Professionista&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Rappresentante&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="indweb">CG16_INDWEB - Indirizzo web.</param>
        /// <param name="lastchange">CG16_LASTCHANGE - Data ultima variazione.</param>
        /// <param name="nome">CG16_NOME - Nome.</param>
        /// <param name="partitaIVA">Partita IVA.</param>
        /// <param name="partiva">CG16_PARTIVA - Partita IVA.</param>
        /// <param name="partivaEst">CG16_PARTIVA_EST - Partita IVA estera.</param>
        /// <param name="prov">CG16_PROV - Prov.</param>
        /// <param name="provcor">CG16_PROVCOR - Provincia corrispondenza.</param>
        /// <param name="provfisc">CG16_PROVFISC - Provincia fiscale.</param>
        /// <param name="provnascita">CG16_PROVNASCITA - Provincia di nascita.</param>
        /// <param name="ragSoAnag">CG16_RAGSOANAG - Ragione sociale.</param>
        /// <param name="ragsoanagex">CG16_RAGSOANAGEX - Ragione sociale estesa.</param>
        /// <param name="ragsocor">CG16_RAGSOCOR - Ragione sociale corrispondenza.</param>
        /// <param name="ragsocorex">CG16_RAGSOCOREX - Ragione sociale corrispondenza estesa.</param>
        /// <param name="ragsofisc">CG16_RAGSOFISC - Ragione sociale fiscale.</param>
        /// <param name="ragsofiscex">CG16_RAGSOFISCEX - Ragione sociale fiscale estesa.</param>
        /// <param name="rapazestCg16">CG16_RAPAZEST_CG16 - Codice anagrafico rappresentante legale.</param>
        /// <param name="sesso">CG16_SESSO - Sesso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Maschio&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Femmina&lt;/li&gt;&lt;/ul&gt; (default to 0).</param>
        /// <param name="statofed">CG16_STATOFED - Stato federato.</param>
        /// <param name="statofedfisc">CG16_STATOFEDFISC - Stato federato fisc..</param>
        /// <param name="statofiscCg07">CG16_STATOFISC_CG07 - Codice stato fiscale.</param>
        /// <param name="statonascitaCg07">CG16_STATONASCITA_CG07 - Codice stato nascita.</param>
        /// <param name="tel1num">CG16_TEL1NUM - Telefono 1.</param>
        /// <param name="tel2num">CG16_TEL2NUM - Telefono 2.</param>
        /// <param name="idExtendedAttributeEntity">idExtendedAttributeEntity.</param>
        /// <param name="idExtendedAttributeSubEntity">idExtendedAttributeSubEntity.</param>
        /// <param name="addresses">addresses.</param>
        /// <param name="fiscalRepresentative">fiscalRepresentative.</param>
        /// <param name="intragroupStructureCO">intragroupStructureCO.</param>
        /// <param name="nationCOBirth">nationCOBirth.</param>
        /// <param name="substitutiveMasterdata">substitutiveMasterdata.</param>
        /// <param name="wtCodeCO">wtCodeCO.</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public GeneralMasterDataCODTO(string alias = default(string), long? auidAu04 = default(long?), string cap = default(string), string capcor = default(string), string capfisc = default(string), string cellnum = default(string), string citta = default(string), string cittacor = default(string), string cittafisc = default(string), string codfiscale = default(string), int? codice = default(int?), double? codiceCg07 = default(double?), string codiceCg15 = default(string), double? codiceCgc0 = default(double?), double? codicecorCg07 = default(double?), string codiceident = default(string), string codicesfed = default(string), int? codrichiamo = default(int?), string cognome = default(string), string comfisCg01 = default(string), string comnascita = default(string), string comnascitaCg01 = default(string), DateTime? datanascita = default(DateTime?), DateTime? datavalid = default(DateTime?), DateTime? dtfinepec = default(DateTime?), DateTime? dtiniziopec = default(DateTime?), string faxnum = default(string), double? flgAnagval = 1, int? flgFattpa = 0, double? flgNoblacklist = 0, double? flgOmonimo = 0, double? flgPrsfis = 0, double? idmediaCg99 = default(double?), string indemail = default(string), string indFiscale = default(string), string indFiscaleEX = default(string), string indirCor = default(string), string indirCorEX = default(string), string indirizzo = default(string), string indirizzoEX = default(string), double? indsoggrit = 0, string indweb = default(string), DateTime? lastchange = default(DateTime?), string nome = default(string), string partitaIVA = default(string), string partiva = default(string), string partivaEst = default(string), string prov = default(string), string provcor = default(string), string provfisc = default(string), string provnascita = default(string), string ragSoAnag = default(string), string ragsoanagex = default(string), string ragsocor = default(string), string ragsocorex = default(string), string ragsofisc = default(string), string ragsofiscex = default(string), int? rapazestCg16 = default(int?), double? sesso = 0, string statofed = default(string), string statofedfisc = default(string), double? statofiscCg07 = default(double?), double? statonascitaCg07 = default(double?), string tel1num = default(string), string tel2num = default(string), int? idExtendedAttributeEntity = default(int?), int? idExtendedAttributeSubEntity = default(int?), List<AddressCODTO> addresses = default(List<AddressCODTO>), GeneralMasterDataCODTO fiscalRepresentative = default(GeneralMasterDataCODTO), IntragroupStructureCODTO intragroupStructureCO = default(IntragroupStructureCODTO), NationCODTO nationCOBirth = default(NationCODTO), GeneralMasterDataCODTO substitutiveMasterdata = default(GeneralMasterDataCODTO), WTCodeCODTO wtCodeCO = default(WTCodeCODTO), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "codice" is required (not null)
            if (codice == null)
            {
                throw new InvalidDataException("codice is a required property for GeneralMasterDataCODTO and cannot be null");
            }
            else
            {
                this.Codice = codice;
            }
            this.Alias = alias;
            this.AuidAu04 = auidAu04;
            this.Cap = cap;
            this.Capcor = capcor;
            this.Capfisc = capfisc;
            this.Cellnum = cellnum;
            this.Citta = citta;
            this.Cittacor = cittacor;
            this.Cittafisc = cittafisc;
            this.Codfiscale = codfiscale;
            this.CodiceCg07 = codiceCg07;
            this.CodiceCg15 = codiceCg15;
            this.CodiceCgc0 = codiceCgc0;
            this.CodicecorCg07 = codicecorCg07;
            this.Codiceident = codiceident;
            this.Codicesfed = codicesfed;
            this.Codrichiamo = codrichiamo;
            this.Cognome = cognome;
            this.ComfisCg01 = comfisCg01;
            this.Comnascita = comnascita;
            this.ComnascitaCg01 = comnascitaCg01;
            this.Datanascita = datanascita;
            this.Datavalid = datavalid;
            this.Dtfinepec = dtfinepec;
            this.Dtiniziopec = dtiniziopec;
            this.Faxnum = faxnum;
            // use default value if no "flgAnagval" provided
            if (flgAnagval == null)
            {
                this.FlgAnagval = 1;
            }
            else
            {
                this.FlgAnagval = flgAnagval;
            }
            // use default value if no "flgFattpa" provided
            if (flgFattpa == null)
            {
                this.FlgFattpa = 0;
            }
            else
            {
                this.FlgFattpa = flgFattpa;
            }
            // use default value if no "flgNoblacklist" provided
            if (flgNoblacklist == null)
            {
                this.FlgNoblacklist = 0;
            }
            else
            {
                this.FlgNoblacklist = flgNoblacklist;
            }
            // use default value if no "flgOmonimo" provided
            if (flgOmonimo == null)
            {
                this.FlgOmonimo = 0;
            }
            else
            {
                this.FlgOmonimo = flgOmonimo;
            }
            // use default value if no "flgPrsfis" provided
            if (flgPrsfis == null)
            {
                this.FlgPrsfis = 0;
            }
            else
            {
                this.FlgPrsfis = flgPrsfis;
            }
            this.IdmediaCg99 = idmediaCg99;
            this.Indemail = indemail;
            this.IndFiscale = indFiscale;
            this.IndFiscaleEX = indFiscaleEX;
            this.IndirCor = indirCor;
            this.IndirCorEX = indirCorEX;
            this.Indirizzo = indirizzo;
            this.IndirizzoEX = indirizzoEX;
            // use default value if no "indsoggrit" provided
            if (indsoggrit == null)
            {
                this.Indsoggrit = 0;
            }
            else
            {
                this.Indsoggrit = indsoggrit;
            }
            this.Indweb = indweb;
            this.Lastchange = lastchange;
            this.Nome = nome;
            this.PartitaIVA = partitaIVA;
            this.Partiva = partiva;
            this.PartivaEst = partivaEst;
            this.Prov = prov;
            this.Provcor = provcor;
            this.Provfisc = provfisc;
            this.Provnascita = provnascita;
            this.RagSoAnag = ragSoAnag;
            this.Ragsoanagex = ragsoanagex;
            this.Ragsocor = ragsocor;
            this.Ragsocorex = ragsocorex;
            this.Ragsofisc = ragsofisc;
            this.Ragsofiscex = ragsofiscex;
            this.RapazestCg16 = rapazestCg16;
            // use default value if no "sesso" provided
            if (sesso == null)
            {
                this.Sesso = 0;
            }
            else
            {
                this.Sesso = sesso;
            }
            this.Statofed = statofed;
            this.Statofedfisc = statofedfisc;
            this.StatofiscCg07 = statofiscCg07;
            this.StatonascitaCg07 = statonascitaCg07;
            this.Tel1num = tel1num;
            this.Tel2num = tel2num;
            this.IdExtendedAttributeEntity = idExtendedAttributeEntity;
            this.IdExtendedAttributeSubEntity = idExtendedAttributeSubEntity;
            this.Addresses = addresses;
            this.FiscalRepresentative = fiscalRepresentative;
            this.IntragroupStructureCO = intragroupStructureCO;
            this.NationCOBirth = nationCOBirth;
            this.SubstitutiveMasterdata = substitutiveMasterdata;
            this.WtCodeCO = wtCodeCO;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// CG16_ALIAS - Alias
        /// </summary>
        /// <value>CG16_ALIAS - Alias</value>
        [DataMember(Name="alias", EmitDefaultValue=false)]
        public string Alias { get; set; }

        /// <summary>
        /// CG16_AUID_AU04 - Codice AU
        /// </summary>
        /// <value>CG16_AUID_AU04 - Codice AU</value>
        [DataMember(Name="auidAu04", EmitDefaultValue=false)]
        public long? AuidAu04 { get; set; }

        /// <summary>
        /// CG16_CAP - Cap
        /// </summary>
        /// <value>CG16_CAP - Cap</value>
        [DataMember(Name="cap", EmitDefaultValue=false)]
        public string Cap { get; set; }

        /// <summary>
        /// CG16_CAPCOR - Cap corrispondenza
        /// </summary>
        /// <value>CG16_CAPCOR - Cap corrispondenza</value>
        [DataMember(Name="capcor", EmitDefaultValue=false)]
        public string Capcor { get; set; }

        /// <summary>
        /// CG16_CAPFISC - CAP fiscale
        /// </summary>
        /// <value>CG16_CAPFISC - CAP fiscale</value>
        [DataMember(Name="capfisc", EmitDefaultValue=false)]
        public string Capfisc { get; set; }

        /// <summary>
        /// CG16_CELLNUM - Cell.
        /// </summary>
        /// <value>CG16_CELLNUM - Cell.</value>
        [DataMember(Name="cellnum", EmitDefaultValue=false)]
        public string Cellnum { get; set; }

        /// <summary>
        /// CG16_CITTA - Città
        /// </summary>
        /// <value>CG16_CITTA - Città</value>
        [DataMember(Name="citta", EmitDefaultValue=false)]
        public string Citta { get; set; }

        /// <summary>
        /// CG16_CITTACOR - Città corrispondenza
        /// </summary>
        /// <value>CG16_CITTACOR - Città corrispondenza</value>
        [DataMember(Name="cittacor", EmitDefaultValue=false)]
        public string Cittacor { get; set; }

        /// <summary>
        /// CG16_CITTAFISC - Città fiscale
        /// </summary>
        /// <value>CG16_CITTAFISC - Città fiscale</value>
        [DataMember(Name="cittafisc", EmitDefaultValue=false)]
        public string Cittafisc { get; set; }

        /// <summary>
        /// CG16_CODFISCALE - Codice fiscale
        /// </summary>
        /// <value>CG16_CODFISCALE - Codice fiscale</value>
        [DataMember(Name="codfiscale", EmitDefaultValue=false)]
        public string Codfiscale { get; set; }

        /// <summary>
        /// CG16_CODICE - Codice
        /// </summary>
        /// <value>CG16_CODICE - Codice</value>
        [DataMember(Name="codice", EmitDefaultValue=false)]
        public int? Codice { get; set; }

        /// <summary>
        /// CG16_CODICE_CG07 - Stato estero
        /// </summary>
        /// <value>CG16_CODICE_CG07 - Stato estero</value>
        [DataMember(Name="codiceCg07", EmitDefaultValue=false)]
        public double? CodiceCg07 { get; set; }

        /// <summary>
        /// CG16_CODICE_CG15 - Causale prestazione
        /// </summary>
        /// <value>CG16_CODICE_CG15 - Causale prestazione</value>
        [DataMember(Name="codiceCg15", EmitDefaultValue=false)]
        public string CodiceCg15 { get; set; }

        /// <summary>
        /// CG16_CODICE_CGC0 - Azienda intercompany
        /// </summary>
        /// <value>CG16_CODICE_CGC0 - Azienda intercompany</value>
        [DataMember(Name="codiceCgc0", EmitDefaultValue=false)]
        public double? CodiceCgc0 { get; set; }

        /// <summary>
        /// CG16_CODICECOR_CG07 - Stato estero corrisp.
        /// </summary>
        /// <value>CG16_CODICECOR_CG07 - Stato estero corrisp.</value>
        [DataMember(Name="codicecorCg07", EmitDefaultValue=false)]
        public double? CodicecorCg07 { get; set; }

        /// <summary>
        /// CG16_CODICEIDENT - Codice aggiuntivo
        /// </summary>
        /// <value>CG16_CODICEIDENT - Codice aggiuntivo</value>
        [DataMember(Name="codiceident", EmitDefaultValue=false)]
        public string Codiceident { get; set; }

        /// <summary>
        /// CG16_CODICESFED - Stato federato
        /// </summary>
        /// <value>CG16_CODICESFED - Stato federato</value>
        [DataMember(Name="codicesfed", EmitDefaultValue=false)]
        public string Codicesfed { get; set; }

        /// <summary>
        /// CG16_CODRICHIAMO - Codice anagrafica sostitutiva
        /// </summary>
        /// <value>CG16_CODRICHIAMO - Codice anagrafica sostitutiva</value>
        [DataMember(Name="codrichiamo", EmitDefaultValue=false)]
        public int? Codrichiamo { get; set; }

        /// <summary>
        /// CG16_COGNOME - Cognome
        /// </summary>
        /// <value>CG16_COGNOME - Cognome</value>
        [DataMember(Name="cognome", EmitDefaultValue=false)]
        public string Cognome { get; set; }

        /// <summary>
        /// CG16_COMFIS_CG01 - Codice comune fiscale
        /// </summary>
        /// <value>CG16_COMFIS_CG01 - Codice comune fiscale</value>
        [DataMember(Name="comfisCg01", EmitDefaultValue=false)]
        public string ComfisCg01 { get; set; }

        /// <summary>
        /// CG16_COMNASCITA - Comune di nascita
        /// </summary>
        /// <value>CG16_COMNASCITA - Comune di nascita</value>
        [DataMember(Name="comnascita", EmitDefaultValue=false)]
        public string Comnascita { get; set; }

        /// <summary>
        /// CG16_COMNASCITA_CG01 - Codice comune nascita
        /// </summary>
        /// <value>CG16_COMNASCITA_CG01 - Codice comune nascita</value>
        [DataMember(Name="comnascitaCg01", EmitDefaultValue=false)]
        public string ComnascitaCg01 { get; set; }

        /// <summary>
        /// CG16_DATANASCITA - Data di nascita
        /// </summary>
        /// <value>CG16_DATANASCITA - Data di nascita</value>
        [DataMember(Name="datanascita", EmitDefaultValue=false)]
        public DateTime? Datanascita { get; set; }

        /// <summary>
        /// CG16_DATAVALID - Data validità
        /// </summary>
        /// <value>CG16_DATAVALID - Data validità</value>
        [DataMember(Name="datavalid", EmitDefaultValue=false)]
        public DateTime? Datavalid { get; set; }

        /// <summary>
        /// CG16_DTFINEPEC - Data fine procedure esecutive o concorsuali
        /// </summary>
        /// <value>CG16_DTFINEPEC - Data fine procedure esecutive o concorsuali</value>
        [DataMember(Name="dtfinepec", EmitDefaultValue=false)]
        public DateTime? Dtfinepec { get; set; }

        /// <summary>
        /// CG16_DTINIZIOPEC - Data inizio procedure esecutive o concorsuali
        /// </summary>
        /// <value>CG16_DTINIZIOPEC - Data inizio procedure esecutive o concorsuali</value>
        [DataMember(Name="dtiniziopec", EmitDefaultValue=false)]
        public DateTime? Dtiniziopec { get; set; }

        /// <summary>
        /// CG16_FAXNUM - Fax
        /// </summary>
        /// <value>CG16_FAXNUM - Fax</value>
        [DataMember(Name="faxnum", EmitDefaultValue=false)]
        public string Faxnum { get; set; }

        /// <summary>
        /// CG16_FLGANAGVAL - Anag. valida&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Anagrafica valida&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Anagrafica non valida&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG16_FLGANAGVAL - Anag. valida&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Anagrafica valida&lt;/li&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Anagrafica non valida&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgAnagval", EmitDefaultValue=false)]
        public double? FlgAnagval { get; set; }

        /// <summary>
        /// CG16_FLGFATTPA - Attivazione modulo fatturazione elettronica verso la Pubblica Amministrazione
        /// </summary>
        /// <value>CG16_FLGFATTPA - Attivazione modulo fatturazione elettronica verso la Pubblica Amministrazione</value>
        [DataMember(Name="flgFattpa", EmitDefaultValue=false)]
        public int? FlgFattpa { get; set; }

        /// <summary>
        /// CG16_FLGNOBLACKLIST - Escludi anagrafica da elenco Black List
        /// </summary>
        /// <value>CG16_FLGNOBLACKLIST - Escludi anagrafica da elenco Black List</value>
        [DataMember(Name="flgNoblacklist", EmitDefaultValue=false)]
        public double? FlgNoblacklist { get; set; }

        /// <summary>
        /// CG16_FLGOMONIMO - Anagr. principale per fusione omonimi
        /// </summary>
        /// <value>CG16_FLGOMONIMO - Anagr. principale per fusione omonimi</value>
        [DataMember(Name="flgOmonimo", EmitDefaultValue=false)]
        public double? FlgOmonimo { get; set; }

        /// <summary>
        /// CG16_FLGPRSFIS - Persona fisica&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG16_FLGPRSFIS - Persona fisica&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgPrsfis", EmitDefaultValue=false)]
        public double? FlgPrsfis { get; set; }

        /// <summary>
        /// CG16_IDMEDIA_CG99 - ID HyperMedia
        /// </summary>
        /// <value>CG16_IDMEDIA_CG99 - ID HyperMedia</value>
        [DataMember(Name="idmediaCg99", EmitDefaultValue=false)]
        public double? IdmediaCg99 { get; set; }

        /// <summary>
        /// CG16_INDEMAIL - E-mail
        /// </summary>
        /// <value>CG16_INDEMAIL - E-mail</value>
        [DataMember(Name="indemail", EmitDefaultValue=false)]
        public string Indemail { get; set; }

        /// <summary>
        /// CG16_INDFISCALE - Indirizzo fiscale
        /// </summary>
        /// <value>CG16_INDFISCALE - Indirizzo fiscale</value>
        [DataMember(Name="indFiscale", EmitDefaultValue=false)]
        public string IndFiscale { get; set; }

        /// <summary>
        /// CG16_INDFISCALEEX - Indirizzo fiscale est
        /// </summary>
        /// <value>CG16_INDFISCALEEX - Indirizzo fiscale est</value>
        [DataMember(Name="indFiscaleEX", EmitDefaultValue=false)]
        public string IndFiscaleEX { get; set; }

        /// <summary>
        /// CG16_INDIRCOR - Indirizzo corrispondenza
        /// </summary>
        /// <value>CG16_INDIRCOR - Indirizzo corrispondenza</value>
        [DataMember(Name="indirCor", EmitDefaultValue=false)]
        public string IndirCor { get; set; }

        /// <summary>
        /// CG16_INDIRCOREX - Indirizzo corrispondenza esteso
        /// </summary>
        /// <value>CG16_INDIRCOREX - Indirizzo corrispondenza esteso</value>
        [DataMember(Name="indirCorEX", EmitDefaultValue=false)]
        public string IndirCorEX { get; set; }

        /// <summary>
        /// CG16_INDIRIZZO - Indirizzo
        /// </summary>
        /// <value>CG16_INDIRIZZO - Indirizzo</value>
        [DataMember(Name="indirizzo", EmitDefaultValue=false)]
        public string Indirizzo { get; set; }

        /// <summary>
        /// CG16_INDIRIZZOEX - Indirizzo esteso
        /// </summary>
        /// <value>CG16_INDIRIZZOEX - Indirizzo esteso</value>
        [DataMember(Name="indirizzoEX", EmitDefaultValue=false)]
        public string IndirizzoEX { get; set; }

        /// <summary>
        /// CG16_INDSOGGRIT - Soggetto ritenuta acconto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Non soggetto&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Professionista&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Rappresentante&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG16_INDSOGGRIT - Soggetto ritenuta acconto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; -  Non soggetto&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Professionista&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - Rappresentante&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="indsoggrit", EmitDefaultValue=false)]
        public double? Indsoggrit { get; set; }

        /// <summary>
        /// CG16_INDWEB - Indirizzo web
        /// </summary>
        /// <value>CG16_INDWEB - Indirizzo web</value>
        [DataMember(Name="indweb", EmitDefaultValue=false)]
        public string Indweb { get; set; }

        /// <summary>
        /// CG16_LASTCHANGE - Data ultima variazione
        /// </summary>
        /// <value>CG16_LASTCHANGE - Data ultima variazione</value>
        [DataMember(Name="lastchange", EmitDefaultValue=false)]
        public DateTime? Lastchange { get; set; }

        /// <summary>
        /// CG16_NOME - Nome
        /// </summary>
        /// <value>CG16_NOME - Nome</value>
        [DataMember(Name="nome", EmitDefaultValue=false)]
        public string Nome { get; set; }

        /// <summary>
        /// Partita IVA
        /// </summary>
        /// <value>Partita IVA</value>
        [DataMember(Name="partitaIVA", EmitDefaultValue=false)]
        public string PartitaIVA { get; set; }

        /// <summary>
        /// CG16_PARTIVA - Partita IVA
        /// </summary>
        /// <value>CG16_PARTIVA - Partita IVA</value>
        [DataMember(Name="partiva", EmitDefaultValue=false)]
        public string Partiva { get; set; }

        /// <summary>
        /// CG16_PARTIVA_EST - Partita IVA estera
        /// </summary>
        /// <value>CG16_PARTIVA_EST - Partita IVA estera</value>
        [DataMember(Name="partivaEst", EmitDefaultValue=false)]
        public string PartivaEst { get; set; }

        /// <summary>
        /// CG16_PROV - Prov
        /// </summary>
        /// <value>CG16_PROV - Prov</value>
        [DataMember(Name="prov", EmitDefaultValue=false)]
        public string Prov { get; set; }

        /// <summary>
        /// CG16_PROVCOR - Provincia corrispondenza
        /// </summary>
        /// <value>CG16_PROVCOR - Provincia corrispondenza</value>
        [DataMember(Name="provcor", EmitDefaultValue=false)]
        public string Provcor { get; set; }

        /// <summary>
        /// CG16_PROVFISC - Provincia fiscale
        /// </summary>
        /// <value>CG16_PROVFISC - Provincia fiscale</value>
        [DataMember(Name="provfisc", EmitDefaultValue=false)]
        public string Provfisc { get; set; }

        /// <summary>
        /// CG16_PROVNASCITA - Provincia di nascita
        /// </summary>
        /// <value>CG16_PROVNASCITA - Provincia di nascita</value>
        [DataMember(Name="provnascita", EmitDefaultValue=false)]
        public string Provnascita { get; set; }

        /// <summary>
        /// CG16_RAGSOANAG - Ragione sociale
        /// </summary>
        /// <value>CG16_RAGSOANAG - Ragione sociale</value>
        [DataMember(Name="ragSoAnag", EmitDefaultValue=false)]
        public string RagSoAnag { get; set; }

        /// <summary>
        /// CG16_RAGSOANAGEX - Ragione sociale estesa
        /// </summary>
        /// <value>CG16_RAGSOANAGEX - Ragione sociale estesa</value>
        [DataMember(Name="ragsoanagex", EmitDefaultValue=false)]
        public string Ragsoanagex { get; set; }

        /// <summary>
        /// CG16_RAGSOCOR - Ragione sociale corrispondenza
        /// </summary>
        /// <value>CG16_RAGSOCOR - Ragione sociale corrispondenza</value>
        [DataMember(Name="ragsocor", EmitDefaultValue=false)]
        public string Ragsocor { get; set; }

        /// <summary>
        /// CG16_RAGSOCOREX - Ragione sociale corrispondenza estesa
        /// </summary>
        /// <value>CG16_RAGSOCOREX - Ragione sociale corrispondenza estesa</value>
        [DataMember(Name="ragsocorex", EmitDefaultValue=false)]
        public string Ragsocorex { get; set; }

        /// <summary>
        /// CG16_RAGSOFISC - Ragione sociale fiscale
        /// </summary>
        /// <value>CG16_RAGSOFISC - Ragione sociale fiscale</value>
        [DataMember(Name="ragsofisc", EmitDefaultValue=false)]
        public string Ragsofisc { get; set; }

        /// <summary>
        /// CG16_RAGSOFISCEX - Ragione sociale fiscale estesa
        /// </summary>
        /// <value>CG16_RAGSOFISCEX - Ragione sociale fiscale estesa</value>
        [DataMember(Name="ragsofiscex", EmitDefaultValue=false)]
        public string Ragsofiscex { get; set; }

        /// <summary>
        /// CG16_RAPAZEST_CG16 - Codice anagrafico rappresentante legale
        /// </summary>
        /// <value>CG16_RAPAZEST_CG16 - Codice anagrafico rappresentante legale</value>
        [DataMember(Name="rapazestCg16", EmitDefaultValue=false)]
        public int? RapazestCg16 { get; set; }

        /// <summary>
        /// CG16_SESSO - Sesso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Maschio&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Femmina&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>CG16_SESSO - Sesso&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Maschio&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Femmina&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="sesso", EmitDefaultValue=false)]
        public double? Sesso { get; set; }

        /// <summary>
        /// CG16_STATOFED - Stato federato
        /// </summary>
        /// <value>CG16_STATOFED - Stato federato</value>
        [DataMember(Name="statofed", EmitDefaultValue=false)]
        public string Statofed { get; set; }

        /// <summary>
        /// CG16_STATOFEDFISC - Stato federato fisc.
        /// </summary>
        /// <value>CG16_STATOFEDFISC - Stato federato fisc.</value>
        [DataMember(Name="statofedfisc", EmitDefaultValue=false)]
        public string Statofedfisc { get; set; }

        /// <summary>
        /// CG16_STATOFISC_CG07 - Codice stato fiscale
        /// </summary>
        /// <value>CG16_STATOFISC_CG07 - Codice stato fiscale</value>
        [DataMember(Name="statofiscCg07", EmitDefaultValue=false)]
        public double? StatofiscCg07 { get; set; }

        /// <summary>
        /// CG16_STATONASCITA_CG07 - Codice stato nascita
        /// </summary>
        /// <value>CG16_STATONASCITA_CG07 - Codice stato nascita</value>
        [DataMember(Name="statonascitaCg07", EmitDefaultValue=false)]
        public double? StatonascitaCg07 { get; set; }

        /// <summary>
        /// CG16_TEL1NUM - Telefono 1
        /// </summary>
        /// <value>CG16_TEL1NUM - Telefono 1</value>
        [DataMember(Name="tel1num", EmitDefaultValue=false)]
        public string Tel1num { get; set; }

        /// <summary>
        /// CG16_TEL2NUM - Telefono 2
        /// </summary>
        /// <value>CG16_TEL2NUM - Telefono 2</value>
        [DataMember(Name="tel2num", EmitDefaultValue=false)]
        public string Tel2num { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeEntity { get; set; }

        /// <summary>
        /// Gets or Sets IdExtendedAttributeSubEntity
        /// </summary>
        [DataMember(Name="idExtendedAttributeSubEntity", EmitDefaultValue=false)]
        public int? IdExtendedAttributeSubEntity { get; set; }

        /// <summary>
        /// Gets or Sets Addresses
        /// </summary>
        [DataMember(Name="addresses", EmitDefaultValue=false)]
        public List<AddressCODTO> Addresses { get; set; }

        /// <summary>
        /// Gets or Sets FiscalRepresentative
        /// </summary>
        [DataMember(Name="fiscalRepresentative", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO FiscalRepresentative { get; set; }

        /// <summary>
        /// Gets or Sets IntragroupStructureCO
        /// </summary>
        [DataMember(Name="intragroupStructureCO", EmitDefaultValue=false)]
        public IntragroupStructureCODTO IntragroupStructureCO { get; set; }

        /// <summary>
        /// Gets or Sets NationCOBirth
        /// </summary>
        [DataMember(Name="nationCO_Birth", EmitDefaultValue=false)]
        public NationCODTO NationCOBirth { get; set; }

        /// <summary>
        /// Gets or Sets SubstitutiveMasterdata
        /// </summary>
        [DataMember(Name="substitutiveMasterdata", EmitDefaultValue=false)]
        public GeneralMasterDataCODTO SubstitutiveMasterdata { get; set; }

        /// <summary>
        /// Gets or Sets WtCodeCO
        /// </summary>
        [DataMember(Name="wtCodeCO", EmitDefaultValue=false)]
        public WTCodeCODTO WtCodeCO { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class GeneralMasterDataCODTO {\n");
            sb.Append("  Alias: ").Append(Alias).Append("\n");
            sb.Append("  AuidAu04: ").Append(AuidAu04).Append("\n");
            sb.Append("  Cap: ").Append(Cap).Append("\n");
            sb.Append("  Capcor: ").Append(Capcor).Append("\n");
            sb.Append("  Capfisc: ").Append(Capfisc).Append("\n");
            sb.Append("  Cellnum: ").Append(Cellnum).Append("\n");
            sb.Append("  Citta: ").Append(Citta).Append("\n");
            sb.Append("  Cittacor: ").Append(Cittacor).Append("\n");
            sb.Append("  Cittafisc: ").Append(Cittafisc).Append("\n");
            sb.Append("  Codfiscale: ").Append(Codfiscale).Append("\n");
            sb.Append("  Codice: ").Append(Codice).Append("\n");
            sb.Append("  CodiceCg07: ").Append(CodiceCg07).Append("\n");
            sb.Append("  CodiceCg15: ").Append(CodiceCg15).Append("\n");
            sb.Append("  CodiceCgc0: ").Append(CodiceCgc0).Append("\n");
            sb.Append("  CodicecorCg07: ").Append(CodicecorCg07).Append("\n");
            sb.Append("  Codiceident: ").Append(Codiceident).Append("\n");
            sb.Append("  Codicesfed: ").Append(Codicesfed).Append("\n");
            sb.Append("  Codrichiamo: ").Append(Codrichiamo).Append("\n");
            sb.Append("  Cognome: ").Append(Cognome).Append("\n");
            sb.Append("  ComfisCg01: ").Append(ComfisCg01).Append("\n");
            sb.Append("  Comnascita: ").Append(Comnascita).Append("\n");
            sb.Append("  ComnascitaCg01: ").Append(ComnascitaCg01).Append("\n");
            sb.Append("  Datanascita: ").Append(Datanascita).Append("\n");
            sb.Append("  Datavalid: ").Append(Datavalid).Append("\n");
            sb.Append("  Dtfinepec: ").Append(Dtfinepec).Append("\n");
            sb.Append("  Dtiniziopec: ").Append(Dtiniziopec).Append("\n");
            sb.Append("  Faxnum: ").Append(Faxnum).Append("\n");
            sb.Append("  FlgAnagval: ").Append(FlgAnagval).Append("\n");
            sb.Append("  FlgFattpa: ").Append(FlgFattpa).Append("\n");
            sb.Append("  FlgNoblacklist: ").Append(FlgNoblacklist).Append("\n");
            sb.Append("  FlgOmonimo: ").Append(FlgOmonimo).Append("\n");
            sb.Append("  FlgPrsfis: ").Append(FlgPrsfis).Append("\n");
            sb.Append("  IdmediaCg99: ").Append(IdmediaCg99).Append("\n");
            sb.Append("  Indemail: ").Append(Indemail).Append("\n");
            sb.Append("  IndFiscale: ").Append(IndFiscale).Append("\n");
            sb.Append("  IndFiscaleEX: ").Append(IndFiscaleEX).Append("\n");
            sb.Append("  IndirCor: ").Append(IndirCor).Append("\n");
            sb.Append("  IndirCorEX: ").Append(IndirCorEX).Append("\n");
            sb.Append("  Indirizzo: ").Append(Indirizzo).Append("\n");
            sb.Append("  IndirizzoEX: ").Append(IndirizzoEX).Append("\n");
            sb.Append("  Indsoggrit: ").Append(Indsoggrit).Append("\n");
            sb.Append("  Indweb: ").Append(Indweb).Append("\n");
            sb.Append("  Lastchange: ").Append(Lastchange).Append("\n");
            sb.Append("  Nome: ").Append(Nome).Append("\n");
            sb.Append("  PartitaIVA: ").Append(PartitaIVA).Append("\n");
            sb.Append("  Partiva: ").Append(Partiva).Append("\n");
            sb.Append("  PartivaEst: ").Append(PartivaEst).Append("\n");
            sb.Append("  Prov: ").Append(Prov).Append("\n");
            sb.Append("  Provcor: ").Append(Provcor).Append("\n");
            sb.Append("  Provfisc: ").Append(Provfisc).Append("\n");
            sb.Append("  Provnascita: ").Append(Provnascita).Append("\n");
            sb.Append("  RagSoAnag: ").Append(RagSoAnag).Append("\n");
            sb.Append("  Ragsoanagex: ").Append(Ragsoanagex).Append("\n");
            sb.Append("  Ragsocor: ").Append(Ragsocor).Append("\n");
            sb.Append("  Ragsocorex: ").Append(Ragsocorex).Append("\n");
            sb.Append("  Ragsofisc: ").Append(Ragsofisc).Append("\n");
            sb.Append("  Ragsofiscex: ").Append(Ragsofiscex).Append("\n");
            sb.Append("  RapazestCg16: ").Append(RapazestCg16).Append("\n");
            sb.Append("  Sesso: ").Append(Sesso).Append("\n");
            sb.Append("  Statofed: ").Append(Statofed).Append("\n");
            sb.Append("  Statofedfisc: ").Append(Statofedfisc).Append("\n");
            sb.Append("  StatofiscCg07: ").Append(StatofiscCg07).Append("\n");
            sb.Append("  StatonascitaCg07: ").Append(StatonascitaCg07).Append("\n");
            sb.Append("  Tel1num: ").Append(Tel1num).Append("\n");
            sb.Append("  Tel2num: ").Append(Tel2num).Append("\n");
            sb.Append("  IdExtendedAttributeEntity: ").Append(IdExtendedAttributeEntity).Append("\n");
            sb.Append("  IdExtendedAttributeSubEntity: ").Append(IdExtendedAttributeSubEntity).Append("\n");
            sb.Append("  Addresses: ").Append(Addresses).Append("\n");
            sb.Append("  FiscalRepresentative: ").Append(FiscalRepresentative).Append("\n");
            sb.Append("  IntragroupStructureCO: ").Append(IntragroupStructureCO).Append("\n");
            sb.Append("  NationCOBirth: ").Append(NationCOBirth).Append("\n");
            sb.Append("  SubstitutiveMasterdata: ").Append(SubstitutiveMasterdata).Append("\n");
            sb.Append("  WtCodeCO: ").Append(WtCodeCO).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as GeneralMasterDataCODTO);
        }

        /// <summary>
        /// Returns true if GeneralMasterDataCODTO instances are equal
        /// </summary>
        /// <param name="input">Instance of GeneralMasterDataCODTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(GeneralMasterDataCODTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Alias == input.Alias ||
                    (this.Alias != null &&
                    this.Alias.Equals(input.Alias))
                ) && 
                (
                    this.AuidAu04 == input.AuidAu04 ||
                    (this.AuidAu04 != null &&
                    this.AuidAu04.Equals(input.AuidAu04))
                ) && 
                (
                    this.Cap == input.Cap ||
                    (this.Cap != null &&
                    this.Cap.Equals(input.Cap))
                ) && 
                (
                    this.Capcor == input.Capcor ||
                    (this.Capcor != null &&
                    this.Capcor.Equals(input.Capcor))
                ) && 
                (
                    this.Capfisc == input.Capfisc ||
                    (this.Capfisc != null &&
                    this.Capfisc.Equals(input.Capfisc))
                ) && 
                (
                    this.Cellnum == input.Cellnum ||
                    (this.Cellnum != null &&
                    this.Cellnum.Equals(input.Cellnum))
                ) && 
                (
                    this.Citta == input.Citta ||
                    (this.Citta != null &&
                    this.Citta.Equals(input.Citta))
                ) && 
                (
                    this.Cittacor == input.Cittacor ||
                    (this.Cittacor != null &&
                    this.Cittacor.Equals(input.Cittacor))
                ) && 
                (
                    this.Cittafisc == input.Cittafisc ||
                    (this.Cittafisc != null &&
                    this.Cittafisc.Equals(input.Cittafisc))
                ) && 
                (
                    this.Codfiscale == input.Codfiscale ||
                    (this.Codfiscale != null &&
                    this.Codfiscale.Equals(input.Codfiscale))
                ) && 
                (
                    this.Codice == input.Codice ||
                    (this.Codice != null &&
                    this.Codice.Equals(input.Codice))
                ) && 
                (
                    this.CodiceCg07 == input.CodiceCg07 ||
                    (this.CodiceCg07 != null &&
                    this.CodiceCg07.Equals(input.CodiceCg07))
                ) && 
                (
                    this.CodiceCg15 == input.CodiceCg15 ||
                    (this.CodiceCg15 != null &&
                    this.CodiceCg15.Equals(input.CodiceCg15))
                ) && 
                (
                    this.CodiceCgc0 == input.CodiceCgc0 ||
                    (this.CodiceCgc0 != null &&
                    this.CodiceCgc0.Equals(input.CodiceCgc0))
                ) && 
                (
                    this.CodicecorCg07 == input.CodicecorCg07 ||
                    (this.CodicecorCg07 != null &&
                    this.CodicecorCg07.Equals(input.CodicecorCg07))
                ) && 
                (
                    this.Codiceident == input.Codiceident ||
                    (this.Codiceident != null &&
                    this.Codiceident.Equals(input.Codiceident))
                ) && 
                (
                    this.Codicesfed == input.Codicesfed ||
                    (this.Codicesfed != null &&
                    this.Codicesfed.Equals(input.Codicesfed))
                ) && 
                (
                    this.Codrichiamo == input.Codrichiamo ||
                    (this.Codrichiamo != null &&
                    this.Codrichiamo.Equals(input.Codrichiamo))
                ) && 
                (
                    this.Cognome == input.Cognome ||
                    (this.Cognome != null &&
                    this.Cognome.Equals(input.Cognome))
                ) && 
                (
                    this.ComfisCg01 == input.ComfisCg01 ||
                    (this.ComfisCg01 != null &&
                    this.ComfisCg01.Equals(input.ComfisCg01))
                ) && 
                (
                    this.Comnascita == input.Comnascita ||
                    (this.Comnascita != null &&
                    this.Comnascita.Equals(input.Comnascita))
                ) && 
                (
                    this.ComnascitaCg01 == input.ComnascitaCg01 ||
                    (this.ComnascitaCg01 != null &&
                    this.ComnascitaCg01.Equals(input.ComnascitaCg01))
                ) && 
                (
                    this.Datanascita == input.Datanascita ||
                    (this.Datanascita != null &&
                    this.Datanascita.Equals(input.Datanascita))
                ) && 
                (
                    this.Datavalid == input.Datavalid ||
                    (this.Datavalid != null &&
                    this.Datavalid.Equals(input.Datavalid))
                ) && 
                (
                    this.Dtfinepec == input.Dtfinepec ||
                    (this.Dtfinepec != null &&
                    this.Dtfinepec.Equals(input.Dtfinepec))
                ) && 
                (
                    this.Dtiniziopec == input.Dtiniziopec ||
                    (this.Dtiniziopec != null &&
                    this.Dtiniziopec.Equals(input.Dtiniziopec))
                ) && 
                (
                    this.Faxnum == input.Faxnum ||
                    (this.Faxnum != null &&
                    this.Faxnum.Equals(input.Faxnum))
                ) && 
                (
                    this.FlgAnagval == input.FlgAnagval ||
                    (this.FlgAnagval != null &&
                    this.FlgAnagval.Equals(input.FlgAnagval))
                ) && 
                (
                    this.FlgFattpa == input.FlgFattpa ||
                    (this.FlgFattpa != null &&
                    this.FlgFattpa.Equals(input.FlgFattpa))
                ) && 
                (
                    this.FlgNoblacklist == input.FlgNoblacklist ||
                    (this.FlgNoblacklist != null &&
                    this.FlgNoblacklist.Equals(input.FlgNoblacklist))
                ) && 
                (
                    this.FlgOmonimo == input.FlgOmonimo ||
                    (this.FlgOmonimo != null &&
                    this.FlgOmonimo.Equals(input.FlgOmonimo))
                ) && 
                (
                    this.FlgPrsfis == input.FlgPrsfis ||
                    (this.FlgPrsfis != null &&
                    this.FlgPrsfis.Equals(input.FlgPrsfis))
                ) && 
                (
                    this.IdmediaCg99 == input.IdmediaCg99 ||
                    (this.IdmediaCg99 != null &&
                    this.IdmediaCg99.Equals(input.IdmediaCg99))
                ) && 
                (
                    this.Indemail == input.Indemail ||
                    (this.Indemail != null &&
                    this.Indemail.Equals(input.Indemail))
                ) && 
                (
                    this.IndFiscale == input.IndFiscale ||
                    (this.IndFiscale != null &&
                    this.IndFiscale.Equals(input.IndFiscale))
                ) && 
                (
                    this.IndFiscaleEX == input.IndFiscaleEX ||
                    (this.IndFiscaleEX != null &&
                    this.IndFiscaleEX.Equals(input.IndFiscaleEX))
                ) && 
                (
                    this.IndirCor == input.IndirCor ||
                    (this.IndirCor != null &&
                    this.IndirCor.Equals(input.IndirCor))
                ) && 
                (
                    this.IndirCorEX == input.IndirCorEX ||
                    (this.IndirCorEX != null &&
                    this.IndirCorEX.Equals(input.IndirCorEX))
                ) && 
                (
                    this.Indirizzo == input.Indirizzo ||
                    (this.Indirizzo != null &&
                    this.Indirizzo.Equals(input.Indirizzo))
                ) && 
                (
                    this.IndirizzoEX == input.IndirizzoEX ||
                    (this.IndirizzoEX != null &&
                    this.IndirizzoEX.Equals(input.IndirizzoEX))
                ) && 
                (
                    this.Indsoggrit == input.Indsoggrit ||
                    (this.Indsoggrit != null &&
                    this.Indsoggrit.Equals(input.Indsoggrit))
                ) && 
                (
                    this.Indweb == input.Indweb ||
                    (this.Indweb != null &&
                    this.Indweb.Equals(input.Indweb))
                ) && 
                (
                    this.Lastchange == input.Lastchange ||
                    (this.Lastchange != null &&
                    this.Lastchange.Equals(input.Lastchange))
                ) && 
                (
                    this.Nome == input.Nome ||
                    (this.Nome != null &&
                    this.Nome.Equals(input.Nome))
                ) && 
                (
                    this.PartitaIVA == input.PartitaIVA ||
                    (this.PartitaIVA != null &&
                    this.PartitaIVA.Equals(input.PartitaIVA))
                ) && 
                (
                    this.Partiva == input.Partiva ||
                    (this.Partiva != null &&
                    this.Partiva.Equals(input.Partiva))
                ) && 
                (
                    this.PartivaEst == input.PartivaEst ||
                    (this.PartivaEst != null &&
                    this.PartivaEst.Equals(input.PartivaEst))
                ) && 
                (
                    this.Prov == input.Prov ||
                    (this.Prov != null &&
                    this.Prov.Equals(input.Prov))
                ) && 
                (
                    this.Provcor == input.Provcor ||
                    (this.Provcor != null &&
                    this.Provcor.Equals(input.Provcor))
                ) && 
                (
                    this.Provfisc == input.Provfisc ||
                    (this.Provfisc != null &&
                    this.Provfisc.Equals(input.Provfisc))
                ) && 
                (
                    this.Provnascita == input.Provnascita ||
                    (this.Provnascita != null &&
                    this.Provnascita.Equals(input.Provnascita))
                ) && 
                (
                    this.RagSoAnag == input.RagSoAnag ||
                    (this.RagSoAnag != null &&
                    this.RagSoAnag.Equals(input.RagSoAnag))
                ) && 
                (
                    this.Ragsoanagex == input.Ragsoanagex ||
                    (this.Ragsoanagex != null &&
                    this.Ragsoanagex.Equals(input.Ragsoanagex))
                ) && 
                (
                    this.Ragsocor == input.Ragsocor ||
                    (this.Ragsocor != null &&
                    this.Ragsocor.Equals(input.Ragsocor))
                ) && 
                (
                    this.Ragsocorex == input.Ragsocorex ||
                    (this.Ragsocorex != null &&
                    this.Ragsocorex.Equals(input.Ragsocorex))
                ) && 
                (
                    this.Ragsofisc == input.Ragsofisc ||
                    (this.Ragsofisc != null &&
                    this.Ragsofisc.Equals(input.Ragsofisc))
                ) && 
                (
                    this.Ragsofiscex == input.Ragsofiscex ||
                    (this.Ragsofiscex != null &&
                    this.Ragsofiscex.Equals(input.Ragsofiscex))
                ) && 
                (
                    this.RapazestCg16 == input.RapazestCg16 ||
                    (this.RapazestCg16 != null &&
                    this.RapazestCg16.Equals(input.RapazestCg16))
                ) && 
                (
                    this.Sesso == input.Sesso ||
                    (this.Sesso != null &&
                    this.Sesso.Equals(input.Sesso))
                ) && 
                (
                    this.Statofed == input.Statofed ||
                    (this.Statofed != null &&
                    this.Statofed.Equals(input.Statofed))
                ) && 
                (
                    this.Statofedfisc == input.Statofedfisc ||
                    (this.Statofedfisc != null &&
                    this.Statofedfisc.Equals(input.Statofedfisc))
                ) && 
                (
                    this.StatofiscCg07 == input.StatofiscCg07 ||
                    (this.StatofiscCg07 != null &&
                    this.StatofiscCg07.Equals(input.StatofiscCg07))
                ) && 
                (
                    this.StatonascitaCg07 == input.StatonascitaCg07 ||
                    (this.StatonascitaCg07 != null &&
                    this.StatonascitaCg07.Equals(input.StatonascitaCg07))
                ) && 
                (
                    this.Tel1num == input.Tel1num ||
                    (this.Tel1num != null &&
                    this.Tel1num.Equals(input.Tel1num))
                ) && 
                (
                    this.Tel2num == input.Tel2num ||
                    (this.Tel2num != null &&
                    this.Tel2num.Equals(input.Tel2num))
                ) && 
                (
                    this.IdExtendedAttributeEntity == input.IdExtendedAttributeEntity ||
                    (this.IdExtendedAttributeEntity != null &&
                    this.IdExtendedAttributeEntity.Equals(input.IdExtendedAttributeEntity))
                ) && 
                (
                    this.IdExtendedAttributeSubEntity == input.IdExtendedAttributeSubEntity ||
                    (this.IdExtendedAttributeSubEntity != null &&
                    this.IdExtendedAttributeSubEntity.Equals(input.IdExtendedAttributeSubEntity))
                ) && 
                (
                    this.Addresses == input.Addresses ||
                    this.Addresses != null &&
                    input.Addresses != null &&
                    this.Addresses.SequenceEqual(input.Addresses)
                ) && 
                (
                    this.FiscalRepresentative == input.FiscalRepresentative ||
                    (this.FiscalRepresentative != null &&
                    this.FiscalRepresentative.Equals(input.FiscalRepresentative))
                ) && 
                (
                    this.IntragroupStructureCO == input.IntragroupStructureCO ||
                    (this.IntragroupStructureCO != null &&
                    this.IntragroupStructureCO.Equals(input.IntragroupStructureCO))
                ) && 
                (
                    this.NationCOBirth == input.NationCOBirth ||
                    (this.NationCOBirth != null &&
                    this.NationCOBirth.Equals(input.NationCOBirth))
                ) && 
                (
                    this.SubstitutiveMasterdata == input.SubstitutiveMasterdata ||
                    (this.SubstitutiveMasterdata != null &&
                    this.SubstitutiveMasterdata.Equals(input.SubstitutiveMasterdata))
                ) && 
                (
                    this.WtCodeCO == input.WtCodeCO ||
                    (this.WtCodeCO != null &&
                    this.WtCodeCO.Equals(input.WtCodeCO))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Alias != null)
                    hashCode = hashCode * 59 + this.Alias.GetHashCode();
                if (this.AuidAu04 != null)
                    hashCode = hashCode * 59 + this.AuidAu04.GetHashCode();
                if (this.Cap != null)
                    hashCode = hashCode * 59 + this.Cap.GetHashCode();
                if (this.Capcor != null)
                    hashCode = hashCode * 59 + this.Capcor.GetHashCode();
                if (this.Capfisc != null)
                    hashCode = hashCode * 59 + this.Capfisc.GetHashCode();
                if (this.Cellnum != null)
                    hashCode = hashCode * 59 + this.Cellnum.GetHashCode();
                if (this.Citta != null)
                    hashCode = hashCode * 59 + this.Citta.GetHashCode();
                if (this.Cittacor != null)
                    hashCode = hashCode * 59 + this.Cittacor.GetHashCode();
                if (this.Cittafisc != null)
                    hashCode = hashCode * 59 + this.Cittafisc.GetHashCode();
                if (this.Codfiscale != null)
                    hashCode = hashCode * 59 + this.Codfiscale.GetHashCode();
                if (this.Codice != null)
                    hashCode = hashCode * 59 + this.Codice.GetHashCode();
                if (this.CodiceCg07 != null)
                    hashCode = hashCode * 59 + this.CodiceCg07.GetHashCode();
                if (this.CodiceCg15 != null)
                    hashCode = hashCode * 59 + this.CodiceCg15.GetHashCode();
                if (this.CodiceCgc0 != null)
                    hashCode = hashCode * 59 + this.CodiceCgc0.GetHashCode();
                if (this.CodicecorCg07 != null)
                    hashCode = hashCode * 59 + this.CodicecorCg07.GetHashCode();
                if (this.Codiceident != null)
                    hashCode = hashCode * 59 + this.Codiceident.GetHashCode();
                if (this.Codicesfed != null)
                    hashCode = hashCode * 59 + this.Codicesfed.GetHashCode();
                if (this.Codrichiamo != null)
                    hashCode = hashCode * 59 + this.Codrichiamo.GetHashCode();
                if (this.Cognome != null)
                    hashCode = hashCode * 59 + this.Cognome.GetHashCode();
                if (this.ComfisCg01 != null)
                    hashCode = hashCode * 59 + this.ComfisCg01.GetHashCode();
                if (this.Comnascita != null)
                    hashCode = hashCode * 59 + this.Comnascita.GetHashCode();
                if (this.ComnascitaCg01 != null)
                    hashCode = hashCode * 59 + this.ComnascitaCg01.GetHashCode();
                if (this.Datanascita != null)
                    hashCode = hashCode * 59 + this.Datanascita.GetHashCode();
                if (this.Datavalid != null)
                    hashCode = hashCode * 59 + this.Datavalid.GetHashCode();
                if (this.Dtfinepec != null)
                    hashCode = hashCode * 59 + this.Dtfinepec.GetHashCode();
                if (this.Dtiniziopec != null)
                    hashCode = hashCode * 59 + this.Dtiniziopec.GetHashCode();
                if (this.Faxnum != null)
                    hashCode = hashCode * 59 + this.Faxnum.GetHashCode();
                if (this.FlgAnagval != null)
                    hashCode = hashCode * 59 + this.FlgAnagval.GetHashCode();
                if (this.FlgFattpa != null)
                    hashCode = hashCode * 59 + this.FlgFattpa.GetHashCode();
                if (this.FlgNoblacklist != null)
                    hashCode = hashCode * 59 + this.FlgNoblacklist.GetHashCode();
                if (this.FlgOmonimo != null)
                    hashCode = hashCode * 59 + this.FlgOmonimo.GetHashCode();
                if (this.FlgPrsfis != null)
                    hashCode = hashCode * 59 + this.FlgPrsfis.GetHashCode();
                if (this.IdmediaCg99 != null)
                    hashCode = hashCode * 59 + this.IdmediaCg99.GetHashCode();
                if (this.Indemail != null)
                    hashCode = hashCode * 59 + this.Indemail.GetHashCode();
                if (this.IndFiscale != null)
                    hashCode = hashCode * 59 + this.IndFiscale.GetHashCode();
                if (this.IndFiscaleEX != null)
                    hashCode = hashCode * 59 + this.IndFiscaleEX.GetHashCode();
                if (this.IndirCor != null)
                    hashCode = hashCode * 59 + this.IndirCor.GetHashCode();
                if (this.IndirCorEX != null)
                    hashCode = hashCode * 59 + this.IndirCorEX.GetHashCode();
                if (this.Indirizzo != null)
                    hashCode = hashCode * 59 + this.Indirizzo.GetHashCode();
                if (this.IndirizzoEX != null)
                    hashCode = hashCode * 59 + this.IndirizzoEX.GetHashCode();
                if (this.Indsoggrit != null)
                    hashCode = hashCode * 59 + this.Indsoggrit.GetHashCode();
                if (this.Indweb != null)
                    hashCode = hashCode * 59 + this.Indweb.GetHashCode();
                if (this.Lastchange != null)
                    hashCode = hashCode * 59 + this.Lastchange.GetHashCode();
                if (this.Nome != null)
                    hashCode = hashCode * 59 + this.Nome.GetHashCode();
                if (this.PartitaIVA != null)
                    hashCode = hashCode * 59 + this.PartitaIVA.GetHashCode();
                if (this.Partiva != null)
                    hashCode = hashCode * 59 + this.Partiva.GetHashCode();
                if (this.PartivaEst != null)
                    hashCode = hashCode * 59 + this.PartivaEst.GetHashCode();
                if (this.Prov != null)
                    hashCode = hashCode * 59 + this.Prov.GetHashCode();
                if (this.Provcor != null)
                    hashCode = hashCode * 59 + this.Provcor.GetHashCode();
                if (this.Provfisc != null)
                    hashCode = hashCode * 59 + this.Provfisc.GetHashCode();
                if (this.Provnascita != null)
                    hashCode = hashCode * 59 + this.Provnascita.GetHashCode();
                if (this.RagSoAnag != null)
                    hashCode = hashCode * 59 + this.RagSoAnag.GetHashCode();
                if (this.Ragsoanagex != null)
                    hashCode = hashCode * 59 + this.Ragsoanagex.GetHashCode();
                if (this.Ragsocor != null)
                    hashCode = hashCode * 59 + this.Ragsocor.GetHashCode();
                if (this.Ragsocorex != null)
                    hashCode = hashCode * 59 + this.Ragsocorex.GetHashCode();
                if (this.Ragsofisc != null)
                    hashCode = hashCode * 59 + this.Ragsofisc.GetHashCode();
                if (this.Ragsofiscex != null)
                    hashCode = hashCode * 59 + this.Ragsofiscex.GetHashCode();
                if (this.RapazestCg16 != null)
                    hashCode = hashCode * 59 + this.RapazestCg16.GetHashCode();
                if (this.Sesso != null)
                    hashCode = hashCode * 59 + this.Sesso.GetHashCode();
                if (this.Statofed != null)
                    hashCode = hashCode * 59 + this.Statofed.GetHashCode();
                if (this.Statofedfisc != null)
                    hashCode = hashCode * 59 + this.Statofedfisc.GetHashCode();
                if (this.StatofiscCg07 != null)
                    hashCode = hashCode * 59 + this.StatofiscCg07.GetHashCode();
                if (this.StatonascitaCg07 != null)
                    hashCode = hashCode * 59 + this.StatonascitaCg07.GetHashCode();
                if (this.Tel1num != null)
                    hashCode = hashCode * 59 + this.Tel1num.GetHashCode();
                if (this.Tel2num != null)
                    hashCode = hashCode * 59 + this.Tel2num.GetHashCode();
                if (this.IdExtendedAttributeEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeEntity.GetHashCode();
                if (this.IdExtendedAttributeSubEntity != null)
                    hashCode = hashCode * 59 + this.IdExtendedAttributeSubEntity.GetHashCode();
                if (this.Addresses != null)
                    hashCode = hashCode * 59 + this.Addresses.GetHashCode();
                if (this.FiscalRepresentative != null)
                    hashCode = hashCode * 59 + this.FiscalRepresentative.GetHashCode();
                if (this.IntragroupStructureCO != null)
                    hashCode = hashCode * 59 + this.IntragroupStructureCO.GetHashCode();
                if (this.NationCOBirth != null)
                    hashCode = hashCode * 59 + this.NationCOBirth.GetHashCode();
                if (this.SubstitutiveMasterdata != null)
                    hashCode = hashCode * 59 + this.SubstitutiveMasterdata.GetHashCode();
                if (this.WtCodeCO != null)
                    hashCode = hashCode * 59 + this.WtCodeCO.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
