'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CompanyBankCODTO
 **/
exports.apiV1EnvironmentCOCompanyBankCOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "ggvalmavincpos" : 2.8841621266687802,
  "spinccambfil" : 6.073898085781152,
  "spcommordpfil" : 5.507386964179881,
  "codSia" : "codSia",
  "bancaCg12" : 6.027456183070403,
  "spritrid" : 9.897492629215506,
  "codiceCg07" : 9.301444243932576,
  "flgRidsdd" : 9.369310271410669,
  "spincribaalt" : 6.623518433804886,
  "flgCessioni" : 1.2315135367772556,
  "spritmavincas" : 5.299143560275359,
  "spcommbonalt" : 9.702963800023566,
  "flgRibatratac" : 5.025004791520295,
  "bicbanca" : "bicbanca",
  "nationCO" : {
    "codSian" : 9.702963800023566,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 5.507386964179881,
    "codice" : 0.8774076871421566,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "descr" : "descr",
    "flgIban" : 0,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 4.86315908102884,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "ggvalscfattfil" : 7.143538047012306,
  "id" : 6,
  "idbancaestera" : "idbancaestera",
  "cabbonifCg13" : 1.4658129805029452,
  "spincridalt" : 8.863729185622827,
  "spincmavincpos" : 1.7325933120207193,
  "cabridCg13" : 7.061401241503109,
  "dittaCg18" : 2.027123023002322,
  "idsuccursale" : 4.652396432933246,
  "spinctrafil" : 3.502657762086401,
  "scfindbasecalc" : 7.260521264802104,
  "indPresriba" : 3.2588565619047607,
  "codAzienda" : "codAzienda",
  "bbaneffpresef" : "bbaneffpresef",
  "flgRibatratte" : 9.965781217890562,
  "indPresrid" : 4.078845849666752,
  "spincridfil" : 9.254183946267839,
  "scfperctasso" : 0.8774076871421566,
  "ibaneffpresef" : "ibaneffpresef",
  "ggvalridfil" : 3.353193347011243,
  "ggvalcambfil" : 3.5571952270680973,
  "flgRibacamb" : 7.457744773683766,
  "ggvalribaalt" : 6.878052220127876,
  "idcontratto" : "idcontratto",
  "ggvalmavincfil" : 1.284659006116532,
  "bbananticipi" : "bbananticipi",
  "indTipolib" : 0.2025324113236393,
  "spcommordpalt" : 7.933506881737151,
  "scfvsdocrif" : "scfvsdocrif",
  "spritmavsbf" : 8.37823741034869,
  "progR" : 4.678947989005849,
  "sprittratte" : 7.835035282970782,
  "flgCambiali" : 7.386281948385884,
  "bankCO" : {
    "descrizione" : "descrizione",
    "codBicswift" : "codBicswift",
    "codiceBanca" : 1.4658129805029452,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "flgRiba" : 6.84685269835264,
  "spincesitopag" : 3.901545264248647,
  "cabmavCg13" : 5.637376656633329,
  "flgMav" : 1.0246457001441578,
  "sppresdistinta" : 9.183123594773994,
  "cceffpresef" : "cceffpresef",
  "scfnsdocrif" : "scfnsdocrif",
  "spincmavincfil" : 2.9409642974827896,
  "ggvaltratfil" : 7.058770351582356,
  "bbanordpbonif" : "bbanordpbonif",
  "ccconto" : "ccconto",
  "ibanordpbonif" : "ibanordpbonif",
  "daprogressmav" : 3.616076749251911,
  "flgRibacess" : 1.1730742509559433,
  "ibananticipi" : "ibananticipi",
  "impfido" : 7.740351818741173,
  "flgTratte" : 9.018348186070783,
  "spritcamb" : 8.761432466225475,
  "spritmavsbfcl" : 7.606863723092579,
  "spritridcl" : 5.877124706116695,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "ccordpbonif" : "ccordpbonif",
  "spinccorfil" : 4.459605034958679,
  "ccanticipi" : "ccanticipi",
  "flgScfatt" : 8.762042012749001,
  "locbancaestera" : "locbancaestera",
  "ultprogressmav" : 2.380090174313445,
  "spincribafil" : 4.573936264232251,
  "creditidentifier" : "creditidentifier",
  "descr" : "descr",
  "spcommbonfil" : 0.5199002018724985,
  "indTipopres" : 6.628464275087742,
  "indCheckpivacf" : 3,
  "ggvalribafil" : 5.944895607614016,
  "ggvalmavincalt" : 6.965117697638846,
  "spritribacl" : 3.111202833403195,
  "spincmavsbf" : 8.28965939814297,
  "rowversion" : "",
  "flgAutattribnrmav" : 4,
  "flgRibaricba" : 4.965218492984954,
  "spritcambcl" : 0.4182561061793122,
  "spritmavincascl" : 5.312489704336296,
  "idmediaCg99" : 0.10263654006109402,
  "ggvalmavsbf" : 6.778324963048013,
  "indCompind" : 3,
  "bbanconto" : "bbanconto",
  "sprittrattecl" : 0.4768402382624515,
  "prefissoattribmav" : 1.041444916118296,
  "aprogressmav" : 0.8008281904610115,
  "codRappopor" : "codRappopor",
  "spincmavincalt" : 0.43431398824148815,
  "spinctraalt" : 1.8268702177058116,
  "ggvaltratalt" : 0.8851374739011653,
  "impcastel" : 8.969578798196912,
  "spritriba" : 3.7814124730767915,
  "scfpercpres" : 9.132027271330688,
  "spinccambalt" : 4.86315908102884,
  "codicecuc" : "codicecuc",
  "ibanconto" : "ibanconto",
  "indContpmtinf" : 7,
  "tipobanca" : 3.1497903714250555,
  "indPresmav" : 5.533258397034986,
  "ggvalridalt" : 6.704019297950036,
  "cabcontoCg13" : 5.962133916683182,
  "ggvalcambalt" : 6.438423552598547,
  "maxgginsoluti" : 4.258773108174356,
  "flgRidsddraggr" : 6,
  "ggvalscfattalt" : 3.0937452626664474,
  "flgPref" : 1.4894159098541704,
  "cabribaCg13" : 2.3021358869347655,
  "spinccoralt" : 8.251625748923757
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CompanyBankCODTO
 **/
exports.apiV1EnvironmentCOCompanyBankCOIdGET = function(id,environment,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "ggvalmavincpos" : 2.8841621266687802,
  "spinccambfil" : 6.073898085781152,
  "spcommordpfil" : 5.507386964179881,
  "codSia" : "codSia",
  "bancaCg12" : 6.027456183070403,
  "spritrid" : 9.897492629215506,
  "codiceCg07" : 9.301444243932576,
  "flgRidsdd" : 9.369310271410669,
  "spincribaalt" : 6.623518433804886,
  "flgCessioni" : 1.2315135367772556,
  "spritmavincas" : 5.299143560275359,
  "spcommbonalt" : 9.702963800023566,
  "flgRibatratac" : 5.025004791520295,
  "bicbanca" : "bicbanca",
  "nationCO" : {
    "codSian" : 9.702963800023566,
    "crtpiva" : "crtpiva",
    "leniban" : 6,
    "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
    "desiso3166" : "desiso3166",
    "idmediaCg99" : 5.507386964179881,
    "codice" : 0.8774076871421566,
    "numiso3166" : "numiso3166",
    "codiceCg08" : "codiceCg08",
    "currencyCO" : {
      "sigla" : "sigla",
      "dataattuem" : "2000-01-23T04:56:07.000+00:00",
      "numdec" : 8.28965939814297,
      "exchangeRateCO" : [ {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      }, {
        "cambio" : 8.863729185622827,
        "anno" : 4.573936264232251,
        "idmediaCg99" : 1.8268702177058116,
        "codiceCg08" : "codiceCg08",
        "indCertoincerto" : 3,
        "codicerifCg08" : "codicerifCg08",
        "giorno" : 9.254183946267839,
        "mese" : 9.183123594773994,
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "adegcambio" : 6.623518433804886,
        "rowversion" : ""
      } ],
      "idmediaCg99" : 3.901545264248647,
      "codice" : "codice",
      "indCertoincerto" : 0,
      "cambiofisso" : 8.251625748923757,
      "descr" : "descr",
      "flgValuem" : 4.459605034958679,
      "indValuem" : 1.7325933120207193,
      "indSepmigl" : 2.9409642974827896,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "descr" : "descr",
    "flgIban" : 0,
    "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
    "codIso" : "codIso",
    "a3iso3166" : "a3iso3166",
    "indTipostato" : 4.86315908102884,
    "a2iso3166" : "a2iso3166",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "datacee" : "2000-01-23T04:56:07.000+00:00",
    "flgSepa" : 7
  },
  "ggvalscfattfil" : 7.143538047012306,
  "id" : 6,
  "idbancaestera" : "idbancaestera",
  "cabbonifCg13" : 1.4658129805029452,
  "spincridalt" : 8.863729185622827,
  "spincmavincpos" : 1.7325933120207193,
  "cabridCg13" : 7.061401241503109,
  "dittaCg18" : 2.027123023002322,
  "idsuccursale" : 4.652396432933246,
  "spinctrafil" : 3.502657762086401,
  "scfindbasecalc" : 7.260521264802104,
  "indPresriba" : 3.2588565619047607,
  "codAzienda" : "codAzienda",
  "bbaneffpresef" : "bbaneffpresef",
  "flgRibatratte" : 9.965781217890562,
  "indPresrid" : 4.078845849666752,
  "spincridfil" : 9.254183946267839,
  "scfperctasso" : 0.8774076871421566,
  "ibaneffpresef" : "ibaneffpresef",
  "ggvalridfil" : 3.353193347011243,
  "ggvalcambfil" : 3.5571952270680973,
  "flgRibacamb" : 7.457744773683766,
  "ggvalribaalt" : 6.878052220127876,
  "idcontratto" : "idcontratto",
  "ggvalmavincfil" : 1.284659006116532,
  "bbananticipi" : "bbananticipi",
  "indTipolib" : 0.2025324113236393,
  "spcommordpalt" : 7.933506881737151,
  "scfvsdocrif" : "scfvsdocrif",
  "spritmavsbf" : 8.37823741034869,
  "progR" : 4.678947989005849,
  "sprittratte" : 7.835035282970782,
  "flgCambiali" : 7.386281948385884,
  "bankCO" : {
    "descrizione" : "descrizione",
    "codBicswift" : "codBicswift",
    "codiceBanca" : 1.4658129805029452,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "flgRiba" : 6.84685269835264,
  "spincesitopag" : 3.901545264248647,
  "cabmavCg13" : 5.637376656633329,
  "flgMav" : 1.0246457001441578,
  "sppresdistinta" : 9.183123594773994,
  "cceffpresef" : "cceffpresef",
  "scfnsdocrif" : "scfnsdocrif",
  "spincmavincfil" : 2.9409642974827896,
  "ggvaltratfil" : 7.058770351582356,
  "bbanordpbonif" : "bbanordpbonif",
  "ccconto" : "ccconto",
  "ibanordpbonif" : "ibanordpbonif",
  "daprogressmav" : 3.616076749251911,
  "flgRibacess" : 1.1730742509559433,
  "ibananticipi" : "ibananticipi",
  "impfido" : 7.740351818741173,
  "flgTratte" : 9.018348186070783,
  "spritcamb" : 8.761432466225475,
  "spritmavsbfcl" : 7.606863723092579,
  "spritridcl" : 5.877124706116695,
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "ccordpbonif" : "ccordpbonif",
  "spinccorfil" : 4.459605034958679,
  "ccanticipi" : "ccanticipi",
  "flgScfatt" : 8.762042012749001,
  "locbancaestera" : "locbancaestera",
  "ultprogressmav" : 2.380090174313445,
  "spincribafil" : 4.573936264232251,
  "creditidentifier" : "creditidentifier",
  "descr" : "descr",
  "spcommbonfil" : 0.5199002018724985,
  "indTipopres" : 6.628464275087742,
  "indCheckpivacf" : 3,
  "ggvalribafil" : 5.944895607614016,
  "ggvalmavincalt" : 6.965117697638846,
  "spritribacl" : 3.111202833403195,
  "spincmavsbf" : 8.28965939814297,
  "rowversion" : "",
  "flgAutattribnrmav" : 4,
  "flgRibaricba" : 4.965218492984954,
  "spritcambcl" : 0.4182561061793122,
  "spritmavincascl" : 5.312489704336296,
  "idmediaCg99" : 0.10263654006109402,
  "ggvalmavsbf" : 6.778324963048013,
  "indCompind" : 3,
  "bbanconto" : "bbanconto",
  "sprittrattecl" : 0.4768402382624515,
  "prefissoattribmav" : 1.041444916118296,
  "aprogressmav" : 0.8008281904610115,
  "codRappopor" : "codRappopor",
  "spincmavincalt" : 0.43431398824148815,
  "spinctraalt" : 1.8268702177058116,
  "ggvaltratalt" : 0.8851374739011653,
  "impcastel" : 8.969578798196912,
  "spritriba" : 3.7814124730767915,
  "scfpercpres" : 9.132027271330688,
  "spinccambalt" : 4.86315908102884,
  "codicecuc" : "codicecuc",
  "ibanconto" : "ibanconto",
  "indContpmtinf" : 7,
  "tipobanca" : 3.1497903714250555,
  "indPresmav" : 5.533258397034986,
  "ggvalridalt" : 6.704019297950036,
  "cabcontoCg13" : 5.962133916683182,
  "ggvalcambalt" : 6.438423552598547,
  "maxgginsoluti" : 4.258773108174356,
  "flgRidsddraggr" : 6,
  "ggvalscfattalt" : 3.0937452626664474,
  "flgPref" : 1.4894159098541704,
  "cabribaCg13" : 2.3021358869347655,
  "spinccoralt" : 8.251625748923757
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CompanyBankCODTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOCompanyBankCOValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOCompanyBankCOValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

