'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns OfficePACODTO
 **/
exports.apiV1EnvironmentCOOfficePACOGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "indTypeb2b" : 7,
  "tipocfCg44" : 7.135782839148426,
  "codDestin" : "codDestin",
  "codice" : "codice",
  "codiceCg16" : 7,
  "nome" : "nome",
  "idprovincia" : 2,
  "cap" : "cap",
  "comune" : "comune",
  "idregione" : 1,
  "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "flgPreferenziale" : 1
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Delete
 * Deleting object of type 
 *
 * id String 
 * environment String 
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * codiceCg16 String CodiceCg16 Mandatory to execute current action
 * codDestin String CodDestin Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOOfficePACOIdDELETE = function(id,environment,tipocfCg44,codiceCg16,codDestin,authorizationScope,force,ignoreCompanyPolicyFilter,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * codiceCg16 String CodiceCg16 Mandatory to execute current action
 * codDestin String CodDestin Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns OfficePACODTO
 **/
exports.apiV1EnvironmentCOOfficePACOIdGET = function(id,environment,tipocfCg44,codiceCg16,codDestin,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "indTypeb2b" : 7,
  "tipocfCg44" : 7.135782839148426,
  "codDestin" : "codDestin",
  "codice" : "codice",
  "codiceCg16" : 7,
  "nome" : "nome",
  "idprovincia" : 2,
  "cap" : "cap",
  "comune" : "comune",
  "idregione" : 1,
  "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "flgPreferenziale" : 1
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Update partial
 * Patching an object of type
 *
 * body  Object of type to patch
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * codiceCg16 String CodiceCg16 Mandatory to execute current action
 * codDestin String CodDestin Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOOfficePACOIdPATCH = function(body,ignoreCompanyPolicyFilter,force,_op,tipocfCg44,codiceCg16,codDestin,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Update
 * Updating an object of type
 *
 * body OfficePACODTO Object of type to update
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * codiceCg16 String CodiceCg16 Mandatory to execute current action
 * codDestin String CodDestin Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * id String 
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns OfficePACODTO
 **/
exports.apiV1EnvironmentCOOfficePACOIdPUT = function(body,force,ignoreCompanyPolicyFilter,_op,tipocfCg44,codiceCg16,codDestin,company,user,id,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "indTypeb2b" : 7,
  "tipocfCg44" : 7.135782839148426,
  "codDestin" : "codDestin",
  "codice" : "codice",
  "codiceCg16" : 7,
  "nome" : "nome",
  "idprovincia" : 2,
  "cap" : "cap",
  "comune" : "comune",
  "idregione" : 1,
  "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "flgPreferenziale" : 1
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Create
 * Creating new object of type
 *
 * body OfficePACODTO Object of type to create
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * _op String Set 'reload', if you want the DTO updated in the response request (optional)
 * force String The warning/s code to bypass (separated by ‘,’) during the execution (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns OfficePACODTO
 **/
exports.apiV1EnvironmentCOOfficePACOPOST = function(body,ignoreCompanyPolicyFilter,_op,force,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "indIrizzo" : "indIrizzo",
  "indTypeb2b" : 7,
  "tipocfCg44" : 7.135782839148426,
  "codDestin" : "codDestin",
  "codice" : "codice",
  "codiceCg16" : 7,
  "nome" : "nome",
  "idprovincia" : 2,
  "cap" : "cap",
  "comune" : "comune",
  "idregione" : 1,
  "lastupdateB2b" : "2000-01-23T04:56:07.000+00:00",
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "flgPreferenziale" : 1
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body OfficePACODTO Object of type to validate
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * codiceCg16 String CodiceCg16 Mandatory to execute current action
 * codDestin String CodDestin Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentCOOfficePACOValidatePOST = function(body,tipocfCg44,codiceCg16,codDestin,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * tipocfCg44 String TipocfCg44 Mandatory to execute current action
 * codiceCg16 String CodiceCg16 Mandatory to execute current action
 * codDestin String CodDestin Mandatory to execute current action
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentCOOfficePACOValidatePropertiesPOST = function(body,tipocfCg44,codiceCg16,codDestin,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

