/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// DocumentoPortfolioEvadInMGDTO
    /// </summary>
    [DataContract]
        public partial class DocumentoPortfolioEvadInMGDTO :  IEquatable<DocumentoPortfolioEvadInMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DocumentoPortfolioEvadInMGDTO" /> class.
        /// </summary>
        /// <param name="guidSession">Processing Unique Guid Session.</param>
        /// <param name="limiteEvadibilita">Evadability Limit (Filter Criteria) (required).</param>
        /// <param name="tipoEvadibilita">Evadibility type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - All Items&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - For specific item&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - All Documents&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="codArt">ItemWH (Only for Evadibility type &#x3D; 1).</param>
        /// <param name="variante">ItemWH (Only for Evadibility type &#x3D; 1 And CodArt setted).</param>
        /// <param name="isAsyncMode">Elaboration Mode (Sync/Async) (required).</param>
        /// <param name="minExpire">Minute Expire Guid Rows (required).</param>
        public DocumentoPortfolioEvadInMGDTO(string guidSession = default(string), int? limiteEvadibilita = default(int?), int? tipoEvadibilita = default(int?), string codArt = default(string), string variante = default(string), bool? isAsyncMode = default(bool?), int? minExpire = default(int?))
        {
            // to ensure "limiteEvadibilita" is required (not null)
            if (limiteEvadibilita == null)
            {
                throw new InvalidDataException("limiteEvadibilita is a required property for DocumentoPortfolioEvadInMGDTO and cannot be null");
            }
            else
            {
                this.LimiteEvadibilita = limiteEvadibilita;
            }
            // to ensure "isAsyncMode" is required (not null)
            if (isAsyncMode == null)
            {
                throw new InvalidDataException("isAsyncMode is a required property for DocumentoPortfolioEvadInMGDTO and cannot be null");
            }
            else
            {
                this.IsAsyncMode = isAsyncMode;
            }
            // to ensure "minExpire" is required (not null)
            if (minExpire == null)
            {
                throw new InvalidDataException("minExpire is a required property for DocumentoPortfolioEvadInMGDTO and cannot be null");
            }
            else
            {
                this.MinExpire = minExpire;
            }
            this.GuidSession = guidSession;
            this.TipoEvadibilita = tipoEvadibilita;
            this.CodArt = codArt;
            this.Variante = variante;
        }
        
        /// <summary>
        /// Processing Unique Guid Session
        /// </summary>
        /// <value>Processing Unique Guid Session</value>
        [DataMember(Name="guidSession", EmitDefaultValue=false)]
        public string GuidSession { get; set; }

        /// <summary>
        /// Evadability Limit (Filter Criteria)
        /// </summary>
        /// <value>Evadability Limit (Filter Criteria)</value>
        [DataMember(Name="limiteEvadibilita", EmitDefaultValue=false)]
        public int? LimiteEvadibilita { get; set; }

        /// <summary>
        /// Evadibility type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - All Items&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - For specific item&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - All Documents&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>Evadibility type&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - All Items&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - For specific item&lt;/li&gt;&lt;li&gt;&lt;i&gt;2&lt;/i&gt; - All Documents&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="tipoEvadibilita", EmitDefaultValue=false)]
        public int? TipoEvadibilita { get; set; }

        /// <summary>
        /// ItemWH (Only for Evadibility type &#x3D; 1)
        /// </summary>
        /// <value>ItemWH (Only for Evadibility type &#x3D; 1)</value>
        [DataMember(Name="codArt", EmitDefaultValue=false)]
        public string CodArt { get; set; }

        /// <summary>
        /// ItemWH (Only for Evadibility type &#x3D; 1 And CodArt setted)
        /// </summary>
        /// <value>ItemWH (Only for Evadibility type &#x3D; 1 And CodArt setted)</value>
        [DataMember(Name="variante", EmitDefaultValue=false)]
        public string Variante { get; set; }

        /// <summary>
        /// Elaboration Mode (Sync/Async)
        /// </summary>
        /// <value>Elaboration Mode (Sync/Async)</value>
        [DataMember(Name="isAsyncMode", EmitDefaultValue=false)]
        public bool? IsAsyncMode { get; set; }

        /// <summary>
        /// Minute Expire Guid Rows
        /// </summary>
        /// <value>Minute Expire Guid Rows</value>
        [DataMember(Name="minExpire", EmitDefaultValue=false)]
        public int? MinExpire { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class DocumentoPortfolioEvadInMGDTO {\n");
            sb.Append("  GuidSession: ").Append(GuidSession).Append("\n");
            sb.Append("  LimiteEvadibilita: ").Append(LimiteEvadibilita).Append("\n");
            sb.Append("  TipoEvadibilita: ").Append(TipoEvadibilita).Append("\n");
            sb.Append("  CodArt: ").Append(CodArt).Append("\n");
            sb.Append("  Variante: ").Append(Variante).Append("\n");
            sb.Append("  IsAsyncMode: ").Append(IsAsyncMode).Append("\n");
            sb.Append("  MinExpire: ").Append(MinExpire).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as DocumentoPortfolioEvadInMGDTO);
        }

        /// <summary>
        /// Returns true if DocumentoPortfolioEvadInMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of DocumentoPortfolioEvadInMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(DocumentoPortfolioEvadInMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.GuidSession == input.GuidSession ||
                    (this.GuidSession != null &&
                    this.GuidSession.Equals(input.GuidSession))
                ) && 
                (
                    this.LimiteEvadibilita == input.LimiteEvadibilita ||
                    (this.LimiteEvadibilita != null &&
                    this.LimiteEvadibilita.Equals(input.LimiteEvadibilita))
                ) && 
                (
                    this.TipoEvadibilita == input.TipoEvadibilita ||
                    (this.TipoEvadibilita != null &&
                    this.TipoEvadibilita.Equals(input.TipoEvadibilita))
                ) && 
                (
                    this.CodArt == input.CodArt ||
                    (this.CodArt != null &&
                    this.CodArt.Equals(input.CodArt))
                ) && 
                (
                    this.Variante == input.Variante ||
                    (this.Variante != null &&
                    this.Variante.Equals(input.Variante))
                ) && 
                (
                    this.IsAsyncMode == input.IsAsyncMode ||
                    (this.IsAsyncMode != null &&
                    this.IsAsyncMode.Equals(input.IsAsyncMode))
                ) && 
                (
                    this.MinExpire == input.MinExpire ||
                    (this.MinExpire != null &&
                    this.MinExpire.Equals(input.MinExpire))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.GuidSession != null)
                    hashCode = hashCode * 59 + this.GuidSession.GetHashCode();
                if (this.LimiteEvadibilita != null)
                    hashCode = hashCode * 59 + this.LimiteEvadibilita.GetHashCode();
                if (this.TipoEvadibilita != null)
                    hashCode = hashCode * 59 + this.TipoEvadibilita.GetHashCode();
                if (this.CodArt != null)
                    hashCode = hashCode * 59 + this.CodArt.GetHashCode();
                if (this.Variante != null)
                    hashCode = hashCode * 59 + this.Variante.GetHashCode();
                if (this.IsAsyncMode != null)
                    hashCode = hashCode * 59 + this.IsAsyncMode.GetHashCode();
                if (this.MinExpire != null)
                    hashCode = hashCode * 59 + this.MinExpire.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
