/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.3000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// LoadProductKitParameterDTO
    /// </summary>
    [DataContract]
        public partial class LoadProductKitParameterDTO :  IEquatable<LoadProductKitParameterDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LoadProductKitParameterDTO" /> class.
        /// </summary>
        /// <param name="documentCode">Document code for loading kit products (required).</param>
        /// <param name="postingDate">Document posting date.</param>
        /// <param name="documentDate">Document date.</param>
        /// <param name="documentSectional">Document sectional.</param>
        /// <param name="documentNumber">Document number.</param>
        public LoadProductKitParameterDTO(string documentCode = default(string), DateTime? postingDate = default(DateTime?), DateTime? documentDate = default(DateTime?), string documentSectional = default(string), double? documentNumber = default(double?))
        {
            // to ensure "documentCode" is required (not null)
            if (documentCode == null)
            {
                throw new InvalidDataException("documentCode is a required property for LoadProductKitParameterDTO and cannot be null");
            }
            else
            {
                this.DocumentCode = documentCode;
            }
            this.PostingDate = postingDate;
            this.DocumentDate = documentDate;
            this.DocumentSectional = documentSectional;
            this.DocumentNumber = documentNumber;
        }
        
        /// <summary>
        /// Document code for loading kit products
        /// </summary>
        /// <value>Document code for loading kit products</value>
        [DataMember(Name="documentCode", EmitDefaultValue=false)]
        public string DocumentCode { get; set; }

        /// <summary>
        /// Document posting date
        /// </summary>
        /// <value>Document posting date</value>
        [DataMember(Name="postingDate", EmitDefaultValue=false)]
        public DateTime? PostingDate { get; set; }

        /// <summary>
        /// Document date
        /// </summary>
        /// <value>Document date</value>
        [DataMember(Name="documentDate", EmitDefaultValue=false)]
        public DateTime? DocumentDate { get; set; }

        /// <summary>
        /// Document sectional
        /// </summary>
        /// <value>Document sectional</value>
        [DataMember(Name="documentSectional", EmitDefaultValue=false)]
        public string DocumentSectional { get; set; }

        /// <summary>
        /// Document number
        /// </summary>
        /// <value>Document number</value>
        [DataMember(Name="documentNumber", EmitDefaultValue=false)]
        public double? DocumentNumber { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class LoadProductKitParameterDTO {\n");
            sb.Append("  DocumentCode: ").Append(DocumentCode).Append("\n");
            sb.Append("  PostingDate: ").Append(PostingDate).Append("\n");
            sb.Append("  DocumentDate: ").Append(DocumentDate).Append("\n");
            sb.Append("  DocumentSectional: ").Append(DocumentSectional).Append("\n");
            sb.Append("  DocumentNumber: ").Append(DocumentNumber).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as LoadProductKitParameterDTO);
        }

        /// <summary>
        /// Returns true if LoadProductKitParameterDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of LoadProductKitParameterDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(LoadProductKitParameterDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.DocumentCode == input.DocumentCode ||
                    (this.DocumentCode != null &&
                    this.DocumentCode.Equals(input.DocumentCode))
                ) && 
                (
                    this.PostingDate == input.PostingDate ||
                    (this.PostingDate != null &&
                    this.PostingDate.Equals(input.PostingDate))
                ) && 
                (
                    this.DocumentDate == input.DocumentDate ||
                    (this.DocumentDate != null &&
                    this.DocumentDate.Equals(input.DocumentDate))
                ) && 
                (
                    this.DocumentSectional == input.DocumentSectional ||
                    (this.DocumentSectional != null &&
                    this.DocumentSectional.Equals(input.DocumentSectional))
                ) && 
                (
                    this.DocumentNumber == input.DocumentNumber ||
                    (this.DocumentNumber != null &&
                    this.DocumentNumber.Equals(input.DocumentNumber))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.DocumentCode != null)
                    hashCode = hashCode * 59 + this.DocumentCode.GetHashCode();
                if (this.PostingDate != null)
                    hashCode = hashCode * 59 + this.PostingDate.GetHashCode();
                if (this.DocumentDate != null)
                    hashCode = hashCode * 59 + this.DocumentDate.GetHashCode();
                if (this.DocumentSectional != null)
                    hashCode = hashCode * 59 + this.DocumentSectional.GetHashCode();
                if (this.DocumentNumber != null)
                    hashCode = hashCode * 59 + this.DocumentNumber.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
