# IO.Swagger.Api.CustomerSupplierExtensionMGApi

All URIs are relative to *https://apicsdemo.teamsystem.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet**](CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgidget) | **GET** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id} | Get by ID
[**ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch**](CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgidpatch) | **PATCH** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id} | Update partial
[**ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut**](CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgidput) | **PUT** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/{id} | Update
[**ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost**](CustomerSupplierExtensionMGApi.md#apiv1environmentmgcustomersupplierextensionmgvalidatepost) | **POST** /api/v1/{environment}/MG/CustomerSupplierExtensionMG/validate | Validate

<a name="apiv1environmentmgcustomersupplierextensionmgidget"></a>
# **ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet**
> CustomerSupplierExtensionMGDTO ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet (string id, string environment, string tipocfCg44, string authorizationScope, string dlevel = null, string dlevelkey = null, string company = null, string user = null, string acceptLanguage = null)

Get by ID

Get an object of type corresponding the requested id

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGetExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierExtensionMGApi();
            var id = id_example;  // string | Id to get the object
            var environment = environment_example;  // string | 
            var tipocfCg44 = tipocfCg44_example;  // string | TipocfCg44 Mandatory to execute current action
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var dlevel = dlevel_example;  // string | Serialization level (optional) 
            var dlevelkey = dlevelkey_example;  // string | Serialization level key (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)

            try
            {
                // Get by ID
                CustomerSupplierExtensionMGDTO result = apiInstance.ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet(id, environment, tipocfCg44, authorizationScope, dlevel, dlevelkey, company, user, acceptLanguage);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierExtensionMGApi.ApiV1EnvironmentMGCustomerSupplierExtensionMGIdGet: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Id to get the object | 
 **environment** | **string**|  | 
 **tipocfCg44** | **string**| TipocfCg44 Mandatory to execute current action | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **dlevel** | **string**| Serialization level | [optional] 
 **dlevelkey** | **string**| Serialization level key | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]

### Return type

[**CustomerSupplierExtensionMGDTO**](CustomerSupplierExtensionMGDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgcustomersupplierextensionmgidpatch"></a>
# **ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch**
> void ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch (Object body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)

Update partial

Patching an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatchExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierExtensionMGApi();
            var body = new Object(); // Object | Object of type to patch
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var tipocfCg44 = tipocfCg44_example;  // string | TipocfCg44 Mandatory to execute current action
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update partial
                apiInstance.ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch(body, authorizationScope, tipocfCg44, id, environment, acceptLanguage, force, op, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierExtensionMGApi.ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPatch: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**Object**](Object.md)| Object of type to patch | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **tipocfCg44** | **string**| TipocfCg44 Mandatory to execute current action | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgcustomersupplierextensionmgidput"></a>
# **ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut**
> CustomerSupplierExtensionMGDTO ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut (CustomerSupplierExtensionMGDTO body, string authorizationScope, string tipocfCg44, string id, string environment, string acceptLanguage = null, string force = null, string op = null, string company = null, string user = null)

Update

Updating an object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPutExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierExtensionMGApi();
            var body = new CustomerSupplierExtensionMGDTO(); // CustomerSupplierExtensionMGDTO | Object of type to update
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var tipocfCg44 = tipocfCg44_example;  // string | TipocfCg44 Mandatory to execute current action
            var id = id_example;  // string | 
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var force = force_example;  // string | The warning/s code to bypass (separated by ‘,’) during the execution (optional) 
            var op = op_example;  // string | Set 'reload', if you want the DTO updated in the response request, otherwise will be returned null value (optional) 
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Update
                CustomerSupplierExtensionMGDTO result = apiInstance.ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut(body, authorizationScope, tipocfCg44, id, environment, acceptLanguage, force, op, company, user);
                Debug.WriteLine(result);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierExtensionMGApi.ApiV1EnvironmentMGCustomerSupplierExtensionMGIdPut: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CustomerSupplierExtensionMGDTO**](CustomerSupplierExtensionMGDTO.md)| Object of type to update | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **tipocfCg44** | **string**| TipocfCg44 Mandatory to execute current action | 
 **id** | **string**|  | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **force** | **string**| The warning/s code to bypass (separated by ‘,’) during the execution | [optional] 
 **op** | **string**| Set &#x27;reload&#x27;, if you want the DTO updated in the response request, otherwise will be returned null value | [optional] 
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

[**CustomerSupplierExtensionMGDTO**](CustomerSupplierExtensionMGDTO.md)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
<a name="apiv1environmentmgcustomersupplierextensionmgvalidatepost"></a>
# **ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost**
> void ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost (CustomerSupplierExtensionMGDTO body, string authorizationScope, string environment, string acceptLanguage = null, string company = null, string user = null)

Validate

Validation of object of type

### Example
```csharp
using System;
using System.Diagnostics;
using IO.Swagger.Api;
using IO.Swagger.Client;
using IO.Swagger.Model;

namespace Example
{
    public class ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePostExample
    {
        public void main()
        {
            // Configure HTTP basic authorization: Basic
            Configuration.Default.Username = "YOUR_USERNAME";
            Configuration.Default.Password = "YOUR_PASSWORD";

            var apiInstance = new CustomerSupplierExtensionMGApi();
            var body = new CustomerSupplierExtensionMGDTO(); // CustomerSupplierExtensionMGDTO | Object of type to validate
            var authorizationScope = authorizationScope_example;  // string | The environment where this operation will be executed. This must match with the environment in the url.
            var environment = environment_example;  // string | 
            var acceptLanguage = acceptLanguage_example;  // string | Example for multilanguage (optional)  (default to it-IT)
            var company = company_example;  // string | Company code (optional) 
            var user = user_example;  // string | Application user (mandatory if the WebApi user does not have any mapped application user) (optional) 

            try
            {
                // Validate
                apiInstance.ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost(body, authorizationScope, environment, acceptLanguage, company, user);
            }
            catch (Exception e)
            {
                Debug.Print("Exception when calling CustomerSupplierExtensionMGApi.ApiV1EnvironmentMGCustomerSupplierExtensionMGValidatePost: " + e.Message );
            }
        }
    }
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**CustomerSupplierExtensionMGDTO**](CustomerSupplierExtensionMGDTO.md)| Object of type to validate | 
 **authorizationScope** | **string**| The environment where this operation will be executed. This must match with the environment in the url. | 
 **environment** | **string**|  | 
 **acceptLanguage** | **string**| Example for multilanguage | [optional] [default to it-IT]
 **company** | **string**| Company code | [optional] 
 **user** | **string**| Application user (mandatory if the WebApi user does not have any mapped application user) | [optional] 

### Return type

void (empty response body)

### Authorization

[Basic](../README.md#Basic), [Bearer](../README.md#Bearer)

### HTTP request headers

 - **Content-Type**: application/json, application/xml
 - **Accept**: application/json, application/xml

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)
