/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// DO31_DOCCORPOORD - Corpo dati ordini&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;NumregCo99&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;ProgRiga&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class DocumentoRigaOrdineMGDTO :  IEquatable<DocumentoRigaOrdineMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="DocumentoRigaOrdineMGDTO" /> class.
        /// </summary>
        /// <param name="codPiano">DO31_CODPIANO - Codice piano.</param>
        /// <param name="codTraclegdb">DO31_CODTRACLEGDB - Codice tracciabilità legame distinta.</param>
        /// <param name="codTraclegwbs">DO31_CODTRACLEGWBS - Codice tracciabilità legame WBS.</param>
        /// <param name="collicons">DO31_COLLICONS - Colli consegnati (default to 0).</param>
        /// <param name="collitrasfddtcl">DO31_COLLITRASFDDTCL - Colli trasf. conto lavoro.</param>
        /// <param name="collitrasfp">DO31_COLLITRASFP - Colli trasf.p..</param>
        /// <param name="contpcarPd79">DO31_CONTPCAR_PD79 - Piano carico.</param>
        /// <param name="datacons">DO31_DATACONS - Data consegna.</param>
        /// <param name="dataconsint">DO31_DATACONSINT - Data consegna interna.</param>
        /// <param name="dataconsorig">DO31_DATACONSORIG - Data consegna origine corpo.</param>
        /// <param name="datafineoap">DO31_DATAFINEOAP - Data fine validità ordine aperto.</param>
        /// <param name="datainizlav">DO31_DATAINIZLAV - Data inizio lavorazione.</param>
        /// <param name="datainizoap">DO31_DATAINIZOAP - Data inizio validità ordine aperto.</param>
        /// <param name="datalancio">DO31_DATALANCIO - Data lancio.</param>
        /// <param name="datapianif">DO31_DATAPIANIF - Data pianificazione.</param>
        /// <param name="dittaCg18">DO31_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="flgConsconf">DO31_FLGCONSCONF - Flag consegna confermata&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgNoevasparz">DO31_FLGNOEVASPARZ - Flag no evasione parziale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgNonpiuev">DO31_FLGNONPIUEV - Riga non piu evadibile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgNosugg">DO31_FLGNOSUGG - Flag no suggerimento in MRP&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgRicpreev">DO31_FLGRICPREEV - Flag ricalcolo prezzi in evasione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="flgSospriga">DO31_FLGSOSPRIGA - Flag riga sospesa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="ggtollercons">DO31_GGTOLLERCONS - Giorni di tolleranza consegna.</param>
        /// <param name="indEvasdescsp">DO31_INDEVASDESCSP - Indicatore evasione descrizioni e spese (default to 0).</param>
        /// <param name="indStatocons">DO31_INDSTATOCONS - Indicatore stato consegnato (default to 0).</param>
        /// <param name="indStatodescsp">DO31_INDSTATODESCSP - Indicatore stato trasf. descrizioni e spese (default to 0).</param>
        /// <param name="numpiano">DO31_NUMPIANO - Numero piano.</param>
        /// <param name="numpropPd39">DO31_NUMPROP_PD39 - Numero proposta.</param>
        /// <param name="numregCo99">DO31_NUMREG_CO99 - Numero registrazione (required).</param>
        /// <param name="progRiga">DO31_PROGRIGA - Progressivo Riga (required).</param>
        /// <param name="progRigpiaPd80">DO31_PROGRIGPIA_PD80 - Progressivo riga piano consegna.</param>
        /// <param name="qta1cons">DO31_QTA1CONS - Quantità consegnata (default to 0).</param>
        /// <param name="qta1lanc">DO31_QTA1LANC - Quantità consegnata alla data lancio (default to 0).</param>
        /// <param name="qta1prel">DO31_QTA1PREL - Quantità 1 prelevata (default to 0).</param>
        /// <param name="qta1trasfddtcl">DO31_QTA1TRASFDDTCL - Quantità 1 trasf. conto lavoro.</param>
        /// <param name="qta1trasfp">DO31_QTA1TRASFP - Qta 1 trasf.p..</param>
        /// <param name="qta2cons">DO31_QTA2CONS - Quantità consegnata 2 (default to 0).</param>
        /// <param name="qta2lanc">DO31_QTA2LANC - Quantità consegnata alla data lancio (default to 0).</param>
        /// <param name="qta2prel">DO31_QTA2PREL - Quantità 2 prelevata (default to 0).</param>
        /// <param name="qta2trasfddtcl">DO31_QTA2TRASFDDTCL - Quantità 2 trasf. conto lavoro.</param>
        /// <param name="qta2trasfp">DO31_QTA2TRASFP - Qta 2 trasf.p..</param>
        /// <param name="valorecons">DO31_VALORECONS - Valore cons. (default to 0).</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public DocumentoRigaOrdineMGDTO(string codPiano = default(string), string codTraclegdb = default(string), string codTraclegwbs = default(string), double? collicons = 0, double? collitrasfddtcl = default(double?), double? collitrasfp = default(double?), double? contpcarPd79 = default(double?), DateTime? datacons = default(DateTime?), DateTime? dataconsint = default(DateTime?), DateTime? dataconsorig = default(DateTime?), DateTime? datafineoap = default(DateTime?), DateTime? datainizlav = default(DateTime?), DateTime? datainizoap = default(DateTime?), DateTime? datalancio = default(DateTime?), DateTime? datapianif = default(DateTime?), double? dittaCg18 = 0, int? flgConsconf = default(int?), int? flgNoevasparz = default(int?), int? flgNonpiuev = default(int?), int? flgNosugg = default(int?), int? flgRicpreev = default(int?), int? flgSospriga = default(int?), double? ggtollercons = default(double?), int? indEvasdescsp = 0, int? indStatocons = 0, int? indStatodescsp = 0, double? numpiano = default(double?), double? numpropPd39 = default(double?), string numregCo99 = default(string), double? progRiga = default(double?), double? progRigpiaPd80 = default(double?), double? qta1cons = 0, double? qta1lanc = 0, double? qta1prel = 0, double? qta1trasfddtcl = default(double?), double? qta1trasfp = default(double?), double? qta2cons = 0, double? qta2lanc = 0, double? qta2prel = 0, double? qta2trasfddtcl = default(double?), double? qta2trasfp = default(double?), double? valorecons = 0, List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "numregCo99" is required (not null)
            if (numregCo99 == null)
            {
                throw new InvalidDataException("numregCo99 is a required property for DocumentoRigaOrdineMGDTO and cannot be null");
            }
            else
            {
                this.NumregCo99 = numregCo99;
            }
            // to ensure "progRiga" is required (not null)
            if (progRiga == null)
            {
                throw new InvalidDataException("progRiga is a required property for DocumentoRigaOrdineMGDTO and cannot be null");
            }
            else
            {
                this.ProgRiga = progRiga;
            }
            this.CodPiano = codPiano;
            this.CodTraclegdb = codTraclegdb;
            this.CodTraclegwbs = codTraclegwbs;
            // use default value if no "collicons" provided
            if (collicons == null)
            {
                this.Collicons = 0;
            }
            else
            {
                this.Collicons = collicons;
            }
            this.Collitrasfddtcl = collitrasfddtcl;
            this.Collitrasfp = collitrasfp;
            this.ContpcarPd79 = contpcarPd79;
            this.Datacons = datacons;
            this.Dataconsint = dataconsint;
            this.Dataconsorig = dataconsorig;
            this.Datafineoap = datafineoap;
            this.Datainizlav = datainizlav;
            this.Datainizoap = datainizoap;
            this.Datalancio = datalancio;
            this.Datapianif = datapianif;
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.FlgConsconf = flgConsconf;
            this.FlgNoevasparz = flgNoevasparz;
            this.FlgNonpiuev = flgNonpiuev;
            this.FlgNosugg = flgNosugg;
            this.FlgRicpreev = flgRicpreev;
            this.FlgSospriga = flgSospriga;
            this.Ggtollercons = ggtollercons;
            // use default value if no "indEvasdescsp" provided
            if (indEvasdescsp == null)
            {
                this.IndEvasdescsp = 0;
            }
            else
            {
                this.IndEvasdescsp = indEvasdescsp;
            }
            // use default value if no "indStatocons" provided
            if (indStatocons == null)
            {
                this.IndStatocons = 0;
            }
            else
            {
                this.IndStatocons = indStatocons;
            }
            // use default value if no "indStatodescsp" provided
            if (indStatodescsp == null)
            {
                this.IndStatodescsp = 0;
            }
            else
            {
                this.IndStatodescsp = indStatodescsp;
            }
            this.Numpiano = numpiano;
            this.NumpropPd39 = numpropPd39;
            this.ProgRigpiaPd80 = progRigpiaPd80;
            // use default value if no "qta1cons" provided
            if (qta1cons == null)
            {
                this.Qta1cons = 0;
            }
            else
            {
                this.Qta1cons = qta1cons;
            }
            // use default value if no "qta1lanc" provided
            if (qta1lanc == null)
            {
                this.Qta1lanc = 0;
            }
            else
            {
                this.Qta1lanc = qta1lanc;
            }
            // use default value if no "qta1prel" provided
            if (qta1prel == null)
            {
                this.Qta1prel = 0;
            }
            else
            {
                this.Qta1prel = qta1prel;
            }
            this.Qta1trasfddtcl = qta1trasfddtcl;
            this.Qta1trasfp = qta1trasfp;
            // use default value if no "qta2cons" provided
            if (qta2cons == null)
            {
                this.Qta2cons = 0;
            }
            else
            {
                this.Qta2cons = qta2cons;
            }
            // use default value if no "qta2lanc" provided
            if (qta2lanc == null)
            {
                this.Qta2lanc = 0;
            }
            else
            {
                this.Qta2lanc = qta2lanc;
            }
            // use default value if no "qta2prel" provided
            if (qta2prel == null)
            {
                this.Qta2prel = 0;
            }
            else
            {
                this.Qta2prel = qta2prel;
            }
            this.Qta2trasfddtcl = qta2trasfddtcl;
            this.Qta2trasfp = qta2trasfp;
            // use default value if no "valorecons" provided
            if (valorecons == null)
            {
                this.Valorecons = 0;
            }
            else
            {
                this.Valorecons = valorecons;
            }
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// DO31_CODPIANO - Codice piano
        /// </summary>
        /// <value>DO31_CODPIANO - Codice piano</value>
        [DataMember(Name="codPiano", EmitDefaultValue=false)]
        public string CodPiano { get; set; }

        /// <summary>
        /// DO31_CODTRACLEGDB - Codice tracciabilità legame distinta
        /// </summary>
        /// <value>DO31_CODTRACLEGDB - Codice tracciabilità legame distinta</value>
        [DataMember(Name="codTraclegdb", EmitDefaultValue=false)]
        public string CodTraclegdb { get; set; }

        /// <summary>
        /// DO31_CODTRACLEGWBS - Codice tracciabilità legame WBS
        /// </summary>
        /// <value>DO31_CODTRACLEGWBS - Codice tracciabilità legame WBS</value>
        [DataMember(Name="codTraclegwbs", EmitDefaultValue=false)]
        public string CodTraclegwbs { get; set; }

        /// <summary>
        /// DO31_COLLICONS - Colli consegnati
        /// </summary>
        /// <value>DO31_COLLICONS - Colli consegnati</value>
        [DataMember(Name="collicons", EmitDefaultValue=false)]
        public double? Collicons { get; set; }

        /// <summary>
        /// DO31_COLLITRASFDDTCL - Colli trasf. conto lavoro
        /// </summary>
        /// <value>DO31_COLLITRASFDDTCL - Colli trasf. conto lavoro</value>
        [DataMember(Name="collitrasfddtcl", EmitDefaultValue=false)]
        public double? Collitrasfddtcl { get; set; }

        /// <summary>
        /// DO31_COLLITRASFP - Colli trasf.p.
        /// </summary>
        /// <value>DO31_COLLITRASFP - Colli trasf.p.</value>
        [DataMember(Name="collitrasfp", EmitDefaultValue=false)]
        public double? Collitrasfp { get; set; }

        /// <summary>
        /// DO31_CONTPCAR_PD79 - Piano carico
        /// </summary>
        /// <value>DO31_CONTPCAR_PD79 - Piano carico</value>
        [DataMember(Name="contpcarPd79", EmitDefaultValue=false)]
        public double? ContpcarPd79 { get; set; }

        /// <summary>
        /// DO31_DATACONS - Data consegna
        /// </summary>
        /// <value>DO31_DATACONS - Data consegna</value>
        [DataMember(Name="datacons", EmitDefaultValue=false)]
        public DateTime? Datacons { get; set; }

        /// <summary>
        /// DO31_DATACONSINT - Data consegna interna
        /// </summary>
        /// <value>DO31_DATACONSINT - Data consegna interna</value>
        [DataMember(Name="dataconsint", EmitDefaultValue=false)]
        public DateTime? Dataconsint { get; set; }

        /// <summary>
        /// DO31_DATACONSORIG - Data consegna origine corpo
        /// </summary>
        /// <value>DO31_DATACONSORIG - Data consegna origine corpo</value>
        [DataMember(Name="dataconsorig", EmitDefaultValue=false)]
        public DateTime? Dataconsorig { get; set; }

        /// <summary>
        /// DO31_DATAFINEOAP - Data fine validità ordine aperto
        /// </summary>
        /// <value>DO31_DATAFINEOAP - Data fine validità ordine aperto</value>
        [DataMember(Name="datafineoap", EmitDefaultValue=false)]
        public DateTime? Datafineoap { get; set; }

        /// <summary>
        /// DO31_DATAINIZLAV - Data inizio lavorazione
        /// </summary>
        /// <value>DO31_DATAINIZLAV - Data inizio lavorazione</value>
        [DataMember(Name="datainizlav", EmitDefaultValue=false)]
        public DateTime? Datainizlav { get; set; }

        /// <summary>
        /// DO31_DATAINIZOAP - Data inizio validità ordine aperto
        /// </summary>
        /// <value>DO31_DATAINIZOAP - Data inizio validità ordine aperto</value>
        [DataMember(Name="datainizoap", EmitDefaultValue=false)]
        public DateTime? Datainizoap { get; set; }

        /// <summary>
        /// DO31_DATALANCIO - Data lancio
        /// </summary>
        /// <value>DO31_DATALANCIO - Data lancio</value>
        [DataMember(Name="datalancio", EmitDefaultValue=false)]
        public DateTime? Datalancio { get; set; }

        /// <summary>
        /// DO31_DATAPIANIF - Data pianificazione
        /// </summary>
        /// <value>DO31_DATAPIANIF - Data pianificazione</value>
        [DataMember(Name="datapianif", EmitDefaultValue=false)]
        public DateTime? Datapianif { get; set; }

        /// <summary>
        /// DO31_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>DO31_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// DO31_FLGCONSCONF - Flag consegna confermata&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO31_FLGCONSCONF - Flag consegna confermata&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgConsconf", EmitDefaultValue=false)]
        public int? FlgConsconf { get; set; }

        /// <summary>
        /// DO31_FLGNOEVASPARZ - Flag no evasione parziale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO31_FLGNOEVASPARZ - Flag no evasione parziale&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgNoevasparz", EmitDefaultValue=false)]
        public int? FlgNoevasparz { get; set; }

        /// <summary>
        /// DO31_FLGNONPIUEV - Riga non piu evadibile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO31_FLGNONPIUEV - Riga non piu evadibile&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgNonpiuev", EmitDefaultValue=false)]
        public int? FlgNonpiuev { get; set; }

        /// <summary>
        /// DO31_FLGNOSUGG - Flag no suggerimento in MRP&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO31_FLGNOSUGG - Flag no suggerimento in MRP&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgNosugg", EmitDefaultValue=false)]
        public int? FlgNosugg { get; set; }

        /// <summary>
        /// DO31_FLGRICPREEV - Flag ricalcolo prezzi in evasione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO31_FLGRICPREEV - Flag ricalcolo prezzi in evasione&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgRicpreev", EmitDefaultValue=false)]
        public int? FlgRicpreev { get; set; }

        /// <summary>
        /// DO31_FLGSOSPRIGA - Flag riga sospesa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>DO31_FLGSOSPRIGA - Flag riga sospesa&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - No&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Si&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgSospriga", EmitDefaultValue=false)]
        public int? FlgSospriga { get; set; }

        /// <summary>
        /// DO31_GGTOLLERCONS - Giorni di tolleranza consegna
        /// </summary>
        /// <value>DO31_GGTOLLERCONS - Giorni di tolleranza consegna</value>
        [DataMember(Name="ggtollercons", EmitDefaultValue=false)]
        public double? Ggtollercons { get; set; }

        /// <summary>
        /// DO31_INDEVASDESCSP - Indicatore evasione descrizioni e spese
        /// </summary>
        /// <value>DO31_INDEVASDESCSP - Indicatore evasione descrizioni e spese</value>
        [DataMember(Name="indEvasdescsp", EmitDefaultValue=false)]
        public int? IndEvasdescsp { get; set; }

        /// <summary>
        /// DO31_INDSTATOCONS - Indicatore stato consegnato
        /// </summary>
        /// <value>DO31_INDSTATOCONS - Indicatore stato consegnato</value>
        [DataMember(Name="indStatocons", EmitDefaultValue=false)]
        public int? IndStatocons { get; set; }

        /// <summary>
        /// DO31_INDSTATODESCSP - Indicatore stato trasf. descrizioni e spese
        /// </summary>
        /// <value>DO31_INDSTATODESCSP - Indicatore stato trasf. descrizioni e spese</value>
        [DataMember(Name="indStatodescsp", EmitDefaultValue=false)]
        public int? IndStatodescsp { get; set; }

        /// <summary>
        /// DO31_NUMPIANO - Numero piano
        /// </summary>
        /// <value>DO31_NUMPIANO - Numero piano</value>
        [DataMember(Name="numpiano", EmitDefaultValue=false)]
        public double? Numpiano { get; set; }

        /// <summary>
        /// DO31_NUMPROP_PD39 - Numero proposta
        /// </summary>
        /// <value>DO31_NUMPROP_PD39 - Numero proposta</value>
        [DataMember(Name="numpropPd39", EmitDefaultValue=false)]
        public double? NumpropPd39 { get; set; }

        /// <summary>
        /// DO31_NUMREG_CO99 - Numero registrazione
        /// </summary>
        /// <value>DO31_NUMREG_CO99 - Numero registrazione</value>
        [DataMember(Name="numregCo99", EmitDefaultValue=false)]
        public string NumregCo99 { get; set; }

        /// <summary>
        /// DO31_PROGRIGA - Progressivo Riga
        /// </summary>
        /// <value>DO31_PROGRIGA - Progressivo Riga</value>
        [DataMember(Name="progRiga", EmitDefaultValue=false)]
        public double? ProgRiga { get; set; }

        /// <summary>
        /// DO31_PROGRIGPIA_PD80 - Progressivo riga piano consegna
        /// </summary>
        /// <value>DO31_PROGRIGPIA_PD80 - Progressivo riga piano consegna</value>
        [DataMember(Name="progRigpiaPd80", EmitDefaultValue=false)]
        public double? ProgRigpiaPd80 { get; set; }

        /// <summary>
        /// DO31_QTA1CONS - Quantità consegnata
        /// </summary>
        /// <value>DO31_QTA1CONS - Quantità consegnata</value>
        [DataMember(Name="qta1cons", EmitDefaultValue=false)]
        public double? Qta1cons { get; set; }

        /// <summary>
        /// DO31_QTA1LANC - Quantità consegnata alla data lancio
        /// </summary>
        /// <value>DO31_QTA1LANC - Quantità consegnata alla data lancio</value>
        [DataMember(Name="qta1lanc", EmitDefaultValue=false)]
        public double? Qta1lanc { get; set; }

        /// <summary>
        /// DO31_QTA1PREL - Quantità 1 prelevata
        /// </summary>
        /// <value>DO31_QTA1PREL - Quantità 1 prelevata</value>
        [DataMember(Name="qta1prel", EmitDefaultValue=false)]
        public double? Qta1prel { get; set; }

        /// <summary>
        /// DO31_QTA1TRASFDDTCL - Quantità 1 trasf. conto lavoro
        /// </summary>
        /// <value>DO31_QTA1TRASFDDTCL - Quantità 1 trasf. conto lavoro</value>
        [DataMember(Name="qta1trasfddtcl", EmitDefaultValue=false)]
        public double? Qta1trasfddtcl { get; set; }

        /// <summary>
        /// DO31_QTA1TRASFP - Qta 1 trasf.p.
        /// </summary>
        /// <value>DO31_QTA1TRASFP - Qta 1 trasf.p.</value>
        [DataMember(Name="qta1trasfp", EmitDefaultValue=false)]
        public double? Qta1trasfp { get; set; }

        /// <summary>
        /// DO31_QTA2CONS - Quantità consegnata 2
        /// </summary>
        /// <value>DO31_QTA2CONS - Quantità consegnata 2</value>
        [DataMember(Name="qta2cons", EmitDefaultValue=false)]
        public double? Qta2cons { get; set; }

        /// <summary>
        /// DO31_QTA2LANC - Quantità consegnata alla data lancio
        /// </summary>
        /// <value>DO31_QTA2LANC - Quantità consegnata alla data lancio</value>
        [DataMember(Name="qta2lanc", EmitDefaultValue=false)]
        public double? Qta2lanc { get; set; }

        /// <summary>
        /// DO31_QTA2PREL - Quantità 2 prelevata
        /// </summary>
        /// <value>DO31_QTA2PREL - Quantità 2 prelevata</value>
        [DataMember(Name="qta2prel", EmitDefaultValue=false)]
        public double? Qta2prel { get; set; }

        /// <summary>
        /// DO31_QTA2TRASFDDTCL - Quantità 2 trasf. conto lavoro
        /// </summary>
        /// <value>DO31_QTA2TRASFDDTCL - Quantità 2 trasf. conto lavoro</value>
        [DataMember(Name="qta2trasfddtcl", EmitDefaultValue=false)]
        public double? Qta2trasfddtcl { get; set; }

        /// <summary>
        /// DO31_QTA2TRASFP - Qta 2 trasf.p.
        /// </summary>
        /// <value>DO31_QTA2TRASFP - Qta 2 trasf.p.</value>
        [DataMember(Name="qta2trasfp", EmitDefaultValue=false)]
        public double? Qta2trasfp { get; set; }

        /// <summary>
        /// DO31_VALORECONS - Valore cons.
        /// </summary>
        /// <value>DO31_VALORECONS - Valore cons.</value>
        [DataMember(Name="valorecons", EmitDefaultValue=false)]
        public double? Valorecons { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class DocumentoRigaOrdineMGDTO {\n");
            sb.Append("  CodPiano: ").Append(CodPiano).Append("\n");
            sb.Append("  CodTraclegdb: ").Append(CodTraclegdb).Append("\n");
            sb.Append("  CodTraclegwbs: ").Append(CodTraclegwbs).Append("\n");
            sb.Append("  Collicons: ").Append(Collicons).Append("\n");
            sb.Append("  Collitrasfddtcl: ").Append(Collitrasfddtcl).Append("\n");
            sb.Append("  Collitrasfp: ").Append(Collitrasfp).Append("\n");
            sb.Append("  ContpcarPd79: ").Append(ContpcarPd79).Append("\n");
            sb.Append("  Datacons: ").Append(Datacons).Append("\n");
            sb.Append("  Dataconsint: ").Append(Dataconsint).Append("\n");
            sb.Append("  Dataconsorig: ").Append(Dataconsorig).Append("\n");
            sb.Append("  Datafineoap: ").Append(Datafineoap).Append("\n");
            sb.Append("  Datainizlav: ").Append(Datainizlav).Append("\n");
            sb.Append("  Datainizoap: ").Append(Datainizoap).Append("\n");
            sb.Append("  Datalancio: ").Append(Datalancio).Append("\n");
            sb.Append("  Datapianif: ").Append(Datapianif).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgConsconf: ").Append(FlgConsconf).Append("\n");
            sb.Append("  FlgNoevasparz: ").Append(FlgNoevasparz).Append("\n");
            sb.Append("  FlgNonpiuev: ").Append(FlgNonpiuev).Append("\n");
            sb.Append("  FlgNosugg: ").Append(FlgNosugg).Append("\n");
            sb.Append("  FlgRicpreev: ").Append(FlgRicpreev).Append("\n");
            sb.Append("  FlgSospriga: ").Append(FlgSospriga).Append("\n");
            sb.Append("  Ggtollercons: ").Append(Ggtollercons).Append("\n");
            sb.Append("  IndEvasdescsp: ").Append(IndEvasdescsp).Append("\n");
            sb.Append("  IndStatocons: ").Append(IndStatocons).Append("\n");
            sb.Append("  IndStatodescsp: ").Append(IndStatodescsp).Append("\n");
            sb.Append("  Numpiano: ").Append(Numpiano).Append("\n");
            sb.Append("  NumpropPd39: ").Append(NumpropPd39).Append("\n");
            sb.Append("  NumregCo99: ").Append(NumregCo99).Append("\n");
            sb.Append("  ProgRiga: ").Append(ProgRiga).Append("\n");
            sb.Append("  ProgRigpiaPd80: ").Append(ProgRigpiaPd80).Append("\n");
            sb.Append("  Qta1cons: ").Append(Qta1cons).Append("\n");
            sb.Append("  Qta1lanc: ").Append(Qta1lanc).Append("\n");
            sb.Append("  Qta1prel: ").Append(Qta1prel).Append("\n");
            sb.Append("  Qta1trasfddtcl: ").Append(Qta1trasfddtcl).Append("\n");
            sb.Append("  Qta1trasfp: ").Append(Qta1trasfp).Append("\n");
            sb.Append("  Qta2cons: ").Append(Qta2cons).Append("\n");
            sb.Append("  Qta2lanc: ").Append(Qta2lanc).Append("\n");
            sb.Append("  Qta2prel: ").Append(Qta2prel).Append("\n");
            sb.Append("  Qta2trasfddtcl: ").Append(Qta2trasfddtcl).Append("\n");
            sb.Append("  Qta2trasfp: ").Append(Qta2trasfp).Append("\n");
            sb.Append("  Valorecons: ").Append(Valorecons).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as DocumentoRigaOrdineMGDTO);
        }

        /// <summary>
        /// Returns true if DocumentoRigaOrdineMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of DocumentoRigaOrdineMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(DocumentoRigaOrdineMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.CodPiano == input.CodPiano ||
                    (this.CodPiano != null &&
                    this.CodPiano.Equals(input.CodPiano))
                ) && 
                (
                    this.CodTraclegdb == input.CodTraclegdb ||
                    (this.CodTraclegdb != null &&
                    this.CodTraclegdb.Equals(input.CodTraclegdb))
                ) && 
                (
                    this.CodTraclegwbs == input.CodTraclegwbs ||
                    (this.CodTraclegwbs != null &&
                    this.CodTraclegwbs.Equals(input.CodTraclegwbs))
                ) && 
                (
                    this.Collicons == input.Collicons ||
                    (this.Collicons != null &&
                    this.Collicons.Equals(input.Collicons))
                ) && 
                (
                    this.Collitrasfddtcl == input.Collitrasfddtcl ||
                    (this.Collitrasfddtcl != null &&
                    this.Collitrasfddtcl.Equals(input.Collitrasfddtcl))
                ) && 
                (
                    this.Collitrasfp == input.Collitrasfp ||
                    (this.Collitrasfp != null &&
                    this.Collitrasfp.Equals(input.Collitrasfp))
                ) && 
                (
                    this.ContpcarPd79 == input.ContpcarPd79 ||
                    (this.ContpcarPd79 != null &&
                    this.ContpcarPd79.Equals(input.ContpcarPd79))
                ) && 
                (
                    this.Datacons == input.Datacons ||
                    (this.Datacons != null &&
                    this.Datacons.Equals(input.Datacons))
                ) && 
                (
                    this.Dataconsint == input.Dataconsint ||
                    (this.Dataconsint != null &&
                    this.Dataconsint.Equals(input.Dataconsint))
                ) && 
                (
                    this.Dataconsorig == input.Dataconsorig ||
                    (this.Dataconsorig != null &&
                    this.Dataconsorig.Equals(input.Dataconsorig))
                ) && 
                (
                    this.Datafineoap == input.Datafineoap ||
                    (this.Datafineoap != null &&
                    this.Datafineoap.Equals(input.Datafineoap))
                ) && 
                (
                    this.Datainizlav == input.Datainizlav ||
                    (this.Datainizlav != null &&
                    this.Datainizlav.Equals(input.Datainizlav))
                ) && 
                (
                    this.Datainizoap == input.Datainizoap ||
                    (this.Datainizoap != null &&
                    this.Datainizoap.Equals(input.Datainizoap))
                ) && 
                (
                    this.Datalancio == input.Datalancio ||
                    (this.Datalancio != null &&
                    this.Datalancio.Equals(input.Datalancio))
                ) && 
                (
                    this.Datapianif == input.Datapianif ||
                    (this.Datapianif != null &&
                    this.Datapianif.Equals(input.Datapianif))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgConsconf == input.FlgConsconf ||
                    (this.FlgConsconf != null &&
                    this.FlgConsconf.Equals(input.FlgConsconf))
                ) && 
                (
                    this.FlgNoevasparz == input.FlgNoevasparz ||
                    (this.FlgNoevasparz != null &&
                    this.FlgNoevasparz.Equals(input.FlgNoevasparz))
                ) && 
                (
                    this.FlgNonpiuev == input.FlgNonpiuev ||
                    (this.FlgNonpiuev != null &&
                    this.FlgNonpiuev.Equals(input.FlgNonpiuev))
                ) && 
                (
                    this.FlgNosugg == input.FlgNosugg ||
                    (this.FlgNosugg != null &&
                    this.FlgNosugg.Equals(input.FlgNosugg))
                ) && 
                (
                    this.FlgRicpreev == input.FlgRicpreev ||
                    (this.FlgRicpreev != null &&
                    this.FlgRicpreev.Equals(input.FlgRicpreev))
                ) && 
                (
                    this.FlgSospriga == input.FlgSospriga ||
                    (this.FlgSospriga != null &&
                    this.FlgSospriga.Equals(input.FlgSospriga))
                ) && 
                (
                    this.Ggtollercons == input.Ggtollercons ||
                    (this.Ggtollercons != null &&
                    this.Ggtollercons.Equals(input.Ggtollercons))
                ) && 
                (
                    this.IndEvasdescsp == input.IndEvasdescsp ||
                    (this.IndEvasdescsp != null &&
                    this.IndEvasdescsp.Equals(input.IndEvasdescsp))
                ) && 
                (
                    this.IndStatocons == input.IndStatocons ||
                    (this.IndStatocons != null &&
                    this.IndStatocons.Equals(input.IndStatocons))
                ) && 
                (
                    this.IndStatodescsp == input.IndStatodescsp ||
                    (this.IndStatodescsp != null &&
                    this.IndStatodescsp.Equals(input.IndStatodescsp))
                ) && 
                (
                    this.Numpiano == input.Numpiano ||
                    (this.Numpiano != null &&
                    this.Numpiano.Equals(input.Numpiano))
                ) && 
                (
                    this.NumpropPd39 == input.NumpropPd39 ||
                    (this.NumpropPd39 != null &&
                    this.NumpropPd39.Equals(input.NumpropPd39))
                ) && 
                (
                    this.NumregCo99 == input.NumregCo99 ||
                    (this.NumregCo99 != null &&
                    this.NumregCo99.Equals(input.NumregCo99))
                ) && 
                (
                    this.ProgRiga == input.ProgRiga ||
                    (this.ProgRiga != null &&
                    this.ProgRiga.Equals(input.ProgRiga))
                ) && 
                (
                    this.ProgRigpiaPd80 == input.ProgRigpiaPd80 ||
                    (this.ProgRigpiaPd80 != null &&
                    this.ProgRigpiaPd80.Equals(input.ProgRigpiaPd80))
                ) && 
                (
                    this.Qta1cons == input.Qta1cons ||
                    (this.Qta1cons != null &&
                    this.Qta1cons.Equals(input.Qta1cons))
                ) && 
                (
                    this.Qta1lanc == input.Qta1lanc ||
                    (this.Qta1lanc != null &&
                    this.Qta1lanc.Equals(input.Qta1lanc))
                ) && 
                (
                    this.Qta1prel == input.Qta1prel ||
                    (this.Qta1prel != null &&
                    this.Qta1prel.Equals(input.Qta1prel))
                ) && 
                (
                    this.Qta1trasfddtcl == input.Qta1trasfddtcl ||
                    (this.Qta1trasfddtcl != null &&
                    this.Qta1trasfddtcl.Equals(input.Qta1trasfddtcl))
                ) && 
                (
                    this.Qta1trasfp == input.Qta1trasfp ||
                    (this.Qta1trasfp != null &&
                    this.Qta1trasfp.Equals(input.Qta1trasfp))
                ) && 
                (
                    this.Qta2cons == input.Qta2cons ||
                    (this.Qta2cons != null &&
                    this.Qta2cons.Equals(input.Qta2cons))
                ) && 
                (
                    this.Qta2lanc == input.Qta2lanc ||
                    (this.Qta2lanc != null &&
                    this.Qta2lanc.Equals(input.Qta2lanc))
                ) && 
                (
                    this.Qta2prel == input.Qta2prel ||
                    (this.Qta2prel != null &&
                    this.Qta2prel.Equals(input.Qta2prel))
                ) && 
                (
                    this.Qta2trasfddtcl == input.Qta2trasfddtcl ||
                    (this.Qta2trasfddtcl != null &&
                    this.Qta2trasfddtcl.Equals(input.Qta2trasfddtcl))
                ) && 
                (
                    this.Qta2trasfp == input.Qta2trasfp ||
                    (this.Qta2trasfp != null &&
                    this.Qta2trasfp.Equals(input.Qta2trasfp))
                ) && 
                (
                    this.Valorecons == input.Valorecons ||
                    (this.Valorecons != null &&
                    this.Valorecons.Equals(input.Valorecons))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.CodPiano != null)
                    hashCode = hashCode * 59 + this.CodPiano.GetHashCode();
                if (this.CodTraclegdb != null)
                    hashCode = hashCode * 59 + this.CodTraclegdb.GetHashCode();
                if (this.CodTraclegwbs != null)
                    hashCode = hashCode * 59 + this.CodTraclegwbs.GetHashCode();
                if (this.Collicons != null)
                    hashCode = hashCode * 59 + this.Collicons.GetHashCode();
                if (this.Collitrasfddtcl != null)
                    hashCode = hashCode * 59 + this.Collitrasfddtcl.GetHashCode();
                if (this.Collitrasfp != null)
                    hashCode = hashCode * 59 + this.Collitrasfp.GetHashCode();
                if (this.ContpcarPd79 != null)
                    hashCode = hashCode * 59 + this.ContpcarPd79.GetHashCode();
                if (this.Datacons != null)
                    hashCode = hashCode * 59 + this.Datacons.GetHashCode();
                if (this.Dataconsint != null)
                    hashCode = hashCode * 59 + this.Dataconsint.GetHashCode();
                if (this.Dataconsorig != null)
                    hashCode = hashCode * 59 + this.Dataconsorig.GetHashCode();
                if (this.Datafineoap != null)
                    hashCode = hashCode * 59 + this.Datafineoap.GetHashCode();
                if (this.Datainizlav != null)
                    hashCode = hashCode * 59 + this.Datainizlav.GetHashCode();
                if (this.Datainizoap != null)
                    hashCode = hashCode * 59 + this.Datainizoap.GetHashCode();
                if (this.Datalancio != null)
                    hashCode = hashCode * 59 + this.Datalancio.GetHashCode();
                if (this.Datapianif != null)
                    hashCode = hashCode * 59 + this.Datapianif.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgConsconf != null)
                    hashCode = hashCode * 59 + this.FlgConsconf.GetHashCode();
                if (this.FlgNoevasparz != null)
                    hashCode = hashCode * 59 + this.FlgNoevasparz.GetHashCode();
                if (this.FlgNonpiuev != null)
                    hashCode = hashCode * 59 + this.FlgNonpiuev.GetHashCode();
                if (this.FlgNosugg != null)
                    hashCode = hashCode * 59 + this.FlgNosugg.GetHashCode();
                if (this.FlgRicpreev != null)
                    hashCode = hashCode * 59 + this.FlgRicpreev.GetHashCode();
                if (this.FlgSospriga != null)
                    hashCode = hashCode * 59 + this.FlgSospriga.GetHashCode();
                if (this.Ggtollercons != null)
                    hashCode = hashCode * 59 + this.Ggtollercons.GetHashCode();
                if (this.IndEvasdescsp != null)
                    hashCode = hashCode * 59 + this.IndEvasdescsp.GetHashCode();
                if (this.IndStatocons != null)
                    hashCode = hashCode * 59 + this.IndStatocons.GetHashCode();
                if (this.IndStatodescsp != null)
                    hashCode = hashCode * 59 + this.IndStatodescsp.GetHashCode();
                if (this.Numpiano != null)
                    hashCode = hashCode * 59 + this.Numpiano.GetHashCode();
                if (this.NumpropPd39 != null)
                    hashCode = hashCode * 59 + this.NumpropPd39.GetHashCode();
                if (this.NumregCo99 != null)
                    hashCode = hashCode * 59 + this.NumregCo99.GetHashCode();
                if (this.ProgRiga != null)
                    hashCode = hashCode * 59 + this.ProgRiga.GetHashCode();
                if (this.ProgRigpiaPd80 != null)
                    hashCode = hashCode * 59 + this.ProgRigpiaPd80.GetHashCode();
                if (this.Qta1cons != null)
                    hashCode = hashCode * 59 + this.Qta1cons.GetHashCode();
                if (this.Qta1lanc != null)
                    hashCode = hashCode * 59 + this.Qta1lanc.GetHashCode();
                if (this.Qta1prel != null)
                    hashCode = hashCode * 59 + this.Qta1prel.GetHashCode();
                if (this.Qta1trasfddtcl != null)
                    hashCode = hashCode * 59 + this.Qta1trasfddtcl.GetHashCode();
                if (this.Qta1trasfp != null)
                    hashCode = hashCode * 59 + this.Qta1trasfp.GetHashCode();
                if (this.Qta2cons != null)
                    hashCode = hashCode * 59 + this.Qta2cons.GetHashCode();
                if (this.Qta2lanc != null)
                    hashCode = hashCode * 59 + this.Qta2lanc.GetHashCode();
                if (this.Qta2prel != null)
                    hashCode = hashCode * 59 + this.Qta2prel.GetHashCode();
                if (this.Qta2trasfddtcl != null)
                    hashCode = hashCode * 59 + this.Qta2trasfddtcl.GetHashCode();
                if (this.Qta2trasfp != null)
                    hashCode = hashCode * 59 + this.Qta2trasfp.GetHashCode();
                if (this.Valorecons != null)
                    hashCode = hashCode * 59 + this.Valorecons.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
