/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// KitUnloadComponentParameterDTO
    /// </summary>
    [DataContract]
        public partial class KitUnloadComponentParameterDTO :  IEquatable<KitUnloadComponentParameterDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="KitUnloadComponentParameterDTO" /> class.
        /// </summary>
        /// <param name="loadDocumentCodeFilter">Product Loading Document Code Selection (required).</param>
        /// <param name="unloadComponentKitParameter">unloadComponentKitParameter (required).</param>
        /// <param name="headLoadDocumentsFilter">headLoadDocumentsFilter.</param>
        /// <param name="rowLoadDocumentsFilter">rowLoadDocumentsFilter.</param>
        public KitUnloadComponentParameterDTO(string loadDocumentCodeFilter = default(string), UnloadComponentKitParameterDTO unloadComponentKitParameter = default(UnloadComponentKitParameterDTO), SearchDTO headLoadDocumentsFilter = default(SearchDTO), SearchDTO rowLoadDocumentsFilter = default(SearchDTO))
        {
            // to ensure "loadDocumentCodeFilter" is required (not null)
            if (loadDocumentCodeFilter == null)
            {
                throw new InvalidDataException("loadDocumentCodeFilter is a required property for KitUnloadComponentParameterDTO and cannot be null");
            }
            else
            {
                this.LoadDocumentCodeFilter = loadDocumentCodeFilter;
            }
            // to ensure "unloadComponentKitParameter" is required (not null)
            if (unloadComponentKitParameter == null)
            {
                throw new InvalidDataException("unloadComponentKitParameter is a required property for KitUnloadComponentParameterDTO and cannot be null");
            }
            else
            {
                this.UnloadComponentKitParameter = unloadComponentKitParameter;
            }
            this.HeadLoadDocumentsFilter = headLoadDocumentsFilter;
            this.RowLoadDocumentsFilter = rowLoadDocumentsFilter;
        }
        
        /// <summary>
        /// Product Loading Document Code Selection
        /// </summary>
        /// <value>Product Loading Document Code Selection</value>
        [DataMember(Name="loadDocumentCodeFilter", EmitDefaultValue=false)]
        public string LoadDocumentCodeFilter { get; set; }

        /// <summary>
        /// Gets or Sets UnloadComponentKitParameter
        /// </summary>
        [DataMember(Name="unloadComponentKitParameter", EmitDefaultValue=false)]
        public UnloadComponentKitParameterDTO UnloadComponentKitParameter { get; set; }

        /// <summary>
        /// Gets or Sets HeadLoadDocumentsFilter
        /// </summary>
        [DataMember(Name="headLoadDocumentsFilter", EmitDefaultValue=false)]
        public SearchDTO HeadLoadDocumentsFilter { get; set; }

        /// <summary>
        /// Gets or Sets RowLoadDocumentsFilter
        /// </summary>
        [DataMember(Name="rowLoadDocumentsFilter", EmitDefaultValue=false)]
        public SearchDTO RowLoadDocumentsFilter { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class KitUnloadComponentParameterDTO {\n");
            sb.Append("  LoadDocumentCodeFilter: ").Append(LoadDocumentCodeFilter).Append("\n");
            sb.Append("  UnloadComponentKitParameter: ").Append(UnloadComponentKitParameter).Append("\n");
            sb.Append("  HeadLoadDocumentsFilter: ").Append(HeadLoadDocumentsFilter).Append("\n");
            sb.Append("  RowLoadDocumentsFilter: ").Append(RowLoadDocumentsFilter).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as KitUnloadComponentParameterDTO);
        }

        /// <summary>
        /// Returns true if KitUnloadComponentParameterDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of KitUnloadComponentParameterDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(KitUnloadComponentParameterDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.LoadDocumentCodeFilter == input.LoadDocumentCodeFilter ||
                    (this.LoadDocumentCodeFilter != null &&
                    this.LoadDocumentCodeFilter.Equals(input.LoadDocumentCodeFilter))
                ) && 
                (
                    this.UnloadComponentKitParameter == input.UnloadComponentKitParameter ||
                    (this.UnloadComponentKitParameter != null &&
                    this.UnloadComponentKitParameter.Equals(input.UnloadComponentKitParameter))
                ) && 
                (
                    this.HeadLoadDocumentsFilter == input.HeadLoadDocumentsFilter ||
                    (this.HeadLoadDocumentsFilter != null &&
                    this.HeadLoadDocumentsFilter.Equals(input.HeadLoadDocumentsFilter))
                ) && 
                (
                    this.RowLoadDocumentsFilter == input.RowLoadDocumentsFilter ||
                    (this.RowLoadDocumentsFilter != null &&
                    this.RowLoadDocumentsFilter.Equals(input.RowLoadDocumentsFilter))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.LoadDocumentCodeFilter != null)
                    hashCode = hashCode * 59 + this.LoadDocumentCodeFilter.GetHashCode();
                if (this.UnloadComponentKitParameter != null)
                    hashCode = hashCode * 59 + this.UnloadComponentKitParameter.GetHashCode();
                if (this.HeadLoadDocumentsFilter != null)
                    hashCode = hashCode * 59 + this.HeadLoadDocumentsFilter.GetHashCode();
                if (this.RowLoadDocumentsFilter != null)
                    hashCode = hashCode * 59 + this.RowLoadDocumentsFilter.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
