/* 
 * TSE Cloud - MG
 *
 * This is Swagger Docs for Document WebApi Teamsystemn Enterprise Cloud, more detail at [https://swagger.io](https://swagger.io).
 *
 * OpenAPI spec version: v2025.1000
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */
using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using SwaggerDateConverter = IO.Swagger.Client.SwaggerDateConverter;
namespace IO.Swagger.Model
{
    /// <summary>
    /// MG44_PARMAGLIST - Listino vendita/acquisto&lt;br&gt;Proprietà chiave:&lt;ul&gt;&lt;li&gt;&lt;b&gt;DittaCg18&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;FlgVenacq&lt;/b&gt;&lt;/li&gt;&lt;li&gt;&lt;b&gt;Numlist&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;
    /// </summary>
    [DataContract]
        public partial class SalePurchasePriceListCodeMGDTO :  IEquatable<SalePurchasePriceListCodeMGDTO>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SalePurchasePriceListCodeMGDTO" /> class.
        /// </summary>
        /// <param name="desclist">MG44_DESCLIST - Descrizione listino (required).</param>
        /// <param name="dittaCg18">MG44_DITTA_CG18 - Ditta (default to 0).</param>
        /// <param name="flgVenacq">MG44_FLGVENACQ - Vendita / Acquisto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Listino di vendita&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Listino di acquisto&lt;/li&gt;&lt;/ul&gt;.</param>
        /// <param name="numlist">MG44_NUMLIST - Numero listino (required).</param>
        /// <param name="valutaCg08">MG44_VALUTA_CG08 - Codice valuta (required).</param>
        /// <param name="extensionData">extensionData.</param>
        /// <param name="additionalData">additionalData.</param>
        /// <param name="pluginData">pluginData.</param>
        public SalePurchasePriceListCodeMGDTO(string desclist = default(string), double? dittaCg18 = 0, double? flgVenacq = default(double?), double? numlist = default(double?), string valutaCg08 = default(string), List<StringObjectKeyValuePair> extensionData = default(List<StringObjectKeyValuePair>), Dictionary<string, Object> additionalData = default(Dictionary<string, Object>), Dictionary<string, Object> pluginData = default(Dictionary<string, Object>))
        {
            // to ensure "desclist" is required (not null)
            if (desclist == null)
            {
                throw new InvalidDataException("desclist is a required property for SalePurchasePriceListCodeMGDTO and cannot be null");
            }
            else
            {
                this.Desclist = desclist;
            }
            // to ensure "numlist" is required (not null)
            if (numlist == null)
            {
                throw new InvalidDataException("numlist is a required property for SalePurchasePriceListCodeMGDTO and cannot be null");
            }
            else
            {
                this.Numlist = numlist;
            }
            // to ensure "valutaCg08" is required (not null)
            if (valutaCg08 == null)
            {
                throw new InvalidDataException("valutaCg08 is a required property for SalePurchasePriceListCodeMGDTO and cannot be null");
            }
            else
            {
                this.ValutaCg08 = valutaCg08;
            }
            // use default value if no "dittaCg18" provided
            if (dittaCg18 == null)
            {
                this.DittaCg18 = 0;
            }
            else
            {
                this.DittaCg18 = dittaCg18;
            }
            this.FlgVenacq = flgVenacq;
            this.ExtensionData = extensionData;
            this.AdditionalData = additionalData;
            this.PluginData = pluginData;
        }
        
        /// <summary>
        /// MG44_DESCLIST - Descrizione listino
        /// </summary>
        /// <value>MG44_DESCLIST - Descrizione listino</value>
        [DataMember(Name="desclist", EmitDefaultValue=false)]
        public string Desclist { get; set; }

        /// <summary>
        /// MG44_DITTA_CG18 - Ditta
        /// </summary>
        /// <value>MG44_DITTA_CG18 - Ditta</value>
        [DataMember(Name="dittaCg18", EmitDefaultValue=false)]
        public double? DittaCg18 { get; set; }

        /// <summary>
        /// MG44_FLGVENACQ - Vendita / Acquisto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Listino di vendita&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Listino di acquisto&lt;/li&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>MG44_FLGVENACQ - Vendita / Acquisto&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;i&gt;0&lt;/i&gt; - Listino di vendita&lt;/li&gt;&lt;li&gt;&lt;i&gt;1&lt;/i&gt; - Listino di acquisto&lt;/li&gt;&lt;/ul&gt;</value>
        [DataMember(Name="flgVenacq", EmitDefaultValue=false)]
        public double? FlgVenacq { get; set; }

        /// <summary>
        /// MG44_NUMLIST - Numero listino
        /// </summary>
        /// <value>MG44_NUMLIST - Numero listino</value>
        [DataMember(Name="numlist", EmitDefaultValue=false)]
        public double? Numlist { get; set; }

        /// <summary>
        /// MG44_VALUTA_CG08 - Codice valuta
        /// </summary>
        /// <value>MG44_VALUTA_CG08 - Codice valuta</value>
        [DataMember(Name="valutaCg08", EmitDefaultValue=false)]
        public string ValutaCg08 { get; set; }

        /// <summary>
        /// Gets or Sets ExtensionData
        /// </summary>
        [DataMember(Name="extensionData", EmitDefaultValue=false)]
        public List<StringObjectKeyValuePair> ExtensionData { get; set; }

        /// <summary>
        /// Gets or Sets AdditionalData
        /// </summary>
        [DataMember(Name="additionalData", EmitDefaultValue=false)]
        public Dictionary<string, Object> AdditionalData { get; set; }

        /// <summary>
        /// Gets or Sets PluginData
        /// </summary>
        [DataMember(Name="pluginData", EmitDefaultValue=false)]
        public Dictionary<string, Object> PluginData { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class SalePurchasePriceListCodeMGDTO {\n");
            sb.Append("  Desclist: ").Append(Desclist).Append("\n");
            sb.Append("  DittaCg18: ").Append(DittaCg18).Append("\n");
            sb.Append("  FlgVenacq: ").Append(FlgVenacq).Append("\n");
            sb.Append("  Numlist: ").Append(Numlist).Append("\n");
            sb.Append("  ValutaCg08: ").Append(ValutaCg08).Append("\n");
            sb.Append("  ExtensionData: ").Append(ExtensionData).Append("\n");
            sb.Append("  AdditionalData: ").Append(AdditionalData).Append("\n");
            sb.Append("  PluginData: ").Append(PluginData).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as SalePurchasePriceListCodeMGDTO);
        }

        /// <summary>
        /// Returns true if SalePurchasePriceListCodeMGDTO instances are equal
        /// </summary>
        /// <param name="input">Instance of SalePurchasePriceListCodeMGDTO to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(SalePurchasePriceListCodeMGDTO input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Desclist == input.Desclist ||
                    (this.Desclist != null &&
                    this.Desclist.Equals(input.Desclist))
                ) && 
                (
                    this.DittaCg18 == input.DittaCg18 ||
                    (this.DittaCg18 != null &&
                    this.DittaCg18.Equals(input.DittaCg18))
                ) && 
                (
                    this.FlgVenacq == input.FlgVenacq ||
                    (this.FlgVenacq != null &&
                    this.FlgVenacq.Equals(input.FlgVenacq))
                ) && 
                (
                    this.Numlist == input.Numlist ||
                    (this.Numlist != null &&
                    this.Numlist.Equals(input.Numlist))
                ) && 
                (
                    this.ValutaCg08 == input.ValutaCg08 ||
                    (this.ValutaCg08 != null &&
                    this.ValutaCg08.Equals(input.ValutaCg08))
                ) && 
                (
                    this.ExtensionData == input.ExtensionData ||
                    this.ExtensionData != null &&
                    input.ExtensionData != null &&
                    this.ExtensionData.SequenceEqual(input.ExtensionData)
                ) && 
                (
                    this.AdditionalData == input.AdditionalData ||
                    this.AdditionalData != null &&
                    input.AdditionalData != null &&
                    this.AdditionalData.SequenceEqual(input.AdditionalData)
                ) && 
                (
                    this.PluginData == input.PluginData ||
                    this.PluginData != null &&
                    input.PluginData != null &&
                    this.PluginData.SequenceEqual(input.PluginData)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Desclist != null)
                    hashCode = hashCode * 59 + this.Desclist.GetHashCode();
                if (this.DittaCg18 != null)
                    hashCode = hashCode * 59 + this.DittaCg18.GetHashCode();
                if (this.FlgVenacq != null)
                    hashCode = hashCode * 59 + this.FlgVenacq.GetHashCode();
                if (this.Numlist != null)
                    hashCode = hashCode * 59 + this.Numlist.GetHashCode();
                if (this.ValutaCg08 != null)
                    hashCode = hashCode * 59 + this.ValutaCg08.GetHashCode();
                if (this.ExtensionData != null)
                    hashCode = hashCode * 59 + this.ExtensionData.GetHashCode();
                if (this.AdditionalData != null)
                    hashCode = hashCode * 59 + this.AdditionalData.GetHashCode();
                if (this.PluginData != null)
                    hashCode = hashCode * 59 + this.PluginData.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }
}
