'use strict';


/**
 * Get new
 * Get an empty object of type corresponding
 *
 * _op String The value must be 'new'
 * param String Specify optional parameters that will be used during entity creation
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierMGDTO
 **/
exports.apiV1EnvironmentMGCustomerSupplierMGGET = function(_op,param,environment,authorizationScope,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 2,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 2
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "idCliFor" : 8,
  "idmediaCg99" : 7.740351818741173,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 7,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 7.061401241503109,
    "indsoggrit" : 7.457744773683766,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9
    },
    "statofiscCg07" : 5.025004791520295,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 2,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 9,
    "citta" : "citta",
    "statonascitaCg07" : 9.965781217890562,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 1.2315135367772556,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.84685269835264,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 0.8774076871421566,
      "flgRegagevo" : 4.86315908102884,
      "idmediaCg99" : 3.901545264248647,
      "percRipPerc" : 1.8268702177058116,
      "flgRitImposta" : 6.073898085781152,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 9.254183946267839,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 7.933506881737151,
      "flgProteo360" : 5.507386964179881,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 9.702963800023566,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 4,
      "idprov" : 0.43431398824148815,
      "codice" : "codice",
      "percci" : 4.573936264232251,
      "flgSosprit" : 8,
      "descr" : "descr",
      "flgMinimi" : 0,
      "codTributo" : "codTributo",
      "indCodattglad" : 2.9409642974827896,
      "indTipocassa" : 1,
      "percra" : 8.863729185622827,
      "percbaseimp" : 6.623518433804886,
      "codTribrp" : "codTribrp",
      "inpsivs" : 8.28965939814297,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 3.616076749251911,
    "codiceCgc0" : 9.301444243932576,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 1.0246457001441578,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 4.145608029883936,
    "rapazestCg16" : 1,
    "cellnum" : "cellnum",
    "flgPrsfis" : 1.4894159098541704,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 6,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 4.965218492984954,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 5,
    "indweb" : "indweb"
  },
  "goods" : {
    "reverseTypeFI" : {
      "reverseTypeCode" : 8,
      "reverseTypeDescription" : "reverseTypeDescription",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "flgBilconsattpassdist" : 5,
    "contochiu" : "contochiu",
    "flgAnalit" : 8,
    "codeformatted" : "codeformatted",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9
    },
    "flgAggfatt" : 5,
    "indLivchius" : 3,
    "idcontoratattCg24" : 8,
    "idcontoapeCg24" : 4,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "contocrsosp" : "contocrsosp",
    "flgContoimm" : 0,
    "flgOpnonfin" : 8.257837395465918,
    "indDaavec" : 1,
    "cogeprogeMateriali" : 8,
    "coaAccountCustomizationFI" : [ {
      "descr" : "descr",
      "iddespcon" : 9,
      "dittaCg18" : 8.780989965779524,
      "contoCg24" : "contoCg24",
      "idmediaCg99" : 6.203595661339589,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.616380282218067,
      "idCg24" : 9,
      "rowversion" : ""
    }, {
      "descr" : "descr",
      "iddespcon" : 9,
      "dittaCg18" : 8.780989965779524,
      "contoCg24" : "contoCg24",
      "idmediaCg99" : 6.203595661339589,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.616380282218067,
      "idCg24" : 9,
      "rowversion" : ""
    } ],
    "accountType" : 9,
    "contoratpass" : "contoratpass",
    "descr" : "descr",
    "idcontorisattCg24" : 7,
    "indDaav" : 4,
    "suddconti" : 0.9178980228274691,
    "contoratatt" : "contoratatt",
    "indMastroCliFor" : 3.8581948879558317,
    "idcontochiuCg24" : 8,
    "percindetra" : 8.262575023052213,
    "codiceCg22" : 1.5743672347582194,
    "indAttpasspor" : 7,
    "indTipoconto" : 1,
    "contoape" : "contoape",
    "flgGespor" : 8,
    "cogeprogeAbil" : 2,
    "flgSaldog" : 2,
    "percindeduc" : 4.5403315819302215,
    "contorisatt" : "contorisatt",
    "codiceCgc0" : 4.863793115215697,
    "flgValutaest" : 5,
    "flgRaganal" : 5,
    "alias" : "alias",
    "conto" : "conto",
    "cogeprogeNodo" : 2,
    "contorispass" : "contorispass",
    "indContoricav" : 1,
    "vatTypeFI" : {
      "descr" : "descr",
      "indAutofattura" : 9,
      "agviaggio" : 0,
      "codice" : 0.7370530802760489,
      "pluginData" : {
        "key" : ""
      },
      "localizzazione" : 7,
      "additionalData" : {
        "key" : ""
      },
      "codiceCg0d" : 4.318826475758856,
      "indTipo" : 7.541803065493349
    },
    "idcontorispassCg24" : 1,
    "cogeprogeAttivita" : 2,
    "flgGesec" : 1,
    "coaInternationalCustomizationFI" : [ {
      "contoCg24" : "contoCg24",
      "subcategoria" : 9,
      "categoria" : 9,
      "gbDeferralcode" : "gbDeferralcode",
      "esModulo347" : 3,
      "pluginData" : {
        "key" : ""
      },
      "id" : 8,
      "iso3166A2" : "iso3166A2",
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.267310321293582,
      "idCg24" : 7,
      "rowversion" : ""
    }, {
      "contoCg24" : "contoCg24",
      "subcategoria" : 9,
      "categoria" : 9,
      "gbDeferralcode" : "gbDeferralcode",
      "esModulo347" : 3,
      "pluginData" : {
        "key" : ""
      },
      "id" : 8,
      "iso3166A2" : "iso3166A2",
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.267310321293582,
      "idCg24" : 7,
      "rowversion" : ""
    } ],
    "gruppoCg10" : 5.412786966532157,
    "coaAccountStateFI" : [ {
      "consosCg24" : "consosCg24",
      "dittaCg18" : 7.014147440046284,
      "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
      "grusosCg10" : 9.684087197655908,
      "pluginData" : {
        "key" : ""
      },
      "idstatipdc" : 6,
      "additionalData" : {
        "key" : ""
      },
      "dtconsos" : "2000-01-23T04:56:07.000+00:00",
      "flgDisatt" : 0.8972273556195443,
      "idCg24" : 1,
      "rowversion" : ""
    }, {
      "consosCg24" : "consosCg24",
      "dittaCg18" : 7.014147440046284,
      "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
      "grusosCg10" : 9.684087197655908,
      "pluginData" : {
        "key" : ""
      },
      "idstatipdc" : 6,
      "additionalData" : {
        "key" : ""
      },
      "dtconsos" : "2000-01-23T04:56:07.000+00:00",
      "flgDisatt" : 0.8972273556195443,
      "idCg24" : 1,
      "rowversion" : ""
    } ],
    "coaGroupCodeFI" : {
      "descr" : "descr",
      "numlivcons" : 8.289598895249666,
      "gruppo" : 9.372628622067484,
      "numlivelli" : 6.460213024504889,
      "accountProposals" : [ {
        "contoCg24" : "contoCg24",
        "codice" : 6.8668894011844035,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 7.375698277301938,
        "idCg24" : 0,
        "rowversion" : ""
      }, {
        "contoCg24" : "contoCg24",
        "codice" : 6.8668894011844035,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 7.375698277301938,
        "idCg24" : 0,
        "rowversion" : ""
      } ],
      "pluginData" : {
        "key" : ""
      },
      "maskedit" : "maskedit",
      "additionalData" : {
        "key" : ""
      },
      "flgPdclib" : 9,
      "rowversion" : ""
    },
    "idparent" : 2,
    "idreverse" : 1,
    "flgIntercompany" : 2,
    "idcontoratpassCg24" : 6,
    "flgRarp" : 9,
    "idconto" : 8,
    "cogeprogeSpese" : 6,
    "idRifPdC80" : 7,
    "indCosvend" : 4
  },
  "flgAttivo" : 0.8851374739011653,
  "tipocfCg40" : 5.533258397034986,
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 2,
    "idknos" : 6,
    "dittaCg18" : 1.0046985756074744,
    "flgInvalid" : 3,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 1.6056289151258096,
    "codice" : 8.875589915795528,
    "indDimcentrocomm" : 6.720288821326667,
    "cap" : "cap",
    "dittaCg18" : 7.766860781935265,
    "progRea" : 5.304373278797373,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "flgInterCompany" : 6.519180951018382,
  "paymentTermCO" : {
    "flgDesc" : 8.708394192403432,
    "paymentTermDetailCO" : [ {
      "indImpfix" : 6.568304668801491,
      "daggfix1" : 9.610516429629122,
      "daggfix2" : 9.140242185517025,
      "ggmmfix" : 6.936593194494838,
      "ggdecor" : 2.408218941758913,
      "idCg64" : 4,
      "imporfix" : 2.674423984487264,
      "flgFrperciva" : 7.686670838404092,
      "idCg62" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "el2friva" : 4.180725413706508,
      "indTipocalend" : 1,
      "indTipodecor" : 7.338782761819433,
      "aggfix2" : 5.948961008630453,
      "aggfix1" : 8.638367073739522,
      "perciva" : 0.05965928697733491,
      "el2frimp" : 7.964879197514727,
      "ggscadfix2" : 0.6052866655822231,
      "tipoeff" : 9.728706165995554,
      "flgFrpercimp" : 7.321091499885957,
      "percimp" : 9.739448828157911,
      "prog" : 5.099298781640682,
      "el1frimp" : 8.81377937009168,
      "codPagCg62" : "codPagCg62",
      "ggscadfix1" : 3.8463127686084055,
      "subTypeCO" : {
        "ggoffset" : 5.3152834658745505,
        "codiceCg07" : 3.3182952910080674,
        "tipoeff" : 2.4977456046390434,
        "codPaguc" : "codPaguc",
        "descstipo" : "descstipo",
        "codStipoeff" : 8.50835276411088,
        "flgAssegno" : 9,
        "indModfatturapa" : 4,
        "nationCO" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "foreignPaymentCodeCO" : {
          "flgIbanobbl" : 0,
          "descrpag" : "descrpag",
          "codIso" : "codIso",
          "codice" : "codice",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "el1friva" : 4.39343993729625,
      "indDatarif" : 2.3317418552851765,
      "rowversion" : ""
    }, {
      "indImpfix" : 6.568304668801491,
      "daggfix1" : 9.610516429629122,
      "daggfix2" : 9.140242185517025,
      "ggmmfix" : 6.936593194494838,
      "ggdecor" : 2.408218941758913,
      "idCg64" : 4,
      "imporfix" : 2.674423984487264,
      "flgFrperciva" : 7.686670838404092,
      "idCg62" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "el2friva" : 4.180725413706508,
      "indTipocalend" : 1,
      "indTipodecor" : 7.338782761819433,
      "aggfix2" : 5.948961008630453,
      "aggfix1" : 8.638367073739522,
      "perciva" : 0.05965928697733491,
      "el2frimp" : 7.964879197514727,
      "ggscadfix2" : 0.6052866655822231,
      "tipoeff" : 9.728706165995554,
      "flgFrpercimp" : 7.321091499885957,
      "percimp" : 9.739448828157911,
      "prog" : 5.099298781640682,
      "el1frimp" : 8.81377937009168,
      "codPagCg62" : "codPagCg62",
      "ggscadfix1" : 3.8463127686084055,
      "subTypeCO" : {
        "ggoffset" : 5.3152834658745505,
        "codiceCg07" : 3.3182952910080674,
        "tipoeff" : 2.4977456046390434,
        "codPaguc" : "codPaguc",
        "descstipo" : "descstipo",
        "codStipoeff" : 8.50835276411088,
        "flgAssegno" : 9,
        "indModfatturapa" : 4,
        "nationCO" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "foreignPaymentCodeCO" : {
          "flgIbanobbl" : 0,
          "descrpag" : "descrpag",
          "codIso" : "codIso",
          "codice" : "codice",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "el1friva" : 4.39343993729625,
      "indDatarif" : 2.3317418552851765,
      "rowversion" : ""
    } ],
    "codPag" : "codPag",
    "desPagAnal" : "desPagAnal",
    "flgDisgg" : 0.8164256701298711,
    "flgPrefpass" : 4,
    "idExtendedAttributeSubEntity" : 3,
    "flgPrefatt" : 4,
    "flgStornoiva" : 0.313237310471568,
    "descPag" : "descPag",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "scpermer2" : 4.035133329541982,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "scpercas" : 4.403697036782718,
    "scpermer1" : 6.936499209818381,
    "additionalData" : {
      "key" : ""
    },
    "scpercart26" : 0.05189710095898081,
    "idExtendedAttributeEntity" : 2,
    "rowversion" : "",
    "scart26" : 2.1871588311421153
  },
  "progrEf08" : 3.0576100241049344,
  "tipoCf" : 7.04836565559697,
  "pluginData" : {
    "key" : ""
  },
  "cliFor" : 3.353193347011243,
  "additionalData" : {
    "key" : ""
  },
  "ggScadFix" : 0.10263654006109402,
  "idExtendedAttributeEntity" : 3,
  "idExtendedAttributeSubEntity" : 4,
  "flgCointestati" : 7.058770351582356,
  "gruppoCg10" : 4.652396432933246,
  "currencyCO" : {
    "sigla" : "sigla",
    "dataattuem" : "2000-01-23T04:56:07.000+00:00",
    "numdec" : 7.04836565559697,
    "exchangeRateCO" : [ {
      "cambio" : 4.078845849666752,
      "anno" : 3.2588565619047607,
      "idmediaCg99" : 6.628464275087742,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 4,
      "codicerifCg08" : "codicerifCg08",
      "giorno" : 0.2025324113236393,
      "mese" : 1.041444916118296,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 5.533258397034986,
      "rowversion" : ""
    }, {
      "cambio" : 4.078845849666752,
      "anno" : 3.2588565619047607,
      "idmediaCg99" : 6.628464275087742,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 4,
      "codicerifCg08" : "codicerifCg08",
      "giorno" : 0.2025324113236393,
      "mese" : 1.041444916118296,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 5.533258397034986,
      "rowversion" : ""
    } ],
    "idmediaCg99" : 8.969578798196912,
    "codice" : "codice",
    "indCertoincerto" : 7,
    "cambiofisso" : 0.10263654006109402,
    "descr" : "descr",
    "flgValuem" : 4.652396432933246,
    "indValuem" : 3.0576100241049344,
    "indSepmigl" : 3.0205796992916243,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "vatCodeCO" : {
    "flgSospimp" : 7.224413148959403,
    "indNatura" : 7,
    "flgAgri" : 7.239590766928185,
    "tipologia" : 6.614319261836819,
    "percindet" : 6.541917087228235,
    "mossperc" : 6.711221582652969,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 4,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 4,
    "perciva" : 6.389489858092311,
    "percforf" : 5.305668385940959,
    "codice" : "codice",
    "impostamonofasersm" : 0.42286244411048224,
    "codiceOss" : "codiceOss",
    "extensionData" : [ null, null ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 2,
    "flgAutoue" : 6.677419970877656,
    "flgIndet" : 4.966567419166605,
    "codPlafond" : 2.6736395633233356,
    "note" : "note",
    "flgAssport398" : 9.852147203726787,
    "flgMossrid" : 3,
    "indStaper" : 8.474710856151638,
    "flgAllclifor" : 6.090696483578148,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 5,
    "flgCorrVent" : 1.2880645475702646,
    "aliqivavent" : 8.018039914932286,
    "flgNotvar" : 0.9619297253823988,
    "percmonofasersm" : 5.201737367852583,
    "idprov" : 1.633699845078339,
    "idExtendedAttributeSubEntity" : 0,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 5,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 9.693372334146686,
    "mosscodCg07" : 6.008900790410507,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 1.822577900073098,
    "flgIvaedit" : 2.9790233918904585,
    "indtipopart" : 3.474156394106027
  },
  "extensionData" : [ null, null ],
  "classificationData" : {
    "cliforCg44" : 0.2025324113236393,
    "indarrinfat" : 4.573936264232251,
    "indprefstdoc" : 5.299143560275359,
    "notes" : [ {
      "cliforCg44" : 0.30134145536422907,
      "note" : "note",
      "dittaCg18" : 0.4867146239815201,
      "tipocfCg44" : 7.88722683998926,
      "idmediaCg99" : 9.456612101333725,
      "destiponote" : "destiponote",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prog" : 9.721723570087065
    }, {
      "cliforCg44" : 0.30134145536422907,
      "note" : "note",
      "dittaCg18" : 0.4867146239815201,
      "tipocfCg44" : 7.88722683998926,
      "idmediaCg99" : 9.456612101333725,
      "destiponote" : "destiponote",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prog" : 9.721723570087065
    } ],
    "sc2percor" : 0.4768402382624515,
    "codrifnum" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 3.209082285545927,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 2,
      "idmediaCg99" : 8.262795412896967,
      "tipocf" : 9.146339979307802,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "language" : {
      "iso639" : "iso639",
      "idmediaCg99" : 2.9679475177256287,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrlingua" : "descrlingua",
      "codLingua" : "codLingua",
      "siglalingua" : "siglalingua"
    },
    "irs1099" : "irs1099",
    "ggcons" : 2.9409642974827896,
    "flgesclspepor" : 0.5199002018724985,
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 8.910869026866926,
      "idprov" : 6,
      "idmediaCg99" : 2.058822123984536,
      "tipocf" : 0.8411762798681321,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "datiAccompagnamento" : {
      "cliforCg44" : 4.8789878742268815,
      "vett1Mg14" : "vett1Mg14",
      "imballoMg95" : "imballoMg95",
      "tipocfCg44" : 1.3949519358941398,
      "idmediaCg99" : 9.806951670467935,
      "portoMg91" : "portoMg91",
      "vett2Mg14" : "vett2Mg14",
      "aspettoMg99" : "aspettoMg99",
      "dittaCg18" : 6.966044574347761,
      "spedizMg15" : "spedizMg15",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "tipospedMg93" : "tipospedMg93"
    },
    "tipoclxdoc" : 0.4833312865174044,
    "priceListSalePurchase" : {
      "desclist" : "desclist",
      "numlist" : 4.637509675190766,
      "valutaCg08" : "valutaCg08",
      "dittaCg18" : 6.918231485891953,
      "flgVenacq" : 0.11859130807119977,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "coddocumMg3g" : "coddocumMg3g",
    "indtestof2" : "0",
    "impdaarrot" : 6.623518433804886,
    "indtestof1" : 3.7814124730767915,
    "pluginData" : {
      "key" : ""
    },
    "flgrottsingdoc" : 8.251625748923757,
    "scimpcor" : 3.804112695731078,
    "additionalData" : {
      "key" : ""
    },
    "dataultord" : "2000-01-23T04:56:07.000+00:00",
    "flgTaxliable" : 0,
    "flgspbol" : 4.459605034958679,
    "magpercor" : 5.877124706116695,
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 2.380090174313445,
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 6.749525837406151,
      "tipocf" : 4.943637496515336,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "flgspeinc" : 3.901545264248647,
    "codrifalf" : "codrifalf",
    "sc1percor" : 7.835035282970782,
    "listmag" : 3.111202833403195,
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.173804034172511,
      "descrcat" : "descrcat",
      "dittaCg18" : 2.535258963197524,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "dittaCg18" : 4.258773108174356,
    "indspesecum" : 8.37823741034869,
    "magimpcor" : 9.897492629215506,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
    "macAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 5.747795090145878,
      "idprov" : 0,
      "tipocf" : 7.3842318535314,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "indclibloc" : 9.254183946267839,
    "fixedText1" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "flgart62ctr" : 0,
    "imparrotprec" : 8.28965939814297,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.35262192099236644,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 2.7977867356748476,
        "idprov" : 9,
        "descrzona" : "descrzona",
        "tipocfMg08" : 0.58919091925136,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 2.7977867356748476,
        "idprov" : 9,
        "descrzona" : "descrzona",
        "tipocfMg08" : 0.58919091925136,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 7,
      "tipocfMg07" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 4.518309517874243,
    "fidofactoring" : 4.678947989005849,
    "idmediaCg99" : 1.7325933120207193,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "indstscadest" : 7.606863723092579,
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.010300976654761,
      "idprov" : 6,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 8.276461147928103,
      "tipocf" : 4.141296055235948,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indclifat" : 1.8268702177058116,
    "fixedExp1" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "scperpiede" : 8.675064425986758,
    "rischio" : {
      "indSegnalazionecorpo" : 7.464202015255506,
      "flgAttivo" : 4.1661834558007,
      "flgScadereins" : 2.4669941706755685,
      "flgOrdini" : 8.250639315618633,
      "flgCalcmovprev" : 5.573385265048522,
      "flgSaldocon" : 7.273019311111276,
      "pluginData" : {
        "key" : ""
      },
      "flgCalcmovdacons" : 1.9626702727164813,
      "additionalData" : {
        "key" : ""
      },
      "flgScadutoins" : 0.4008378390304357,
      "mesiricscadenze" : 6.642953999458534,
      "flgSelclifortrasf" : 4.432841187680573,
      "indElabscadinsol" : 9.721046668148785,
      "flgScadutonoins" : 2.5524281586707875,
      "codice" : "codice",
      "flgEffettiscaduti" : 3.0269458094096646,
      "flgScaderenoins" : 8.782449469456207,
      "flgCalceffcons" : 2.026856458177285,
      "flgCalcmovcons" : 3.8156682252305574,
      "descrizione" : "descrizione",
      "flgCalceffprev" : 5.296102445648278,
      "dittaCg18" : 2.0981949483881577,
      "flgCalceffdacons" : 3.196820582978078,
      "indAttivatrasf" : 5.726375546151009,
      "mesiricordini" : 6.370609851066415,
      "flgSolobusinesriskattivo" : 3.5117904067536143,
      "indProvenienzafido" : 2.922265432447957,
      "mesiricdocdafatt" : 7.129168897240568
    },
    "dataultfat" : "2000-01-23T04:56:07.000+00:00",
    "notebloc" : "notebloc",
    "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
    "indgesfido" : 8.761432466225475,
    "flgprzcamp" : 5.507386964179881,
    "inddesdocest" : 3.502657762086401,
    "flgdaticlfat" : 9.702963800023566,
    "indgiorni" : 0.4182561061793122,
    "fidoaziendale" : 1.041444916118296,
    "fidolivello1" : 7.260521264802104,
    "indrottcig" : 5.312489704336296,
    "fidolivello2" : 9.132027271330688,
    "raggruppamentoPrevalente" : {
      "descragg" : "descragg",
      "cliforCg44" : 7.390706075830692,
      "dittaCg18" : 1.0502890910539986,
      "idmediaCg99" : 6.176386745020588,
      "codRag" : "codRag",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indarrl96" : 8.863729185622827,
    "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
    "flgrottcig" : 6.073898085781152,
    "coddestprev" : "coddestprev",
    "codprevragb" : "codprevragb",
    "art62txt" : "art62txt",
    "flgEstrpayline" : 7.933506881737151,
    "indFattper" : 9.183123594773994,
    "flgqualita" : 4.86315908102884,
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "priceListWithMultipleItems" : {
      "descr" : "descr",
      "dittaCg18" : 0.36062689002149373,
      "codice" : "codice",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 8.768153453040833,
      "dittaCg18" : 9.505836306729838,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "sc3percor" : 3.1497903714250555
  },
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "dittaCg18" : 3.0937452626664474,
  "flgart62" : 7,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "indElenchiMov3000" : 3,
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Get by ID
 * Get an object of type corresponding the requested id
 *
 * id String Id to get the object
 * environment String 
 * tipoCf String TipoCf Mandatory to execute current action
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * ignoreCompanyPolicyFilter Boolean Specify 'ignoreCompanyPolicyFilter=true' if you want ignore the company filter (optional)
 * dlevel String Serialization level (optional)
 * dlevelkey String Serialization level key (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns CustomerSupplierMGDTO
 **/
exports.apiV1EnvironmentMGCustomerSupplierMGIdGET = function(id,environment,tipoCf,authorizationScope,ignoreCompanyPolicyFilter,dlevel,dlevelkey,company,user,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "statoAttualeCO" : {
    "statiDisponibili" : [ null, null ],
    "statoCorrente" : {
      "indTipoStato" : 2,
      "idStato" : 1,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "seq" : 2
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "contratto" : "contratto",
  "idCliFor" : 8,
  "idmediaCg99" : 7.740351818741173,
  "blackListGeneralMasterData" : {
    "datavalid" : "2000-01-23T04:56:07.000+00:00",
    "ragsofiscex" : "ragsofiscex",
    "addresses" : [ {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    }, {
      "indirizzocomp2" : "indirizzocomp2",
      "addressesType" : [ {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      }, {
        "tipo" : 6,
        "idCG1J" : 6,
        "pluginData" : {
          "key" : ""
        },
        "id" : 2,
        "additionalData" : {
          "key" : ""
        }
      } ],
      "risstato" : "risstato",
      "riszip" : "riszip",
      "pv" : "pv",
      "precisione" : "precisione",
      "codlinguaMg52" : "codlinguaMg52",
      "frazione" : "frazione",
      "emailPec" : "emailPec",
      "tipologia" : "tipologia",
      "via" : "via",
      "idTeamportal" : 6,
      "numciv" : "numciv",
      "cap" : "cap",
      "latitudine" : 3.5571952270680973,
      "statoCg07" : 1.284659006116532,
      "presso" : "presso",
      "federalStateViewCO" : {
        "descr" : "descr",
        "iso3166statofed" : "iso3166statofed",
        "a2iso3166Cg07" : "a2iso3166Cg07",
        "pluginData" : {
          "key" : ""
        },
        "codiceCg07" : 5.944895607614016,
        "additionalData" : {
          "key" : ""
        },
        "statofed" : "statofed"
      },
      "pluginData" : {
        "key" : ""
      },
      "id" : 9,
      "additionalData" : {
        "key" : ""
      },
      "fax" : "fax",
      "statofed" : "statofed",
      "telefono" : "telefono",
      "datamod" : "2000-01-23T04:56:07.000+00:00",
      "email" : "email",
      "citta" : "citta",
      "ragsoc" : "ragsoc",
      "cellnum" : "cellnum",
      "comanaCg01" : "comanaCg01",
      "codiceCg16" : 8,
      "datacre" : "2000-01-23T04:56:07.000+00:00",
      "ragsocex" : "ragsocex",
      "rifindirizzo" : "rifindirizzo",
      "codicesfed" : "codicesfed",
      "contea" : "contea",
      "indirizzocomp" : "indirizzocomp",
      "riswarning" : "riswarning",
      "indirizzoex" : "indirizzoex",
      "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
      "risregione" : "risregione",
      "edificio" : "edificio",
      "statoEst" : {
        "codSian" : 3.353193347011243,
        "crtpiva" : "crtpiva",
        "leniban" : 6,
        "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
        "desiso3166" : "desiso3166",
        "idmediaCg99" : 0.8851374739011653,
        "codice" : 6.704019297950036,
        "numiso3166" : "numiso3166",
        "codiceCg08" : "codiceCg08",
        "currencyCO" : {
          "sigla" : "sigla",
          "dataattuem" : "2000-01-23T04:56:07.000+00:00",
          "numdec" : 7.04836565559697,
          "exchangeRateCO" : [ {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          }, {
            "cambio" : 4.078845849666752,
            "anno" : 3.2588565619047607,
            "idmediaCg99" : 6.628464275087742,
            "codiceCg08" : "codiceCg08",
            "indCertoincerto" : 4,
            "codicerifCg08" : "codicerifCg08",
            "giorno" : 0.2025324113236393,
            "mese" : 1.041444916118296,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            },
            "adegcambio" : 5.533258397034986,
            "rowversion" : ""
          } ],
          "idmediaCg99" : 8.969578798196912,
          "codice" : "codice",
          "indCertoincerto" : 7,
          "cambiofisso" : 0.10263654006109402,
          "descr" : "descr",
          "flgValuem" : 4.652396432933246,
          "indValuem" : 3.0576100241049344,
          "indSepmigl" : 3.0205796992916243,
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "descr" : "descr",
        "flgIban" : 3,
        "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
        "codIso" : "codIso",
        "a3iso3166" : "a3iso3166",
        "indTipostato" : 7.058770351582356,
        "a2iso3166" : "a2iso3166",
        "pluginData" : {
          "key" : ""
        },
        "additionalData" : {
          "key" : ""
        },
        "datacee" : "2000-01-23T04:56:07.000+00:00",
        "flgSepa" : 7
      },
      "longitudine" : 6.965117697638846,
      "indweb" : "indweb"
    } ],
    "codiceident" : "codiceident",
    "indirCorEX" : "indirCorEX",
    "flgFattpa" : 7,
    "indirizzo" : "indirizzo",
    "ragsoanagex" : "ragsoanagex",
    "codiceCg07" : 7.061401241503109,
    "indsoggrit" : 7.457744773683766,
    "ragSoAnag" : "ragSoAnag",
    "capcor" : "capcor",
    "cittafisc" : "cittafisc",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9
    },
    "statofiscCg07" : 5.025004791520295,
    "tel2num" : "tel2num",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "codfiscale" : "codfiscale",
    "statofed" : "statofed",
    "codrichiamo" : 2,
    "provfisc" : "provfisc",
    "idExtendedAttributeEntity" : 9,
    "citta" : "citta",
    "statonascitaCg07" : 9.965781217890562,
    "codice" : 2,
    "indFiscale" : "indFiscale",
    "nome" : "nome",
    "comnascitaCg01" : "comnascitaCg01",
    "codiceCg15" : "codiceCg15",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "ragsofisc" : "ragsofisc",
    "indemail" : "indemail",
    "indirizzoEX" : "indirizzoEX",
    "comfisCg01" : "comfisCg01",
    "comnascita" : "comnascita",
    "partiva" : "partiva",
    "flgNoblacklist" : 1.2315135367772556,
    "partivaEst" : "partivaEst",
    "cognome" : "cognome",
    "idmediaCg99" : 6.84685269835264,
    "wtCodeCO" : {
      "causdd1" : "causdd1",
      "codNonsog" : 0.8774076871421566,
      "flgRegagevo" : 4.86315908102884,
      "idmediaCg99" : 3.901545264248647,
      "percRipPerc" : 1.8268702177058116,
      "flgRitImposta" : 6.073898085781152,
      "codPrev" : "codPrev",
      "tiporapporto" : "tiporapporto",
      "percripaz" : 9.254183946267839,
      "pluginData" : {
        "key" : ""
      },
      "flgPignTerzi" : 7.933506881737151,
      "flgProteo360" : 5.507386964179881,
      "additionalData" : {
        "key" : ""
      },
      "flgGlad" : 9.702963800023566,
      "codFiscPrev" : "codFiscPrev",
      "gcprev" : 4,
      "idprov" : 0.43431398824148815,
      "codice" : "codice",
      "percci" : 4.573936264232251,
      "flgSosprit" : 8,
      "descr" : "descr",
      "flgMinimi" : 0,
      "codTributo" : "codTributo",
      "indCodattglad" : 2.9409642974827896,
      "indTipocassa" : 1,
      "percra" : 8.863729185622827,
      "percbaseimp" : 6.623518433804886,
      "codTribrp" : "codTribrp",
      "inpsivs" : 8.28965939814297,
      "rowversion" : ""
    },
    "dtiniziopec" : "2000-01-23T04:56:07.000+00:00",
    "capfisc" : "capfisc",
    "codicecorCg07" : 3.616076749251911,
    "codiceCgc0" : 9.301444243932576,
    "cap" : "cap",
    "faxnum" : "faxnum",
    "alias" : "alias",
    "flgOmonimo" : 1.0246457001441578,
    "provnascita" : "provnascita",
    "ragsocor" : "ragsocor",
    "prov" : "prov",
    "flgAnagval" : 4.145608029883936,
    "rapazestCg16" : 1,
    "cellnum" : "cellnum",
    "flgPrsfis" : 1.4894159098541704,
    "tel1num" : "tel1num",
    "idExtendedAttributeSubEntity" : 6,
    "provcor" : "provcor",
    "dtfinepec" : "2000-01-23T04:56:07.000+00:00",
    "cittacor" : "cittacor",
    "codicesfed" : "codicesfed",
    "statofedfisc" : "statofedfisc",
    "indFiscaleEX" : "indFiscaleEX",
    "partitaIVA" : "partitaIVA",
    "indirCor" : "indirCor",
    "sesso" : 4.965218492984954,
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "ragsocorex" : "ragsocorex",
    "datanascita" : "2000-01-23T04:56:07.000+00:00",
    "auidAu04" : 5,
    "indweb" : "indweb"
  },
  "goods" : {
    "reverseTypeFI" : {
      "reverseTypeCode" : 8,
      "reverseTypeDescription" : "reverseTypeDescription",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "flgBilconsattpassdist" : 5,
    "contochiu" : "contochiu",
    "flgAnalit" : 8,
    "codeformatted" : "codeformatted",
    "intragroupStructureCO" : {
      "descr" : "descr",
      "codice" : 7.260521264802104,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "codAnagGen" : 4,
      "codIntercompany" : 9
    },
    "flgAggfatt" : 5,
    "indLivchius" : 3,
    "idcontoratattCg24" : 8,
    "idcontoapeCg24" : 4,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "contocrsosp" : "contocrsosp",
    "flgContoimm" : 0,
    "flgOpnonfin" : 8.257837395465918,
    "indDaavec" : 1,
    "cogeprogeMateriali" : 8,
    "coaAccountCustomizationFI" : [ {
      "descr" : "descr",
      "iddespcon" : 9,
      "dittaCg18" : 8.780989965779524,
      "contoCg24" : "contoCg24",
      "idmediaCg99" : 6.203595661339589,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.616380282218067,
      "idCg24" : 9,
      "rowversion" : ""
    }, {
      "descr" : "descr",
      "iddespcon" : 9,
      "dittaCg18" : 8.780989965779524,
      "contoCg24" : "contoCg24",
      "idmediaCg99" : 6.203595661339589,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.616380282218067,
      "idCg24" : 9,
      "rowversion" : ""
    } ],
    "accountType" : 9,
    "contoratpass" : "contoratpass",
    "descr" : "descr",
    "idcontorisattCg24" : 7,
    "indDaav" : 4,
    "suddconti" : 0.9178980228274691,
    "contoratatt" : "contoratatt",
    "indMastroCliFor" : 3.8581948879558317,
    "idcontochiuCg24" : 8,
    "percindetra" : 8.262575023052213,
    "codiceCg22" : 1.5743672347582194,
    "indAttpasspor" : 7,
    "indTipoconto" : 1,
    "contoape" : "contoape",
    "flgGespor" : 8,
    "cogeprogeAbil" : 2,
    "flgSaldog" : 2,
    "percindeduc" : 4.5403315819302215,
    "contorisatt" : "contorisatt",
    "codiceCgc0" : 4.863793115215697,
    "flgValutaest" : 5,
    "flgRaganal" : 5,
    "alias" : "alias",
    "conto" : "conto",
    "cogeprogeNodo" : 2,
    "contorispass" : "contorispass",
    "indContoricav" : 1,
    "vatTypeFI" : {
      "descr" : "descr",
      "indAutofattura" : 9,
      "agviaggio" : 0,
      "codice" : 0.7370530802760489,
      "pluginData" : {
        "key" : ""
      },
      "localizzazione" : 7,
      "additionalData" : {
        "key" : ""
      },
      "codiceCg0d" : 4.318826475758856,
      "indTipo" : 7.541803065493349
    },
    "idcontorispassCg24" : 1,
    "cogeprogeAttivita" : 2,
    "flgGesec" : 1,
    "coaInternationalCustomizationFI" : [ {
      "contoCg24" : "contoCg24",
      "subcategoria" : 9,
      "categoria" : 9,
      "gbDeferralcode" : "gbDeferralcode",
      "esModulo347" : 3,
      "pluginData" : {
        "key" : ""
      },
      "id" : 8,
      "iso3166A2" : "iso3166A2",
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.267310321293582,
      "idCg24" : 7,
      "rowversion" : ""
    }, {
      "contoCg24" : "contoCg24",
      "subcategoria" : 9,
      "categoria" : 9,
      "gbDeferralcode" : "gbDeferralcode",
      "esModulo347" : 3,
      "pluginData" : {
        "key" : ""
      },
      "id" : 8,
      "iso3166A2" : "iso3166A2",
      "additionalData" : {
        "key" : ""
      },
      "gruppoCg10" : 5.267310321293582,
      "idCg24" : 7,
      "rowversion" : ""
    } ],
    "gruppoCg10" : 5.412786966532157,
    "coaAccountStateFI" : [ {
      "consosCg24" : "consosCg24",
      "dittaCg18" : 7.014147440046284,
      "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
      "grusosCg10" : 9.684087197655908,
      "pluginData" : {
        "key" : ""
      },
      "idstatipdc" : 6,
      "additionalData" : {
        "key" : ""
      },
      "dtconsos" : "2000-01-23T04:56:07.000+00:00",
      "flgDisatt" : 0.8972273556195443,
      "idCg24" : 1,
      "rowversion" : ""
    }, {
      "consosCg24" : "consosCg24",
      "dittaCg18" : 7.014147440046284,
      "dtdisatt" : "2000-01-23T04:56:07.000+00:00",
      "grusosCg10" : 9.684087197655908,
      "pluginData" : {
        "key" : ""
      },
      "idstatipdc" : 6,
      "additionalData" : {
        "key" : ""
      },
      "dtconsos" : "2000-01-23T04:56:07.000+00:00",
      "flgDisatt" : 0.8972273556195443,
      "idCg24" : 1,
      "rowversion" : ""
    } ],
    "coaGroupCodeFI" : {
      "descr" : "descr",
      "numlivcons" : 8.289598895249666,
      "gruppo" : 9.372628622067484,
      "numlivelli" : 6.460213024504889,
      "accountProposals" : [ {
        "contoCg24" : "contoCg24",
        "codice" : 6.8668894011844035,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 7.375698277301938,
        "idCg24" : 0,
        "rowversion" : ""
      }, {
        "contoCg24" : "contoCg24",
        "codice" : 6.8668894011844035,
        "pluginData" : {
          "key" : ""
        },
        "id" : 6,
        "additionalData" : {
          "key" : ""
        },
        "gruppoCg10" : 7.375698277301938,
        "idCg24" : 0,
        "rowversion" : ""
      } ],
      "pluginData" : {
        "key" : ""
      },
      "maskedit" : "maskedit",
      "additionalData" : {
        "key" : ""
      },
      "flgPdclib" : 9,
      "rowversion" : ""
    },
    "idparent" : 2,
    "idreverse" : 1,
    "flgIntercompany" : 2,
    "idcontoratpassCg24" : 6,
    "flgRarp" : 9,
    "idconto" : 8,
    "cogeprogeSpese" : 6,
    "idRifPdC80" : 7,
    "indCosvend" : 4
  },
  "flgAttivo" : 0.8851374739011653,
  "tipocfCg40" : 5.533258397034986,
  "dmsPublishedEntityFW" : {
    "tipoarchHm30" : 2,
    "idknos" : 6,
    "dittaCg18" : 1.0046985756074744,
    "flgInvalid" : 3,
    "datapub" : "2000-01-23T04:56:07.000+00:00",
    "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
    "protocollo" : "protocollo",
    "nome" : "nome",
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "publicationid" : "publicationid",
    "percorso" : "percorso"
  },
  "officeCO" : {
    "indIrizzo" : "indIrizzo",
    "idmediaCg99" : 1.6056289151258096,
    "codice" : 8.875589915795528,
    "indDimcentrocomm" : 6.720288821326667,
    "cap" : "cap",
    "dittaCg18" : 7.766860781935265,
    "progRea" : 5.304373278797373,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "prov" : "prov",
    "numerorea" : "numerorea",
    "citta" : "citta",
    "rowversion" : ""
  },
  "flgInterCompany" : 6.519180951018382,
  "paymentTermCO" : {
    "flgDesc" : 8.708394192403432,
    "paymentTermDetailCO" : [ {
      "indImpfix" : 6.568304668801491,
      "daggfix1" : 9.610516429629122,
      "daggfix2" : 9.140242185517025,
      "ggmmfix" : 6.936593194494838,
      "ggdecor" : 2.408218941758913,
      "idCg64" : 4,
      "imporfix" : 2.674423984487264,
      "flgFrperciva" : 7.686670838404092,
      "idCg62" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "el2friva" : 4.180725413706508,
      "indTipocalend" : 1,
      "indTipodecor" : 7.338782761819433,
      "aggfix2" : 5.948961008630453,
      "aggfix1" : 8.638367073739522,
      "perciva" : 0.05965928697733491,
      "el2frimp" : 7.964879197514727,
      "ggscadfix2" : 0.6052866655822231,
      "tipoeff" : 9.728706165995554,
      "flgFrpercimp" : 7.321091499885957,
      "percimp" : 9.739448828157911,
      "prog" : 5.099298781640682,
      "el1frimp" : 8.81377937009168,
      "codPagCg62" : "codPagCg62",
      "ggscadfix1" : 3.8463127686084055,
      "subTypeCO" : {
        "ggoffset" : 5.3152834658745505,
        "codiceCg07" : 3.3182952910080674,
        "tipoeff" : 2.4977456046390434,
        "codPaguc" : "codPaguc",
        "descstipo" : "descstipo",
        "codStipoeff" : 8.50835276411088,
        "flgAssegno" : 9,
        "indModfatturapa" : 4,
        "nationCO" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "foreignPaymentCodeCO" : {
          "flgIbanobbl" : 0,
          "descrpag" : "descrpag",
          "codIso" : "codIso",
          "codice" : "codice",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "el1friva" : 4.39343993729625,
      "indDatarif" : 2.3317418552851765,
      "rowversion" : ""
    }, {
      "indImpfix" : 6.568304668801491,
      "daggfix1" : 9.610516429629122,
      "daggfix2" : 9.140242185517025,
      "ggmmfix" : 6.936593194494838,
      "ggdecor" : 2.408218941758913,
      "idCg64" : 4,
      "imporfix" : 2.674423984487264,
      "flgFrperciva" : 7.686670838404092,
      "idCg62" : 4,
      "pluginData" : {
        "key" : ""
      },
      "id" : 5,
      "additionalData" : {
        "key" : ""
      },
      "el2friva" : 4.180725413706508,
      "indTipocalend" : 1,
      "indTipodecor" : 7.338782761819433,
      "aggfix2" : 5.948961008630453,
      "aggfix1" : 8.638367073739522,
      "perciva" : 0.05965928697733491,
      "el2frimp" : 7.964879197514727,
      "ggscadfix2" : 0.6052866655822231,
      "tipoeff" : 9.728706165995554,
      "flgFrpercimp" : 7.321091499885957,
      "percimp" : 9.739448828157911,
      "prog" : 5.099298781640682,
      "el1frimp" : 8.81377937009168,
      "codPagCg62" : "codPagCg62",
      "ggscadfix1" : 3.8463127686084055,
      "subTypeCO" : {
        "ggoffset" : 5.3152834658745505,
        "codiceCg07" : 3.3182952910080674,
        "tipoeff" : 2.4977456046390434,
        "codPaguc" : "codPaguc",
        "descstipo" : "descstipo",
        "codStipoeff" : 8.50835276411088,
        "flgAssegno" : 9,
        "indModfatturapa" : 4,
        "nationCO" : {
          "codSian" : 3.353193347011243,
          "crtpiva" : "crtpiva",
          "leniban" : 6,
          "datafinblacklist" : "2000-01-23T04:56:07.000+00:00",
          "desiso3166" : "desiso3166",
          "idmediaCg99" : 0.8851374739011653,
          "codice" : 6.704019297950036,
          "numiso3166" : "numiso3166",
          "codiceCg08" : "codiceCg08",
          "currencyCO" : {
            "sigla" : "sigla",
            "dataattuem" : "2000-01-23T04:56:07.000+00:00",
            "numdec" : 7.04836565559697,
            "exchangeRateCO" : [ {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            }, {
              "cambio" : 4.078845849666752,
              "anno" : 3.2588565619047607,
              "idmediaCg99" : 6.628464275087742,
              "codiceCg08" : "codiceCg08",
              "indCertoincerto" : 4,
              "codicerifCg08" : "codicerifCg08",
              "giorno" : 0.2025324113236393,
              "mese" : 1.041444916118296,
              "pluginData" : {
                "key" : ""
              },
              "additionalData" : {
                "key" : ""
              },
              "adegcambio" : 5.533258397034986,
              "rowversion" : ""
            } ],
            "idmediaCg99" : 8.969578798196912,
            "codice" : "codice",
            "indCertoincerto" : 7,
            "cambiofisso" : 0.10263654006109402,
            "descr" : "descr",
            "flgValuem" : 4.652396432933246,
            "indValuem" : 3.0576100241049344,
            "indSepmigl" : 3.0205796992916243,
            "pluginData" : {
              "key" : ""
            },
            "additionalData" : {
              "key" : ""
            }
          },
          "descr" : "descr",
          "flgIban" : 3,
          "datainiblacklist" : "2000-01-23T04:56:07.000+00:00",
          "codIso" : "codIso",
          "a3iso3166" : "a3iso3166",
          "indTipostato" : 7.058770351582356,
          "a2iso3166" : "a2iso3166",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          },
          "datacee" : "2000-01-23T04:56:07.000+00:00",
          "flgSepa" : 7
        },
        "foreignPaymentCodeCO" : {
          "flgIbanobbl" : 0,
          "descrpag" : "descrpag",
          "codIso" : "codIso",
          "codice" : "codice",
          "pluginData" : {
            "key" : ""
          },
          "additionalData" : {
            "key" : ""
          }
        },
        "pluginData" : {
          "key" : ""
        },
        "id" : 9,
        "additionalData" : {
          "key" : ""
        },
        "rowversion" : ""
      },
      "el1friva" : 4.39343993729625,
      "indDatarif" : 2.3317418552851765,
      "rowversion" : ""
    } ],
    "codPag" : "codPag",
    "desPagAnal" : "desPagAnal",
    "flgDisgg" : 0.8164256701298711,
    "flgPrefpass" : 4,
    "idExtendedAttributeSubEntity" : 3,
    "flgPrefatt" : 4,
    "flgStornoiva" : 0.313237310471568,
    "descPag" : "descPag",
    "extensionData" : [ {
      "value" : "",
      "key" : "key"
    }, {
      "value" : "",
      "key" : "key"
    } ],
    "scpermer2" : 4.035133329541982,
    "pluginData" : {
      "key" : ""
    },
    "id" : 7,
    "scpercas" : 4.403697036782718,
    "scpermer1" : 6.936499209818381,
    "additionalData" : {
      "key" : ""
    },
    "scpercart26" : 0.05189710095898081,
    "idExtendedAttributeEntity" : 2,
    "rowversion" : "",
    "scart26" : 2.1871588311421153
  },
  "progrEf08" : 3.0576100241049344,
  "tipoCf" : 7.04836565559697,
  "pluginData" : {
    "key" : ""
  },
  "cliFor" : 3.353193347011243,
  "additionalData" : {
    "key" : ""
  },
  "ggScadFix" : 0.10263654006109402,
  "idExtendedAttributeEntity" : 3,
  "idExtendedAttributeSubEntity" : 4,
  "flgCointestati" : 7.058770351582356,
  "gruppoCg10" : 4.652396432933246,
  "currencyCO" : {
    "sigla" : "sigla",
    "dataattuem" : "2000-01-23T04:56:07.000+00:00",
    "numdec" : 7.04836565559697,
    "exchangeRateCO" : [ {
      "cambio" : 4.078845849666752,
      "anno" : 3.2588565619047607,
      "idmediaCg99" : 6.628464275087742,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 4,
      "codicerifCg08" : "codicerifCg08",
      "giorno" : 0.2025324113236393,
      "mese" : 1.041444916118296,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 5.533258397034986,
      "rowversion" : ""
    }, {
      "cambio" : 4.078845849666752,
      "anno" : 3.2588565619047607,
      "idmediaCg99" : 6.628464275087742,
      "codiceCg08" : "codiceCg08",
      "indCertoincerto" : 4,
      "codicerifCg08" : "codicerifCg08",
      "giorno" : 0.2025324113236393,
      "mese" : 1.041444916118296,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "adegcambio" : 5.533258397034986,
      "rowversion" : ""
    } ],
    "idmediaCg99" : 8.969578798196912,
    "codice" : "codice",
    "indCertoincerto" : 7,
    "cambiofisso" : 0.10263654006109402,
    "descr" : "descr",
    "flgValuem" : 4.652396432933246,
    "indValuem" : 3.0576100241049344,
    "indSepmigl" : 3.0205796992916243,
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    }
  },
  "vatCodeCO" : {
    "flgSospimp" : 7.224413148959403,
    "indNatura" : 7,
    "flgAgri" : 7.239590766928185,
    "tipologia" : 6.614319261836819,
    "percindet" : 6.541917087228235,
    "mossperc" : 6.711221582652969,
    "natureEsCO" : {
      "descr" : "descr",
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "natureAssCO" : [ null, null ],
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "id" : 3,
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "pluginData" : {
      "key" : ""
    },
    "additionalData" : {
      "key" : ""
    },
    "verslynfa" : "verslynfa",
    "idExtendedAttributeEntity" : 4,
    "annotazioni" : "annotazioni",
    "rowVersion" : "",
    "indNatassoswCg2n" : 4,
    "perciva" : 6.389489858092311,
    "percforf" : 5.305668385940959,
    "codice" : "codice",
    "impostamonofasersm" : 0.42286244411048224,
    "codiceOss" : "codiceOss",
    "extensionData" : [ null, null ],
    "stdcodivarifCg28" : "stdcodivarifCg28",
    "flgMossgest" : 2,
    "flgAutoue" : 6.677419970877656,
    "flgIndet" : 4.966567419166605,
    "codPlafond" : 2.6736395633233356,
    "note" : "note",
    "flgAssport398" : 9.852147203726787,
    "flgMossrid" : 3,
    "indStaper" : 8.474710856151638,
    "flgAllclifor" : 6.090696483578148,
    "codiceagr" : "codiceagr",
    "flgImpostadibollo" : 5,
    "flgCorrVent" : 1.2880645475702646,
    "aliqivavent" : 8.018039914932286,
    "flgNotvar" : 0.9619297253823988,
    "percmonofasersm" : 5.201737367852583,
    "idprov" : 1.633699845078339,
    "idExtendedAttributeSubEntity" : 0,
    "natureAssCO" : {
      "descr" : "descr",
      "idCg2m" : 5,
      "idassosw" : 3,
      "codice" : "codice",
      "datainival" : "2000-01-23T04:56:07.000+00:00",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "rowversion" : ""
    },
    "flgMonofasersm" : 9.693372334146686,
    "mosscodCg07" : 6.008900790410507,
    "descrizione" : "descrizione",
    "flgEscludiblacklist" : 1.822577900073098,
    "flgIvaedit" : 2.9790233918904585,
    "indtipopart" : 3.474156394106027
  },
  "extensionData" : [ null, null ],
  "classificationData" : {
    "cliforCg44" : 0.2025324113236393,
    "indarrinfat" : 4.573936264232251,
    "indprefstdoc" : 5.299143560275359,
    "notes" : [ {
      "cliforCg44" : 0.30134145536422907,
      "note" : "note",
      "dittaCg18" : 0.4867146239815201,
      "tipocfCg44" : 7.88722683998926,
      "idmediaCg99" : 9.456612101333725,
      "destiponote" : "destiponote",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prog" : 9.721723570087065
    }, {
      "cliforCg44" : 0.30134145536422907,
      "note" : "note",
      "dittaCg18" : 0.4867146239815201,
      "tipocfCg44" : 7.88722683998926,
      "idmediaCg99" : 9.456612101333725,
      "destiponote" : "destiponote",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "prog" : 9.721723570087065
    } ],
    "sc2percor" : 0.4768402382624515,
    "codrifnum" : 6.628464275087742,
    "grouping1CO" : {
      "dittaCg18" : 3.209082285545927,
      "codRaggrcf1" : "codRaggrcf1",
      "descraggrcf1" : "descraggrcf1",
      "idprov" : 2,
      "idmediaCg99" : 8.262795412896967,
      "tipocf" : 9.146339979307802,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "language" : {
      "iso639" : "iso639",
      "idmediaCg99" : 2.9679475177256287,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrlingua" : "descrlingua",
      "codLingua" : "codLingua",
      "siglalingua" : "siglalingua"
    },
    "irs1099" : "irs1099",
    "ggcons" : 2.9409642974827896,
    "flgesclspepor" : 0.5199002018724985,
    "grouping3CO" : {
      "codRaggrcf3" : "codRaggrcf3",
      "descraggrcf3" : "descraggrcf3",
      "dittaCg18" : 8.910869026866926,
      "idprov" : 6,
      "idmediaCg99" : 2.058822123984536,
      "tipocf" : 0.8411762798681321,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "datiAccompagnamento" : {
      "cliforCg44" : 4.8789878742268815,
      "vett1Mg14" : "vett1Mg14",
      "imballoMg95" : "imballoMg95",
      "tipocfCg44" : 1.3949519358941398,
      "idmediaCg99" : 9.806951670467935,
      "portoMg91" : "portoMg91",
      "vett2Mg14" : "vett2Mg14",
      "aspettoMg99" : "aspettoMg99",
      "dittaCg18" : 6.966044574347761,
      "spedizMg15" : "spedizMg15",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "tipospedMg93" : "tipospedMg93"
    },
    "tipoclxdoc" : 0.4833312865174044,
    "priceListSalePurchase" : {
      "desclist" : "desclist",
      "numlist" : 4.637509675190766,
      "valutaCg08" : "valutaCg08",
      "dittaCg18" : 6.918231485891953,
      "flgVenacq" : 0.11859130807119977,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "coddocumMg3g" : "coddocumMg3g",
    "indtestof2" : "0",
    "impdaarrot" : 6.623518433804886,
    "indtestof1" : 3.7814124730767915,
    "pluginData" : {
      "key" : ""
    },
    "flgrottsingdoc" : 8.251625748923757,
    "scimpcor" : 3.804112695731078,
    "additionalData" : {
      "key" : ""
    },
    "dataultord" : "2000-01-23T04:56:07.000+00:00",
    "flgTaxliable" : 0,
    "flgspbol" : 4.459605034958679,
    "magpercor" : 5.877124706116695,
    "taxexemptionno" : "taxexemptionno",
    "scaglspbanc" : 2.380090174313445,
    "macroCategoryCO" : {
      "descrmacrocat" : "descrmacrocat",
      "categorie" : [ null, null ],
      "dittaCg18" : 6.749525837406151,
      "tipocf" : 4.943637496515336,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "macrocat" : "macrocat"
    },
    "datacreaz" : "2000-01-23T04:56:07.000+00:00",
    "flgspeinc" : 3.901545264248647,
    "codrifalf" : "codrifalf",
    "sc1percor" : 7.835035282970782,
    "listmag" : 3.111202833403195,
    "categoryCO" : {
      "macrocatMg10" : "macrocatMg10",
      "tipocfMg10" : 6.173804034172511,
      "descrcat" : "descrcat",
      "dittaCg18" : 2.535258963197524,
      "categ" : "categ",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "dittaCg18" : 4.258773108174356,
    "indspesecum" : 8.37823741034869,
    "magimpcor" : 9.897492629215506,
    "datadismis" : "2000-01-23T04:56:07.000+00:00",
    "dataultdoc" : "2000-01-23T04:56:07.000+00:00",
    "macAreaCO" : {
      "descrmacroar" : "descrmacroar",
      "dittaCg18" : 5.747795090145878,
      "idprov" : 0,
      "tipocf" : 7.3842318535314,
      "areas" : [ null, null ],
      "pluginData" : {
        "key" : ""
      },
      "codiceMacroarea" : "codiceMacroarea",
      "additionalData" : {
        "key" : ""
      }
    },
    "indclibloc" : 9.254183946267839,
    "fixedText1" : {
      "descr" : "descr",
      "datainizioval" : "2000-01-23T04:56:07.000+00:00",
      "indTipoevas" : 4.4935252719377825,
      "idprov" : 1,
      "idmediaCg99" : 9.402167524121316,
      "codice" : "codice",
      "datafineval" : "2000-01-23T04:56:07.000+00:00",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "testo" : "testo"
    },
    "flgart62ctr" : 0,
    "imparrotprec" : 8.28965939814297,
    "areaCO" : {
      "codiceAreaMG" : "codiceAreaMG",
      "macroareaMg07" : "macroareaMg07",
      "dittaCg18" : 0.35262192099236644,
      "zone" : [ {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 2.7977867356748476,
        "idprov" : 9,
        "descrzona" : "descrzona",
        "tipocfMg08" : 0.58919091925136,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      }, {
        "areaMg08" : "areaMg08",
        "macroareaMg08" : "macroareaMg08",
        "dittaCg18" : 2.7977867356748476,
        "idprov" : 9,
        "descrzona" : "descrzona",
        "tipocfMg08" : 0.58919091925136,
        "pluginData" : {
          "key" : ""
        },
        "codiceZona" : "codiceZona",
        "additionalData" : {
          "key" : ""
        }
      } ],
      "idprov" : 7,
      "tipocfMg07" : 4.332304821875894,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      },
      "descrarea" : "descrarea"
    },
    "dataultvar" : "2000-01-23T04:56:07.000+00:00",
    "tipocfCg44" : 4.518309517874243,
    "fidofactoring" : 4.678947989005849,
    "idmediaCg99" : 1.7325933120207193,
    "datarischio" : "2000-01-23T04:56:07.000+00:00",
    "indstscadest" : 7.606863723092579,
    "grouping2CO" : {
      "codRaggrcf2" : "codRaggrcf2",
      "dittaCg18" : 4.010300976654761,
      "idprov" : 6,
      "descraggrcf2" : "descraggrcf2",
      "idmediaCg99" : 8.276461147928103,
      "tipocf" : 4.141296055235948,
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indclifat" : 1.8268702177058116,
    "fixedExp1" : {
      "flgRicfatriep" : 5.6644160867523485,
      "flgVentstat" : 4.372688051310086,
      "flgIvaincl" : 1,
      "indTipoevas" : 9.785002165136461,
      "idmediaCg99" : 5.7911894223693885,
      "codice" : "codice",
      "indTotspese" : 7.92839742024475,
      "indRotturacorpo" : 1.0639121808530916,
      "indTipospesa" : 7.3718573971919445,
      "indGesintra" : 3.8008573585058016,
      "descr" : "descr",
      "indFatriep" : 5.974942028545841,
      "indTipotot" : 7.726998920545485,
      "indTipoaliq" : 3.2841216543560217,
      "pluginData" : {
        "key" : ""
      },
      "flgVentamm" : 1.5970080735609526,
      "additionalData" : {
        "key" : ""
      },
      "flgOramin" : 3.812761638325517
    },
    "scperpiede" : 8.675064425986758,
    "rischio" : {
      "indSegnalazionecorpo" : 7.464202015255506,
      "flgAttivo" : 4.1661834558007,
      "flgScadereins" : 2.4669941706755685,
      "flgOrdini" : 8.250639315618633,
      "flgCalcmovprev" : 5.573385265048522,
      "flgSaldocon" : 7.273019311111276,
      "pluginData" : {
        "key" : ""
      },
      "flgCalcmovdacons" : 1.9626702727164813,
      "additionalData" : {
        "key" : ""
      },
      "flgScadutoins" : 0.4008378390304357,
      "mesiricscadenze" : 6.642953999458534,
      "flgSelclifortrasf" : 4.432841187680573,
      "indElabscadinsol" : 9.721046668148785,
      "flgScadutonoins" : 2.5524281586707875,
      "codice" : "codice",
      "flgEffettiscaduti" : 3.0269458094096646,
      "flgScaderenoins" : 8.782449469456207,
      "flgCalceffcons" : 2.026856458177285,
      "flgCalcmovcons" : 3.8156682252305574,
      "descrizione" : "descrizione",
      "flgCalceffprev" : 5.296102445648278,
      "dittaCg18" : 2.0981949483881577,
      "flgCalceffdacons" : 3.196820582978078,
      "indAttivatrasf" : 5.726375546151009,
      "mesiricordini" : 6.370609851066415,
      "flgSolobusinesriskattivo" : 3.5117904067536143,
      "indProvenienzafido" : 2.922265432447957,
      "mesiricdocdafatt" : 7.129168897240568
    },
    "dataultfat" : "2000-01-23T04:56:07.000+00:00",
    "notebloc" : "notebloc",
    "areaMGnielsenMg0e" : "areaMGnielsenMg0e",
    "indgesfido" : 8.761432466225475,
    "flgprzcamp" : 5.507386964179881,
    "inddesdocest" : 3.502657762086401,
    "flgdaticlfat" : 9.702963800023566,
    "indgiorni" : 0.4182561061793122,
    "fidoaziendale" : 1.041444916118296,
    "fidolivello1" : 7.260521264802104,
    "indrottcig" : 5.312489704336296,
    "fidolivello2" : 9.132027271330688,
    "raggruppamentoPrevalente" : {
      "descragg" : "descragg",
      "cliforCg44" : 7.390706075830692,
      "dittaCg18" : 1.0502890910539986,
      "idmediaCg99" : 6.176386745020588,
      "codRag" : "codRag",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "indarrl96" : 8.863729185622827,
    "dataultcalsp" : "2000-01-23T04:56:07.000+00:00",
    "flgrottcig" : 6.073898085781152,
    "coddestprev" : "coddestprev",
    "codprevragb" : "codprevragb",
    "art62txt" : "art62txt",
    "flgEstrpayline" : 7.933506881737151,
    "indFattper" : 9.183123594773994,
    "flgqualita" : 4.86315908102884,
    "datablocco" : "2000-01-23T04:56:07.000+00:00",
    "priceListWithMultipleItems" : {
      "descr" : "descr",
      "dittaCg18" : 0.36062689002149373,
      "codice" : "codice",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "subCategoryCO" : {
      "descrsottocat" : "descrsottocat",
      "tipocfMg11" : 8.768153453040833,
      "dittaCg18" : 9.505836306729838,
      "sottcat" : "sottcat",
      "categMg11" : "categMg11",
      "macrocatMg11" : "macrocatMg11",
      "pluginData" : {
        "key" : ""
      },
      "additionalData" : {
        "key" : ""
      }
    },
    "lastchange" : "2000-01-23T04:56:07.000+00:00",
    "sc3percor" : 3.1497903714250555
  },
  "datavaliva" : "2000-01-23T04:56:07.000+00:00",
  "dittaCg18" : 3.0937452626664474,
  "flgart62" : 7,
  "guid" : "046b6c7f-0b8a-43b9-b35d-6489e6daee91",
  "indElenchiMov3000" : 3,
  "lastchange" : "2000-01-23T04:56:07.000+00:00"
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}


/**
 * Validate
 * Validation of object of type
 *
 * body CustomerSupplierMGDTO Object of type to validate
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * no response value expected for this operation
 **/
exports.apiV1EnvironmentMGCustomerSupplierMGValidatePOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    resolve();
  });
}


/**
 * Validation of one on more properties of Type
 * Validation of object of type
 *
 * body String  - One or more key-value pairs where the key is the DTO property name and the value is value to validate * REQUIRED<br> - The id of an existing object to validate properties, or '' if the object does not exist yet <br> (optional)
 * company String Company code (optional)
 * user String Application user (mandatory if the WebApi user does not have any mapped application user) (optional)
 * environment String 
 * authorizationScope String The environment where this operation will be executed. This must match with the environment in the url.
 * acceptLanguage String Specifies the UI culture to be used for localization of messages. (optional)
 * acceptTerritory String Specifies the culture to be used for data formatting (numbers, dates, currencies). Default: Accept-Language or 'IT' (optional)
 * returns ValidateDTO
 **/
exports.apiV1EnvironmentMGCustomerSupplierMGValidatePropertiesPOST = function(body,company,user,environment,authorizationScope,acceptLanguage,acceptTerritory) {
  return new Promise(function(resolve, reject) {
    var examples = {};
    examples['application/json'] = {
  "pluginData" : {
    "key" : ""
  },
  "additionalData" : {
    "key" : ""
  },
  "items" : [ {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  }, {
    "isError" : true,
    "isWarning" : true,
    "warningCode" : 0,
    "dtoName" : "dtoName",
    "dtoPropertyName" : "dtoPropertyName",
    "message" : "message",
    "entityPropertyPath" : "entityPropertyPath"
  } ]
};
    if (Object.keys(examples).length > 0) {
      resolve(examples[Object.keys(examples)[0]]);
    } else {
      resolve();
    }
  });
}

