# Function to log output to file if enabled
function Log-Output {
    param (
        [string]$message,
        [bool]$logToFile
    )
    $timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    $logMessage = "[$timestamp] $message"
    Write-Output $logMessage
    if ($logToFile) {
        Add-Content -Path "output.log" -Value $logMessage
    }
}
